!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!1
!!! EXTENSIONS
!!! DO these extensions the first time the file is included...
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!1
#ifndef VERBPOINT; 
	constant VERBPOINT;#ifndef VERBPOINT;#endif; !!!no warning to define verbpoint at this point
	#ifdef USEOBJ_NUMBERED;
	!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	!!  This is an object that is designed to emulate a collection of openable, stationary containers 
	!!		(like lockers).  Requirments are:
	!!			1) the display name must be plural
	!!			2) singular_name should contain a singular version of display name
	!!			3) state should point to a table of the specified number of items this object is to reprent
	!!			4) inside should point to an object that non-visible contents are contained in
	!!		also, description should generally be a routine that calls self.numbered_description as the
	!!		last thing it does.
	!!		
	!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

	attribute numberedobject;
	class numbered_object 
		with	singular_name "<singular_name>"
		,		state null
		,		inside null
		,		description 
				[;
					print "<description>";
					self.numbered_description();
				]
		,		numbered_description
				[;
					print "Each ",(string)self.singular_name," is labled with a number beginning with ",self.start_numb," and ending with ",(self.state-->0)-1+self.start_numb,".";
				]
		,		start_numb 1
		,		singular_number 0
		,		before
				[o count total n;
					receive, open, close, Search: print_ret "There are many ",(name) self," here. Which one specifically?";
					ReceiveNum:	if((self.state-->self.singular_number)==false) 
									print_ret "That specific ",(string) self.singular_name," is closed.";
								else
								{
									if((second provides number)==false) print_ret (The) second, " will not fit in the ",(string)self.singular_name,".";
									second.number=self.singular_number;
									move second to self;
									print_ret "You put ",(the) second," into the ",(string) self.singular_name," (number ",self.singular_number,").";
								}
					SearchNum:	if(self.state-->self.singular_number==true)  
								{
									total=0;
									objectloop(o in self && o.number==self.singular_number) total++;
									if(total==0) print_ret "There is nothing inside the ",(string)self.singular_name,".";
									print "Inside the ",(string) self.singular_name," is ";
									count=0;
									objectloop(o in self && o.number==self.singular_number) 
									{
										count++;
										if(count==total && total>1) print " and ";
										print (a)o;
										if(count<total) 
											print", ";
										else
											print".";
									}
									return true;

								}
								else print_ret "That ",(string) self.singular_name," is closed.";
								
					OpenNum:	if(self.state-->self.singular_number==true) 
									print_ret "That ",(string) self.singular_name," is already open.";
								else
								{
									(self.state-->self.singular_number)=true;
									print "You open the ",(string) self.singular_name,". ";
									o=child(insidelocker);
									while(o~=nothing)
									{
										n=sibling(o);
										if(o.number==self.singular_number) move o to self;
										o=n;
									}
									<<SearchNum noun>>;
								}
					CloseNum:	if(self.state-->self.singular_number==false) 
									print_ret "That ",(string) self.singular_name," is already closed.";
								else
								{
									self.state-->self.singular_number=false;
									o=child(self);
									while(o~=nothing)
									{
										n=sibling(o);
										move o to insidelocker;
										o=n;
									}
									print_ret "You close the ",(string) self.singular_name,". ";
								}
					
				]
		has		static scenery pluralname container open has numberedobject
	;
	#endif; !USEOBJ_NUMBERED;
	#ifdef USEOBJ_DISPENSOR;
	!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	!!  This is an object that is designed to dispense quantities of a specific object.  It is useful 
	!!		for things like a pot of gold coins, where the pot may contain numerous gold coins, but the 
	!!		developer does not want to actually create all coins at once.  The class of the items that
	!!		the derived object dispenses must be defined as the property "item".  When the Dispensor
	!!		object is initialised, the newitem() function must be called with the number of items that
	!!		are to be visible at all times in the object.  When the items are removed, more are generated
	!!		to replace them, when the items are returned to the dispensor, they are destroyed.
	!!		
	!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	Class Dispensor
		with	item
		,		newitem
				[numb o t;
					if(numb<1) numb=1;
					for(t=0:t<numb:t++)
					{
						o=self.item.create();
						move o to self;
					}
				]
		,		before
				[;
					LetGo: !create another object to replace the released one
						if(noun.class==item.class) self.newitem();
					receive: !create another object to replace the released one
						if(noun.class==item.class)
						{
							print "You put ",(the) noun," into ", (the) self, " with the rest.^";
							self.item.destroy(noun);
							return true;
						}
				]
		has		container openable ~open 
	;
	#ENDIF; !USEOBJ_DISPENSOR;
	#IFDEF USEOBJ_STANDARDDOOR;
	!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	!!  This is a generic door.  It simply eases coding for the developer by utilizing generic 
	!!		reusable code for the door_to, door_dir properties.  In order use an object derived from
	!!		the StandardDoor class, simply define it with the "found_in" property listing both rooms
	!!		that the door appears in.  Also reference the door in the direction definitions (as would
	!!		normally be done)																						 
	!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	Class StandardDoor
		with	door_to 
				[;
					if((self.&found_in-->0)==location) return self.&found_in-->1;
					return self.&found_in-->0;
				]
		,		door_dir
				[;
					if(location.n_to==self) return n_to;
					if(location.s_to==self) return s_to;
					if(location.e_to==self) return e_to;
					if(location.w_to==self) return w_to;
					if(location.ne_to==self) return ne_to;
					if(location.se_to==self) return se_to;
					if(location.nw_to==self) return nw_to;
					if(location.sw_to==self) return sw_to;
					if(location.u_to==self) return u_to;
					if(location.d_to==self) return d_to;
					return self;
				]
		has static door openable
	;
	#ENDIF; !USEOBJ_STANDARDDOOR;
	#IFDEF USEOBJ_KNOWLEDGE;
		object memory "memory" selfobj
			with	name "memory" "knowledge" 
			,		invent
					[; return true;
					]
			,		article "your"
			,		knowledgeof 
					[w;
						w=null;
						return false;
					]
			,		before
					[w r c;
						Give, Show, PutOn, Take, Drop, Remove, Transfer, Insert: print_ret "Sometimes you'd like to do that to your memory, but since it is all stored inside your head you would find that somewhat difficult.";
						Consult:
							wn=consult_from;
							r=false;
							for(c=0:c<consult_words && r==false:c++)
							{
								w=NextWord();
								r=self.knowledgeof(w);
							}
							if(r==false) print_ret "You think back for a moment but can't seem to recall special about that subject.";
							return true;
					]
			has		static scenery
		;
	#ENDIF; !USEOBJ_KNOWLEDGE;
				
	!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	!!  center() is a function that works essentially like print except that text is centered on the 
	!!		screen.  Wordwrap also occurs as it does with print, but for centered text, it is generaly 
	!!		more attractive to limit the size of a line of text.  This can be accomplished by specifying
	!!		an additional value representing the maximum width of a line.  If the width is either not 
	!!		specified or is specified to be larger than the screen, then the screen width is used 
	!!		instead.
	!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	array line table 1000;
	[center text maxwidth width markerstart markerend o i;
		@loadb $21 0 -> width;				!first get the width of the display
		width=width-2;							!subtract one
		if(maxwidth==0 || maxwidth >width) maxwidth=width;		!default maxwidth of line to the width of the display if it is not defined or too large to display

		!copy the text to an array that we can manipulate
		@output_stream 3 line;	!capture output to an array
		print (string)text,"^";		!print text in array
		@output_stream -3;		!release output back to screen
		
		for(markerend=markerstart=o=2:o<=line-->0:o++)
		{
			if(line->o==' ' || line->o==13) markerend=o;					!adjust pointer to end-of-line in increments of whole words
			if(line->o==13 || o==line-->0|| o-markerstart>maxwidth)			!dump the captured line if 1)found carriage return, 2)finished parsing input, or 3) reached max size of screen
			{
				if(o==line-->0) markerend=o+1;								!if we have finished parsing the input, then the character pointed to by o is not necessarily a space or return.  Go ahead and include it in the output
				spaces(width/2)-((markerend-markerstart)/2);				!print number 
				for(i=markerstart:i<markerend:i++) print (char) line->i;	!print every charater from startmark to just prior to endmark (so as not to print ending space or carriage return)
				new_line;													!next line
				markerend=markerstart=markerend+1;							!skip the return or the space for the next run (so that it doesn't get appended to the front of the next line)
			}
		}
	];
	!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	!!  eject() prints the same number of linefeeds as there are lines on the screen (adjusting for
	!!		status and input lines).  The routine is best called after printing one section of code, but 
	!!		before printing another section of code.  This conveys a transition between logical breaks 
	!!		in the game (for instance, chapters).  The general use of the routine is as follows:
	!!				1) Text Section A is printed.
	!!				2) eject() scrolls Section A to the top of the screen and then prompts [MORE]
	!!					After user input, Section A is scrolled off.
	!!				3) Text of Section B is printed on a clear screen.
	!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	[eject height t;
		@loadb $20 0 -> height; 
		! minus three lines for the eject (status line, user prompt line, top of text line)
		for(t=0:t<height-3:t++) new_line;
	];

	Replace WriteListR;
	Replace AttemptToTakeObject;
	Replace DropSub;
	Replace PutOnSub;
	Replace InsertSub;
	!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	! MoveNotify() designed to replace a move.  It calls the moving object's 
	!		move_notify property if it exits and the receiving object's 
	!		move_to_notify property if it exisits.
	!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	Property move_notify;
	Property move_to_notify;
	[MoveNotify obj dest;
		move obj to dest;	
		if(obj provides move_notify) obj.move_notify();
		if(dest provides move_to_notify) dest.move_to_notify();
	];
	!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	! Library modifications:  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	Property plural_many;		!Used by WriteListR
	Attribute specific_number;	!Used by WriteListR
	! WriteListR: pulled from VERBLIBM.h (Rel 6/10 sn 991113)
	!	History:
	!	ModA 2000.07.20	For multiple object lists (in the form of "10 gold coins"), 
	!					replaced the count value with the property value "plural_many" 
	!					This is done if :	1) the object provides plural_many
	!										2) the count is greater than the object's property
	!											many_number, or 3 if it doesn't provide 
	!											that property (generally
	!											speaking, three doesn't equate to "many" 
	!											or "several")
	!										3) the object's parent does not have the 
	!											attribute "specific_number"
	[ WriteListR o depth stack_pointer  classes_p sizes_p i j k k2 l m n q senc mr;

	  if (depth>0 && o==child(parent(o)))
	  {   SortOutList(o); o=child(parent(o)); }
	  for (::)
	  {   if (o==0) rfalse;
		  if (c_style & WORKFLAG_BIT ~= 0 && depth==0 && o hasnt workflag)
		  {   o = sibling(o); continue; }
		  if (c_style & CONCEAL_BIT ~= 0
			  && (o has concealed || o has scenery))
		  {   o=sibling(o); continue; }
		  break;
	  }

	  classes_p = match_classes + stack_pointer;
	  sizes_p   = match_list + stack_pointer;

	  for (i=o,j=0:i~=0 && (j+stack_pointer)<128:i=NextEntry(i,depth),j++)
	  {   classes_p->j=0;
		  if (i.plural~=0) k++;
	  }

	  if (c_style & ISARE_BIT ~= 0)
	  {   if (j==1 && o hasnt pluralname)
			  print (string) IS__TX; else print (string) ARE__TX;
		  if (c_style & NEWLINE_BIT ~= 0) print ":^"; else print (char) ' ';
		  c_style = c_style - ISARE_BIT;
	  }

	  stack_pointer = stack_pointer+j+1;

	  if (k<2) jump EconomyVersion;   ! It takes two to plural
	  n=1;
	  for (i=o,k=0:k<j:i=NextEntry(i,depth),k++)
		  if (classes_p->k==0)
		  {   classes_p->k=n; sizes_p->n=1;
			  for (l=NextEntry(i,depth), m=k+1:l~=0 && m<j:
				   l=NextEntry(l,depth), m++)
				  if (classes_p->m==0 && i.plural~=0 && l.plural~=0)
				  {   if (ListEqual(i,l)==1)
					  {   sizes_p->n = sizes_p->n + 1;
						  classes_p->m = n;
					  }
				  }
			  n++;
		  }
	  n--;

	  for (i=1, j=o, k=0: i<=n: i++, senc++)
	  {   while (((classes_p->k) ~= i)
				 && ((classes_p->k) ~= -i)) { k++; j=NextEntry(j,depth); }
		  m=sizes_p->i;
		  if (j==0) mr = 0;
		  else
		  {   if (j.list_together~=0 or lt_value
				  && ZRegion(j.list_together)==2 or 3
				  && j.list_together==mr) senc--;
			  mr=j.list_together;
		  }
	  }
	  senc--;

	  for (i=1, j=o, k=0, mr=0: senc>=0: i++, senc--)
	  {   while (((classes_p->k) ~= i)
				 && ((classes_p->k) ~= -i)) { k++; j=NextEntry(j,depth); }
		  if (j.list_together~=0 or lt_value)
		  {   if (j.list_together==mr) { senc++; jump Omit_FL2; }
			  k2=NextEntry(j,depth);
			  if (k2==0 || k2.list_together~=j.list_together) jump Omit_WL2;
			  k2=ZRegion(j.list_together);
			  if (k2==2 or 3)
			  {   q=j; listing_size=1; l=k; m=i;
				  while (m<n && q.list_together==j.list_together)
				  {   m++;
					  while (((classes_p->l) ~= m)
							 && ((classes_p->l) ~= -m))
					  {   l++; q=NextEntry(q,depth); }
					  if (q.list_together==j.list_together) listing_size++;
				  }
	!              print " [", listing_size, "] ";
				  if (listing_size==1) jump Omit_WL2;
				  if (c_style & INDENT_BIT ~= 0)
					  Print__Spaces(2*(depth+wlf_indent));
              
				  if (k2==3)
				  {   q=0; for (l=0:l<listing_size:l++) q=q+sizes_p->(l+i);

	! ModA begin !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
						if(j provides plural_many && parent(j) hasnt specific_number && ( (j provides many_number && q > j.many_number) || ((j provides many_number)==false && q>3) ) )
						{
							if(PrintOrRun(j,plural_many,1)==false) EnglishNumber(q); 
						}
						else EnglishNumber(q); 
						print " ";
	! ModA end !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
					  print (string) j.list_together;
					  if (c_style & ENGLISH_BIT ~= 0) print " (";
					  if (c_style & INDENT_BIT ~= 0) print ":^";
				  }
				  q=c_style;
				  if (k2~=3)
				  {   inventory_stage=1;
					  parser_one=j; parser_two=depth+wlf_indent;
					  if (RunRoutines(j,list_together)==1) jump Omit__Sublist2;
				  }

				  @push lt_value; @push listing_together; @push listing_size;
				  lt_value=j.list_together; listing_together=j; wlf_indent++;
				  WriteListR(j,depth,stack_pointer); wlf_indent--;
				  @pull listing_size; @pull listing_together; @pull lt_value;

				  if (k2==3)
				  {   if (q & ENGLISH_BIT ~= 0) print ")";
				  }
				  else
				  {   inventory_stage=2;
					  parser_one=j; parser_two=depth+wlf_indent;
					  RunRoutines(j,list_together);
				  }
				 .Omit__Sublist2;
				  if (q & NEWLINE_BIT ~= 0 && c_style & NEWLINE_BIT == 0)
					  new_line;
				  c_style=q;
				  mr=j.list_together;
				  jump Omit_EL2;
			  }
		  }

		 .Omit_WL2;
		  if (WriteBeforeEntry(j,depth,-senc)==1) jump Omit_FL2;
		  if (sizes_p->i == 1)
		  {   if (c_style & NOARTICLE_BIT ~= 0) print (name) j;
			  else
			  {   if (c_style & DEFART_BIT ~= 0) print (the) j; else print (a) j;
			  }
		  }
		  else
		  {   if (c_style & DEFART_BIT ~= 0)
				  PrefaceByArticle(j, 1, sizes_p->i);
	! ModA begin !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!				if(j provides plural_many && number > 3 && parent(j) hasnt specific_number)
				if(j provides plural_many && parent(j) hasnt specific_number && ( (j provides many_number && number > j.many_number) || ((j provides many_number)==false && number>3) ) )
				{
					if(PrintOrRun(j,plural_many,1)==false) print (number) sizes_p->i; 
				}
				else print (number) sizes_p->i; 
				print " ";
	! ModA end !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
			PrintOrRun(j,plural,1);
		  }
		  WriteAfterEntry(j,depth,stack_pointer);

		 .Omit_EL2;
		  if (c_style & ENGLISH_BIT ~= 0)
		  {   if (senc==1) print (string) AND__TX;
			  if (senc>1) print ", ";
		  }
		 .Omit_FL2;
	  }
	  rtrue;

	  .EconomyVersion;

	  n=j;

	  for (i=1, j=o: i<=n: j=NextEntry(j,depth), i++, senc++)
	  {   if (j.list_together~=0 or lt_value
			  && ZRegion(j.list_together)==2 or 3
			  && j.list_together==mr) senc--;
		  mr=j.list_together;
	  }

	  for (i=1, j=o, mr=0: i<=senc: j=NextEntry(j,depth), i++)
	  {   if (j.list_together~=0 or lt_value)
		  {   if (j.list_together==mr) { i--; jump Omit_FL; }
			  k=NextEntry(j,depth);
			  if (k==0 || k.list_together~=j.list_together) jump Omit_WL;
			  k=ZRegion(j.list_together);
			  if (k==2 or 3)
			  {   if (c_style & INDENT_BIT ~= 0)
					  Print__Spaces(2*(depth+wlf_indent));
				  if (k==3)
				  {   q=j; l=0;
					  do
					  {   q=NextEntry(q,depth); l++;
					  } until (q==0 || q.list_together~=j.list_together);
					  EnglishNumber(l); print " ";
					  print (string) j.list_together;
					  if (c_style & ENGLISH_BIT ~= 0) print " (";
					  if (c_style & INDENT_BIT ~= 0) print ":^";
				  }
				  q=c_style;
				  if (k~=3)
				  {   inventory_stage=1;
					  parser_one=j; parser_two=depth+wlf_indent;
					  if (RunRoutines(j,list_together)==1) jump Omit__Sublist;
				  }

				  @push lt_value; @push listing_together; @push listing_size;
				  lt_value=j.list_together; listing_together=j; wlf_indent++;
				  WriteListR(j,depth,stack_pointer); wlf_indent--;
				  @pull listing_size; @pull listing_together; @pull lt_value;

				  if (k==3)
				  {   if (q & ENGLISH_BIT ~= 0) print ")";
				  }
				  else
				  {   inventory_stage=2;
					  parser_one=j; parser_two=depth+wlf_indent;
					  RunRoutines(j,list_together);
				  }
				 .Omit__Sublist;
				  if (q & NEWLINE_BIT ~= 0 && c_style & NEWLINE_BIT == 0) new_line;
				  c_style=q;
				  mr=j.list_together;
				  jump Omit_EL;
			  }
		  }
		 .Omit_WL;
		  if (WriteBeforeEntry(j,depth,i-senc)==1) jump Omit_FL;
		  if (c_style & NOARTICLE_BIT ~= 0) print (name) j;
		  else
		  {   if (c_style & DEFART_BIT ~= 0) print (the) j; else print (a) j;
		  }
		  WriteAfterEntry(j,depth,stack_pointer);

		 .Omit_EL;
		  if (c_style & ENGLISH_BIT ~= 0)
		  {   if (i==senc-1) print (string) AND__TX;
			  if (i<senc-1) print ", ";
		  }
		 .Omit_FL;
	  }
	];

	[ AttemptToTakeObject item     ancestor after_recipient i j k;
	  ! Try to transfer the given item to the player: return false
	  ! if successful, true if unsuccessful, printing a suitable message
	  ! in the latter case.

	  ! People cannot ordinarily be taken.
	  if (item == player) return L__M(##Take,2);
	  if (item has animate) return L__M(##Take,3,item);

	  ancestor = CommonAncestor(player, item);

	  if (ancestor == 0)
	  {   i = ObjectScopedBySomething(item);
		  if (i ~= 0) ancestor = CommonAncestor(player, i);
	  }

	  ! Are player and item in totally different places?

	  if (ancestor == 0) return L__M(##Take,8,item);

	  ! Is the player indirectly inside the item?
	  if (ancestor == item) return L__M(##Take,4,item);

	  ! Does the player already directly contain the item?
	  if (item in player) return L__M(##Take,5,item);

	  ! Can the player touch the item, or is there (e.g.) a closed container
	  ! in the way?
	  if (ObjectIsUntouchable(item,false,true)) return;

	  ! The item is now known to be accessible.

	  ! Consult the immediate possessor of the item, if it's in a container
	  ! which the player is not in.

	  i=parent(item);
	  if (i ~= ancestor && (i has container || i has supporter))
	  {   after_recipient=i;
		  k=action; action=##LetGo;
		  if (RunRoutines(i,before)~=0) { action=k; rtrue; }
		  action=k;
	  }

	  if (item has scenery) return L__M(##Take,10,item);
	  if (item has static)  return L__M(##Take,11,item);

	  ! The item is now known to be available for taking.  Is the player
	  ! carrying too much?  If so, possibly juggle items into the rucksack
	  ! to make room.

	  k=0; objectloop (j in player) if (j hasnt worn) k++;

	  if (k >= ValueOrRun(player,capacity))
	  {   if (SACK_OBJECT~=0)
		  {   if (parent(SACK_OBJECT)~=player)
				  return L__M(##Take,12);
			  j=0;
			  objectloop (k in player) 
				  if (k~=SACK_OBJECT && k hasnt worn && k hasnt light) j=k;

			  if (j~=0)
			  {   L__M(##Take,13,j);
				  keep_silent = 1; <Insert j SACK_OBJECT>; keep_silent = 0;
				  if (j notin SACK_OBJECT) rtrue;
			  }
			  else return L__M(##Take,12);
		  }
		  else return L__M(##Take,12);
	  }

	  ! Transfer the item.

	  !move item to player;
	  MoveNotify(item, player);

	  ! Send "after" message to the object letting go of the item, if any.

	  if (after_recipient~=0)
	  {   k=action; action=##LetGo;
		  if (RunRoutines(after_recipient,after)~=0) { action=k; rtrue; }
		  action=k;
	  }
	  rfalse;
	];

	[ DropSub;
	  if (noun == player) return L__M(##PutOn, 4);
	  if (noun in parent(player)) return L__M(##Drop,1,noun);
	  if (noun notin player) return L__M(##Drop,2,noun);
	  if (noun has worn)
	  {   L__M(##Drop,3,noun);
		  <Disrobe noun>;
		  if (noun has worn && noun in player) rtrue;
	  }
	  !move noun to parent(player);
	  MoveNotify(noun, parent(player));

	  if (AfterRoutines()==1) rtrue;
	  if (keep_silent==1) rtrue;
	  return L__M(##Drop,4,noun);
	];

	[ PutOnSub ancestor;
	  receive_action=##PutOn; 
	  if (second == d_obj || player in second) <<Drop noun>>;
	  if (parent(noun)~=player) return L__M(##PutOn,1,noun);

	  ancestor = CommonAncestor(noun, second);
	  if (ancestor == noun) return L__M(##PutOn,2,noun);
	  if (ObjectIsUntouchable(second)) return;

	  if (second ~= ancestor)
	  {   action=##Receive;
		  if (RunRoutines(second,before)~=0) { action=##PutOn; return; }
		  action=##PutOn;
	  }
	  if (second hasnt supporter) return L__M(##PutOn,3,second);
	  if (ancestor == player) return L__M(##PutOn,4);
	  if (noun has worn)
	  {   L__M(##PutOn,5,noun); <Disrobe noun>; if (noun has worn) return;
	  }

	  if (children(second)>=ValueOrRun(second,capacity))
		  return L__M(##PutOn,6,second);

	  !move noun to second;
	  MoveNotify(noun,second);

	  if (AfterRoutines()==1) return;

	  if (second ~= ancestor)
	  {   action=##Receive;
		  if (RunRoutines(second,after)~=0) { action=##PutOn; return; }
		  action=##PutOn;
	  }
	  if (keep_silent==1) return;
	  if (multiflag==1) return L__M(##PutOn,7);
	  L__M(##PutOn,8,noun);
	];

	[ InsertSub ancestor;
	  receive_action = ##Insert;
	  if (second==d_obj || player in second) <<Drop noun>>;
	  if (parent(noun)~=player) return L__M(##Insert,1,noun);

	  ancestor = CommonAncestor(noun, second);
	  if (ancestor == noun) return L__M(##Insert, 5, noun);
	  if (ObjectIsUntouchable(second)) return;

	  if (second ~= ancestor)
	  {   action=##Receive;
		  if (RunRoutines(second,before)~=0) { action=##Insert; rtrue; }
		  action=##Insert;
		  if (second has container && second hasnt open)
			  return L__M(##Insert,3,second);
	  }
	  if (second hasnt container) return L__M(##Insert,2,second);

	  if (noun has worn)
	  {   L__M(##Insert,6,noun); <Disrobe noun>; if (noun has worn) return;
	  }

	  if (children(second) >= ValueOrRun(second,capacity))
		  return L__M(##Insert,7,second);

	  !move noun to second;
	  MoveNotify(noun,second);

	  if (AfterRoutines()==1) rtrue;

	  if (second ~= ancestor)
	  {   action=##Receive;
		  if (RunRoutines(second,after)~=0) { action=##Insert; rtrue; }
		  action=##Insert;
	  }
	  if (keep_silent==1) rtrue;
	  if (multiflag==1) return L__M(##Insert,8,noun);
	  L__M(##Insert,9,noun);
	];
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!! VERBS
!!! DO these language implementations the second time the file is included...
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
#ifnot;
	!--  typing or entering or putting number into an object -------------------------------------
	Verb "type"
		* number "into"/"in"/"on"/"onto" noun	->TypeNum reverse
	;
	Extend only "enter" 
		* number "into"/"in"/"on"/"onto" noun	->TypeNum reverse
	;
	Extend only "put" 
		* number "into"/"in"/"on"/"onto" noun	->TypeNum reverse
	;
	[TypeNumSub;
		print "You cannot type anything on ",(the) noun,".";
	];
	!--  climb into -----------------------------------------------------------------------------------
	Extend only "climb"
		*	"into"/"in"/"onto"/"on" noun	->Enter
	;
	#ifdef USEOBJ_NUMBERED;
		!---- handle numbered objects ----------------------------------------------
		[NumberedObj o word n;
			o=noundomain(location,player,NOUN_TOKEN);
			if(o==0 or 1) return -1;
			if(o hasnt numberedobject) return -1;
			word=NextWord(); !get the next word and move on...
			if(word~='number' or 'numbered') wn--; !if the next word was not a word to ignore then backtrack
			n=trynumber(wn);
			if(n==-1000 or 0) return -1; !this may be a numbered object, but if we can't find the specifying number then move on
			o.singular_number=n;
			wn++;
			return o;
		];
		!---- numbered object open -------------------------------------------------
		Extend "open" first
			* NumberedObj			->	OpenNum
		;
		[OpenNumSub;
			print (The) noun," is not a numbered object.";	
		];
		!---- numbered object close -------------------------------------------------
		Extend "close" last
			* NumberedObj			->	CloseNum
		;
		[CloseNumSub;
			print (The) noun," is not a numbered object.";	
		];
		!---- numbered object search -------------------------------------------------
		Extend "examine" last
			* NumberedObj			->	SearchNum
		;
		Extend "look" last
			* "in"/"at" NumberedObj	->	SearchNum
		;
		[SearchNumSub;
			print (The) noun," is not a numbered object.";	
		];
		!---- numbered object insert into -------------------------------------------------
		Extend "insert" first
			* held "into"/"in" NumberedObj ->	ReceiveNum reverse 
			* "into"/"in" NumberedObj held ->	ReceiveNum 
		;
		Extend "put" first
			* held "into"/"in" NumberedObj ->	ReceiveNum reverse
			* "into"/"in" NumberedObj held ->	ReceiveNum 
		;
		!the noun should be the numbered container so that it can handle the before and after routiones and 
		!determine what to do based on the number
		[ReceiveNumSub;
			print (The) noun," is not a numbered object.";	
		];
	#endif;
	#ifdef USEOBJ_KNOWLEDGE;
		!---- remember ----------------------------------------------
		Verb "remember"
			* topic					->	Remember
		;
		Verb "recall" 
			* topic					->	Remember
		;
		[RememberSub;
			<<Consult memory>>;
		];
	#endif; !verbpoint
#endif; !verbpoint

