// Generated by CoffeeScript 1.7.1
var Animal, Bird, Elephant, Goat, Mayfly, Monkey, Penguin, Tiger, Villager, Vulture, animalGrid, animals,
  __hasProp = {}.hasOwnProperty,
  __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

Animal = (function(_super) {
  __extends(Animal, _super);

  Animal.prototype.hp = 10;

  Animal.prototype.speed = 1;

  Animal.prototype.size = 5;

  Animal.prototype.strength = 5;

  Animal.prototype.material = flesh;

  Animal.prototype.gender = "unknown";

  Animal.prototype.animate = true;

  Animal.prototype.feed = "herbivore";

  function Animal(list) {
    this.hunger = between(0, 50);
    Animal.__super__.constructor.call(this, list);
  }

  Animal.prototype.act = function() {
    var target;
    this.hunger++;
    if (this === player || this.pause || this.dead) {
      return;
    }
    this.stand();
    if (player.curse && visible(this, player)) {
      this.attack(player);
      return true;
    }
    if (this.hunger > 50) {
      if (this.feed === "predator" || this.feed === "scavenger") {
        target = oneOf(select(all(root(this)), function(c) {
          return c.dead;
        }));
        if (target) {
          see("#1 devour#s the #2", this, target);
          this.hunger = 0;
          return true;
        }
      }
      if (this.feed === "predator") {
        target = oneOf(select(all(root(this)), function(c) {
          return c.size < this.size;
        }));
        if (target) {
          if (this.hunger < 60) {
            see("#1 look#s hungrily at #2.", this, target);
          } else {
            this.attack(target);
          }
          return true;
        }
      }
    }
    if (this.inside.animate) {
      switch (magnitude(2)) {
        case 1:
          see("#1 struggle#s in #2 grip.", this, this.inside);
          break;
        case 2:
          see("#1 escape#s #2!", this, this.inside);
          get(this.inside.inside, this);
      }
      return true;
    }
    switch (magnitude(3)) {
      case 1:
        this.talk();
        return true;
      case 2:
        randomMove(this);
        return true;
    }
  };

  Animal.prototype.talk = function(target) {
    if (this.vocalisations) {
      hear("#1 " + (oneOf(this.vocalisations)) + "#s.", this);
    }
    if (target) {
      return target.talked(this);
    }
  };

  Animal.prototype.talked = function(speaker) {
    return this.talk();
  };

  Animal.prototype.stand = function() {
    if (this.relation === relation.fallen && oneIn(2)) {
      if (visible) {
        Say("" + (capitalise(knowIntimately(this))) + " stands.");
      }
    }
    return this.relation === relation["in"];
  };

  Animal.prototype.kissedBy = function(thing) {
    this.startle();
    return this.talk();
  };

  Animal.prototype.startle = function() {
    return see("#1 " + (oneOf(['startles', 'jumps', 'stares', 'panics', 'glares'])) + ".", this);
  };

  Animal.prototype.die = function() {
    this.dead = true;
    return this.name = "dead " + this.name;
  };

  return Animal;

})(Thing);

Bird = (function(_super) {
  __extends(Bird, _super);

  function Bird() {
    return Bird.__super__.constructor.apply(this, arguments);
  }

  Bird.prototype.name = oneOf(["parrot", "mynah", "macaw", "toucan"]);

  Bird.prototype.vocalisations = ['squawk', 'cluck', 'gurgle', 'trill'];

  Bird.prototype.act = function() {
    var scratchable;
    if (Bird.__super__.act.call(this)) {
      return;
    }
    if (oneIn(2)) {
      if (visible(this)) {
        scratchable = select(all(this.inside), function(c) {
          return c.material === vegetable || c.material === wood;
        });
        if (scratchable.length === 0) {
          scratchable = oneOf(all(this.inside));
        }
        if (scratchable.length) {
          Say("" + (capitalise(knowIntimately(this))) + " " + (oneOf(['scratch', 'peck', 'gnaw'])) + (s(this)) + " " + (knowIntimately(oneOf(scratchable))) + ".");
        }
      }
    }
    if (oneIn(256)) {
      return hear("#1 cries '" + (recollection()) + "'", this);
    }
  };

  return Bird;

})(Animal);

Monkey = (function(_super) {
  __extends(Monkey, _super);

  function Monkey() {
    return Monkey.__super__.constructor.apply(this, arguments);
  }

  Monkey.prototype.name = oneOf(["chimpanzee", "tamarin", "capuchin", "colobus"]);

  Monkey.prototype.vocalisations = ['shriek', 'howl', 'stare', 'jumps up and down'];

  Monkey.prototype.act = function() {
    var target;
    if (Monkey.__super__.act.call(this)) {
      return;
    }
    if (oneIn(2)) {
      target = oneOf(select(all(root(this)), function(c) {
        return c.size > 50;
      }));
      if (target && target !== this.inside) {
        see("#1 leap#s from #2 to #3.", this, this.inside, target);
        get(target, this);
        if (target.exits) {
          return this.relation = relation["in"];
        } else {
          return this.relation = relation.clinging;
        }
      }
    }
  };

  return Monkey;

})(Animal);

Elephant = (function(_super) {
  __extends(Elephant, _super);

  function Elephant() {
    return Elephant.__super__.constructor.apply(this, arguments);
  }

  Elephant.prototype.name = "elephant";

  Elephant.prototype.vocalisations = ['trumpet', 'gurgle', 'stomp', 'snuffle'];

  Elephant.prototype.size = 150;

  return Elephant;

})(Animal);

Vulture = (function(_super) {
  __extends(Vulture, _super);

  function Vulture() {
    return Vulture.__super__.constructor.apply(this, arguments);
  }

  Vulture.prototype.name = oneOf(["vulture", "buzzard", "wedge-tailed eagle", "carrion crow"]);

  Vulture.prototype.vocalisations = ['caw', 'shriek', 'screech', 'cackle'];

  Vulture.prototype.feed = "scavenger";

  return Vulture;

})(Animal);

Tiger = (function(_super) {
  __extends(Tiger, _super);

  function Tiger() {
    return Tiger.__super__.constructor.apply(this, arguments);
  }

  Tiger.prototype.name = oneOf(["tiger", "lion", "leopard", "panther"]);

  Tiger.prototype.vocalisations = ['roar', 'snarl', 'scratches itself', 'sniff'];

  Tiger.prototype.feed = "predator";

  Tiger.prototype.size = 30;

  Tiger.prototype.flavour = "blood";

  return Tiger;

})(Animal);

Penguin = (function(_super) {
  __extends(Penguin, _super);

  function Penguin() {
    return Penguin.__super__.constructor.apply(this, arguments);
  }

  Penguin.prototype.name = "penguin";

  Penguin.prototype.vocalisations = ['squawk', 'flap', 'strut', 'groan'];

  Penguin.prototype.size = 3;

  return Penguin;

})(Animal);

Goat = (function(_super) {
  __extends(Goat, _super);

  function Goat() {
    return Goat.__super__.constructor.apply(this, arguments);
  }

  Goat.prototype.name = "mountain goat";

  Goat.prototype.vocalisations = ['gnaw', 'hop', 'bray', 'grumble'];

  Goat.prototype.size = 15;

  return Goat;

})(Animal);

Villager = (function(_super) {
  __extends(Villager, _super);

  Villager.prototype.wandering = 20;

  function Villager() {
    this.name = oneOf(getWords(ADJECTIVE, EVIL | GRAND)) + " villager";
    Villager.__super__.constructor.call(this);
  }

  Villager.prototype.talk = function() {
    var target;
    target = oneOf(select(this.inside.contents, function(c) {
      return c.animate;
    }));
    if ((target != null) !== this) {
      return target.talked(this);
    }
  };

  Villager.prototype.talked = function(speaker) {
    var statement;
    switch (between(0, 4)) {
      case 0:
        if (localStorage.length) {
          statement = "A stranger once told me life is " + localStorage['memory no. ' + between(0, localStorage.length)] + ".";
        }
        break;
      case 1:
        statement = "I seek a " + (oneOf(['many-faceted diamond', 'crystal skull', 'aleph', 'gold talismen', 'witch book'])) + ".";
        break;
      case 2:
        statement = "Good day, sir!";
        break;
      case 3:
        switch (magnitude(4)) {
          case 0:
            statement = oneOf(rumours);
            break;
          case 1:
            statement = proverb();
            break;
          case 2:
            statement = "" + (vulgarity()) + ", I'm " + (oneOf(getWords(ADJECTIVE))) + "!";
            break;
          case 3:
            statement = oneOf(getWords(0)).toUpperCase() + "!";
            break;
          default:
            statement = "The magic word is " + oneOf(Object.keys(magicWords));
        }
    }
    if (statement && speaker !== this) {
      return hear("#1 say#s to #2: '" + statement + "'", this, speaker);
    }
  };

  return Villager;

})(Animal);

Mayfly = (function(_super) {
  __extends(Mayfly, _super);

  function Mayfly() {
    return Mayfly.__super__.constructor.apply(this, arguments);
  }

  Mayfly.prototype.name = "mayfly";

  Mayfly.prototype.size = 1;

  Mayfly.prototype.flavour = "transience";

  Mayfly.prototype.act = function() {
    if (this.inside === player) {
      Say("The mayfly vibrates against your palm, desperate to escape.", "box monospace");
    }
    return Mayfly.__super__.act.call(this);
  };

  return Mayfly;

})(Animal);

animals = function(room) {
  var animal, ix, iy;
  ix = parseInt(room.temperature * 1.5 + 1.49);
  iy = parseInt(room.rainfall * 1.5 + 1.49);
  animal = oneOf(animalGrid[iy][ix]);
  if (animal) {
    return get(room, new animal());
  }
};

animalGrid = [[[], [], [Penguin]], [[Goat], [], []], [[Vulture], [Elephant, Tiger], [Bird, Monkey]]];
