/* error.c
   functions to handle error and notice popups */

     /*---------------------------------------------------------------*/
     /* Xgopher        version 1.2     20 November 1991               */
     /*                version 1.1     20 April 1991                  */
     /*                version 1.0     04 March 1991                  */
     /* X window system client for the University of Minnesota        */
     /*                                Internet Gopher System.        */
     /* Allan Tuchman, University of Illinois at Urbana-Champaign     */
     /*                Computing and Communications Services Office   */
     /* Copyright 1992 by                                             */
     /*           the Board of Trustees of the University of Illinois */
     /* Permission is granted to freely copy and redistribute this    */
     /* software with the copyright notice intact.                    */
     /*---------------------------------------------------------------*/


#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/Command.h>
#include <X11/Xaw/Dialog.h>
#include <X11/Shell.h>

#include "error.h"
#include "gui.h"
#include "bitmaps/sadxgopher.xbm"
#include "bitmaps/xgopher.xbm"

static Widget	topLevel;
Widget		errorDialogShell,
		errorDialog;
Widget		errorDialogLabel;
Widget		errorOkButton;
Pixmap		errorPixmap = None;

int		width;

Widget		infoDialogShell,
		infoDialog;
Widget		infoDialogLabel;
Pixmap		infoPixmap = None;


/* errorOkProc
   User has read and accepted the error */

static void
errorOkProc(w, client_data, call_data)
Widget		w;
XtPointer	client_data, call_data;
{
	XtPopdown(errorDialogShell);

	return;
}


/* errorExitProc
   Fatal errors exit here */

static void
errorExitProc(w, client_data, call_data)
Widget		w;
XtPointer	client_data, call_data;
{
	XtPopdown(errorDialogShell);

	exit(1);
}


/* makeErrorDialog
   create popup dialog for reporting errors */

void
makeErrorDialog(top)
Widget	top;
{
	Arg		args[3];
	Cardinal	n = 0;

	topLevel = top;
	n = 0;
	XtSetArg(args[n], XtNtitle, "Xgopher error");  n++;
	errorDialogShell = XtCreatePopupShell("errorDialogShell", 
					transientShellWidgetClass,
					topLevel, args, n);

	errorPixmap = XCreatePixmapFromBitmapData (XtDisplay(topLevel),
				RootWindowOfScreen(XtScreen(topLevel)),
					sadxgopher_bits,
					sadxgopher_width, sadxgopher_height,
					BlackPixelOfScreen(XtScreen(topLevel)),
					WhitePixelOfScreen(XtScreen(topLevel)),
					DefaultDepthOfScreen(XtScreen(topLevel))
					);

	n = 0;
	XtSetArg(args[n], XtNlabel, "Xgopher error");  n++;
	if (errorPixmap != None) {
		XtSetArg(args[n], XtNicon, errorPixmap);  n++;
	}
	errorDialog= XtCreateManagedWidget("errorDialog", 
					dialogWidgetClass,
					errorDialogShell, args, n);
		{
			XFontStruct	*textFontStruct;
			int		direction, ascent, descent;
			XCharStruct	overall;
			Position	topMargin, bottomMargin;

			errorDialogLabel = XtNameToWidget(errorDialog, "label");

			n=0;
			XtSetArg(args[n], XtNfont, &textFontStruct);  n++;
			XtGetValues(errorDialogLabel, args, n);
			XTextExtents(textFontStruct, "mljf", 4,
				&direction, &ascent, &descent, &overall);

			width = overall.width*20;
		}

	errorOkButton = XtCreateManagedWidget("ok", commandWidgetClass, 
					errorDialog, NULL, (Cardinal) 0);
		XtAddCallback(errorOkButton, XtNcallback, errorOkProc, NULL);

	
}


/* displayError
   enable popup dialog for saving files */

void
displayError(errorText, fatal)
char	*errorText;
Boolean	fatal;
{
	Arg		args[3];
	Cardinal	n = 0;


	n = 0;
	XtSetArg(args[n], XtNlabel, errorText);  n++;
	XtSetValues(errorDialog, args, n);

	n = 0;
	XtSetArg(args[n], XtNwidth, width);  n++;
	XtSetValues(errorDialogLabel, args, n);


	if (fatal) {
		XtAddCallback(errorOkButton, XtNcallback, errorExitProc, NULL);
		positionPopup(errorDialogShell, POS_screen, topLevel,
				50, 50, 1, 1);
	} else {
		positionPopup(errorDialogShell, POS_pointer, topLevel,
				50, 50, 0, 2);
	}


	XtPopup(errorDialogShell, XtGrabNonexclusive);

	return;
}

/* info popup and stuff */

/* infoOkProc
   User has read and accepted the information */

static void
infoOkProc(w, client_data, call_data)
Widget		w;
XtPointer	client_data, call_data;
{
	XtPopdown(infoDialogShell);

	return;
}


/* makeInfoDialog
   create popup dialog for reporting infos */

void
makeInfoDialog(top)
Widget	top;
{
	Widget		infoOkButton;
	Arg		args[3];
	Cardinal	n = 0;

	topLevel = top;
	n = 0;
	XtSetArg(args[n], XtNtitle, "Xgopher information");  n++;
	infoDialogShell = XtCreatePopupShell("infoDialogShell", 
					transientShellWidgetClass,
					topLevel, args, n);

	infoPixmap = XCreatePixmapFromBitmapData (XtDisplay(topLevel),
				RootWindowOfScreen(XtScreen(topLevel)),
					xgopher_bits,
					xgopher_width, xgopher_height,
					BlackPixelOfScreen(XtScreen(topLevel)),
					WhitePixelOfScreen(XtScreen(topLevel)),
					DefaultDepthOfScreen(XtScreen(topLevel))
					);

	n = 0;
	XtSetArg(args[n], XtNlabel, "Xgopher information");  n++;
	if (infoPixmap != None) {
		XtSetArg(args[n], XtNicon, infoPixmap);  n++;
	}
	infoDialog= XtCreateManagedWidget("infoDialog", 
					dialogWidgetClass,
					infoDialogShell, args, n);
		{
			XFontStruct	*textFontStruct;
			int		direction, ascent, descent;
			XCharStruct	overall;
			Position	topMargin, bottomMargin;

			infoDialogLabel = XtNameToWidget(infoDialog, "label");

			n=0;
			XtSetArg(args[n], XtNfont, &textFontStruct);  n++;
			XtGetValues(infoDialogLabel, args, n);
			XTextExtents(textFontStruct, "mljf", 4,
				&direction, &ascent, &descent, &overall);

			width = overall.width*20;
		}

	infoOkButton = XtCreateManagedWidget("ok", commandWidgetClass, 
					infoDialog, NULL, (Cardinal) 0);
		XtAddCallback(infoOkButton, XtNcallback, infoOkProc, NULL);

	
}


/* displayInfo
   enable popup dialog for saving files */

void
displayInfo(infoText)
char	*infoText;
{
	Arg		args[3];
	Cardinal	n = 0;


	n = 0;
	XtSetArg(args[n], XtNlabel, infoText);  n++;
	XtSetValues(infoDialog, args, n);

	n = 0;
	XtSetArg(args[n], XtNwidth, width);  n++;
	XtSetValues(infoDialogLabel, args, n);


	positionPopup(infoDialogShell, POS_pointer, topLevel,
			50, 50, 0, 2);


	XtPopup(infoDialogShell, XtGrabNonexclusive);

	return;
}
