# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from ._utils.model_base import Model as _Model, rest_discriminator, rest_field
from ._enums import (
    AgentKind,
    AnnotationType,
    CodeInterpreterOutputType,
    ComputerActionType,
    ComputerToolCallOutputItemOutputType,
    CredentialType,
    DatasetType,
    DeploymentType,
    EvaluationRuleActionType,
    EvaluationTaxonomyInputType,
    EvaluatorDefinitionType,
    IndexType,
    InsightType,
    ItemContentType,
    ItemType,
    LocationType,
    MemoryItemKind,
    MemoryStoreKind,
    OpenApiAuthType,
    PendingUploadType,
    ReasoningItemSummaryPartType,
    RecurrenceType,
    ResponseStreamEventType,
    ResponseTextFormatConfigurationType,
    ResponsesMessageRole,
    SampleType,
    ScheduleTaskType,
    ToolChoiceObjectType,
    ToolType,
    TriggerType,
    WebSearchActionType,
)

if TYPE_CHECKING:
    from .. import _types, models as _models   # type: ignore


class Tool(_Model):
    """Tool.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    A2ATool, AzureAISearchAgentTool, AzureFunctionAgentTool, BingCustomSearchAgentTool,
    BingGroundingAgentTool, BrowserAutomationAgentTool, CaptureStructuredOutputsTool,
    CodeInterpreterTool, ComputerUsePreviewTool, MicrosoftFabricAgentTool, FileSearchTool,
    FunctionTool, ImageGenTool, LocalShellTool, MCPTool, MemorySearchTool, OpenApiAgentTool,
    SharepointAgentTool, WebSearchPreviewTool

    :ivar type: Required. Known values are: "file_search", "function", "computer_use_preview",
     "web_search_preview", "mcp", "code_interpreter", "image_generation", "local_shell",
     "bing_grounding", "browser_automation_preview", "fabric_dataagent_preview",
     "sharepoint_grounding_preview", "azure_ai_search", "openapi", "bing_custom_search_preview",
     "capture_structured_outputs", "a2a_preview", "azure_function", and "memory_search".
    :vartype type: str or ~azure.ai.projects.models.ToolType
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Required. Known values are: \"file_search\", \"function\", \"computer_use_preview\",
     \"web_search_preview\", \"mcp\", \"code_interpreter\", \"image_generation\", \"local_shell\",
     \"bing_grounding\", \"browser_automation_preview\", \"fabric_dataagent_preview\",
     \"sharepoint_grounding_preview\", \"azure_ai_search\", \"openapi\",
     \"bing_custom_search_preview\", \"capture_structured_outputs\", \"a2a_preview\",
     \"azure_function\", and \"memory_search\"."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class A2ATool(Tool, discriminator="a2a_preview"):
    """An agent implementing the A2A protocol.

       :ivar type: The type of the tool. Always ``a2a``. Required.
       :vartype type: str or ~azure.ai.projects.models.A2_A_PREVIEW
       :ivar base_url: Base URL of the agent.
       :vartype base_url: str
       :ivar agent_card_path: The path to the agent card relative to the ``base_url``.
    If not provided, defaults to  ``/.well-known/agent-card.json``.
       :vartype agent_card_path: str
       :ivar project_connection_id: The connection ID in the project for the A2A server.
    The connection stores authentication and other connection details needed to connect to the A2A
        server.
       :vartype project_connection_id: str
    """

    type: Literal[ToolType.A2_A_PREVIEW] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the tool. Always ``a2a``. Required."""
    base_url: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Base URL of the agent."""
    agent_card_path: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The path to the agent card relative to the ``base_url``.
 If not provided, defaults to  ``/.well-known/agent-card.json``."""
    project_connection_id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The connection ID in the project for the A2A server.
 The connection stores authentication and other connection details needed to connect to the A2A
     server."""

    @overload
    def __init__(
        self,
        *,
        base_url: Optional[str] = None,
        agent_card_path: Optional[str] = None,
        project_connection_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ToolType.A2_A_PREVIEW  # type: ignore


class InsightResult(_Model):
    """The result of the insights.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AgentClusterInsightResult, EvalCompareReport, EvaluationRunClusterInsightResult

    :ivar type: The type of insights result. Required. Known values are:
     "EvaluationRunClusterInsight", "AgentClusterInsight", and "EvaluationComparison".
    :vartype type: str or ~azure.ai.projects.models.InsightType
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """The type of insights result. Required. Known values are: \"EvaluationRunClusterInsight\",
     \"AgentClusterInsight\", and \"EvaluationComparison\"."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AgentClusterInsightResult(InsightResult, discriminator="AgentClusterInsight"):
    """Insights from the agent cluster analysis.

    :ivar type: The type of insights result. Required. Cluster Insight on an Agent.
    :vartype type: str or ~azure.ai.projects.models.AGENT_CLUSTER_INSIGHT
    :ivar cluster_insight: Required.
    :vartype cluster_insight: ~azure.ai.projects.models.ClusterInsightResult
    """

    type: Literal[InsightType.AGENT_CLUSTER_INSIGHT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of insights result. Required. Cluster Insight on an Agent."""
    cluster_insight: "_models.ClusterInsightResult" = rest_field(
        name="clusterInsight", visibility=["read", "create", "update", "delete", "query"]
    )
    """Required."""

    @overload
    def __init__(
        self,
        *,
        cluster_insight: "_models.ClusterInsightResult",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = InsightType.AGENT_CLUSTER_INSIGHT  # type: ignore


class InsightRequest(_Model):
    """The request of the insights report.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AgentClusterInsightsRequest, EvaluationComparisonRequest, EvaluationRunClusterInsightsRequest

    :ivar type: The type of request. Required. Known values are: "EvaluationRunClusterInsight",
     "AgentClusterInsight", and "EvaluationComparison".
    :vartype type: str or ~azure.ai.projects.models.InsightType
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """The type of request. Required. Known values are: \"EvaluationRunClusterInsight\",
     \"AgentClusterInsight\", and \"EvaluationComparison\"."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AgentClusterInsightsRequest(InsightRequest, discriminator="AgentClusterInsight"):
    """Insights on set of Agent Evaluation Results.

    :ivar type: The type of request. Required. Cluster Insight on an Agent.
    :vartype type: str or ~azure.ai.projects.models.AGENT_CLUSTER_INSIGHT
    :ivar agent_name: Identifier for the agent. Required.
    :vartype agent_name: str
    :ivar model_configuration: Configuration of the model used in the insight generation.
    :vartype model_configuration: ~azure.ai.projects.models.InsightModelConfiguration
    """

    type: Literal[InsightType.AGENT_CLUSTER_INSIGHT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of request. Required. Cluster Insight on an Agent."""
    agent_name: str = rest_field(name="agentName", visibility=["read", "create", "update", "delete", "query"])
    """Identifier for the agent. Required."""
    model_configuration: Optional["_models.InsightModelConfiguration"] = rest_field(
        name="modelConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Configuration of the model used in the insight generation."""

    @overload
    def __init__(
        self,
        *,
        agent_name: str,
        model_configuration: Optional["_models.InsightModelConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = InsightType.AGENT_CLUSTER_INSIGHT  # type: ignore


class AgentContainerObject(_Model):
    """The details of the container of a specific version of an agent.

    :ivar object: The object type, which is always 'agent.container'. Required. Default value is
     "agent.container".
    :vartype object: str
    :ivar status: The status of the container of a specific version of an agent. Required. Known
     values are: "Starting", "Running", "Stopping", "Stopped", "Failed", "Deleting", "Deleted", and
     "Updating".
    :vartype status: str or ~azure.ai.projects.models.AgentContainerStatus
    :ivar max_replicas: The maximum number of replicas for the container. Default is 1.
    :vartype max_replicas: int
    :ivar min_replicas: The minimum number of replicas for the container. Default is 1.
    :vartype min_replicas: int
    :ivar error_message: The error message if the container failed to operate, if any.
    :vartype error_message: str
    :ivar created_at: The creation time of the container. Required.
    :vartype created_at: ~datetime.datetime
    :ivar updated_at: The last update time of the container. Required.
    :vartype updated_at: ~datetime.datetime
    """

    object: Literal["agent.container"] = rest_field(visibility=["read"])
    """The object type, which is always 'agent.container'. Required. Default value is
     \"agent.container\"."""
    status: Union[str, "_models.AgentContainerStatus"] = rest_field(visibility=["read"])
    """The status of the container of a specific version of an agent. Required. Known values are:
     \"Starting\", \"Running\", \"Stopping\", \"Stopped\", \"Failed\", \"Deleting\", \"Deleted\",
     and \"Updating\"."""
    max_replicas: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The maximum number of replicas for the container. Default is 1."""
    min_replicas: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The minimum number of replicas for the container. Default is 1."""
    error_message: Optional[str] = rest_field(visibility=["read"])
    """The error message if the container failed to operate, if any."""
    created_at: datetime.datetime = rest_field(visibility=["read"], format="rfc3339")
    """The creation time of the container. Required."""
    updated_at: datetime.datetime = rest_field(visibility=["read"], format="rfc3339")
    """The last update time of the container. Required."""

    @overload
    def __init__(
        self,
        *,
        max_replicas: Optional[int] = None,
        min_replicas: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object: Literal["agent.container"] = "agent.container"


class AgentContainerOperationError(_Model):
    """The error details of the container operation, if any.

    :ivar code: The error code of the container operation, if any. Required.
    :vartype code: str
    :ivar type: The error type of the container operation, if any. Required.
    :vartype type: str
    :ivar message: The error message of the container operation, if any. Required.
    :vartype message: str
    """

    code: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error code of the container operation, if any. Required."""
    type: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error type of the container operation, if any. Required."""
    message: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error message of the container operation, if any. Required."""

    @overload
    def __init__(
        self,
        *,
        code: str,
        type: str,
        message: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AgentContainerOperationObject(_Model):
    """The container operation for a specific version of an agent.

    :ivar id: The ID of the container operation. This id is unique identifier across the system.
     Required.
    :vartype id: str
    :ivar agent_id: The ID of the agent. Required.
    :vartype agent_id: str
    :ivar agent_version_id: The ID of the agent version. Required.
    :vartype agent_version_id: str
    :ivar status: The status of the container operation. Required. Known values are: "NotStarted",
     "InProgress", "Succeeded", and "Failed".
    :vartype status: str or ~azure.ai.projects.models.AgentContainerOperationStatus
    :ivar error: The error of the container operation, if any.
    :vartype error: ~azure.ai.projects.models.AgentContainerOperationError
    :ivar container: The container of the specific version of an agent.
    :vartype container: ~azure.ai.projects.models.AgentContainerObject
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the container operation. This id is unique identifier across the system. Required."""
    agent_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the agent. Required."""
    agent_version_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the agent version. Required."""
    status: Union[str, "_models.AgentContainerOperationStatus"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The status of the container operation. Required. Known values are: \"NotStarted\",
     \"InProgress\", \"Succeeded\", and \"Failed\"."""
    error: Optional["_models.AgentContainerOperationError"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The error of the container operation, if any."""
    container: Optional["_models.AgentContainerObject"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The container of the specific version of an agent."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        agent_id: str,
        agent_version_id: str,
        status: Union[str, "_models.AgentContainerOperationStatus"],
        error: Optional["_models.AgentContainerOperationError"] = None,
        container: Optional["_models.AgentContainerObject"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AgentDefinition(_Model):
    """AgentDefinition.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ContainerAppAgentDefinition, HostedAgentDefinition, PromptAgentDefinition, WorkflowDefinition

    :ivar kind: Required. Known values are: "prompt", "hosted", "container_app", and "workflow".
    :vartype kind: str or ~azure.ai.projects.models.AgentKind
    :ivar rai_config: Configuration for Responsible AI (RAI) content filtering and safety features.
    :vartype rai_config: ~azure.ai.projects.models.RaiConfig
    """

    __mapping__: dict[str, _Model] = {}
    kind: str = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])
    """Required. Known values are: \"prompt\", \"hosted\", \"container_app\", and \"workflow\"."""
    rai_config: Optional["_models.RaiConfig"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Configuration for Responsible AI (RAI) content filtering and safety features."""

    @overload
    def __init__(
        self,
        *,
        kind: str,
        rai_config: Optional["_models.RaiConfig"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BaseCredentials(_Model):
    """A base class for connection credentials.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    EntraIDCredentials, AgenticIdentityCredentials, ApiKeyCredentials, CustomCredential,
    NoAuthenticationCredentials, SASCredentials

    :ivar type: The type of credential used by the connection. Required. Known values are:
     "ApiKey", "AAD", "SAS", "CustomKeys", "None", and "AgenticIdentityToken".
    :vartype type: str or ~azure.ai.projects.models.CredentialType
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read"])
    """The type of credential used by the connection. Required. Known values are: \"ApiKey\", \"AAD\",
     \"SAS\", \"CustomKeys\", \"None\", and \"AgenticIdentityToken\"."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AgenticIdentityCredentials(BaseCredentials, discriminator="AgenticIdentityToken"):
    """Agentic identity credential definition.

    :ivar type: The credential type. Required. Agentic identity credential
    :vartype type: str or ~azure.ai.projects.models.AGENTIC_IDENTITY
    """

    type: Literal[CredentialType.AGENTIC_IDENTITY] = rest_discriminator(name="type", visibility=["read"])  # type: ignore
    """The credential type. Required. Agentic identity credential"""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = CredentialType.AGENTIC_IDENTITY  # type: ignore


class AgentId(_Model):
    """AgentId.

    :ivar type: Required. Default value is "agent_id".
    :vartype type: str
    :ivar name: The name of the agent. Required.
    :vartype name: str
    :ivar version: The version identifier of the agent. Required.
    :vartype version: str
    """

    type: Literal["agent_id"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required. Default value is \"agent_id\"."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the agent. Required."""
    version: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The version identifier of the agent. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        version: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type: Literal["agent_id"] = "agent_id"


class AgentObject(_Model):
    """AgentObject.

    :ivar object: The object type, which is always 'agent'. Required. Default value is "agent".
    :vartype object: str
    :ivar id: The unique identifier of the agent. Required.
    :vartype id: str
    :ivar name: The name of the agent. Required.
    :vartype name: str
    :ivar versions: The latest version of the agent. Required.
    :vartype versions: ~azure.ai.projects.models.AgentObjectVersions
    """

    object: Literal["agent"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The object type, which is always 'agent'. Required. Default value is \"agent\"."""
    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique identifier of the agent. Required."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the agent. Required."""
    versions: "_models.AgentObjectVersions" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The latest version of the agent. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        name: str,
        versions: "_models.AgentObjectVersions",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object: Literal["agent"] = "agent"


class AgentObjectVersions(_Model):
    """AgentObjectVersions.

    :ivar latest: Required.
    :vartype latest: ~azure.ai.projects.models.AgentVersionObject
    """

    latest: "_models.AgentVersionObject" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        latest: "_models.AgentVersionObject",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AgentReference(_Model):
    """AgentReference.

    :ivar type: Required. Default value is "agent_reference".
    :vartype type: str
    :ivar name: The name of the agent. Required.
    :vartype name: str
    :ivar version: The version identifier of the agent.
    :vartype version: str
    """

    type: Literal["agent_reference"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required. Default value is \"agent_reference\"."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the agent. Required."""
    version: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The version identifier of the agent."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type: Literal["agent_reference"] = "agent_reference"


class EvaluationTaxonomyInput(_Model):
    """Input configuration for the evaluation taxonomy.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AgentTaxonomyInput

    :ivar type: Input type of the evaluation taxonomy. Required. Known values are: "agent" and
     "policy".
    :vartype type: str or ~azure.ai.projects.models.EvaluationTaxonomyInputType
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Input type of the evaluation taxonomy. Required. Known values are: \"agent\" and \"policy\"."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AgentTaxonomyInput(EvaluationTaxonomyInput, discriminator="agent"):
    """Input configuration for the evaluation taxonomy when the input type is agent.

    :ivar type: Input type of the evaluation taxonomy. Required. Agent
    :vartype type: str or ~azure.ai.projects.models.AGENT
    :ivar target: Target configuration for the agent. Required.
    :vartype target: ~azure.ai.projects.models.AzureAIAgentTarget
    :ivar risk_categories: List of risk categories to evaluate against. Required.
    :vartype risk_categories: list[str or ~azure.ai.projects.models.RiskCategory]
    """

    type: Literal[EvaluationTaxonomyInputType.AGENT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Input type of the evaluation taxonomy. Required. Agent"""
    target: "_models.AzureAIAgentTarget" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Target configuration for the agent. Required."""
    risk_categories: list[Union[str, "_models.RiskCategory"]] = rest_field(
        name="riskCategories", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of risk categories to evaluate against. Required."""

    @overload
    def __init__(
        self,
        *,
        target: "_models.AzureAIAgentTarget",
        risk_categories: list[Union[str, "_models.RiskCategory"]],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = EvaluationTaxonomyInputType.AGENT  # type: ignore


class AgentVersionObject(_Model):
    """AgentVersionObject.

       :ivar metadata: Set of 16 key-value pairs that can be attached to an object. This can be
    useful for storing additional information about the object in a structured
    format, and querying for objects via API or the dashboard.
    Keys are strings with a maximum length of 64 characters. Values are strings
    with a maximum length of 512 characters. Required.
       :vartype metadata: dict[str, str]
       :ivar object: The object type, which is always 'agent.version'. Required. Default value is
        "agent.version".
       :vartype object: str
       :ivar id: The unique identifier of the agent version. Required.
       :vartype id: str
       :ivar name: The name of the agent. Name can be used to retrieve/update/delete the agent.
        Required.
       :vartype name: str
       :ivar version: The version identifier of the agent. Agents are immutable and every update
        creates a new version while keeping the name same. Required.
       :vartype version: str
       :ivar description: A human-readable description of the agent.
       :vartype description: str
       :ivar created_at: The Unix timestamp (seconds) when the agent was created. Required.
       :vartype created_at: ~datetime.datetime
       :ivar definition: Required.
       :vartype definition: ~azure.ai.projects.models.AgentDefinition
    """

    metadata: dict[str, str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Set of 16 key-value pairs that can be attached to an object. This can be
 useful for storing additional information about the object in a structured
 format, and querying for objects via API or the dashboard.
 Keys are strings with a maximum length of 64 characters. Values are strings
 with a maximum length of 512 characters. Required."""
    object: Literal["agent.version"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The object type, which is always 'agent.version'. Required. Default value is \"agent.version\"."""
    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique identifier of the agent version. Required."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the agent. Name can be used to retrieve/update/delete the agent. Required."""
    version: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The version identifier of the agent. Agents are immutable and every update creates a new
     version while keeping the name same. Required."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A human-readable description of the agent."""
    created_at: datetime.datetime = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="unix-timestamp"
    )
    """The Unix timestamp (seconds) when the agent was created. Required."""
    definition: "_models.AgentDefinition" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        metadata: dict[str, str],
        id: str,  # pylint: disable=redefined-builtin
        name: str,
        version: str,
        created_at: datetime.datetime,
        definition: "_models.AgentDefinition",
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object: Literal["agent.version"] = "agent.version"


class AISearchIndexResource(_Model):
    """A AI Search Index resource.

    :ivar project_connection_id: An index connection ID in an IndexResource attached to this agent.
     Required.
    :vartype project_connection_id: str
    :ivar index_name: The name of an index in an IndexResource attached to this agent.
    :vartype index_name: str
    :ivar query_type: Type of query in an AIIndexResource attached to this agent. Known values are:
     "simple", "semantic", "vector", "vector_simple_hybrid", and "vector_semantic_hybrid".
    :vartype query_type: str or ~azure.ai.projects.models.AzureAISearchQueryType
    :ivar top_k: Number of documents to retrieve from search and present to the model.
    :vartype top_k: int
    :ivar filter: filter string for search resource. Learn more from here:
     `https://learn.microsoft.com/azure/search/search-filters
     <https://learn.microsoft.com/azure/search/search-filters>`_.
    :vartype filter: str
    :ivar index_asset_id: Index asset id for search resource.
    :vartype index_asset_id: str
    """

    project_connection_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An index connection ID in an IndexResource attached to this agent. Required."""
    index_name: Optional[str] = rest_field(name="indexName", visibility=["read", "create", "update", "delete", "query"])
    """The name of an index in an IndexResource attached to this agent."""
    query_type: Optional[Union[str, "_models.AzureAISearchQueryType"]] = rest_field(
        name="queryType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of query in an AIIndexResource attached to this agent. Known values are: \"simple\",
     \"semantic\", \"vector\", \"vector_simple_hybrid\", and \"vector_semantic_hybrid\"."""
    top_k: Optional[int] = rest_field(name="topK", visibility=["read", "create", "update", "delete", "query"])
    """Number of documents to retrieve from search and present to the model."""
    filter: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """filter string for search resource. Learn more from here:
     `https://learn.microsoft.com/azure/search/search-filters
     <https://learn.microsoft.com/azure/search/search-filters>`_."""
    index_asset_id: Optional[str] = rest_field(
        name="indexAssetId", visibility=["read", "create", "update", "delete", "query"]
    )
    """Index asset id for search resource."""

    @overload
    def __init__(
        self,
        *,
        project_connection_id: str,
        index_name: Optional[str] = None,
        query_type: Optional[Union[str, "_models.AzureAISearchQueryType"]] = None,
        top_k: Optional[int] = None,
        filter: Optional[str] = None,  # pylint: disable=redefined-builtin
        index_asset_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Annotation(_Model):
    """Annotation.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AnnotationFileCitation, AnnotationFilePath, AnnotationUrlCitation

    :ivar type: Required. Known values are: "file_citation", "url_citation", "file_path", and
     "container_file_citation".
    :vartype type: str or ~azure.ai.projects.models.AnnotationType
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Required. Known values are: \"file_citation\", \"url_citation\", \"file_path\", and
     \"container_file_citation\"."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AnnotationFileCitation(Annotation, discriminator="file_citation"):
    """A citation to a file.

    :ivar type: The type of the file citation. Always ``file_citation``. Required.
    :vartype type: str or ~azure.ai.projects.models.FILE_CITATION
    :ivar file_id: The ID of the file. Required.
    :vartype file_id: str
    :ivar index: The index of the file in the list of files. Required.
    :vartype index: int
    :ivar filename: The filename of the file cited. Required.
    :vartype filename: str
    """

    type: Literal[AnnotationType.FILE_CITATION] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the file citation. Always ``file_citation``. Required."""
    file_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the file. Required."""
    index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the file in the list of files. Required."""
    filename: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The filename of the file cited. Required."""

    @overload
    def __init__(
        self,
        *,
        file_id: str,
        index: int,
        filename: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = AnnotationType.FILE_CITATION  # type: ignore


class AnnotationFilePath(Annotation, discriminator="file_path"):
    """A path to a file.

    :ivar type: The type of the file path. Always ``file_path``. Required.
    :vartype type: str or ~azure.ai.projects.models.FILE_PATH
    :ivar file_id: The ID of the file. Required.
    :vartype file_id: str
    :ivar index: The index of the file in the list of files. Required.
    :vartype index: int
    """

    type: Literal[AnnotationType.FILE_PATH] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the file path. Always ``file_path``. Required."""
    file_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the file. Required."""
    index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the file in the list of files. Required."""

    @overload
    def __init__(
        self,
        *,
        file_id: str,
        index: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = AnnotationType.FILE_PATH  # type: ignore


class AnnotationUrlCitation(Annotation, discriminator="url_citation"):
    """A citation for a web resource used to generate a model response.

    :ivar type: The type of the URL citation. Always ``url_citation``. Required.
    :vartype type: str or ~azure.ai.projects.models.URL_CITATION
    :ivar url: The URL of the web resource. Required.
    :vartype url: str
    :ivar start_index: The index of the first character of the URL citation in the message.
     Required.
    :vartype start_index: int
    :ivar end_index: The index of the last character of the URL citation in the message. Required.
    :vartype end_index: int
    :ivar title: The title of the web resource. Required.
    :vartype title: str
    """

    type: Literal[AnnotationType.URL_CITATION] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the URL citation. Always ``url_citation``. Required."""
    url: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The URL of the web resource. Required."""
    start_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the first character of the URL citation in the message. Required."""
    end_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the last character of the URL citation in the message. Required."""
    title: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The title of the web resource. Required."""

    @overload
    def __init__(
        self,
        *,
        url: str,
        start_index: int,
        end_index: int,
        title: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = AnnotationType.URL_CITATION  # type: ignore


class ApiError(_Model):
    """ApiError.

    :ivar code: The error code. Required.
    :vartype code: str
    :ivar message: A human-readable description of the error. Required.
    :vartype message: str
    :ivar target: The target of the error, if applicable.
    :vartype target: str
    :ivar details: Additional details about the error. Required.
    :vartype details: list[~azure.ai.projects.models.ApiError]
    :ivar innererror: The inner error, if any.
    :vartype innererror: ~azure.ai.projects.models.ApiInnerError
    """

    code: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error code. Required."""
    message: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A human-readable description of the error. Required."""
    target: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The target of the error, if applicable."""
    details: list["_models.ApiError"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Additional details about the error. Required."""
    innererror: Optional["_models.ApiInnerError"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The inner error, if any."""

    @overload
    def __init__(
        self,
        *,
        code: str,
        message: str,
        details: list["_models.ApiError"],
        target: Optional[str] = None,
        innererror: Optional["_models.ApiInnerError"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ApiErrorResponse(_Model):
    """Error response for API failures.

    :ivar error: Required.
    :vartype error: ~azure.ai.projects.models.ApiError
    """

    error: "_models.ApiError" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        error: "_models.ApiError",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ApiInnerError(_Model):
    """ApiInnerError.

    :ivar code: The error code. Required.
    :vartype code: str
    :ivar innererror: The inner error, if any.
    :vartype innererror: ~azure.ai.projects.models.ApiInnerError
    """

    code: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error code. Required."""
    innererror: Optional["_models.ApiInnerError"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The inner error, if any."""

    @overload
    def __init__(
        self,
        *,
        code: str,
        innererror: Optional["_models.ApiInnerError"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ApiKeyCredentials(BaseCredentials, discriminator="ApiKey"):
    """API Key Credential definition.

    :ivar type: The credential type. Required. API Key credential
    :vartype type: str or ~azure.ai.projects.models.API_KEY
    :ivar api_key: API Key.
    :vartype api_key: str
    """

    type: Literal[CredentialType.API_KEY] = rest_discriminator(name="type", visibility=["read"])  # type: ignore
    """The credential type. Required. API Key credential"""
    api_key: Optional[str] = rest_field(name="key", visibility=["read"])
    """API Key."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = CredentialType.API_KEY  # type: ignore


class Location(_Model):
    """Location.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ApproximateLocation

    :ivar type: Required. "approximate"
    :vartype type: str or ~azure.ai.projects.models.LocationType
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Required. \"approximate\""""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ApproximateLocation(Location, discriminator="approximate"):
    """ApproximateLocation.

    :ivar type: Required.
    :vartype type: str or ~azure.ai.projects.models.APPROXIMATE
    :ivar country:
    :vartype country: str
    :ivar region:
    :vartype region: str
    :ivar city:
    :vartype city: str
    :ivar timezone:
    :vartype timezone: str
    """

    type: Literal[LocationType.APPROXIMATE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    country: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    region: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    city: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    timezone: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        country: Optional[str] = None,
        region: Optional[str] = None,
        city: Optional[str] = None,
        timezone: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = LocationType.APPROXIMATE  # type: ignore


class Target(_Model):
    """Base class for targets with discriminator support.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureAIAgentTarget, AzureAIAssistantTarget, AzureAIModelTarget

    :ivar type: The type of target. Required. Default value is None.
    :vartype type: str
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """The type of target. Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureAIAgentTarget(Target, discriminator="azure_ai_agent"):
    """Represents a target specifying an Azure AI agent.

    :ivar type: The type of target, always ``azure_ai_agent``. Required. Default value is
     "azure_ai_agent".
    :vartype type: str
    :ivar name: The unique identifier of the Azure AI agent. Required.
    :vartype name: str
    :ivar version: The version of the Azure AI agent.
    :vartype version: str
    :ivar tool_descriptions: The parameters used to control the sampling behavior of the agent
     during text generation.
    :vartype tool_descriptions: list[~azure.ai.projects.models.ToolDescription]
    """

    type: Literal["azure_ai_agent"] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of target, always ``azure_ai_agent``. Required. Default value is \"azure_ai_agent\"."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique identifier of the Azure AI agent. Required."""
    version: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The version of the Azure AI agent."""
    tool_descriptions: Optional[list["_models.ToolDescription"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The parameters used to control the sampling behavior of the agent during text generation."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        version: Optional[str] = None,
        tool_descriptions: Optional[list["_models.ToolDescription"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = "azure_ai_agent"  # type: ignore


class AzureAISearchAgentTool(Tool, discriminator="azure_ai_search"):
    """The input definition information for an Azure AI search tool as used to configure an agent.

    :ivar type: The object type, which is always 'azure_ai_search'. Required.
    :vartype type: str or ~azure.ai.projects.models.AZURE_AI_SEARCH
    :ivar azure_ai_search: The azure ai search index resource. Required.
    :vartype azure_ai_search: ~azure.ai.projects.models.AzureAISearchToolResource
    """

    type: Literal[ToolType.AZURE_AI_SEARCH] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The object type, which is always 'azure_ai_search'. Required."""
    azure_ai_search: "_models.AzureAISearchToolResource" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The azure ai search index resource. Required."""

    @overload
    def __init__(
        self,
        *,
        azure_ai_search: "_models.AzureAISearchToolResource",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ToolType.AZURE_AI_SEARCH  # type: ignore


class Index(_Model):
    """Index resource Definition.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureAISearchIndex, CosmosDBIndex, ManagedAzureAISearchIndex

    :ivar type: Type of index. Required. Known values are: "AzureSearch",
     "CosmosDBNoSqlVectorStore", and "ManagedAzureSearch".
    :vartype type: str or ~azure.ai.projects.models.IndexType
    :ivar id: Asset ID, a unique identifier for the asset.
    :vartype id: str
    :ivar name: The name of the resource. Required.
    :vartype name: str
    :ivar version: The version of the resource. Required.
    :vartype version: str
    :ivar description: The asset description text.
    :vartype description: str
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Type of index. Required. Known values are: \"AzureSearch\", \"CosmosDBNoSqlVectorStore\", and
     \"ManagedAzureSearch\"."""
    id: Optional[str] = rest_field(visibility=["read"])
    """Asset ID, a unique identifier for the asset."""
    name: str = rest_field(visibility=["read"])
    """The name of the resource. Required."""
    version: str = rest_field(visibility=["read"])
    """The version of the resource. Required."""
    description: Optional[str] = rest_field(visibility=["create", "update"])
    """The asset description text."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["create", "update"])
    """Tag dictionary. Tags can be added, removed, and updated."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        description: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureAISearchIndex(Index, discriminator="AzureSearch"):
    """Azure AI Search Index Definition.

    :ivar id: Asset ID, a unique identifier for the asset.
    :vartype id: str
    :ivar name: The name of the resource. Required.
    :vartype name: str
    :ivar version: The version of the resource. Required.
    :vartype version: str
    :ivar description: The asset description text.
    :vartype description: str
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar type: Type of index. Required. Azure search
    :vartype type: str or ~azure.ai.projects.models.AZURE_SEARCH
    :ivar connection_name: Name of connection to Azure AI Search. Required.
    :vartype connection_name: str
    :ivar index_name: Name of index in Azure AI Search resource to attach. Required.
    :vartype index_name: str
    :ivar field_mapping: Field mapping configuration.
    :vartype field_mapping: ~azure.ai.projects.models.FieldMapping
    """

    type: Literal[IndexType.AZURE_SEARCH] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Type of index. Required. Azure search"""
    connection_name: str = rest_field(name="connectionName", visibility=["create"])
    """Name of connection to Azure AI Search. Required."""
    index_name: str = rest_field(name="indexName", visibility=["create"])
    """Name of index in Azure AI Search resource to attach. Required."""
    field_mapping: Optional["_models.FieldMapping"] = rest_field(name="fieldMapping", visibility=["create"])
    """Field mapping configuration."""

    @overload
    def __init__(
        self,
        *,
        connection_name: str,
        index_name: str,
        description: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        field_mapping: Optional["_models.FieldMapping"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = IndexType.AZURE_SEARCH  # type: ignore


class AzureAISearchToolResource(_Model):
    """A set of index resources used by the ``azure_ai_search`` tool.

       :ivar index_list: The indices attached to this agent. There can be a maximum of 1 index
    resource attached to the agent.
       :vartype index_list: list[~azure.ai.projects.models.AISearchIndexResource]
    """

    index_list: Optional[list["_models.AISearchIndexResource"]] = rest_field(
        name="indexList", visibility=["read", "create", "update", "delete", "query"]
    )
    """The indices attached to this agent. There can be a maximum of 1 index
 resource attached to the agent."""

    @overload
    def __init__(
        self,
        *,
        index_list: Optional[list["_models.AISearchIndexResource"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureFunctionAgentTool(Tool, discriminator="azure_function"):
    """The input definition information for an Azure Function Tool, as used to configure an Agent.

    :ivar type: The object type, which is always 'browser_automation'. Required.
    :vartype type: str or ~azure.ai.projects.models.AZURE_FUNCTION
    :ivar azure_function: The Azure Function Tool definition. Required.
    :vartype azure_function: ~azure.ai.projects.models.AzureFunctionDefinition
    """

    type: Literal[ToolType.AZURE_FUNCTION] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The object type, which is always 'browser_automation'. Required."""
    azure_function: "_models.AzureFunctionDefinition" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The Azure Function Tool definition. Required."""

    @overload
    def __init__(
        self,
        *,
        azure_function: "_models.AzureFunctionDefinition",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ToolType.AZURE_FUNCTION  # type: ignore


class AzureFunctionBinding(_Model):
    """The structure for keeping storage queue name and URI.

    :ivar type: The type of binding, which is always 'storage_queue'. Required. Default value is
     "storage_queue".
    :vartype type: str
    :ivar storage_queue: Storage queue. Required.
    :vartype storage_queue: ~azure.ai.projects.models.AzureFunctionStorageQueue
    """

    type: Literal["storage_queue"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The type of binding, which is always 'storage_queue'. Required. Default value is
     \"storage_queue\"."""
    storage_queue: "_models.AzureFunctionStorageQueue" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Storage queue. Required."""

    @overload
    def __init__(
        self,
        *,
        storage_queue: "_models.AzureFunctionStorageQueue",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type: Literal["storage_queue"] = "storage_queue"


class AzureFunctionDefinition(_Model):
    """The definition of Azure function.

    :ivar function: The definition of azure function and its parameters. Required.
    :vartype function: ~azure.ai.projects.models.AzureFunctionDefinitionFunction
    :ivar input_binding: Input storage queue. The queue storage trigger runs a function as messages
     are added to it. Required.
    :vartype input_binding: ~azure.ai.projects.models.AzureFunctionBinding
    :ivar output_binding: Output storage queue. The function writes output to this queue when the
     input items are processed. Required.
    :vartype output_binding: ~azure.ai.projects.models.AzureFunctionBinding
    """

    function: "_models.AzureFunctionDefinitionFunction" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The definition of azure function and its parameters. Required."""
    input_binding: "_models.AzureFunctionBinding" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Input storage queue. The queue storage trigger runs a function as messages are added to it.
     Required."""
    output_binding: "_models.AzureFunctionBinding" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Output storage queue. The function writes output to this queue when the input items are
     processed. Required."""

    @overload
    def __init__(
        self,
        *,
        function: "_models.AzureFunctionDefinitionFunction",
        input_binding: "_models.AzureFunctionBinding",
        output_binding: "_models.AzureFunctionBinding",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureFunctionDefinitionFunction(_Model):
    """AzureFunctionDefinitionFunction.

    :ivar name: The name of the function to be called. Required.
    :vartype name: str
    :ivar description: A description of what the function does, used by the model to choose when
     and how to call the function.
    :vartype description: str
    :ivar parameters: The parameters the functions accepts, described as a JSON Schema object.
     Required.
    :vartype parameters: any
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the function to be called. Required."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A description of what the function does, used by the model to choose when and how to call the
     function."""
    parameters: Any = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The parameters the functions accepts, described as a JSON Schema object. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        parameters: Any,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureFunctionStorageQueue(_Model):
    """The structure for keeping storage queue name and URI.

    :ivar queue_service_endpoint: URI to the Azure Storage Queue service allowing you to manipulate
     a queue. Required.
    :vartype queue_service_endpoint: str
    :ivar queue_name: The name of an Azure function storage queue. Required.
    :vartype queue_name: str
    """

    queue_service_endpoint: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """URI to the Azure Storage Queue service allowing you to manipulate a queue. Required."""
    queue_name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of an Azure function storage queue. Required."""

    @overload
    def __init__(
        self,
        *,
        queue_service_endpoint: str,
        queue_name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TargetConfig(_Model):
    """Abstract class for target configuration.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureOpenAIModelConfiguration

    :ivar type: Type of the model configuration. Required. Default value is None.
    :vartype type: str
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Type of the model configuration. Required. Default value is None."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class AzureOpenAIModelConfiguration(TargetConfig, discriminator="AzureOpenAIModel"):
    """Azure OpenAI model configuration. The API version would be selected by the service for querying
    the model.

    :ivar type: Required. Default value is "AzureOpenAIModel".
    :vartype type: str
    :ivar model_deployment_name: Deployment name for AOAI model. Example: gpt-4o if in AIServices
     or connection based ``connection_name/deployment_name`` (e.g. ``my-aoai-connection/gpt-4o``).
     Required.
    :vartype model_deployment_name: str
    """

    type: Literal["AzureOpenAIModel"] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Default value is \"AzureOpenAIModel\"."""
    model_deployment_name: str = rest_field(
        name="modelDeploymentName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Deployment name for AOAI model. Example: gpt-4o if in AIServices or connection based
     ``connection_name/deployment_name`` (e.g. ``my-aoai-connection/gpt-4o``). Required."""

    @overload
    def __init__(
        self,
        *,
        model_deployment_name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = "AzureOpenAIModel"  # type: ignore


class BingCustomSearchAgentTool(Tool, discriminator="bing_custom_search_preview"):
    """The input definition information for a Bing custom search tool as used to configure an agent.

    :ivar type: The object type, which is always 'bing_custom_search'. Required.
    :vartype type: str or ~azure.ai.projects.models.BING_CUSTOM_SEARCH_PREVIEW
    :ivar bing_custom_search_preview: The bing custom search tool parameters. Required.
    :vartype bing_custom_search_preview: ~azure.ai.projects.models.BingCustomSearchToolParameters
    """

    type: Literal[ToolType.BING_CUSTOM_SEARCH_PREVIEW] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The object type, which is always 'bing_custom_search'. Required."""
    bing_custom_search_preview: "_models.BingCustomSearchToolParameters" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The bing custom search tool parameters. Required."""

    @overload
    def __init__(
        self,
        *,
        bing_custom_search_preview: "_models.BingCustomSearchToolParameters",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ToolType.BING_CUSTOM_SEARCH_PREVIEW  # type: ignore


class BingCustomSearchConfiguration(_Model):
    """A bing custom search configuration.

    :ivar project_connection_id: Project connection id for grounding with bing search. Required.
    :vartype project_connection_id: str
    :ivar instance_name: Name of the custom configuration instance given to config. Required.
    :vartype instance_name: str
    :ivar market: The market where the results come from.
    :vartype market: str
    :ivar set_lang: The language to use for user interface strings when calling Bing API.
    :vartype set_lang: str
    :ivar count: The number of search results to return in the bing api response.
    :vartype count: int
    :ivar freshness: Filter search results by a specific time range. Accepted values:
     `https://learn.microsoft.com/bing/search-apis/bing-web-search/reference/query-parameters
     <https://learn.microsoft.com/bing/search-apis/bing-web-search/reference/query-parameters>`_.
    :vartype freshness: str
    """

    project_connection_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Project connection id for grounding with bing search. Required."""
    instance_name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the custom configuration instance given to config. Required."""
    market: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The market where the results come from."""
    set_lang: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The language to use for user interface strings when calling Bing API."""
    count: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of search results to return in the bing api response."""
    freshness: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Filter search results by a specific time range. Accepted values:
     `https://learn.microsoft.com/bing/search-apis/bing-web-search/reference/query-parameters
     <https://learn.microsoft.com/bing/search-apis/bing-web-search/reference/query-parameters>`_."""

    @overload
    def __init__(
        self,
        *,
        project_connection_id: str,
        instance_name: str,
        market: Optional[str] = None,
        set_lang: Optional[str] = None,
        count: Optional[int] = None,
        freshness: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BingCustomSearchToolParameters(_Model):
    """The bing custom search tool parameters.

       :ivar search_configurations: The project connections attached to this tool. There can be a
        maximum of 1 connection
    resource attached to the tool. Required.
       :vartype search_configurations: list[~azure.ai.projects.models.BingCustomSearchConfiguration]
    """

    search_configurations: list["_models.BingCustomSearchConfiguration"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The project connections attached to this tool. There can be a maximum of 1 connection
 resource attached to the tool. Required."""

    @overload
    def __init__(
        self,
        *,
        search_configurations: list["_models.BingCustomSearchConfiguration"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BingGroundingAgentTool(Tool, discriminator="bing_grounding"):
    """The input definition information for a bing grounding search tool as used to configure an
    agent.

    :ivar type: The object type, which is always 'bing_grounding'. Required.
    :vartype type: str or ~azure.ai.projects.models.BING_GROUNDING
    :ivar bing_grounding: The bing grounding search tool parameters. Required.
    :vartype bing_grounding: ~azure.ai.projects.models.BingGroundingSearchToolParameters
    """

    type: Literal[ToolType.BING_GROUNDING] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The object type, which is always 'bing_grounding'. Required."""
    bing_grounding: "_models.BingGroundingSearchToolParameters" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The bing grounding search tool parameters. Required."""

    @overload
    def __init__(
        self,
        *,
        bing_grounding: "_models.BingGroundingSearchToolParameters",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ToolType.BING_GROUNDING  # type: ignore


class BingGroundingSearchConfiguration(_Model):
    """Search configuration for Bing Grounding.

    :ivar project_connection_id: Project connection id for grounding with bing search. Required.
    :vartype project_connection_id: str
    :ivar market: The market where the results come from.
    :vartype market: str
    :ivar set_lang: The language to use for user interface strings when calling Bing API.
    :vartype set_lang: str
    :ivar count: The number of search results to return in the bing api response.
    :vartype count: int
    :ivar freshness: Filter search results by a specific time range. Accepted values:
     `https://learn.microsoft.com/bing/search-apis/bing-web-search/reference/query-parameters
     <https://learn.microsoft.com/bing/search-apis/bing-web-search/reference/query-parameters>`_.
    :vartype freshness: str
    """

    project_connection_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Project connection id for grounding with bing search. Required."""
    market: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The market where the results come from."""
    set_lang: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The language to use for user interface strings when calling Bing API."""
    count: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of search results to return in the bing api response."""
    freshness: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Filter search results by a specific time range. Accepted values:
     `https://learn.microsoft.com/bing/search-apis/bing-web-search/reference/query-parameters
     <https://learn.microsoft.com/bing/search-apis/bing-web-search/reference/query-parameters>`_."""

    @overload
    def __init__(
        self,
        *,
        project_connection_id: str,
        market: Optional[str] = None,
        set_lang: Optional[str] = None,
        count: Optional[int] = None,
        freshness: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BingGroundingSearchToolParameters(_Model):
    """The bing grounding search tool parameters.

       :ivar project_connections: The project connections attached to this tool. There can be a
        maximum of 1 connection
    resource attached to the tool. Required.
       :vartype project_connections: ~azure.ai.projects.models.ToolProjectConnectionList
       :ivar search_configurations: The search configurations attached to this tool. There can be a
        maximum of 1
    search configuration resource attached to the tool. Required.
       :vartype search_configurations:
        list[~azure.ai.projects.models.BingGroundingSearchConfiguration]
    """

    project_connections: "_models.ToolProjectConnectionList" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The project connections attached to this tool. There can be a maximum of 1 connection
 resource attached to the tool. Required."""
    search_configurations: list["_models.BingGroundingSearchConfiguration"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The search configurations attached to this tool. There can be a maximum of 1
 search configuration resource attached to the tool. Required."""

    @overload
    def __init__(
        self,
        *,
        project_connections: "_models.ToolProjectConnectionList",
        search_configurations: list["_models.BingGroundingSearchConfiguration"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BlobReference(_Model):
    """Blob reference details.

    :ivar blob_uri: Blob URI path for client to upload data. Example:
     `https://blob.windows.core.net/Container/Path <https://blob.windows.core.net/Container/Path>`_.
     Required.
    :vartype blob_uri: str
    :ivar storage_account_arm_id: ARM ID of the storage account to use. Required.
    :vartype storage_account_arm_id: str
    :ivar credential: Credential info to access the storage account. Required.
    :vartype credential: ~azure.ai.projects.models.BlobReferenceSasCredential
    """

    blob_uri: str = rest_field(name="blobUri", visibility=["read", "create", "update", "delete", "query"])
    """Blob URI path for client to upload data. Example: `https://blob.windows.core.net/Container/Path
     <https://blob.windows.core.net/Container/Path>`_. Required."""
    storage_account_arm_id: str = rest_field(
        name="storageAccountArmId", visibility=["read", "create", "update", "delete", "query"]
    )
    """ARM ID of the storage account to use. Required."""
    credential: "_models.BlobReferenceSasCredential" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Credential info to access the storage account. Required."""

    @overload
    def __init__(
        self,
        *,
        blob_uri: str,
        storage_account_arm_id: str,
        credential: "_models.BlobReferenceSasCredential",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BlobReferenceSasCredential(_Model):
    """SAS Credential definition.

    :ivar sas_uri: SAS uri. Required.
    :vartype sas_uri: str
    :ivar type: Type of credential. Required. Default value is "SAS".
    :vartype type: str
    """

    sas_uri: str = rest_field(name="sasUri", visibility=["read"])
    """SAS uri. Required."""
    type: Literal["SAS"] = rest_field(visibility=["read"])
    """Type of credential. Required. Default value is \"SAS\"."""

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type: Literal["SAS"] = "SAS"


class BrowserAutomationAgentTool(Tool, discriminator="browser_automation_preview"):
    """The input definition information for a Browser Automation Tool, as used to configure an Agent.

    :ivar type: The object type, which is always 'browser_automation'. Required.
    :vartype type: str or ~azure.ai.projects.models.BROWSER_AUTOMATION_PREVIEW
    :ivar browser_automation_preview: The Browser Automation Tool parameters. Required.
    :vartype browser_automation_preview: ~azure.ai.projects.models.BrowserAutomationToolParameters
    """

    type: Literal[ToolType.BROWSER_AUTOMATION_PREVIEW] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The object type, which is always 'browser_automation'. Required."""
    browser_automation_preview: "_models.BrowserAutomationToolParameters" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The Browser Automation Tool parameters. Required."""

    @overload
    def __init__(
        self,
        *,
        browser_automation_preview: "_models.BrowserAutomationToolParameters",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ToolType.BROWSER_AUTOMATION_PREVIEW  # type: ignore


class BrowserAutomationToolConnectionParameters(_Model):  # pylint: disable=name-too-long
    """Definition of input parameters for the connection used by the Browser Automation Tool.

    :ivar id: The ID of the project connection to your Azure Playwright resource. Required.
    :vartype id: str
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the project connection to your Azure Playwright resource. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BrowserAutomationToolParameters(_Model):
    """Definition of input parameters for the Browser Automation Tool.

    :ivar project_connection: The project connection parameters associated with the Browser
     Automation Tool. Required.
    :vartype project_connection:
     ~azure.ai.projects.models.BrowserAutomationToolConnectionParameters
    """

    project_connection: "_models.BrowserAutomationToolConnectionParameters" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The project connection parameters associated with the Browser Automation Tool. Required."""

    @overload
    def __init__(
        self,
        *,
        project_connection: "_models.BrowserAutomationToolConnectionParameters",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CaptureStructuredOutputsTool(Tool, discriminator="capture_structured_outputs"):
    """A tool for capturing structured outputs.

    :ivar type: The type of the tool. Always ``capture_structured_outputs``. Required.
    :vartype type: str or ~azure.ai.projects.models.CAPTURE_STRUCTURED_OUTPUTS
    :ivar outputs: The structured outputs to capture from the model. Required.
    :vartype outputs: ~azure.ai.projects.models.StructuredOutputDefinition
    """

    type: Literal[ToolType.CAPTURE_STRUCTURED_OUTPUTS] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the tool. Always ``capture_structured_outputs``. Required."""
    outputs: "_models.StructuredOutputDefinition" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The structured outputs to capture from the model. Required."""

    @overload
    def __init__(
        self,
        *,
        outputs: "_models.StructuredOutputDefinition",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ToolType.CAPTURE_STRUCTURED_OUTPUTS  # type: ignore


class ChartCoordinate(_Model):
    """Coordinates for the analysis chart.

    :ivar x: X-axis coordinate. Required.
    :vartype x: int
    :ivar y: Y-axis coordinate. Required.
    :vartype y: int
    :ivar size: Size of the chart element. Required.
    :vartype size: int
    """

    x: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """X-axis coordinate. Required."""
    y: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Y-axis coordinate. Required."""
    size: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Size of the chart element. Required."""

    @overload
    def __init__(
        self,
        *,
        x: int,
        y: int,
        size: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MemoryItem(_Model):
    """A single memory item stored in the memory store, containing content and metadata.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ChatSummaryMemoryItem, UserProfileMemoryItem

    :ivar memory_id: The unique ID of the memory item. Required.
    :vartype memory_id: str
    :ivar updated_at: The last update time of the memory item. Required.
    :vartype updated_at: ~datetime.datetime
    :ivar scope: The namespace that logically groups and isolates memories, such as a user ID.
     Required.
    :vartype scope: str
    :ivar content: The content of the memory. Required.
    :vartype content: str
    :ivar kind: The kind of the memory item. Required. Known values are: "user_profile" and
     "chat_summary".
    :vartype kind: str or ~azure.ai.projects.models.MemoryItemKind
    """

    __mapping__: dict[str, _Model] = {}
    memory_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique ID of the memory item. Required."""
    updated_at: datetime.datetime = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="unix-timestamp"
    )
    """The last update time of the memory item. Required."""
    scope: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The namespace that logically groups and isolates memories, such as a user ID. Required."""
    content: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The content of the memory. Required."""
    kind: str = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])
    """The kind of the memory item. Required. Known values are: \"user_profile\" and \"chat_summary\"."""

    @overload
    def __init__(
        self,
        *,
        memory_id: str,
        updated_at: datetime.datetime,
        scope: str,
        content: str,
        kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ChatSummaryMemoryItem(MemoryItem, discriminator="chat_summary"):
    """A memory item containing a summary extracted from conversations.

    :ivar memory_id: The unique ID of the memory item. Required.
    :vartype memory_id: str
    :ivar updated_at: The last update time of the memory item. Required.
    :vartype updated_at: ~datetime.datetime
    :ivar scope: The namespace that logically groups and isolates memories, such as a user ID.
     Required.
    :vartype scope: str
    :ivar content: The content of the memory. Required.
    :vartype content: str
    :ivar kind: The kind of the memory item. Required. Summary of chat conversations.
    :vartype kind: str or ~azure.ai.projects.models.CHAT_SUMMARY
    """

    kind: Literal[MemoryItemKind.CHAT_SUMMARY] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The kind of the memory item. Required. Summary of chat conversations."""

    @overload
    def __init__(
        self,
        *,
        memory_id: str,
        updated_at: datetime.datetime,
        scope: str,
        content: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = MemoryItemKind.CHAT_SUMMARY  # type: ignore


class ClusterInsightResult(_Model):
    """Insights from the cluster analysis.

     :ivar summary: Summary of the insights report. Required.
     :vartype summary: ~azure.ai.projects.models.InsightSummary
     :ivar clusters: List of clusters identified in the insights. Required.
     :vartype clusters: list[~azure.ai.projects.models.InsightCluster]
     :ivar coordinates:   Optional mapping of IDs to 2D coordinates used by the UX for
      visualization.
    The map keys are string identifiers (for example, a cluster id or a sample id)
    and the values are the coordinates and visual size for rendering on a 2D chart.
    This property is omitted unless the client requests coordinates (for example,
    by passing ``includeCoordinates=true`` as a query parameter).
    Example:
    {
      "cluster-1": { "x": 12, "y": 34, "size": 8 },
      "sample-123": { "x": 18, "y": 22, "size": 4 }
    }
    Coordinates are intended only for client-side visualization and do not
    modify the canonical insights results.
     :vartype coordinates: dict[str, ~azure.ai.projects.models.ChartCoordinate]
    """

    summary: "_models.InsightSummary" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Summary of the insights report. Required."""
    clusters: list["_models.InsightCluster"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of clusters identified in the insights. Required."""
    coordinates: Optional[dict[str, "_models.ChartCoordinate"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """  Optional mapping of IDs to 2D coordinates used by the UX for visualization.
   The map keys are string identifiers (for example, a cluster id or a sample id)
   and the values are the coordinates and visual size for rendering on a 2D chart.
   This property is omitted unless the client requests coordinates (for example,
   by passing ``includeCoordinates=true`` as a query parameter).
   Example:
   {
     \"cluster-1\": { \"x\": 12, \"y\": 34, \"size\": 8 },
     \"sample-123\": { \"x\": 18, \"y\": 22, \"size\": 4 }
   }
   Coordinates are intended only for client-side visualization and do not
   modify the canonical insights results."""

    @overload
    def __init__(
        self,
        *,
        summary: "_models.InsightSummary",
        clusters: list["_models.InsightCluster"],
        coordinates: Optional[dict[str, "_models.ChartCoordinate"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ClusterTokenUsage(_Model):
    """Token usage for cluster analysis.

    :ivar input_token_usage: input token usage. Required.
    :vartype input_token_usage: int
    :ivar output_token_usage: output token usage. Required.
    :vartype output_token_usage: int
    :ivar total_token_usage: total token usage. Required.
    :vartype total_token_usage: int
    """

    input_token_usage: int = rest_field(
        name="inputTokenUsage", visibility=["read", "create", "update", "delete", "query"]
    )
    """input token usage. Required."""
    output_token_usage: int = rest_field(
        name="outputTokenUsage", visibility=["read", "create", "update", "delete", "query"]
    )
    """output token usage. Required."""
    total_token_usage: int = rest_field(
        name="totalTokenUsage", visibility=["read", "create", "update", "delete", "query"]
    )
    """total token usage. Required."""

    @overload
    def __init__(
        self,
        *,
        input_token_usage: int,
        output_token_usage: int,
        total_token_usage: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EvaluatorDefinition(_Model):
    """Base evaluator configuration with discriminator.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CodeBasedEvaluatorDefinition, PromptBasedEvaluatorDefinition

    :ivar type: The type of evaluator definition. Required. Known values are: "prompt", "code",
     "prompt_and_code", "service", and "openai_graders".
    :vartype type: str or ~azure.ai.projects.models.EvaluatorDefinitionType
    :ivar init_parameters: The JSON schema (Draft 2020-12) for the evaluator's input parameters.
     This includes parameters like type, properties, required.
    :vartype init_parameters: any
    :ivar data_schema: The JSON schema (Draft 2020-12) for the evaluator's input data. This
     includes parameters like type, properties, required.
    :vartype data_schema: any
    :ivar metrics: List of output metrics produced by this evaluator.
    :vartype metrics: dict[str, ~azure.ai.projects.models.EvaluatorMetric]
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """The type of evaluator definition. Required. Known values are: \"prompt\", \"code\",
     \"prompt_and_code\", \"service\", and \"openai_graders\"."""
    init_parameters: Optional[Any] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The JSON schema (Draft 2020-12) for the evaluator's input parameters. This includes parameters
     like type, properties, required."""
    data_schema: Optional[Any] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The JSON schema (Draft 2020-12) for the evaluator's input data. This includes parameters like
     type, properties, required."""
    metrics: Optional[dict[str, "_models.EvaluatorMetric"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of output metrics produced by this evaluator."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        init_parameters: Optional[Any] = None,
        data_schema: Optional[Any] = None,
        metrics: Optional[dict[str, "_models.EvaluatorMetric"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CodeBasedEvaluatorDefinition(EvaluatorDefinition, discriminator="code"):
    """Code-based evaluator definition using python code.

    :ivar init_parameters: The JSON schema (Draft 2020-12) for the evaluator's input parameters.
     This includes parameters like type, properties, required.
    :vartype init_parameters: any
    :ivar data_schema: The JSON schema (Draft 2020-12) for the evaluator's input data. This
     includes parameters like type, properties, required.
    :vartype data_schema: any
    :ivar metrics: List of output metrics produced by this evaluator.
    :vartype metrics: dict[str, ~azure.ai.projects.models.EvaluatorMetric]
    :ivar type: Required. Code-based definition
    :vartype type: str or ~azure.ai.projects.models.CODE
    :ivar code_text: Inline code text for the evaluator. Required.
    :vartype code_text: str
    """

    type: Literal[EvaluatorDefinitionType.CODE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Code-based definition"""
    code_text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Inline code text for the evaluator. Required."""

    @overload
    def __init__(
        self,
        *,
        code_text: str,
        init_parameters: Optional[Any] = None,
        data_schema: Optional[Any] = None,
        metrics: Optional[dict[str, "_models.EvaluatorMetric"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = EvaluatorDefinitionType.CODE  # type: ignore


class CodeInterpreterOutput(_Model):
    """CodeInterpreterOutput.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CodeInterpreterOutputImage, CodeInterpreterOutputLogs

    :ivar type: Required. Known values are: "logs" and "image".
    :vartype type: str or ~azure.ai.projects.models.CodeInterpreterOutputType
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Required. Known values are: \"logs\" and \"image\"."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CodeInterpreterOutputImage(CodeInterpreterOutput, discriminator="image"):
    """The image output from the code interpreter.

    :ivar type: The type of the output. Always 'image'. Required.
    :vartype type: str or ~azure.ai.projects.models.IMAGE
    :ivar url: The URL of the image output from the code interpreter. Required.
    :vartype url: str
    """

    type: Literal[CodeInterpreterOutputType.IMAGE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the output. Always 'image'. Required."""
    url: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The URL of the image output from the code interpreter. Required."""

    @overload
    def __init__(
        self,
        *,
        url: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = CodeInterpreterOutputType.IMAGE  # type: ignore


class CodeInterpreterOutputLogs(CodeInterpreterOutput, discriminator="logs"):
    """The logs output from the code interpreter.

    :ivar type: The type of the output. Always 'logs'. Required.
    :vartype type: str or ~azure.ai.projects.models.LOGS
    :ivar logs: The logs output from the code interpreter. Required.
    :vartype logs: str
    """

    type: Literal[CodeInterpreterOutputType.LOGS] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the output. Always 'logs'. Required."""
    logs: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The logs output from the code interpreter. Required."""

    @overload
    def __init__(
        self,
        *,
        logs: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = CodeInterpreterOutputType.LOGS  # type: ignore


class CodeInterpreterTool(Tool, discriminator="code_interpreter"):
    """A tool that runs Python code to help generate a response to a prompt.

       :ivar type: The type of the code interpreter tool. Always ``code_interpreter``. Required.
       :vartype type: str or ~azure.ai.projects.models.CODE_INTERPRETER
       :ivar container: The code interpreter container. Can be a container ID or an object that
    specifies uploaded file IDs to make available to your code. Required. Is either a str type or a
        CodeInterpreterToolAuto type.
       :vartype container: str or ~azure.ai.projects.models.CodeInterpreterToolAuto
    """

    type: Literal[ToolType.CODE_INTERPRETER] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the code interpreter tool. Always ``code_interpreter``. Required."""
    container: Union[str, "_models.CodeInterpreterToolAuto"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The code interpreter container. Can be a container ID or an object that
 specifies uploaded file IDs to make available to your code. Required. Is either a str type or a
     CodeInterpreterToolAuto type."""

    @overload
    def __init__(
        self,
        *,
        container: Union[str, "_models.CodeInterpreterToolAuto"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ToolType.CODE_INTERPRETER  # type: ignore


class CodeInterpreterToolAuto(_Model):
    """Configuration for a code interpreter container. Optionally specify the IDs
    of the files to run the code on.

        :ivar type: Always ``auto``. Required. Default value is "auto".
        :vartype type: str
        :ivar file_ids: An optional list of uploaded files to make available to your code.
        :vartype file_ids: list[str]
    """

    type: Literal["auto"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Always ``auto``. Required. Default value is \"auto\"."""
    file_ids: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An optional list of uploaded files to make available to your code."""

    @overload
    def __init__(
        self,
        *,
        file_ids: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type: Literal["auto"] = "auto"


class ItemParam(_Model):
    """Content item used to generate a response.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CodeInterpreterToolCallItemParam, ComputerToolCallItemParam, ComputerToolCallOutputItemParam,
    FileSearchToolCallItemParam, FunctionToolCallItemParam, FunctionToolCallOutputItemParam,
    ImageGenToolCallItemParam, ItemReferenceItemParam, LocalShellToolCallItemParam,
    LocalShellToolCallOutputItemParam, MCPApprovalRequestItemParam, MCPApprovalResponseItemParam,
    MCPCallItemParam, MCPListToolsItemParam, MemorySearchToolCallItemParam,
    ResponsesMessageItemParam, ReasoningItemParam, WebSearchToolCallItemParam

    :ivar type: Required. Known values are: "message", "file_search_call", "function_call",
     "function_call_output", "computer_call", "computer_call_output", "web_search_call",
     "reasoning", "item_reference", "image_generation_call", "code_interpreter_call",
     "local_shell_call", "local_shell_call_output", "mcp_list_tools", "mcp_approval_request",
     "mcp_approval_response", "mcp_call", "structured_outputs", "workflow_action",
     "memory_search_call", and "oauth_consent_request".
    :vartype type: str or ~azure.ai.projects.models.ItemType
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Required. Known values are: \"message\", \"file_search_call\", \"function_call\",
     \"function_call_output\", \"computer_call\", \"computer_call_output\", \"web_search_call\",
     \"reasoning\", \"item_reference\", \"image_generation_call\", \"code_interpreter_call\",
     \"local_shell_call\", \"local_shell_call_output\", \"mcp_list_tools\",
     \"mcp_approval_request\", \"mcp_approval_response\", \"mcp_call\", \"structured_outputs\",
     \"workflow_action\", \"memory_search_call\", and \"oauth_consent_request\"."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CodeInterpreterToolCallItemParam(ItemParam, discriminator="code_interpreter_call"):
    """A tool call to run code.

       :ivar type: Required.
       :vartype type: str or ~azure.ai.projects.models.CODE_INTERPRETER_CALL
       :ivar container_id: The ID of the container used to run the code. Required.
       :vartype container_id: str
       :ivar code: The code to run, or null if not available. Required.
       :vartype code: str
       :ivar outputs: The outputs generated by the code interpreter, such as logs or images.
    Can be null if no outputs are available. Required.
       :vartype outputs: list[~azure.ai.projects.models.CodeInterpreterOutput]
    """

    type: Literal[ItemType.CODE_INTERPRETER_CALL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    container_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the container used to run the code. Required."""
    code: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The code to run, or null if not available. Required."""
    outputs: list["_models.CodeInterpreterOutput"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The outputs generated by the code interpreter, such as logs or images.
 Can be null if no outputs are available. Required."""

    @overload
    def __init__(
        self,
        *,
        container_id: str,
        code: str,
        outputs: list["_models.CodeInterpreterOutput"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.CODE_INTERPRETER_CALL  # type: ignore


class ItemResource(_Model):
    """Content item used to generate a response.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CodeInterpreterToolCallItemResource, ComputerToolCallItemResource,
    ComputerToolCallOutputItemResource, FileSearchToolCallItemResource,
    FunctionToolCallItemResource, FunctionToolCallOutputItemResource, ImageGenToolCallItemResource,
    LocalShellToolCallItemResource, LocalShellToolCallOutputItemResource,
    MCPApprovalRequestItemResource, MCPApprovalResponseItemResource, MCPCallItemResource,
    MCPListToolsItemResource, MemorySearchToolCallItemResource, ResponsesMessageItemResource,
    OAuthConsentRequestItemResource, ReasoningItemResource, StructuredOutputsItemResource,
    WebSearchToolCallItemResource, WorkflowActionOutputItemResource

    :ivar type: Required. Known values are: "message", "file_search_call", "function_call",
     "function_call_output", "computer_call", "computer_call_output", "web_search_call",
     "reasoning", "item_reference", "image_generation_call", "code_interpreter_call",
     "local_shell_call", "local_shell_call_output", "mcp_list_tools", "mcp_approval_request",
     "mcp_approval_response", "mcp_call", "structured_outputs", "workflow_action",
     "memory_search_call", and "oauth_consent_request".
    :vartype type: str or ~azure.ai.projects.models.ItemType
    :ivar id: Required.
    :vartype id: str
    :ivar created_by: The information about the creator of the item.
    :vartype created_by: ~azure.ai.projects.models.CreatedBy
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Required. Known values are: \"message\", \"file_search_call\", \"function_call\",
     \"function_call_output\", \"computer_call\", \"computer_call_output\", \"web_search_call\",
     \"reasoning\", \"item_reference\", \"image_generation_call\", \"code_interpreter_call\",
     \"local_shell_call\", \"local_shell_call_output\", \"mcp_list_tools\",
     \"mcp_approval_request\", \"mcp_approval_response\", \"mcp_call\", \"structured_outputs\",
     \"workflow_action\", \"memory_search_call\", and \"oauth_consent_request\"."""
    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    created_by: Optional["_models.CreatedBy"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The information about the creator of the item."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        id: str,  # pylint: disable=redefined-builtin
        created_by: Optional["_models.CreatedBy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CodeInterpreterToolCallItemResource(ItemResource, discriminator="code_interpreter_call"):
    """A tool call to run code.

       :ivar id: Required.
       :vartype id: str
       :ivar created_by: The information about the creator of the item.
       :vartype created_by: ~azure.ai.projects.models.CreatedBy
       :ivar type: Required.
       :vartype type: str or ~azure.ai.projects.models.CODE_INTERPRETER_CALL
       :ivar status: Required. Is one of the following types: Literal["in_progress"],
        Literal["completed"], Literal["incomplete"], Literal["interpreting"], Literal["failed"]
       :vartype status: str or str or str or str or str
       :ivar container_id: The ID of the container used to run the code. Required.
       :vartype container_id: str
       :ivar code: The code to run, or null if not available. Required.
       :vartype code: str
       :ivar outputs: The outputs generated by the code interpreter, such as logs or images.
    Can be null if no outputs are available. Required.
       :vartype outputs: list[~azure.ai.projects.models.CodeInterpreterOutput]
    """

    type: Literal[ItemType.CODE_INTERPRETER_CALL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    status: Literal["in_progress", "completed", "incomplete", "interpreting", "failed"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Required. Is one of the following types: Literal[\"in_progress\"], Literal[\"completed\"],
     Literal[\"incomplete\"], Literal[\"interpreting\"], Literal[\"failed\"]"""
    container_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the container used to run the code. Required."""
    code: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The code to run, or null if not available. Required."""
    outputs: list["_models.CodeInterpreterOutput"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The outputs generated by the code interpreter, such as logs or images.
 Can be null if no outputs are available. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        status: Literal["in_progress", "completed", "incomplete", "interpreting", "failed"],
        container_id: str,
        code: str,
        outputs: list["_models.CodeInterpreterOutput"],
        created_by: Optional["_models.CreatedBy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.CODE_INTERPRETER_CALL  # type: ignore


class ComparisonFilter(_Model):
    """A filter used to compare a specified attribute key to a given value using a defined comparison
    operation.

    :ivar type: Specifies the comparison operator: ``eq``, ``ne``, ``gt``, ``gte``, ``lt``,
     ``lte``.
     * `eq`: equals
     * `ne`: not equal
     * `gt`: greater than
     * `gte`: greater than or equal
     * `lt`: less than
     * `lte`: less than or equal. Required. Is one of the following types: Literal["eq"],
       Literal["ne"], Literal["gt"], Literal["gte"], Literal["lt"], Literal["lte"]
    :vartype type: str or str or str or str or str or str
    :ivar key: The key to compare against the value. Required.
    :vartype key: str
    :ivar value: The value to compare against the attribute key; supports string, number, or
     boolean types. Required. Is one of the following types: str, float, bool
    :vartype value: str or float or bool
    """

    type: Literal["eq", "ne", "gt", "gte", "lt", "lte"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Specifies the comparison operator: ``eq``, ``ne``, ``gt``, ``gte``, ``lt``, ``lte``.
     * `eq`: equals
     * `ne`: not equal
     * `gt`: greater than
     * `gte`: greater than or equal
     * `lt`: less than
     * `lte`: less than or equal. Required. Is one of the following types: Literal[\"eq\"],
       Literal[\"ne\"], Literal[\"gt\"], Literal[\"gte\"], Literal[\"lt\"], Literal[\"lte\"]"""
    key: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The key to compare against the value. Required."""
    value: Union[str, float, bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The value to compare against the attribute key; supports string, number, or boolean types.
     Required. Is one of the following types: str, float, bool"""

    @overload
    def __init__(
        self,
        *,
        type: Literal["eq", "ne", "gt", "gte", "lt", "lte"],
        key: str,
        value: Union[str, float, bool],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CompoundFilter(_Model):
    """Combine multiple filters using ``and`` or ``or``.

    :ivar type: Type of operation: ``and`` or ``or``. Required. Is either a Literal["and"] type or
     a Literal["or"] type.
    :vartype type: str or str
    :ivar filters: Array of filters to combine. Items can be ``ComparisonFilter`` or
     ``CompoundFilter``. Required.
    :vartype filters: list[~azure.ai.projects.models.ComparisonFilter or
     ~azure.ai.projects.models.CompoundFilter]
    """

    type: Literal["and", "or"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Type of operation: ``and`` or ``or``. Required. Is either a Literal[\"and\"] type or a
     Literal[\"or\"] type."""
    filters: list[Union["_models.ComparisonFilter", "_models.CompoundFilter"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Array of filters to combine. Items can be ``ComparisonFilter`` or ``CompoundFilter``. Required."""

    @overload
    def __init__(
        self,
        *,
        type: Literal["and", "or"],
        filters: list[Union["_models.ComparisonFilter", "_models.CompoundFilter"]],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ComputerAction(_Model):
    """ComputerAction.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ComputerActionClick, ComputerActionDoubleClick, ComputerActionDrag, ComputerActionKeyPress,
    ComputerActionMove, ComputerActionScreenshot, ComputerActionScroll, ComputerActionTypeKeys,
    ComputerActionWait

    :ivar type: Required. Known values are: "screenshot", "click", "double_click", "scroll",
     "type", "wait", "keypress", "drag", and "move".
    :vartype type: str or ~azure.ai.projects.models.ComputerActionType
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Required. Known values are: \"screenshot\", \"click\", \"double_click\", \"scroll\", \"type\",
     \"wait\", \"keypress\", \"drag\", and \"move\"."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ComputerActionClick(ComputerAction, discriminator="click"):
    """A click action.

       :ivar type: Specifies the event type. For a click action, this property is
    always set to ``click``. Required.
       :vartype type: str or ~azure.ai.projects.models.CLICK
       :ivar button: Indicates which mouse button was pressed during the click. One of ``left``,
        ``right``, ``wheel``, ``back``, or ``forward``. Required. Is one of the following types:
        Literal["left"], Literal["right"], Literal["wheel"], Literal["back"], Literal["forward"]
       :vartype button: str or str or str or str or str
       :ivar x: The x-coordinate where the click occurred. Required.
       :vartype x: int
       :ivar y: The y-coordinate where the click occurred. Required.
       :vartype y: int
    """

    type: Literal[ComputerActionType.CLICK] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Specifies the event type. For a click action, this property is
 always set to ``click``. Required."""
    button: Literal["left", "right", "wheel", "back", "forward"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates which mouse button was pressed during the click. One of ``left``, ``right``,
     ``wheel``, ``back``, or ``forward``. Required. Is one of the following types:
     Literal[\"left\"], Literal[\"right\"], Literal[\"wheel\"], Literal[\"back\"],
     Literal[\"forward\"]"""
    x: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The x-coordinate where the click occurred. Required."""
    y: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The y-coordinate where the click occurred. Required."""

    @overload
    def __init__(
        self,
        *,
        button: Literal["left", "right", "wheel", "back", "forward"],
        x: int,
        y: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ComputerActionType.CLICK  # type: ignore


class ComputerActionDoubleClick(ComputerAction, discriminator="double_click"):
    """A double click action.

       :ivar type: Specifies the event type. For a double click action, this property is
    always set to ``double_click``. Required.
       :vartype type: str or ~azure.ai.projects.models.DOUBLE_CLICK
       :ivar x: The x-coordinate where the double click occurred. Required.
       :vartype x: int
       :ivar y: The y-coordinate where the double click occurred. Required.
       :vartype y: int
    """

    type: Literal[ComputerActionType.DOUBLE_CLICK] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Specifies the event type. For a double click action, this property is
 always set to ``double_click``. Required."""
    x: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The x-coordinate where the double click occurred. Required."""
    y: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The y-coordinate where the double click occurred. Required."""

    @overload
    def __init__(
        self,
        *,
        x: int,
        y: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ComputerActionType.DOUBLE_CLICK  # type: ignore


class ComputerActionDrag(ComputerAction, discriminator="drag"):
    """A drag action.

       :ivar type: Specifies the event type. For a drag action, this property is
    always set to ``drag``. Required.
       :vartype type: str or ~azure.ai.projects.models.DRAG
       :ivar path: An array of coordinates representing the path of the drag action. Coordinates will
        appear as an array
    of objects, eg
    .. code-block::
       [
         { x: 100, y: 200 },
         { x: 200, y: 300 }
       ]. Required.
       :vartype path: list[~azure.ai.projects.models.Coordinate]
    """

    type: Literal[ComputerActionType.DRAG] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Specifies the event type. For a drag action, this property is
 always set to ``drag``. Required."""
    path: list["_models.Coordinate"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An array of coordinates representing the path of the drag action. Coordinates will appear as an
     array
 of objects, eg
 .. code-block::
    [
      { x: 100, y: 200 },
      { x: 200, y: 300 }
    ]. Required."""

    @overload
    def __init__(
        self,
        *,
        path: list["_models.Coordinate"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ComputerActionType.DRAG  # type: ignore


class ComputerActionKeyPress(ComputerAction, discriminator="keypress"):
    """A collection of keypresses the model would like to perform.

       :ivar type: Specifies the event type. For a keypress action, this property is
    always set to ``keypress``. Required.
       :vartype type: str or ~azure.ai.projects.models.KEYPRESS
       :ivar keys_property: The combination of keys the model is requesting to be pressed. This is an
    array of strings, each representing a key. Required.
       :vartype keys_property: list[str]
    """

    type: Literal[ComputerActionType.KEYPRESS] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Specifies the event type. For a keypress action, this property is
 always set to ``keypress``. Required."""
    keys_property: list[str] = rest_field(name="keys", visibility=["read", "create", "update", "delete", "query"])
    """The combination of keys the model is requesting to be pressed. This is an
 array of strings, each representing a key. Required."""

    @overload
    def __init__(
        self,
        *,
        keys_property: list[str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ComputerActionType.KEYPRESS  # type: ignore


class ComputerActionMove(ComputerAction, discriminator="move"):
    """A mouse move action.

       :ivar type: Specifies the event type. For a move action, this property is
    always set to ``move``. Required.
       :vartype type: str or ~azure.ai.projects.models.MOVE
       :ivar x: The x-coordinate to move to. Required.
       :vartype x: int
       :ivar y: The y-coordinate to move to. Required.
       :vartype y: int
    """

    type: Literal[ComputerActionType.MOVE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Specifies the event type. For a move action, this property is
 always set to ``move``. Required."""
    x: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The x-coordinate to move to. Required."""
    y: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The y-coordinate to move to. Required."""

    @overload
    def __init__(
        self,
        *,
        x: int,
        y: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ComputerActionType.MOVE  # type: ignore


class ComputerActionScreenshot(ComputerAction, discriminator="screenshot"):
    """A screenshot action.

       :ivar type: Specifies the event type. For a screenshot action, this property is
    always set to ``screenshot``. Required.
       :vartype type: str or ~azure.ai.projects.models.SCREENSHOT
    """

    type: Literal[ComputerActionType.SCREENSHOT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Specifies the event type. For a screenshot action, this property is
 always set to ``screenshot``. Required."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ComputerActionType.SCREENSHOT  # type: ignore


class ComputerActionScroll(ComputerAction, discriminator="scroll"):
    """A scroll action.

       :ivar type: Specifies the event type. For a scroll action, this property is
    always set to ``scroll``. Required.
       :vartype type: str or ~azure.ai.projects.models.SCROLL
       :ivar x: The x-coordinate where the scroll occurred. Required.
       :vartype x: int
       :ivar y: The y-coordinate where the scroll occurred. Required.
       :vartype y: int
       :ivar scroll_x: The horizontal scroll distance. Required.
       :vartype scroll_x: int
       :ivar scroll_y: The vertical scroll distance. Required.
       :vartype scroll_y: int
    """

    type: Literal[ComputerActionType.SCROLL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Specifies the event type. For a scroll action, this property is
 always set to ``scroll``. Required."""
    x: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The x-coordinate where the scroll occurred. Required."""
    y: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The y-coordinate where the scroll occurred. Required."""
    scroll_x: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The horizontal scroll distance. Required."""
    scroll_y: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The vertical scroll distance. Required."""

    @overload
    def __init__(
        self,
        *,
        x: int,
        y: int,
        scroll_x: int,
        scroll_y: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ComputerActionType.SCROLL  # type: ignore


class ComputerActionTypeKeys(ComputerAction, discriminator="type"):
    """An action to type in text.

       :ivar type: Specifies the event type. For a type action, this property is
    always set to ``type``. Required.
       :vartype type: str or ~azure.ai.projects.models.TYPE
       :ivar text: The text to type. Required.
       :vartype text: str
    """

    type: Literal[ComputerActionType.TYPE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Specifies the event type. For a type action, this property is
 always set to ``type``. Required."""
    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The text to type. Required."""

    @overload
    def __init__(
        self,
        *,
        text: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ComputerActionType.TYPE  # type: ignore


class ComputerActionWait(ComputerAction, discriminator="wait"):
    """A wait action.

       :ivar type: Specifies the event type. For a wait action, this property is
    always set to ``wait``. Required.
       :vartype type: str or ~azure.ai.projects.models.WAIT
    """

    type: Literal[ComputerActionType.WAIT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Specifies the event type. For a wait action, this property is
 always set to ``wait``. Required."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ComputerActionType.WAIT  # type: ignore


class ComputerToolCallItemParam(ItemParam, discriminator="computer_call"):
    """A tool call to a computer use tool. See the
    `computer use guide </docs/guides/tools-computer-use>`_ for more information.

        :ivar type: Required.
        :vartype type: str or ~azure.ai.projects.models.COMPUTER_CALL
        :ivar call_id: An identifier used when responding to the tool call with output. Required.
        :vartype call_id: str
        :ivar action: Required.
        :vartype action: ~azure.ai.projects.models.ComputerAction
        :ivar pending_safety_checks: The pending safety checks for the computer call. Required.
        :vartype pending_safety_checks: list[~azure.ai.projects.models.ComputerToolCallSafetyCheck]
    """

    type: Literal[ItemType.COMPUTER_CALL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    call_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An identifier used when responding to the tool call with output. Required."""
    action: "_models.ComputerAction" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    pending_safety_checks: list["_models.ComputerToolCallSafetyCheck"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The pending safety checks for the computer call. Required."""

    @overload
    def __init__(
        self,
        *,
        call_id: str,
        action: "_models.ComputerAction",
        pending_safety_checks: list["_models.ComputerToolCallSafetyCheck"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.COMPUTER_CALL  # type: ignore


class ComputerToolCallItemResource(ItemResource, discriminator="computer_call"):
    """A tool call to a computer use tool. See the
    `computer use guide </docs/guides/tools-computer-use>`_ for more information.

        :ivar id: Required.
        :vartype id: str
        :ivar created_by: The information about the creator of the item.
        :vartype created_by: ~azure.ai.projects.models.CreatedBy
        :ivar type: Required.
        :vartype type: str or ~azure.ai.projects.models.COMPUTER_CALL
        :ivar status: The status of the item. One of ``in_progress``, ``completed``, or
     ``incomplete``. Populated when items are returned via API. Required. Is one of the following
         types: Literal["in_progress"], Literal["completed"], Literal["incomplete"]
        :vartype status: str or str or str
        :ivar call_id: An identifier used when responding to the tool call with output. Required.
        :vartype call_id: str
        :ivar action: Required.
        :vartype action: ~azure.ai.projects.models.ComputerAction
        :ivar pending_safety_checks: The pending safety checks for the computer call. Required.
        :vartype pending_safety_checks: list[~azure.ai.projects.models.ComputerToolCallSafetyCheck]
    """

    type: Literal[ItemType.COMPUTER_CALL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    status: Literal["in_progress", "completed", "incomplete"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The status of the item. One of ``in_progress``, ``completed``, or
 ``incomplete``. Populated when items are returned via API. Required. Is one of the following
     types: Literal[\"in_progress\"], Literal[\"completed\"], Literal[\"incomplete\"]"""
    call_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An identifier used when responding to the tool call with output. Required."""
    action: "_models.ComputerAction" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    pending_safety_checks: list["_models.ComputerToolCallSafetyCheck"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The pending safety checks for the computer call. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        status: Literal["in_progress", "completed", "incomplete"],
        call_id: str,
        action: "_models.ComputerAction",
        pending_safety_checks: list["_models.ComputerToolCallSafetyCheck"],
        created_by: Optional["_models.CreatedBy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.COMPUTER_CALL  # type: ignore


class ComputerToolCallOutputItemOutput(_Model):
    """ComputerToolCallOutputItemOutput.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ComputerToolCallOutputItemOutputComputerScreenshot

    :ivar type: Required. "computer_screenshot"
    :vartype type: str or ~azure.ai.projects.models.ComputerToolCallOutputItemOutputType
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Required. \"computer_screenshot\""""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ComputerToolCallOutputItemOutputComputerScreenshot(
    ComputerToolCallOutputItemOutput, discriminator="computer_screenshot"
):  # pylint: disable=name-too-long
    """ComputerToolCallOutputItemOutputComputerScreenshot.

    :ivar type: Required.
    :vartype type: str or ~azure.ai.projects.models.SCREENSHOT
    :ivar image_url:
    :vartype image_url: str
    :ivar file_id:
    :vartype file_id: str
    """

    type: Literal[ComputerToolCallOutputItemOutputType.SCREENSHOT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    image_url: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    file_id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        image_url: Optional[str] = None,
        file_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ComputerToolCallOutputItemOutputType.SCREENSHOT  # type: ignore


class ComputerToolCallOutputItemParam(ItemParam, discriminator="computer_call_output"):
    """The output of a computer tool call.

       :ivar type: Required.
       :vartype type: str or ~azure.ai.projects.models.COMPUTER_CALL_OUTPUT
       :ivar call_id: The ID of the computer tool call that produced the output. Required.
       :vartype call_id: str
       :ivar acknowledged_safety_checks: The safety checks reported by the API that have been
        acknowledged by the
    developer.
       :vartype acknowledged_safety_checks:
        list[~azure.ai.projects.models.ComputerToolCallSafetyCheck]
       :ivar output: Required.
       :vartype output: ~azure.ai.projects.models.ComputerToolCallOutputItemOutput
    """

    type: Literal[ItemType.COMPUTER_CALL_OUTPUT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    call_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the computer tool call that produced the output. Required."""
    acknowledged_safety_checks: Optional[list["_models.ComputerToolCallSafetyCheck"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The safety checks reported by the API that have been acknowledged by the
 developer."""
    output: "_models.ComputerToolCallOutputItemOutput" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Required."""

    @overload
    def __init__(
        self,
        *,
        call_id: str,
        output: "_models.ComputerToolCallOutputItemOutput",
        acknowledged_safety_checks: Optional[list["_models.ComputerToolCallSafetyCheck"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.COMPUTER_CALL_OUTPUT  # type: ignore


class ComputerToolCallOutputItemResource(ItemResource, discriminator="computer_call_output"):
    """The output of a computer tool call.

       :ivar id: Required.
       :vartype id: str
       :ivar created_by: The information about the creator of the item.
       :vartype created_by: ~azure.ai.projects.models.CreatedBy
       :ivar type: Required.
       :vartype type: str or ~azure.ai.projects.models.COMPUTER_CALL_OUTPUT
       :ivar status: The status of the item. One of ``in_progress``, ``completed``, or
    ``incomplete``. Populated when items are returned via API. Required. Is one of the following
        types: Literal["in_progress"], Literal["completed"], Literal["incomplete"]
       :vartype status: str or str or str
       :ivar call_id: The ID of the computer tool call that produced the output. Required.
       :vartype call_id: str
       :ivar acknowledged_safety_checks: The safety checks reported by the API that have been
        acknowledged by the
    developer.
       :vartype acknowledged_safety_checks:
        list[~azure.ai.projects.models.ComputerToolCallSafetyCheck]
       :ivar output: Required.
       :vartype output: ~azure.ai.projects.models.ComputerToolCallOutputItemOutput
    """

    type: Literal[ItemType.COMPUTER_CALL_OUTPUT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    status: Literal["in_progress", "completed", "incomplete"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The status of the item. One of ``in_progress``, ``completed``, or
 ``incomplete``. Populated when items are returned via API. Required. Is one of the following
     types: Literal[\"in_progress\"], Literal[\"completed\"], Literal[\"incomplete\"]"""
    call_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the computer tool call that produced the output. Required."""
    acknowledged_safety_checks: Optional[list["_models.ComputerToolCallSafetyCheck"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The safety checks reported by the API that have been acknowledged by the
 developer."""
    output: "_models.ComputerToolCallOutputItemOutput" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        status: Literal["in_progress", "completed", "incomplete"],
        call_id: str,
        output: "_models.ComputerToolCallOutputItemOutput",
        created_by: Optional["_models.CreatedBy"] = None,
        acknowledged_safety_checks: Optional[list["_models.ComputerToolCallSafetyCheck"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.COMPUTER_CALL_OUTPUT  # type: ignore


class ComputerToolCallSafetyCheck(_Model):
    """A pending safety check for the computer call.

    :ivar id: The ID of the pending safety check. Required.
    :vartype id: str
    :ivar code: The type of the pending safety check. Required.
    :vartype code: str
    :ivar message: Details about the pending safety check. Required.
    :vartype message: str
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the pending safety check. Required."""
    code: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The type of the pending safety check. Required."""
    message: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Details about the pending safety check. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        code: str,
        message: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ComputerUsePreviewTool(Tool, discriminator="computer_use_preview"):
    """A tool that controls a virtual computer. Learn more about the `computer tool
    <https://platform.openai.com/docs/guides/tools-computer-use>`_.

    :ivar type: The type of the computer use tool. Always ``computer_use_preview``. Required.
    :vartype type: str or ~azure.ai.projects.models.COMPUTER_USE_PREVIEW
    :ivar environment: The type of computer environment to control. Required. Is one of the
     following types: Literal["windows"], Literal["mac"], Literal["linux"], Literal["ubuntu"],
     Literal["browser"]
    :vartype environment: str or str or str or str or str
    :ivar display_width: The width of the computer display. Required.
    :vartype display_width: int
    :ivar display_height: The height of the computer display. Required.
    :vartype display_height: int
    """

    type: Literal[ToolType.COMPUTER_USE_PREVIEW] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the computer use tool. Always ``computer_use_preview``. Required."""
    environment: Literal["windows", "mac", "linux", "ubuntu", "browser"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of computer environment to control. Required. Is one of the following types:
     Literal[\"windows\"], Literal[\"mac\"], Literal[\"linux\"], Literal[\"ubuntu\"],
     Literal[\"browser\"]"""
    display_width: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The width of the computer display. Required."""
    display_height: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The height of the computer display. Required."""

    @overload
    def __init__(
        self,
        *,
        environment: Literal["windows", "mac", "linux", "ubuntu", "browser"],
        display_width: int,
        display_height: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ToolType.COMPUTER_USE_PREVIEW  # type: ignore


class Connection(_Model):
    """Response from the list and get connections operations.

    :ivar name: The friendly name of the connection, provided by the user. Required.
    :vartype name: str
    :ivar id: A unique identifier for the connection, generated by the service. Required.
    :vartype id: str
    :ivar type: Category of the connection. Required. Known values are: "AzureOpenAI", "AzureBlob",
     "AzureStorageAccount", "CognitiveSearch", "CosmosDB", "ApiKey", "AppConfig", "AppInsights",
     "CustomKeys", and "RemoteTool".
    :vartype type: str or ~azure.ai.projects.models.ConnectionType
    :ivar target: The connection URL to be used for this service. Required.
    :vartype target: str
    :ivar is_default: Whether the connection is tagged as the default connection of its type.
     Required.
    :vartype is_default: bool
    :ivar credentials: The credentials used by the connection. Required.
    :vartype credentials: ~azure.ai.projects.models.BaseCredentials
    :ivar metadata: Metadata of the connection. Required.
    :vartype metadata: dict[str, str]
    """

    name: str = rest_field(visibility=["read"])
    """The friendly name of the connection, provided by the user. Required."""
    id: str = rest_field(visibility=["read"])
    """A unique identifier for the connection, generated by the service. Required."""
    type: Union[str, "_models.ConnectionType"] = rest_field(visibility=["read"])
    """Category of the connection. Required. Known values are: \"AzureOpenAI\", \"AzureBlob\",
     \"AzureStorageAccount\", \"CognitiveSearch\", \"CosmosDB\", \"ApiKey\", \"AppConfig\",
     \"AppInsights\", \"CustomKeys\", and \"RemoteTool\"."""
    target: str = rest_field(visibility=["read"])
    """The connection URL to be used for this service. Required."""
    is_default: bool = rest_field(name="isDefault", visibility=["read"])
    """Whether the connection is tagged as the default connection of its type. Required."""
    credentials: "_models.BaseCredentials" = rest_field(visibility=["read"])
    """The credentials used by the connection. Required."""
    metadata: dict[str, str] = rest_field(visibility=["read"])
    """Metadata of the connection. Required."""


class ContainerAppAgentDefinition(AgentDefinition, discriminator="container_app"):
    """The container app agent definition.

    :ivar rai_config: Configuration for Responsible AI (RAI) content filtering and safety features.
    :vartype rai_config: ~azure.ai.projects.models.RaiConfig
    :ivar kind: Required.
    :vartype kind: str or ~azure.ai.projects.models.CONTAINER_APP
    :ivar container_protocol_versions: The protocols that the agent supports for ingress
     communication of the containers. Required.
    :vartype container_protocol_versions: list[~azure.ai.projects.models.ProtocolVersionRecord]
    :ivar container_app_resource_id: The resource ID of the Azure Container App that hosts this
     agent. Not mutable across versions. Required.
    :vartype container_app_resource_id: str
    :ivar ingress_subdomain_suffix: The suffix to apply to the app subdomain when sending ingress
     to the agent. This can be a label (e.g., '---current'), a specific revision (e.g.,
     '--0000001'), or empty to use the default endpoint for the container app. Required.
    :vartype ingress_subdomain_suffix: str
    """

    kind: Literal[AgentKind.CONTAINER_APP] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    container_protocol_versions: list["_models.ProtocolVersionRecord"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The protocols that the agent supports for ingress communication of the containers. Required."""
    container_app_resource_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The resource ID of the Azure Container App that hosts this agent. Not mutable across versions.
     Required."""
    ingress_subdomain_suffix: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The suffix to apply to the app subdomain when sending ingress to the agent. This can be a label
     (e.g., '---current'), a specific revision (e.g., '--0000001'), or empty to use the default
     endpoint for the container app. Required."""

    @overload
    def __init__(
        self,
        *,
        container_protocol_versions: list["_models.ProtocolVersionRecord"],
        container_app_resource_id: str,
        ingress_subdomain_suffix: str,
        rai_config: Optional["_models.RaiConfig"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = AgentKind.CONTAINER_APP  # type: ignore


class EvaluationRuleAction(_Model):
    """Evaluation action model.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ContinuousEvaluationRuleAction, HumanEvaluationRuleAction

    :ivar type: Type of the evaluation action. Required. Known values are: "continuousEvaluation"
     and "humanEvaluation".
    :vartype type: str or ~azure.ai.projects.models.EvaluationRuleActionType
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Type of the evaluation action. Required. Known values are: \"continuousEvaluation\" and
     \"humanEvaluation\"."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ContinuousEvaluationRuleAction(EvaluationRuleAction, discriminator="continuousEvaluation"):
    """Evaluation rule action for continuous evaluation.

    :ivar type: Required. Continuous evaluation.
    :vartype type: str or ~azure.ai.projects.models.CONTINUOUS_EVALUATION
    :ivar eval_id: Eval Id to add continuous evaluation runs to. Required.
    :vartype eval_id: str
    :ivar max_hourly_runs: Maximum number of evaluation runs allowed per hour.
    :vartype max_hourly_runs: int
    """

    type: Literal[EvaluationRuleActionType.CONTINUOUS_EVALUATION] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Continuous evaluation."""
    eval_id: str = rest_field(name="evalId", visibility=["read", "create", "update", "delete", "query"])
    """Eval Id to add continuous evaluation runs to. Required."""
    max_hourly_runs: Optional[int] = rest_field(
        name="maxHourlyRuns", visibility=["read", "create", "update", "delete", "query"]
    )
    """Maximum number of evaluation runs allowed per hour."""

    @overload
    def __init__(
        self,
        *,
        eval_id: str,
        max_hourly_runs: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = EvaluationRuleActionType.CONTINUOUS_EVALUATION  # type: ignore


class Coordinate(_Model):
    """An x/y coordinate pair, e.g. ``{ x: 100, y: 200 }``.

    :ivar x: The x-coordinate. Required.
    :vartype x: int
    :ivar y: The y-coordinate. Required.
    :vartype y: int
    """

    x: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The x-coordinate. Required."""
    y: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The y-coordinate. Required."""

    @overload
    def __init__(
        self,
        *,
        x: int,
        y: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CosmosDBIndex(Index, discriminator="CosmosDBNoSqlVectorStore"):
    """CosmosDB Vector Store Index Definition.

    :ivar id: Asset ID, a unique identifier for the asset.
    :vartype id: str
    :ivar name: The name of the resource. Required.
    :vartype name: str
    :ivar version: The version of the resource. Required.
    :vartype version: str
    :ivar description: The asset description text.
    :vartype description: str
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar type: Type of index. Required. CosmosDB
    :vartype type: str or ~azure.ai.projects.models.COSMOS_DB
    :ivar connection_name: Name of connection to CosmosDB. Required.
    :vartype connection_name: str
    :ivar database_name: Name of the CosmosDB Database. Required.
    :vartype database_name: str
    :ivar container_name: Name of CosmosDB Container. Required.
    :vartype container_name: str
    :ivar embedding_configuration: Embedding model configuration. Required.
    :vartype embedding_configuration: ~azure.ai.projects.models.EmbeddingConfiguration
    :ivar field_mapping: Field mapping configuration. Required.
    :vartype field_mapping: ~azure.ai.projects.models.FieldMapping
    """

    type: Literal[IndexType.COSMOS_DB] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Type of index. Required. CosmosDB"""
    connection_name: str = rest_field(name="connectionName", visibility=["create"])
    """Name of connection to CosmosDB. Required."""
    database_name: str = rest_field(name="databaseName", visibility=["create"])
    """Name of the CosmosDB Database. Required."""
    container_name: str = rest_field(name="containerName", visibility=["create"])
    """Name of CosmosDB Container. Required."""
    embedding_configuration: "_models.EmbeddingConfiguration" = rest_field(
        name="embeddingConfiguration", visibility=["create"]
    )
    """Embedding model configuration. Required."""
    field_mapping: "_models.FieldMapping" = rest_field(name="fieldMapping", visibility=["create"])
    """Field mapping configuration. Required."""

    @overload
    def __init__(
        self,
        *,
        connection_name: str,
        database_name: str,
        container_name: str,
        embedding_configuration: "_models.EmbeddingConfiguration",
        field_mapping: "_models.FieldMapping",
        description: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = IndexType.COSMOS_DB  # type: ignore


class CreatedBy(_Model):
    """CreatedBy.

    :ivar agent: The agent that created the item.
    :vartype agent: ~azure.ai.projects.models.AgentId
    :ivar response_id: The response on which the item is created.
    :vartype response_id: str
    """

    agent: Optional["_models.AgentId"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The agent that created the item."""
    response_id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The response on which the item is created."""

    @overload
    def __init__(
        self,
        *,
        agent: Optional["_models.AgentId"] = None,
        response_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Trigger(_Model):
    """Base model for Trigger of the schedule.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CronTrigger, OneTimeTrigger, RecurrenceTrigger

    :ivar type: Type of the trigger. Required. Known values are: "Cron", "Recurrence", and
     "OneTime".
    :vartype type: str or ~azure.ai.projects.models.TriggerType
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Type of the trigger. Required. Known values are: \"Cron\", \"Recurrence\", and \"OneTime\"."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CronTrigger(Trigger, discriminator="Cron"):
    """Cron based trigger.

    :ivar type: Required. Cron based trigger.
    :vartype type: str or ~azure.ai.projects.models.CRON
    :ivar expression: Cron expression that defines the schedule frequency. Required.
    :vartype expression: str
    :ivar time_zone: Time zone for the cron schedule.
    :vartype time_zone: str
    :ivar start_time: Start time for the cron schedule in ISO 8601 format.
    :vartype start_time: str
    :ivar end_time: End time for the cron schedule in ISO 8601 format.
    :vartype end_time: str
    """

    type: Literal[TriggerType.CRON] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Cron based trigger."""
    expression: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Cron expression that defines the schedule frequency. Required."""
    time_zone: Optional[str] = rest_field(name="timeZone", visibility=["read", "create", "update", "delete", "query"])
    """Time zone for the cron schedule."""
    start_time: Optional[str] = rest_field(name="startTime", visibility=["read", "create", "update", "delete", "query"])
    """Start time for the cron schedule in ISO 8601 format."""
    end_time: Optional[str] = rest_field(name="endTime", visibility=["read", "create", "update", "delete", "query"])
    """End time for the cron schedule in ISO 8601 format."""

    @overload
    def __init__(
        self,
        *,
        expression: str,
        time_zone: Optional[str] = None,
        start_time: Optional[str] = None,
        end_time: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = TriggerType.CRON  # type: ignore


class CustomCredential(BaseCredentials, discriminator="CustomKeys"):
    """Custom credential definition.

    :ivar type: The credential type. Required. Custom credential
    :vartype type: str or ~azure.ai.projects.models.CUSTOM
    """

    type: Literal[CredentialType.CUSTOM] = rest_discriminator(name="type", visibility=["read"])  # type: ignore
    """The credential type. Required. Custom credential"""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = CredentialType.CUSTOM  # type: ignore


class RecurrenceSchedule(_Model):
    """Recurrence schedule model.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DailyRecurrenceSchedule, HourlyRecurrenceSchedule, MonthlyRecurrenceSchedule,
    WeeklyRecurrenceSchedule

    :ivar type: Recurrence type for the recurrence schedule. Required. Known values are: "Hourly",
     "Daily", "Weekly", and "Monthly".
    :vartype type: str or ~azure.ai.projects.models.RecurrenceType
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Recurrence type for the recurrence schedule. Required. Known values are: \"Hourly\", \"Daily\",
     \"Weekly\", and \"Monthly\"."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DailyRecurrenceSchedule(RecurrenceSchedule, discriminator="Daily"):
    """Daily recurrence schedule.

    :ivar type: Daily recurrence type. Required. Daily recurrence pattern.
    :vartype type: str or ~azure.ai.projects.models.DAILY
    :ivar hours: Hours for the recurrence schedule. Required.
    :vartype hours: list[int]
    """

    type: Literal[RecurrenceType.DAILY] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Daily recurrence type. Required. Daily recurrence pattern."""
    hours: list[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Hours for the recurrence schedule. Required."""

    @overload
    def __init__(
        self,
        *,
        hours: list[int],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = RecurrenceType.DAILY  # type: ignore


class DatasetCredential(_Model):
    """Represents a reference to a blob for consumption.

    :ivar blob_reference: Credential info to access the storage account. Required.
    :vartype blob_reference: ~azure.ai.projects.models.BlobReference
    """

    blob_reference: "_models.BlobReference" = rest_field(
        name="blobReference", visibility=["read", "create", "update", "delete", "query"]
    )
    """Credential info to access the storage account. Required."""

    @overload
    def __init__(
        self,
        *,
        blob_reference: "_models.BlobReference",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DatasetVersion(_Model):
    """DatasetVersion Definition.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    FileDatasetVersion, FolderDatasetVersion

    :ivar data_uri: URI of the data. Example: `https://go.microsoft.com/fwlink/?linkid=2202330
     <https://go.microsoft.com/fwlink/?linkid=2202330>`_. Required.
    :vartype data_uri: str
    :ivar type: Dataset type. Required. Known values are: "uri_file" and "uri_folder".
    :vartype type: str or ~azure.ai.projects.models.DatasetType
    :ivar is_reference: Indicates if the dataset holds a reference to the storage, or the dataset
     manages storage itself. If true, the underlying data will not be deleted when the dataset
     version is deleted.
    :vartype is_reference: bool
    :ivar connection_name: The Azure Storage Account connection name. Required if
     startPendingUploadVersion was not called before creating the Dataset.
    :vartype connection_name: str
    :ivar id: Asset ID, a unique identifier for the asset.
    :vartype id: str
    :ivar name: The name of the resource. Required.
    :vartype name: str
    :ivar version: The version of the resource. Required.
    :vartype version: str
    :ivar description: The asset description text.
    :vartype description: str
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    """

    __mapping__: dict[str, _Model] = {}
    data_uri: str = rest_field(name="dataUri", visibility=["read", "create"])
    """URI of the data. Example: `https://go.microsoft.com/fwlink/?linkid=2202330
     <https://go.microsoft.com/fwlink/?linkid=2202330>`_. Required."""
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Dataset type. Required. Known values are: \"uri_file\" and \"uri_folder\"."""
    is_reference: Optional[bool] = rest_field(name="isReference", visibility=["read"])
    """Indicates if the dataset holds a reference to the storage, or the dataset manages storage
     itself. If true, the underlying data will not be deleted when the dataset version is deleted."""
    connection_name: Optional[str] = rest_field(name="connectionName", visibility=["read", "create"])
    """The Azure Storage Account connection name. Required if startPendingUploadVersion was not called
     before creating the Dataset."""
    id: Optional[str] = rest_field(visibility=["read"])
    """Asset ID, a unique identifier for the asset."""
    name: str = rest_field(visibility=["read"])
    """The name of the resource. Required."""
    version: str = rest_field(visibility=["read"])
    """The version of the resource. Required."""
    description: Optional[str] = rest_field(visibility=["create", "update"])
    """The asset description text."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["create", "update"])
    """Tag dictionary. Tags can be added, removed, and updated."""

    @overload
    def __init__(
        self,
        *,
        data_uri: str,
        type: str,
        connection_name: Optional[str] = None,
        description: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class DeleteAgentResponse(_Model):
    """A deleted agent Object.

    :ivar object: The object type. Always 'agent.deleted'. Required. Default value is
     "agent.deleted".
    :vartype object: str
    :ivar name: The name of the agent. Required.
    :vartype name: str
    :ivar deleted: Whether the agent was successfully deleted. Required.
    :vartype deleted: bool
    """

    object: Literal["agent.deleted"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The object type. Always 'agent.deleted'. Required. Default value is \"agent.deleted\"."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the agent. Required."""
    deleted: bool = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Whether the agent was successfully deleted. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        deleted: bool,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object: Literal["agent.deleted"] = "agent.deleted"


class DeleteAgentVersionResponse(_Model):
    """A deleted agent version Object.

    :ivar object: The object type. Always 'agent.deleted'. Required. Default value is
     "agent.version.deleted".
    :vartype object: str
    :ivar name: The name of the agent. Required.
    :vartype name: str
    :ivar version: The version identifier of the agent. Required.
    :vartype version: str
    :ivar deleted: Whether the agent was successfully deleted. Required.
    :vartype deleted: bool
    """

    object: Literal["agent.version.deleted"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The object type. Always 'agent.deleted'. Required. Default value is \"agent.version.deleted\"."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the agent. Required."""
    version: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The version identifier of the agent. Required."""
    deleted: bool = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Whether the agent was successfully deleted. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        version: str,
        deleted: bool,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object: Literal["agent.version.deleted"] = "agent.version.deleted"


class DeleteMemoryStoreResponse(_Model):
    """DeleteMemoryStoreResponse.

    :ivar object: The object type. Always 'memory_store.deleted'. Required. Default value is
     "memory_store.deleted".
    :vartype object: str
    :ivar name: The name of the memory store. Required.
    :vartype name: str
    :ivar deleted: Whether the memory store was successfully deleted. Required.
    :vartype deleted: bool
    """

    object: Literal["memory_store.deleted"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The object type. Always 'memory_store.deleted'. Required. Default value is
     \"memory_store.deleted\"."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the memory store. Required."""
    deleted: bool = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Whether the memory store was successfully deleted. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        deleted: bool,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object: Literal["memory_store.deleted"] = "memory_store.deleted"


class Deployment(_Model):
    """Model Deployment Definition.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ModelDeployment

    :ivar type: The type of the deployment. Required. "ModelDeployment"
    :vartype type: str or ~azure.ai.projects.models.DeploymentType
    :ivar name: Name of the deployment. Required.
    :vartype name: str
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """The type of the deployment. Required. \"ModelDeployment\""""
    name: str = rest_field(visibility=["read"])
    """Name of the deployment. Required."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EmbeddingConfiguration(_Model):
    """Embedding configuration class.

    :ivar model_deployment_name: Deployment name of embedding model. It can point to a model
     deployment either in the parent AIServices or a connection. Required.
    :vartype model_deployment_name: str
    :ivar embedding_field: Embedding field. Required.
    :vartype embedding_field: str
    """

    model_deployment_name: str = rest_field(name="modelDeploymentName", visibility=["create"])
    """Deployment name of embedding model. It can point to a model deployment either in the parent
     AIServices or a connection. Required."""
    embedding_field: str = rest_field(name="embeddingField", visibility=["create"])
    """Embedding field. Required."""

    @overload
    def __init__(
        self,
        *,
        model_deployment_name: str,
        embedding_field: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EntraIDCredentials(BaseCredentials, discriminator="AAD"):
    """Entra ID credential definition.

    :ivar type: The credential type. Required. Entra ID credential (formerly known as AAD)
    :vartype type: str or ~azure.ai.projects.models.ENTRA_ID
    """

    type: Literal[CredentialType.ENTRA_ID] = rest_discriminator(name="type", visibility=["read"])  # type: ignore
    """The credential type. Required. Entra ID credential (formerly known as AAD)"""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = CredentialType.ENTRA_ID  # type: ignore


class EvalCompareReport(InsightResult, discriminator="EvaluationComparison"):
    """Insights from the evaluation comparison.

    :ivar type: The type of insights result. Required. Evaluation Comparison.
    :vartype type: str or ~azure.ai.projects.models.EVALUATION_COMPARISON
    :ivar comparisons: Comparison results for each treatment run against the baseline. Required.
    :vartype comparisons: list[~azure.ai.projects.models.EvalRunResultComparison]
    :ivar method: The statistical method used for comparison. Required.
    :vartype method: str
    """

    type: Literal[InsightType.EVALUATION_COMPARISON] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of insights result. Required. Evaluation Comparison."""
    comparisons: list["_models.EvalRunResultComparison"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Comparison results for each treatment run against the baseline. Required."""
    method: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The statistical method used for comparison. Required."""

    @overload
    def __init__(
        self,
        *,
        comparisons: list["_models.EvalRunResultComparison"],
        method: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = InsightType.EVALUATION_COMPARISON  # type: ignore


class EvalResult(_Model):
    """Result of the evaluation.

    :ivar name: name of the check. Required.
    :vartype name: str
    :ivar type: type of the check. Required.
    :vartype type: str
    :ivar score: score. Required.
    :vartype score: float
    :ivar passed: indicates if the check passed or failed. Required.
    :vartype passed: bool
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """name of the check. Required."""
    type: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """type of the check. Required."""
    score: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """score. Required."""
    passed: bool = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """indicates if the check passed or failed. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        type: str,
        score: float,
        passed: bool,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EvalRunResultCompareItem(_Model):
    """Metric comparison for a treatment against the baseline.

    :ivar treatment_run_id: The treatment run ID. Required.
    :vartype treatment_run_id: str
    :ivar treatment_run_summary: Summary statistics of the treatment run. Required.
    :vartype treatment_run_summary: ~azure.ai.projects.models.EvalRunResultSummary
    :ivar delta_estimate: Estimated difference between treatment and baseline. Required.
    :vartype delta_estimate: float
    :ivar p_value: P-value for the treatment effect. Required.
    :vartype p_value: float
    :ivar treatment_effect: Type of treatment effect. Required. Known values are: "TooFewSamples",
     "Inconclusive", "Changed", "Improved", and "Degraded".
    :vartype treatment_effect: str or ~azure.ai.projects.models.TreatmentEffectType
    """

    treatment_run_id: str = rest_field(
        name="treatmentRunId", visibility=["read", "create", "update", "delete", "query"]
    )
    """The treatment run ID. Required."""
    treatment_run_summary: "_models.EvalRunResultSummary" = rest_field(
        name="treatmentRunSummary", visibility=["read", "create", "update", "delete", "query"]
    )
    """Summary statistics of the treatment run. Required."""
    delta_estimate: float = rest_field(name="deltaEstimate", visibility=["read", "create", "update", "delete", "query"])
    """Estimated difference between treatment and baseline. Required."""
    p_value: float = rest_field(name="pValue", visibility=["read", "create", "update", "delete", "query"])
    """P-value for the treatment effect. Required."""
    treatment_effect: Union[str, "_models.TreatmentEffectType"] = rest_field(
        name="treatmentEffect", visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of treatment effect. Required. Known values are: \"TooFewSamples\", \"Inconclusive\",
     \"Changed\", \"Improved\", and \"Degraded\"."""

    @overload
    def __init__(
        self,
        *,
        treatment_run_id: str,
        treatment_run_summary: "_models.EvalRunResultSummary",
        delta_estimate: float,
        p_value: float,
        treatment_effect: Union[str, "_models.TreatmentEffectType"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EvalRunResultComparison(_Model):
    """Comparison results for treatment runs against the baseline.

    :ivar testing_criteria: Name of the testing criteria. Required.
    :vartype testing_criteria: str
    :ivar metric: Metric being evaluated. Required.
    :vartype metric: str
    :ivar evaluator: Name of the evaluator for this testing criteria. Required.
    :vartype evaluator: str
    :ivar baseline_run_summary: Summary statistics of the baseline run. Required.
    :vartype baseline_run_summary: ~azure.ai.projects.models.EvalRunResultSummary
    :ivar compare_items: List of comparison results for each treatment run. Required.
    :vartype compare_items: list[~azure.ai.projects.models.EvalRunResultCompareItem]
    """

    testing_criteria: str = rest_field(
        name="testingCriteria", visibility=["read", "create", "update", "delete", "query"]
    )
    """Name of the testing criteria. Required."""
    metric: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Metric being evaluated. Required."""
    evaluator: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the evaluator for this testing criteria. Required."""
    baseline_run_summary: "_models.EvalRunResultSummary" = rest_field(
        name="baselineRunSummary", visibility=["read", "create", "update", "delete", "query"]
    )
    """Summary statistics of the baseline run. Required."""
    compare_items: list["_models.EvalRunResultCompareItem"] = rest_field(
        name="compareItems", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of comparison results for each treatment run. Required."""

    @overload
    def __init__(
        self,
        *,
        testing_criteria: str,
        metric: str,
        evaluator: str,
        baseline_run_summary: "_models.EvalRunResultSummary",
        compare_items: list["_models.EvalRunResultCompareItem"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EvalRunResultSummary(_Model):
    """Summary statistics of a metric in an evaluation run.

    :ivar run_id: The evaluation run ID. Required.
    :vartype run_id: str
    :ivar sample_count: Number of samples in the evaluation run. Required.
    :vartype sample_count: int
    :ivar average: Average value of the metric in the evaluation run. Required.
    :vartype average: float
    :ivar standard_deviation: Standard deviation of the metric in the evaluation run. Required.
    :vartype standard_deviation: float
    """

    run_id: str = rest_field(name="runId", visibility=["read", "create", "update", "delete", "query"])
    """The evaluation run ID. Required."""
    sample_count: int = rest_field(name="sampleCount", visibility=["read", "create", "update", "delete", "query"])
    """Number of samples in the evaluation run. Required."""
    average: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Average value of the metric in the evaluation run. Required."""
    standard_deviation: float = rest_field(
        name="standardDeviation", visibility=["read", "create", "update", "delete", "query"]
    )
    """Standard deviation of the metric in the evaluation run. Required."""

    @overload
    def __init__(
        self,
        *,
        run_id: str,
        sample_count: int,
        average: float,
        standard_deviation: float,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EvaluationComparisonRequest(InsightRequest, discriminator="EvaluationComparison"):
    """Evaluation Comparison Request.

    :ivar type: The type of request. Required. Evaluation Comparison.
    :vartype type: str or ~azure.ai.projects.models.EVALUATION_COMPARISON
    :ivar eval_id: Identifier for the evaluation. Required.
    :vartype eval_id: str
    :ivar baseline_run_id: The baseline run ID for comparison. Required.
    :vartype baseline_run_id: str
    :ivar treatment_run_ids: List of treatment run IDs for comparison. Required.
    :vartype treatment_run_ids: list[str]
    """

    type: Literal[InsightType.EVALUATION_COMPARISON] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of request. Required. Evaluation Comparison."""
    eval_id: str = rest_field(name="evalId", visibility=["read", "create", "update", "delete", "query"])
    """Identifier for the evaluation. Required."""
    baseline_run_id: str = rest_field(name="baselineRunId", visibility=["read", "create", "update", "delete", "query"])
    """The baseline run ID for comparison. Required."""
    treatment_run_ids: list[str] = rest_field(
        name="treatmentRunIds", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of treatment run IDs for comparison. Required."""

    @overload
    def __init__(
        self,
        *,
        eval_id: str,
        baseline_run_id: str,
        treatment_run_ids: list[str],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = InsightType.EVALUATION_COMPARISON  # type: ignore


class InsightSample(_Model):
    """A sample from the analysis.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    EvaluationResultSample

    :ivar id: The unique identifier for the analysis sample. Required.
    :vartype id: str
    :ivar type: Sample type. Required. "EvaluationResultSample"
    :vartype type: str or ~azure.ai.projects.models.SampleType
    :ivar features: Features to help with additional filtering of data in UX. Required.
    :vartype features: dict[str, any]
    :ivar correlation_info: Info about the correlation for the analysis sample. Required.
    :vartype correlation_info: dict[str, any]
    """

    __mapping__: dict[str, _Model] = {}
    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique identifier for the analysis sample. Required."""
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Sample type. Required. \"EvaluationResultSample\""""
    features: dict[str, Any] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Features to help with additional filtering of data in UX. Required."""
    correlation_info: dict[str, Any] = rest_field(
        name="correlationInfo", visibility=["read", "create", "update", "delete", "query"]
    )
    """Info about the correlation for the analysis sample. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        type: str,
        features: dict[str, Any],
        correlation_info: dict[str, Any],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EvaluationResultSample(InsightSample, discriminator="EvaluationResultSample"):
    """A sample from the evaluation result.

    :ivar id: The unique identifier for the analysis sample. Required.
    :vartype id: str
    :ivar features: Features to help with additional filtering of data in UX. Required.
    :vartype features: dict[str, any]
    :ivar correlation_info: Info about the correlation for the analysis sample. Required.
    :vartype correlation_info: dict[str, any]
    :ivar type: Evaluation Result Sample Type. Required. A sample from the evaluation result.
    :vartype type: str or ~azure.ai.projects.models.EVALUATION_RESULT_SAMPLE
    :ivar evaluation_result: Evaluation result for the analysis sample. Required.
    :vartype evaluation_result: ~azure.ai.projects.models.EvalResult
    """

    type: Literal[SampleType.EVALUATION_RESULT_SAMPLE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Evaluation Result Sample Type. Required. A sample from the evaluation result."""
    evaluation_result: "_models.EvalResult" = rest_field(
        name="evaluationResult", visibility=["read", "create", "update", "delete", "query"]
    )
    """Evaluation result for the analysis sample. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        features: dict[str, Any],
        correlation_info: dict[str, Any],
        evaluation_result: "_models.EvalResult",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = SampleType.EVALUATION_RESULT_SAMPLE  # type: ignore


class EvaluationRule(_Model):
    """Evaluation rule model.

    :ivar id: Unique identifier for the evaluation rule. Required.
    :vartype id: str
    :ivar display_name: Display Name for the evaluation rule.
    :vartype display_name: str
    :ivar description: Description for the evaluation rule.
    :vartype description: str
    :ivar action: Definition of the evaluation rule action. Required.
    :vartype action: ~azure.ai.projects.models.EvaluationRuleAction
    :ivar filter: Filter condition of the evaluation rule.
    :vartype filter: ~azure.ai.projects.models.EvaluationRuleFilter
    :ivar event_type: Event type that the evaluation rule applies to. Required. Known values are:
     "response.completed" and "manual".
    :vartype event_type: str or ~azure.ai.projects.models.EvaluationRuleEventType
    :ivar enabled: Indicates whether the evaluation rule is enabled. Default is true. Required.
    :vartype enabled: bool
    :ivar system_data: System metadata for the evaluation rule. Required.
    :vartype system_data: dict[str, str]
    """

    id: str = rest_field(visibility=["read"])
    """Unique identifier for the evaluation rule. Required."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Display Name for the evaluation rule."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Description for the evaluation rule."""
    action: "_models.EvaluationRuleAction" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Definition of the evaluation rule action. Required."""
    filter: Optional["_models.EvaluationRuleFilter"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Filter condition of the evaluation rule."""
    event_type: Union[str, "_models.EvaluationRuleEventType"] = rest_field(
        name="eventType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Event type that the evaluation rule applies to. Required. Known values are:
     \"response.completed\" and \"manual\"."""
    enabled: bool = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Indicates whether the evaluation rule is enabled. Default is true. Required."""
    system_data: dict[str, str] = rest_field(name="systemData", visibility=["read"])
    """System metadata for the evaluation rule. Required."""

    @overload
    def __init__(
        self,
        *,
        action: "_models.EvaluationRuleAction",
        event_type: Union[str, "_models.EvaluationRuleEventType"],
        enabled: bool,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        filter: Optional["_models.EvaluationRuleFilter"] = None,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EvaluationRuleFilter(_Model):
    """Evaluation filter model.

    :ivar agent_name: Filter by agent name. Required.
    :vartype agent_name: str
    """

    agent_name: str = rest_field(name="agentName", visibility=["read", "create", "update", "delete", "query"])
    """Filter by agent name. Required."""

    @overload
    def __init__(
        self,
        *,
        agent_name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EvaluationRunClusterInsightResult(InsightResult, discriminator="EvaluationRunClusterInsight"):
    """Insights from the evaluation run cluster analysis.

    :ivar type: The type of insights result. Required. Insights on an Evaluation run result.
    :vartype type: str or ~azure.ai.projects.models.EVALUATION_RUN_CLUSTER_INSIGHT
    :ivar cluster_insight: Required.
    :vartype cluster_insight: ~azure.ai.projects.models.ClusterInsightResult
    """

    type: Literal[InsightType.EVALUATION_RUN_CLUSTER_INSIGHT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of insights result. Required. Insights on an Evaluation run result."""
    cluster_insight: "_models.ClusterInsightResult" = rest_field(
        name="clusterInsight", visibility=["read", "create", "update", "delete", "query"]
    )
    """Required."""

    @overload
    def __init__(
        self,
        *,
        cluster_insight: "_models.ClusterInsightResult",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = InsightType.EVALUATION_RUN_CLUSTER_INSIGHT  # type: ignore


class EvaluationRunClusterInsightsRequest(InsightRequest, discriminator="EvaluationRunClusterInsight"):
    """Insights on set of Evaluation Results.

    :ivar type: The type of insights request. Required. Insights on an Evaluation run result.
    :vartype type: str or ~azure.ai.projects.models.EVALUATION_RUN_CLUSTER_INSIGHT
    :ivar eval_id: Evaluation Id for the insights. Required.
    :vartype eval_id: str
    :ivar run_ids: List of evaluation run IDs for the insights. Required.
    :vartype run_ids: list[str]
    :ivar model_configuration: Configuration of the model used in the insight generation.
    :vartype model_configuration: ~azure.ai.projects.models.InsightModelConfiguration
    """

    type: Literal[InsightType.EVALUATION_RUN_CLUSTER_INSIGHT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of insights request. Required. Insights on an Evaluation run result."""
    eval_id: str = rest_field(name="evalId", visibility=["read", "create", "update", "delete", "query"])
    """Evaluation Id for the insights. Required."""
    run_ids: list[str] = rest_field(name="runIds", visibility=["read", "create", "update", "delete", "query"])
    """List of evaluation run IDs for the insights. Required."""
    model_configuration: Optional["_models.InsightModelConfiguration"] = rest_field(
        name="modelConfiguration", visibility=["read", "create", "update", "delete", "query"]
    )
    """Configuration of the model used in the insight generation."""

    @overload
    def __init__(
        self,
        *,
        eval_id: str,
        run_ids: list[str],
        model_configuration: Optional["_models.InsightModelConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = InsightType.EVALUATION_RUN_CLUSTER_INSIGHT  # type: ignore


class ScheduleTask(_Model):
    """Schedule task model.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    EvaluationScheduleTask, InsightScheduleTask

    :ivar type: Type of the task. Required. Known values are: "Evaluation" and "Insight".
    :vartype type: str or ~azure.ai.projects.models.ScheduleTaskType
    :ivar configuration: Configuration for the task.
    :vartype configuration: dict[str, str]
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Type of the task. Required. Known values are: \"Evaluation\" and \"Insight\"."""
    configuration: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Configuration for the task."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        configuration: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EvaluationScheduleTask(ScheduleTask, discriminator="Evaluation"):
    """Evaluation task for the schedule.

    :ivar configuration: Configuration for the task.
    :vartype configuration: dict[str, str]
    :ivar type: Required. Evaluation task.
    :vartype type: str or ~azure.ai.projects.models.EVALUATION
    :ivar eval_id: Identifier of the evaluation group. Required.
    :vartype eval_id: str
    :ivar eval_run: The evaluation run payload. Required.
    :vartype eval_run: any
    """

    type: Literal[ScheduleTaskType.EVALUATION] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Evaluation task."""
    eval_id: str = rest_field(name="evalId", visibility=["read", "create", "update", "delete", "query"])
    """Identifier of the evaluation group. Required."""
    eval_run: Any = rest_field(name="evalRun", visibility=["read", "create", "update", "delete", "query"])
    """The evaluation run payload. Required."""

    @overload
    def __init__(
        self,
        *,
        eval_id: str,
        eval_run: Any,
        configuration: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ScheduleTaskType.EVALUATION  # type: ignore


class EvaluationTaxonomy(_Model):
    """Evaluation Taxonomy Definition.

    :ivar id: Asset ID, a unique identifier for the asset.
    :vartype id: str
    :ivar name: The name of the resource. Required.
    :vartype name: str
    :ivar version: The version of the resource. Required.
    :vartype version: str
    :ivar description: The asset description text.
    :vartype description: str
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar taxonomy_input: Input configuration for the evaluation taxonomy. Required.
    :vartype taxonomy_input: ~azure.ai.projects.models.EvaluationTaxonomyInput
    :ivar taxonomy_categories: List of taxonomy categories.
    :vartype taxonomy_categories: list[~azure.ai.projects.models.TaxonomyCategory]
    :ivar properties: Additional properties for the evaluation taxonomy.
    :vartype properties: dict[str, str]
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Asset ID, a unique identifier for the asset."""
    name: str = rest_field(visibility=["read"])
    """The name of the resource. Required."""
    version: str = rest_field(visibility=["read"])
    """The version of the resource. Required."""
    description: Optional[str] = rest_field(visibility=["create", "update"])
    """The asset description text."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["create", "update"])
    """Tag dictionary. Tags can be added, removed, and updated."""
    taxonomy_input: "_models.EvaluationTaxonomyInput" = rest_field(
        name="taxonomyInput", visibility=["read", "create", "update", "delete", "query"]
    )
    """Input configuration for the evaluation taxonomy. Required."""
    taxonomy_categories: Optional[list["_models.TaxonomyCategory"]] = rest_field(
        name="taxonomyCategories", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of taxonomy categories."""
    properties: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Additional properties for the evaluation taxonomy."""

    @overload
    def __init__(
        self,
        *,
        taxonomy_input: "_models.EvaluationTaxonomyInput",
        description: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        taxonomy_categories: Optional[list["_models.TaxonomyCategory"]] = None,
        properties: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EvaluatorMetric(_Model):
    """Evaluator Metric.

    :ivar type: Type of the metric. Known values are: "ordinal", "continuous", and "boolean".
    :vartype type: str or ~azure.ai.projects.models.EvaluatorMetricType
    :ivar desirable_direction: It indicates whether a higher value is better or a lower value is
     better for this metric. Known values are: "increase", "decrease", and "neutral".
    :vartype desirable_direction: str or ~azure.ai.projects.models.EvaluatorMetricDirection
    :ivar min_value: Minimum value for the metric.
    :vartype min_value: float
    :ivar max_value: Maximum value for the metric. If not specified, it is assumed to be unbounded.
    :vartype max_value: float
    :ivar is_primary: Indicates if this metric is primary when there are multiple metrics.
    :vartype is_primary: bool
    """

    type: Optional[Union[str, "_models.EvaluatorMetricType"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of the metric. Known values are: \"ordinal\", \"continuous\", and \"boolean\"."""
    desirable_direction: Optional[Union[str, "_models.EvaluatorMetricDirection"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """It indicates whether a higher value is better or a lower value is better for this metric. Known
     values are: \"increase\", \"decrease\", and \"neutral\"."""
    min_value: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Minimum value for the metric."""
    max_value: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Maximum value for the metric. If not specified, it is assumed to be unbounded."""
    is_primary: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Indicates if this metric is primary when there are multiple metrics."""

    @overload
    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.EvaluatorMetricType"]] = None,
        desirable_direction: Optional[Union[str, "_models.EvaluatorMetricDirection"]] = None,
        min_value: Optional[float] = None,
        max_value: Optional[float] = None,
        is_primary: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class EvaluatorVersion(_Model):
    """Evaluator Definition.

    :ivar display_name: Display Name for evaluator. It helps to find the evaluator easily in AI
     Foundry. It does not need to be unique.
    :vartype display_name: str
    :ivar metadata: Metadata about the evaluator.
    :vartype metadata: dict[str, str]
    :ivar evaluator_type: The type of the evaluator. Required. Known values are: "builtin" and
     "custom".
    :vartype evaluator_type: str or ~azure.ai.projects.models.EvaluatorType
    :ivar categories: The categories of the evaluator. Required.
    :vartype categories: list[str or ~azure.ai.projects.models.EvaluatorCategory]
    :ivar definition: Definition of the evaluator. Required.
    :vartype definition: ~azure.ai.projects.models.EvaluatorDefinition
    :ivar created_by: Creator of the evaluator. Required.
    :vartype created_by: str
    :ivar created_at: Creation date/time of the evaluator. Required.
    :vartype created_at: int
    :ivar modified_at: Last modified date/time of the evaluator. Required.
    :vartype modified_at: int
    :ivar id: Asset ID, a unique identifier for the asset.
    :vartype id: str
    :ivar name: The name of the resource. Required.
    :vartype name: str
    :ivar version: The version of the resource. Required.
    :vartype version: str
    :ivar description: The asset description text.
    :vartype description: str
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    """

    display_name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Display Name for evaluator. It helps to find the evaluator easily in AI Foundry. It does not
     need to be unique."""
    metadata: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Metadata about the evaluator."""
    evaluator_type: Union[str, "_models.EvaluatorType"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of the evaluator. Required. Known values are: \"builtin\" and \"custom\"."""
    categories: list[Union[str, "_models.EvaluatorCategory"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The categories of the evaluator. Required."""
    definition: "_models.EvaluatorDefinition" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Definition of the evaluator. Required."""
    created_by: str = rest_field(visibility=["read"])
    """Creator of the evaluator. Required."""
    created_at: int = rest_field(visibility=["read"])
    """Creation date/time of the evaluator. Required."""
    modified_at: int = rest_field(visibility=["read"])
    """Last modified date/time of the evaluator. Required."""
    id: Optional[str] = rest_field(visibility=["read"])
    """Asset ID, a unique identifier for the asset."""
    name: str = rest_field(visibility=["read"])
    """The name of the resource. Required."""
    version: str = rest_field(visibility=["read"])
    """The version of the resource. Required."""
    description: Optional[str] = rest_field(visibility=["create", "update"])
    """The asset description text."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["create", "update"])
    """Tag dictionary. Tags can be added, removed, and updated."""

    @overload
    def __init__(
        self,
        *,
        evaluator_type: Union[str, "_models.EvaluatorType"],
        categories: list[Union[str, "_models.EvaluatorCategory"]],
        definition: "_models.EvaluatorDefinition",
        display_name: Optional[str] = None,
        metadata: Optional[dict[str, str]] = None,
        description: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FabricDataAgentToolParameters(_Model):
    """The fabric data agent tool parameters.

       :ivar project_connections: The project connections attached to this tool. There can be a
        maximum of 1 connection
    resource attached to the tool.
       :vartype project_connections: list[~azure.ai.projects.models.ToolProjectConnection]
    """

    project_connections: Optional[list["_models.ToolProjectConnection"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The project connections attached to this tool. There can be a maximum of 1 connection
 resource attached to the tool."""

    @overload
    def __init__(
        self,
        *,
        project_connections: Optional[list["_models.ToolProjectConnection"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FieldMapping(_Model):
    """Field mapping configuration class.

    :ivar content_fields: List of fields with text content. Required.
    :vartype content_fields: list[str]
    :ivar filepath_field: Path of file to be used as a source of text content.
    :vartype filepath_field: str
    :ivar title_field: Field containing the title of the document.
    :vartype title_field: str
    :ivar url_field: Field containing the url of the document.
    :vartype url_field: str
    :ivar vector_fields: List of fields with vector content.
    :vartype vector_fields: list[str]
    :ivar metadata_fields: List of fields with metadata content.
    :vartype metadata_fields: list[str]
    """

    content_fields: list[str] = rest_field(name="contentFields", visibility=["create"])
    """List of fields with text content. Required."""
    filepath_field: Optional[str] = rest_field(name="filepathField", visibility=["create"])
    """Path of file to be used as a source of text content."""
    title_field: Optional[str] = rest_field(name="titleField", visibility=["create"])
    """Field containing the title of the document."""
    url_field: Optional[str] = rest_field(name="urlField", visibility=["create"])
    """Field containing the url of the document."""
    vector_fields: Optional[list[str]] = rest_field(name="vectorFields", visibility=["create"])
    """List of fields with vector content."""
    metadata_fields: Optional[list[str]] = rest_field(name="metadataFields", visibility=["create"])
    """List of fields with metadata content."""

    @overload
    def __init__(
        self,
        *,
        content_fields: list[str],
        filepath_field: Optional[str] = None,
        title_field: Optional[str] = None,
        url_field: Optional[str] = None,
        vector_fields: Optional[list[str]] = None,
        metadata_fields: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FileDatasetVersion(DatasetVersion, discriminator="uri_file"):
    """FileDatasetVersion Definition.

    :ivar data_uri: URI of the data. Example: `https://go.microsoft.com/fwlink/?linkid=2202330
     <https://go.microsoft.com/fwlink/?linkid=2202330>`_. Required.
    :vartype data_uri: str
    :ivar is_reference: Indicates if the dataset holds a reference to the storage, or the dataset
     manages storage itself. If true, the underlying data will not be deleted when the dataset
     version is deleted.
    :vartype is_reference: bool
    :ivar connection_name: The Azure Storage Account connection name. Required if
     startPendingUploadVersion was not called before creating the Dataset.
    :vartype connection_name: str
    :ivar id: Asset ID, a unique identifier for the asset.
    :vartype id: str
    :ivar name: The name of the resource. Required.
    :vartype name: str
    :ivar version: The version of the resource. Required.
    :vartype version: str
    :ivar description: The asset description text.
    :vartype description: str
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar type: Dataset type. Required. URI file.
    :vartype type: str or ~azure.ai.projects.models.URI_FILE
    """

    type: Literal[DatasetType.URI_FILE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Dataset type. Required. URI file."""

    @overload
    def __init__(
        self,
        *,
        data_uri: str,
        connection_name: Optional[str] = None,
        description: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = DatasetType.URI_FILE  # type: ignore


class FileSearchTool(Tool, discriminator="file_search"):
    """A tool that searches for relevant content from uploaded files. Learn more about the `file
    search tool <https://platform.openai.com/docs/guides/tools-file-search>`_.

    :ivar type: The type of the file search tool. Always ``file_search``. Required.
    :vartype type: str or ~azure.ai.projects.models.FILE_SEARCH
    :ivar vector_store_ids: The IDs of the vector stores to search. Required.
    :vartype vector_store_ids: list[str]
    :ivar max_num_results: The maximum number of results to return. This number should be between 1
     and 50 inclusive.
    :vartype max_num_results: int
    :ivar ranking_options: Ranking options for search.
    :vartype ranking_options: ~azure.ai.projects.models.RankingOptions
    :ivar filters: A filter to apply. Is either a ComparisonFilter type or a CompoundFilter type.
    :vartype filters: ~azure.ai.projects.models.ComparisonFilter or
     ~azure.ai.projects.models.CompoundFilter
    """

    type: Literal[ToolType.FILE_SEARCH] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the file search tool. Always ``file_search``. Required."""
    vector_store_ids: list[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The IDs of the vector stores to search. Required."""
    max_num_results: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The maximum number of results to return. This number should be between 1 and 50 inclusive."""
    ranking_options: Optional["_models.RankingOptions"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Ranking options for search."""
    filters: Optional[Union["_models.ComparisonFilter", "_models.CompoundFilter"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A filter to apply. Is either a ComparisonFilter type or a CompoundFilter type."""

    @overload
    def __init__(
        self,
        *,
        vector_store_ids: list[str],
        max_num_results: Optional[int] = None,
        ranking_options: Optional["_models.RankingOptions"] = None,
        filters: Optional[Union["_models.ComparisonFilter", "_models.CompoundFilter"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ToolType.FILE_SEARCH  # type: ignore


class FileSearchToolCallItemParam(ItemParam, discriminator="file_search_call"):
    """The results of a file search tool call. See the
    `file search guide </docs/guides/tools-file-search>`_ for more information.

        :ivar type: Required.
        :vartype type: str or ~azure.ai.projects.models.FILE_SEARCH_CALL
        :ivar queries: The queries used to search for files. Required.
        :vartype queries: list[str]
        :ivar results: The results of the file search tool call.
        :vartype results: list[~azure.ai.projects.models.FileSearchToolCallItemParamResult]
    """

    type: Literal[ItemType.FILE_SEARCH_CALL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    queries: list[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The queries used to search for files. Required."""
    results: Optional[list["_models.FileSearchToolCallItemParamResult"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The results of the file search tool call."""

    @overload
    def __init__(
        self,
        *,
        queries: list[str],
        results: Optional[list["_models.FileSearchToolCallItemParamResult"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.FILE_SEARCH_CALL  # type: ignore


class FileSearchToolCallItemParamResult(_Model):
    """FileSearchToolCallItemParamResult.

    :ivar file_id: The unique ID of the file.
    :vartype file_id: str
    :ivar text: The text that was retrieved from the file.
    :vartype text: str
    :ivar filename: The name of the file.
    :vartype filename: str
    :ivar attributes:
    :vartype attributes: ~azure.ai.projects.models.VectorStoreFileAttributes
    :ivar score: The relevance score of the file - a value between 0 and 1.
    :vartype score: float
    """

    file_id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique ID of the file."""
    text: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The text that was retrieved from the file."""
    filename: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the file."""
    attributes: Optional["_models.VectorStoreFileAttributes"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    score: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The relevance score of the file - a value between 0 and 1."""

    @overload
    def __init__(
        self,
        *,
        file_id: Optional[str] = None,
        text: Optional[str] = None,
        filename: Optional[str] = None,
        attributes: Optional["_models.VectorStoreFileAttributes"] = None,
        score: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FileSearchToolCallItemResource(ItemResource, discriminator="file_search_call"):
    """The results of a file search tool call. See the
    `file search guide </docs/guides/tools-file-search>`_ for more information.

        :ivar id: Required.
        :vartype id: str
        :ivar created_by: The information about the creator of the item.
        :vartype created_by: ~azure.ai.projects.models.CreatedBy
        :ivar type: Required.
        :vartype type: str or ~azure.ai.projects.models.FILE_SEARCH_CALL
        :ivar status: The status of the file search tool call. One of ``in_progress``,
     ``searching``, ``incomplete`` or ``failed``,. Required. Is one of the following types:
         Literal["in_progress"], Literal["searching"], Literal["completed"], Literal["incomplete"],
         Literal["failed"]
        :vartype status: str or str or str or str or str
        :ivar queries: The queries used to search for files. Required.
        :vartype queries: list[str]
        :ivar results: The results of the file search tool call.
        :vartype results: list[~azure.ai.projects.models.FileSearchToolCallItemParamResult]
    """

    type: Literal[ItemType.FILE_SEARCH_CALL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    status: Literal["in_progress", "searching", "completed", "incomplete", "failed"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The status of the file search tool call. One of ``in_progress``,
 ``searching``, ``incomplete`` or ``failed``,. Required. Is one of the following types:
     Literal[\"in_progress\"], Literal[\"searching\"], Literal[\"completed\"],
     Literal[\"incomplete\"], Literal[\"failed\"]"""
    queries: list[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The queries used to search for files. Required."""
    results: Optional[list["_models.FileSearchToolCallItemParamResult"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The results of the file search tool call."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        status: Literal["in_progress", "searching", "completed", "incomplete", "failed"],
        queries: list[str],
        created_by: Optional["_models.CreatedBy"] = None,
        results: Optional[list["_models.FileSearchToolCallItemParamResult"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.FILE_SEARCH_CALL  # type: ignore


class FolderDatasetVersion(DatasetVersion, discriminator="uri_folder"):
    """FileDatasetVersion Definition.

    :ivar data_uri: URI of the data. Example: `https://go.microsoft.com/fwlink/?linkid=2202330
     <https://go.microsoft.com/fwlink/?linkid=2202330>`_. Required.
    :vartype data_uri: str
    :ivar is_reference: Indicates if the dataset holds a reference to the storage, or the dataset
     manages storage itself. If true, the underlying data will not be deleted when the dataset
     version is deleted.
    :vartype is_reference: bool
    :ivar connection_name: The Azure Storage Account connection name. Required if
     startPendingUploadVersion was not called before creating the Dataset.
    :vartype connection_name: str
    :ivar id: Asset ID, a unique identifier for the asset.
    :vartype id: str
    :ivar name: The name of the resource. Required.
    :vartype name: str
    :ivar version: The version of the resource. Required.
    :vartype version: str
    :ivar description: The asset description text.
    :vartype description: str
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar type: Dataset type. Required. URI folder.
    :vartype type: str or ~azure.ai.projects.models.URI_FOLDER
    """

    type: Literal[DatasetType.URI_FOLDER] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Dataset type. Required. URI folder."""

    @overload
    def __init__(
        self,
        *,
        data_uri: str,
        connection_name: Optional[str] = None,
        description: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = DatasetType.URI_FOLDER  # type: ignore


class FunctionTool(Tool, discriminator="function"):
    """Defines a function in your own code the model can choose to call. Learn more about `function
    calling <https://platform.openai.com/docs/guides/function-calling>`_.

    :ivar type: The type of the function tool. Always ``function``. Required.
    :vartype type: str or ~azure.ai.projects.models.FUNCTION
    :ivar name: The name of the function to call. Required.
    :vartype name: str
    :ivar description: A description of the function. Used by the model to determine whether or not
     to call the function.
    :vartype description: str
    :ivar parameters: A JSON schema object describing the parameters of the function. Required.
    :vartype parameters: any
    :ivar strict: Whether to enforce strict parameter validation. Default ``true``. Required.
    :vartype strict: bool
    """

    type: Literal[ToolType.FUNCTION] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the function tool. Always ``function``. Required."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the function to call. Required."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A description of the function. Used by the model to determine whether or not to call the
     function."""
    parameters: Any = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A JSON schema object describing the parameters of the function. Required."""
    strict: bool = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Whether to enforce strict parameter validation. Default ``true``. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        parameters: Any,
        strict: bool,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ToolType.FUNCTION  # type: ignore


class FunctionToolCallItemParam(ItemParam, discriminator="function_call"):
    """A tool call to run a function. See the
    `function calling guide </docs/guides/function-calling>`_ for more information.

        :ivar type: Required.
        :vartype type: str or ~azure.ai.projects.models.FUNCTION_CALL
        :ivar call_id: The unique ID of the function tool call generated by the model. Required.
        :vartype call_id: str
        :ivar name: The name of the function to run. Required.
        :vartype name: str
        :ivar arguments: A JSON string of the arguments to pass to the function. Required.
        :vartype arguments: str
    """

    type: Literal[ItemType.FUNCTION_CALL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    call_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique ID of the function tool call generated by the model. Required."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the function to run. Required."""
    arguments: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A JSON string of the arguments to pass to the function. Required."""

    @overload
    def __init__(
        self,
        *,
        call_id: str,
        name: str,
        arguments: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.FUNCTION_CALL  # type: ignore


class FunctionToolCallItemResource(ItemResource, discriminator="function_call"):
    """A tool call to run a function. See the
    `function calling guide </docs/guides/function-calling>`_ for more information.

        :ivar id: Required.
        :vartype id: str
        :ivar created_by: The information about the creator of the item.
        :vartype created_by: ~azure.ai.projects.models.CreatedBy
        :ivar type: Required.
        :vartype type: str or ~azure.ai.projects.models.FUNCTION_CALL
        :ivar status: The status of the item. One of ``in_progress``, ``completed``, or
     ``incomplete``. Populated when items are returned via API. Required. Is one of the following
         types: Literal["in_progress"], Literal["completed"], Literal["incomplete"]
        :vartype status: str or str or str
        :ivar call_id: The unique ID of the function tool call generated by the model. Required.
        :vartype call_id: str
        :ivar name: The name of the function to run. Required.
        :vartype name: str
        :ivar arguments: A JSON string of the arguments to pass to the function. Required.
        :vartype arguments: str
    """

    type: Literal[ItemType.FUNCTION_CALL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    status: Literal["in_progress", "completed", "incomplete"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The status of the item. One of ``in_progress``, ``completed``, or
 ``incomplete``. Populated when items are returned via API. Required. Is one of the following
     types: Literal[\"in_progress\"], Literal[\"completed\"], Literal[\"incomplete\"]"""
    call_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique ID of the function tool call generated by the model. Required."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the function to run. Required."""
    arguments: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A JSON string of the arguments to pass to the function. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        status: Literal["in_progress", "completed", "incomplete"],
        call_id: str,
        name: str,
        arguments: str,
        created_by: Optional["_models.CreatedBy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.FUNCTION_CALL  # type: ignore


class FunctionToolCallOutputItemParam(ItemParam, discriminator="function_call_output"):
    """The output of a function tool call.

    :ivar type: Required.
    :vartype type: str or ~azure.ai.projects.models.FUNCTION_CALL_OUTPUT
    :ivar call_id: The unique ID of the function tool call generated by the model. Required.
    :vartype call_id: str
    :ivar output: A JSON string of the output of the function tool call. Required.
    :vartype output: str
    """

    type: Literal[ItemType.FUNCTION_CALL_OUTPUT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    call_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique ID of the function tool call generated by the model. Required."""
    output: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A JSON string of the output of the function tool call. Required."""

    @overload
    def __init__(
        self,
        *,
        call_id: str,
        output: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.FUNCTION_CALL_OUTPUT  # type: ignore


class FunctionToolCallOutputItemResource(ItemResource, discriminator="function_call_output"):
    """The output of a function tool call.

       :ivar id: Required.
       :vartype id: str
       :ivar created_by: The information about the creator of the item.
       :vartype created_by: ~azure.ai.projects.models.CreatedBy
       :ivar type: Required.
       :vartype type: str or ~azure.ai.projects.models.FUNCTION_CALL_OUTPUT
       :ivar status: The status of the item. One of ``in_progress``, ``completed``, or
    ``incomplete``. Populated when items are returned via API. Required. Is one of the following
        types: Literal["in_progress"], Literal["completed"], Literal["incomplete"]
       :vartype status: str or str or str
       :ivar call_id: The unique ID of the function tool call generated by the model. Required.
       :vartype call_id: str
       :ivar output: A JSON string of the output of the function tool call. Required.
       :vartype output: str
    """

    type: Literal[ItemType.FUNCTION_CALL_OUTPUT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    status: Literal["in_progress", "completed", "incomplete"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The status of the item. One of ``in_progress``, ``completed``, or
 ``incomplete``. Populated when items are returned via API. Required. Is one of the following
     types: Literal[\"in_progress\"], Literal[\"completed\"], Literal[\"incomplete\"]"""
    call_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique ID of the function tool call generated by the model. Required."""
    output: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A JSON string of the output of the function tool call. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        status: Literal["in_progress", "completed", "incomplete"],
        call_id: str,
        output: str,
        created_by: Optional["_models.CreatedBy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.FUNCTION_CALL_OUTPUT  # type: ignore


class HostedAgentDefinition(AgentDefinition, discriminator="hosted"):
    """The hosted agent definition.

       You probably want to use the sub-classes and not this class directly. Known sub-classes are:
       ImageBasedHostedAgentDefinition

       :ivar rai_config: Configuration for Responsible AI (RAI) content filtering and safety features.
       :vartype rai_config: ~azure.ai.projects.models.RaiConfig
       :ivar kind: Required.
       :vartype kind: str or ~azure.ai.projects.models.HOSTED
       :ivar tools: An array of tools the hosted agent's model may call while generating a response.
        You
    can specify which tool to use by setting the ``tool_choice`` parameter.
       :vartype tools: list[~azure.ai.projects.models.Tool]
       :ivar container_protocol_versions: The protocols that the agent supports for ingress
        communication of the containers. Required.
       :vartype container_protocol_versions: list[~azure.ai.projects.models.ProtocolVersionRecord]
       :ivar cpu: The CPU configuration for the hosted agent. Required.
       :vartype cpu: str
       :ivar memory: The memory configuration for the hosted agent. Required.
       :vartype memory: str
       :ivar environment_variables: Environment variables to set in the hosted agent container.
       :vartype environment_variables: dict[str, str]
    """

    __mapping__: dict[str, _Model] = {}
    kind: Literal[AgentKind.HOSTED] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    tools: Optional[list["_models.Tool"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An array of tools the hosted agent's model may call while generating a response. You
 can specify which tool to use by setting the ``tool_choice`` parameter."""
    container_protocol_versions: list["_models.ProtocolVersionRecord"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The protocols that the agent supports for ingress communication of the containers. Required."""
    cpu: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The CPU configuration for the hosted agent. Required."""
    memory: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The memory configuration for the hosted agent. Required."""
    environment_variables: Optional[dict[str, str]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Environment variables to set in the hosted agent container."""

    @overload
    def __init__(
        self,
        *,
        container_protocol_versions: list["_models.ProtocolVersionRecord"],
        cpu: str,
        memory: str,
        rai_config: Optional["_models.RaiConfig"] = None,
        tools: Optional[list["_models.Tool"]] = None,
        environment_variables: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = AgentKind.HOSTED  # type: ignore


class HourlyRecurrenceSchedule(RecurrenceSchedule, discriminator="Hourly"):
    """Hourly recurrence schedule.

    :ivar type: Required. Hourly recurrence pattern.
    :vartype type: str or ~azure.ai.projects.models.HOURLY
    """

    type: Literal[RecurrenceType.HOURLY] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Hourly recurrence pattern."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = RecurrenceType.HOURLY  # type: ignore


class HumanEvaluationRuleAction(EvaluationRuleAction, discriminator="humanEvaluation"):
    """Evaluation rule action for human evaluation.

    :ivar type: Required. Human evaluation.
    :vartype type: str or ~azure.ai.projects.models.HUMAN_EVALUATION
    :ivar template_id: Human evaluation template Id. Required.
    :vartype template_id: str
    """

    type: Literal[EvaluationRuleActionType.HUMAN_EVALUATION] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Human evaluation."""
    template_id: str = rest_field(name="templateId", visibility=["read", "create", "update", "delete", "query"])
    """Human evaluation template Id. Required."""

    @overload
    def __init__(
        self,
        *,
        template_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = EvaluationRuleActionType.HUMAN_EVALUATION  # type: ignore


class ImageBasedHostedAgentDefinition(HostedAgentDefinition, discriminator="hosted"):
    """The image-based deployment definition for a hosted agent.

       :ivar rai_config: Configuration for Responsible AI (RAI) content filtering and safety features.
       :vartype rai_config: ~azure.ai.projects.models.RaiConfig
       :ivar tools: An array of tools the hosted agent's model may call while generating a response.
        You
    can specify which tool to use by setting the ``tool_choice`` parameter.
       :vartype tools: list[~azure.ai.projects.models.Tool]
       :ivar container_protocol_versions: The protocols that the agent supports for ingress
        communication of the containers. Required.
       :vartype container_protocol_versions: list[~azure.ai.projects.models.ProtocolVersionRecord]
       :ivar cpu: The CPU configuration for the hosted agent. Required.
       :vartype cpu: str
       :ivar memory: The memory configuration for the hosted agent. Required.
       :vartype memory: str
       :ivar environment_variables: Environment variables to set in the hosted agent container.
       :vartype environment_variables: dict[str, str]
       :ivar kind: Required.
       :vartype kind: str or ~azure.ai.projects.models.HOSTED
       :ivar image: The image for the hosted agent. Required.
       :vartype image: str
    """

    image: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The image for the hosted agent. Required."""

    @overload
    def __init__(
        self,
        *,
        container_protocol_versions: list["_models.ProtocolVersionRecord"],
        cpu: str,
        memory: str,
        image: str,
        rai_config: Optional["_models.RaiConfig"] = None,
        tools: Optional[list["_models.Tool"]] = None,
        environment_variables: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ImageGenTool(Tool, discriminator="image_generation"):
    """A tool that generates images using a model like ``gpt-image-1``.

       :ivar type: The type of the image generation tool. Always ``image_generation``. Required.
       :vartype type: str or ~azure.ai.projects.models.IMAGE_GENERATION
       :ivar model: The image generation model to use. Default: ``gpt-image-1``. Default value is
        "gpt-image-1".
       :vartype model: str
       :ivar quality: The quality of the generated image. One of ``low``, ``medium``, ``high``,
    or ``auto``. Default: ``auto``. Is one of the following types: Literal["low"],
        Literal["medium"], Literal["high"], Literal["auto"]
       :vartype quality: str or str or str or str
       :ivar size: The size of the generated image. One of ``1024x1024``, ``1024x1536``,
    ``1536x1024``, or ``auto``. Default: ``auto``. Is one of the following types:
        Literal["1024x1024"], Literal["1024x1536"], Literal["1536x1024"], Literal["auto"]
       :vartype size: str or str or str or str
       :ivar output_format: The output format of the generated image. One of ``png``, ``webp``, or
    ``jpeg``. Default: ``png``. Is one of the following types: Literal["png"], Literal["webp"],
        Literal["jpeg"]
       :vartype output_format: str or str or str
       :ivar output_compression: Compression level for the output image. Default: 100.
       :vartype output_compression: int
       :ivar moderation: Moderation level for the generated image. Default: ``auto``. Is either a
        Literal["auto"] type or a Literal["low"] type.
       :vartype moderation: str or str
       :ivar background: Background type for the generated image. One of ``transparent``,
    ``opaque``, or ``auto``. Default: ``auto``. Is one of the following types:
        Literal["transparent"], Literal["opaque"], Literal["auto"]
       :vartype background: str or str or str
       :ivar input_image_mask: Optional mask for inpainting. Contains ``image_url``
    (string, optional) and ``file_id`` (string, optional).
       :vartype input_image_mask: ~azure.ai.projects.models.ImageGenToolInputImageMask
       :ivar partial_images: Number of partial images to generate in streaming mode, from 0 (default
        value) to 3.
       :vartype partial_images: int
    """

    type: Literal[ToolType.IMAGE_GENERATION] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the image generation tool. Always ``image_generation``. Required."""
    model: Optional[Literal["gpt-image-1"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The image generation model to use. Default: ``gpt-image-1``. Default value is \"gpt-image-1\"."""
    quality: Optional[Literal["low", "medium", "high", "auto"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The quality of the generated image. One of ``low``, ``medium``, ``high``,
 or ``auto``. Default: ``auto``. Is one of the following types: Literal[\"low\"],
     Literal[\"medium\"], Literal[\"high\"], Literal[\"auto\"]"""
    size: Optional[Literal["1024x1024", "1024x1536", "1536x1024", "auto"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The size of the generated image. One of ``1024x1024``, ``1024x1536``,
 ``1536x1024``, or ``auto``. Default: ``auto``. Is one of the following types:
     Literal[\"1024x1024\"], Literal[\"1024x1536\"], Literal[\"1536x1024\"], Literal[\"auto\"]"""
    output_format: Optional[Literal["png", "webp", "jpeg"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The output format of the generated image. One of ``png``, ``webp``, or
 ``jpeg``. Default: ``png``. Is one of the following types: Literal[\"png\"], Literal[\"webp\"],
     Literal[\"jpeg\"]"""
    output_compression: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Compression level for the output image. Default: 100."""
    moderation: Optional[Literal["auto", "low"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Moderation level for the generated image. Default: ``auto``. Is either a Literal[\"auto\"] type
     or a Literal[\"low\"] type."""
    background: Optional[Literal["transparent", "opaque", "auto"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Background type for the generated image. One of ``transparent``,
 ``opaque``, or ``auto``. Default: ``auto``. Is one of the following types:
     Literal[\"transparent\"], Literal[\"opaque\"], Literal[\"auto\"]"""
    input_image_mask: Optional["_models.ImageGenToolInputImageMask"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Optional mask for inpainting. Contains ``image_url``
 (string, optional) and ``file_id`` (string, optional)."""
    partial_images: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Number of partial images to generate in streaming mode, from 0 (default value) to 3."""

    @overload
    def __init__(
        self,
        *,
        model: Optional[Literal["gpt-image-1"]] = None,
        quality: Optional[Literal["low", "medium", "high", "auto"]] = None,
        size: Optional[Literal["1024x1024", "1024x1536", "1536x1024", "auto"]] = None,
        output_format: Optional[Literal["png", "webp", "jpeg"]] = None,
        output_compression: Optional[int] = None,
        moderation: Optional[Literal["auto", "low"]] = None,
        background: Optional[Literal["transparent", "opaque", "auto"]] = None,
        input_image_mask: Optional["_models.ImageGenToolInputImageMask"] = None,
        partial_images: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ToolType.IMAGE_GENERATION  # type: ignore


class ImageGenToolCallItemParam(ItemParam, discriminator="image_generation_call"):
    """An image generation request made by the model.

    :ivar type: Required.
    :vartype type: str or ~azure.ai.projects.models.IMAGE_GENERATION_CALL
    :ivar result: The generated image encoded in base64. Required.
    :vartype result: str
    """

    type: Literal[ItemType.IMAGE_GENERATION_CALL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    result: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The generated image encoded in base64. Required."""

    @overload
    def __init__(
        self,
        *,
        result: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.IMAGE_GENERATION_CALL  # type: ignore


class ImageGenToolCallItemResource(ItemResource, discriminator="image_generation_call"):
    """An image generation request made by the model.

    :ivar id: Required.
    :vartype id: str
    :ivar created_by: The information about the creator of the item.
    :vartype created_by: ~azure.ai.projects.models.CreatedBy
    :ivar type: Required.
    :vartype type: str or ~azure.ai.projects.models.IMAGE_GENERATION_CALL
    :ivar status: Required. Is one of the following types: Literal["in_progress"],
     Literal["completed"], Literal["generating"], Literal["failed"]
    :vartype status: str or str or str or str
    :ivar result: The generated image encoded in base64. Required.
    :vartype result: str
    """

    type: Literal[ItemType.IMAGE_GENERATION_CALL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    status: Literal["in_progress", "completed", "generating", "failed"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Required. Is one of the following types: Literal[\"in_progress\"], Literal[\"completed\"],
     Literal[\"generating\"], Literal[\"failed\"]"""
    result: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The generated image encoded in base64. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        status: Literal["in_progress", "completed", "generating", "failed"],
        result: str,
        created_by: Optional["_models.CreatedBy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.IMAGE_GENERATION_CALL  # type: ignore


class ImageGenToolInputImageMask(_Model):
    """ImageGenToolInputImageMask.

    :ivar image_url: Base64-encoded mask image.
    :vartype image_url: str
    :ivar file_id: File ID for the mask image.
    :vartype file_id: str
    """

    image_url: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Base64-encoded mask image."""
    file_id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """File ID for the mask image."""

    @overload
    def __init__(
        self,
        *,
        image_url: Optional[str] = None,
        file_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Insight(_Model):
    """The response body for cluster insights.

    :ivar id: The unique identifier for the insights report. Required.
    :vartype id: str
    :ivar metadata: Metadata about the insights report. Required.
    :vartype metadata: ~azure.ai.projects.models.InsightsMetadata
    :ivar state: The current state of the insights. Required. Known values are: "NotStarted",
     "Running", "Succeeded", "Failed", and "Canceled".
    :vartype state: str or ~azure.ai.projects.models.OperationState
    :ivar display_name: User friendly display name for the insight. Required.
    :vartype display_name: str
    :ivar request: Request for the insights analysis. Required.
    :vartype request: ~azure.ai.projects.models.InsightRequest
    :ivar result: The result of the insights report.
    :vartype result: ~azure.ai.projects.models.InsightResult
    """

    id: str = rest_field(visibility=["read"])
    """The unique identifier for the insights report. Required."""
    metadata: "_models.InsightsMetadata" = rest_field(visibility=["read"])
    """Metadata about the insights report. Required."""
    state: Union[str, "_models.OperationState"] = rest_field(visibility=["read"])
    """The current state of the insights. Required. Known values are: \"NotStarted\", \"Running\",
     \"Succeeded\", \"Failed\", and \"Canceled\"."""
    display_name: str = rest_field(name="displayName", visibility=["read", "create", "update", "delete", "query"])
    """User friendly display name for the insight. Required."""
    request: "_models.InsightRequest" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Request for the insights analysis. Required."""
    result: Optional["_models.InsightResult"] = rest_field(visibility=["read"])
    """The result of the insights report."""

    @overload
    def __init__(
        self,
        *,
        display_name: str,
        request: "_models.InsightRequest",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InsightCluster(_Model):
    """A cluster of analysis samples.

    :ivar id: The id of the analysis cluster. Required.
    :vartype id: str
    :ivar label: Label for the cluster. Required.
    :vartype label: str
    :ivar suggestion: Suggestion for the cluster. Required.
    :vartype suggestion: str
    :ivar description: Description of the analysis cluster. Required.
    :vartype description: str
    :ivar weight: The weight of the analysis cluster. This indicate number of samples in the
     cluster. Required.
    :vartype weight: int
    :ivar sub_clusters: List of subclusters within this cluster. Empty if no subclusters exist.
    :vartype sub_clusters: list[~azure.ai.projects.models.InsightCluster]
    :ivar samples: List of samples that belong to this cluster. Empty if samples are part of
     subclusters.
    :vartype samples: list[~azure.ai.projects.models.InsightSample]
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The id of the analysis cluster. Required."""
    label: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Label for the cluster. Required."""
    suggestion: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Suggestion for the cluster. Required."""
    description: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Description of the analysis cluster. Required."""
    weight: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The weight of the analysis cluster. This indicate number of samples in the cluster. Required."""
    sub_clusters: Optional[list["_models.InsightCluster"]] = rest_field(
        name="subClusters", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of subclusters within this cluster. Empty if no subclusters exist."""
    samples: Optional[list["_models.InsightSample"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of samples that belong to this cluster. Empty if samples are part of subclusters."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        label: str,
        suggestion: str,
        description: str,
        weight: int,
        sub_clusters: Optional[list["_models.InsightCluster"]] = None,
        samples: Optional[list["_models.InsightSample"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InsightModelConfiguration(_Model):
    """Configuration of the model used in the insight generation.

    :ivar model_deployment_name: The model deployment to be evaluated. Accepts either the
     deployment name alone or with the connection name as '{connectionName}/<modelDeploymentName>'.
     Required.
    :vartype model_deployment_name: str
    """

    model_deployment_name: str = rest_field(
        name="modelDeploymentName", visibility=["read", "create", "update", "delete", "query"]
    )
    """The model deployment to be evaluated. Accepts either the deployment name alone or with the
     connection name as '{connectionName}/<modelDeploymentName>'. Required."""

    @overload
    def __init__(
        self,
        *,
        model_deployment_name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InsightScheduleTask(ScheduleTask, discriminator="Insight"):
    """Insight task for the schedule.

    :ivar configuration: Configuration for the task.
    :vartype configuration: dict[str, str]
    :ivar type: Required. Insight task.
    :vartype type: str or ~azure.ai.projects.models.INSIGHT
    :ivar insight: The insight payload. Required.
    :vartype insight: ~azure.ai.projects.models.Insight
    """

    type: Literal[ScheduleTaskType.INSIGHT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Insight task."""
    insight: "_models.Insight" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The insight payload. Required."""

    @overload
    def __init__(
        self,
        *,
        insight: "_models.Insight",
        configuration: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ScheduleTaskType.INSIGHT  # type: ignore


class InsightsMetadata(_Model):
    """Metadata about the insights.

    :ivar created_at: The timestamp when the insights were created. Required.
    :vartype created_at: ~datetime.datetime
    :ivar completed_at: The timestamp when the insights were completed.
    :vartype completed_at: ~datetime.datetime
    """

    created_at: datetime.datetime = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp when the insights were created. Required."""
    completed_at: Optional[datetime.datetime] = rest_field(
        name="completedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp when the insights were completed."""

    @overload
    def __init__(
        self,
        *,
        created_at: datetime.datetime,
        completed_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class InsightSummary(_Model):
    """Summary of the error cluster analysis.

    :ivar sample_count: Total number of samples analyzed. Required.
    :vartype sample_count: int
    :ivar unique_subcluster_count: Total number of unique subcluster labels. Required.
    :vartype unique_subcluster_count: int
    :ivar unique_cluster_count: Total number of unique clusters. Required.
    :vartype unique_cluster_count: int
    :ivar method: Method used for clustering. Required.
    :vartype method: str
    :ivar usage: Token usage while performing clustering analysis. Required.
    :vartype usage: ~azure.ai.projects.models.ClusterTokenUsage
    """

    sample_count: int = rest_field(name="sampleCount", visibility=["read", "create", "update", "delete", "query"])
    """Total number of samples analyzed. Required."""
    unique_subcluster_count: int = rest_field(
        name="uniqueSubclusterCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total number of unique subcluster labels. Required."""
    unique_cluster_count: int = rest_field(
        name="uniqueClusterCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total number of unique clusters. Required."""
    method: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Method used for clustering. Required."""
    usage: "_models.ClusterTokenUsage" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Token usage while performing clustering analysis. Required."""

    @overload
    def __init__(
        self,
        *,
        sample_count: int,
        unique_subcluster_count: int,
        unique_cluster_count: int,
        method: str,
        usage: "_models.ClusterTokenUsage",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WorkflowActionOutputItemResource(ItemResource, discriminator="workflow_action"):
    """WorkflowActionOutputItemResource.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    InvokeAzureAgentWorkflowActionOutputItemResource

    :ivar id: Required.
    :vartype id: str
    :ivar created_by: The information about the creator of the item.
    :vartype created_by: ~azure.ai.projects.models.CreatedBy
    :ivar type: Required.
    :vartype type: str or ~azure.ai.projects.models.WORKFLOW_ACTION
    :ivar kind: The kind of CSDL action (e.g., 'SetVariable', 'InvokeAzureAgent'). Required.
     Default value is None.
    :vartype kind: str
    :ivar action_id: Unique identifier for the action. Required.
    :vartype action_id: str
    :ivar parent_action_id: ID of the parent action if this is a nested action.
    :vartype parent_action_id: str
    :ivar previous_action_id: ID of the previous action if this action follows another.
    :vartype previous_action_id: str
    :ivar status: Status of the action (e.g., 'in_progress', 'completed', 'failed', 'cancelled').
     Required. Is one of the following types: Literal["completed"], Literal["failed"],
     Literal["in_progress"], Literal["cancelled"]
    :vartype status: str or str or str or str
    """

    __mapping__: dict[str, _Model] = {}
    type: Literal[ItemType.WORKFLOW_ACTION] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    kind: str = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])
    """The kind of CSDL action (e.g., 'SetVariable', 'InvokeAzureAgent'). Required. Default value is
     None."""
    action_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique identifier for the action. Required."""
    parent_action_id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """ID of the parent action if this is a nested action."""
    previous_action_id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """ID of the previous action if this action follows another."""
    status: Literal["completed", "failed", "in_progress", "cancelled"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Status of the action (e.g., 'in_progress', 'completed', 'failed', 'cancelled'). Required. Is
     one of the following types: Literal[\"completed\"], Literal[\"failed\"],
     Literal[\"in_progress\"], Literal[\"cancelled\"]"""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        kind: str,
        action_id: str,
        status: Literal["completed", "failed", "in_progress", "cancelled"],
        created_by: Optional["_models.CreatedBy"] = None,
        parent_action_id: Optional[str] = None,
        previous_action_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.WORKFLOW_ACTION  # type: ignore


class InvokeAzureAgentWorkflowActionOutputItemResource(
    WorkflowActionOutputItemResource, discriminator="InvokeAzureAgent"
):  # pylint: disable=name-too-long
    """Details about an agent invocation as part of a workflow action.

    :ivar id: Required.
    :vartype id: str
    :ivar created_by: The information about the creator of the item.
    :vartype created_by: ~azure.ai.projects.models.CreatedBy
    :ivar type: Required.
    :vartype type: str or ~azure.ai.projects.models.WORKFLOW_ACTION
    :ivar action_id: Unique identifier for the action. Required.
    :vartype action_id: str
    :ivar parent_action_id: ID of the parent action if this is a nested action.
    :vartype parent_action_id: str
    :ivar previous_action_id: ID of the previous action if this action follows another.
    :vartype previous_action_id: str
    :ivar status: Status of the action (e.g., 'in_progress', 'completed', 'failed', 'cancelled').
     Required. Is one of the following types: Literal["completed"], Literal["failed"],
     Literal["in_progress"], Literal["cancelled"]
    :vartype status: str or str or str or str
    :ivar kind: Required. Default value is "InvokeAzureAgent".
    :vartype kind: str
    :ivar agent: Agent id. Required.
    :vartype agent: ~azure.ai.projects.models.AgentId
    :ivar conversation_id: ID of the conversation for the agent invocation.
    :vartype conversation_id: str
    :ivar response_id: The response id for the agent invocation. Required.
    :vartype response_id: str
    """

    __mapping__: dict[str, _Model] = {}
    kind: Literal["InvokeAzureAgent"] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Default value is \"InvokeAzureAgent\"."""
    agent: "_models.AgentId" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Agent id. Required."""
    conversation_id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """ID of the conversation for the agent invocation."""
    response_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The response id for the agent invocation. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        action_id: str,
        status: Literal["completed", "failed", "in_progress", "cancelled"],
        agent: "_models.AgentId",
        response_id: str,
        created_by: Optional["_models.CreatedBy"] = None,
        parent_action_id: Optional[str] = None,
        previous_action_id: Optional[str] = None,
        conversation_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = "InvokeAzureAgent"  # type: ignore


class ItemContent(_Model):
    """ItemContent.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ItemContentInputAudio, ItemContentInputFile, ItemContentInputImage, ItemContentInputText,
    ItemContentOutputAudio, ItemContentOutputText, ItemContentRefusal

    :ivar type: Required. Known values are: "input_text", "input_audio", "input_image",
     "input_file", "output_text", "output_audio", and "refusal".
    :vartype type: str or ~azure.ai.projects.models.ItemContentType
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Required. Known values are: \"input_text\", \"input_audio\", \"input_image\", \"input_file\",
     \"output_text\", \"output_audio\", and \"refusal\"."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ItemContentInputAudio(ItemContent, discriminator="input_audio"):
    """An audio input to the model.

       :ivar type: The type of the input item. Always ``input_audio``. Required.
       :vartype type: str or ~azure.ai.projects.models.INPUT_AUDIO
       :ivar data: Base64-encoded audio data. Required.
       :vartype data: str
       :ivar format: The format of the audio data. Currently supported formats are ``mp3`` and
    ``wav``. Required. Is either a Literal["mp3"] type or a Literal["wav"] type.
       :vartype format: str or str
    """

    type: Literal[ItemContentType.INPUT_AUDIO] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the input item. Always ``input_audio``. Required."""
    data: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Base64-encoded audio data. Required."""
    format: Literal["mp3", "wav"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The format of the audio data. Currently supported formats are ``mp3`` and
 ``wav``. Required. Is either a Literal[\"mp3\"] type or a Literal[\"wav\"] type."""

    @overload
    def __init__(
        self,
        *,
        data: str,
        format: Literal["mp3", "wav"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemContentType.INPUT_AUDIO  # type: ignore


class ItemContentInputFile(ItemContent, discriminator="input_file"):
    """A file input to the model.

    :ivar type: The type of the input item. Always ``input_file``. Required.
    :vartype type: str or ~azure.ai.projects.models.INPUT_FILE
    :ivar file_id: The ID of the file to be sent to the model.
    :vartype file_id: str
    :ivar filename: The name of the file to be sent to the model.
    :vartype filename: str
    :ivar file_data: The content of the file to be sent to the model.
    :vartype file_data: str
    """

    type: Literal[ItemContentType.INPUT_FILE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the input item. Always ``input_file``. Required."""
    file_id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the file to be sent to the model."""
    filename: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the file to be sent to the model."""
    file_data: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The content of the file to be sent to the model."""

    @overload
    def __init__(
        self,
        *,
        file_id: Optional[str] = None,
        filename: Optional[str] = None,
        file_data: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemContentType.INPUT_FILE  # type: ignore


class ItemContentInputImage(ItemContent, discriminator="input_image"):
    """An image input to the model. Learn about `image inputs </docs/guides/vision>`_.

    :ivar type: The type of the input item. Always ``input_image``. Required.
    :vartype type: str or ~azure.ai.projects.models.INPUT_IMAGE
    :ivar image_url: The URL of the image to be sent to the model. A fully qualified URL or base64
     encoded image in a data URL.
    :vartype image_url: str
    :ivar file_id: The ID of the file to be sent to the model.
    :vartype file_id: str
    :ivar detail: The detail level of the image to be sent to the model. One of ``high``, ``low``,
     or ``auto``. Defaults to ``auto``. Is one of the following types: Literal["low"],
     Literal["high"], Literal["auto"]
    :vartype detail: str or str or str
    """

    type: Literal[ItemContentType.INPUT_IMAGE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the input item. Always ``input_image``. Required."""
    image_url: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The URL of the image to be sent to the model. A fully qualified URL or base64 encoded image in
     a data URL."""
    file_id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the file to be sent to the model."""
    detail: Optional[Literal["low", "high", "auto"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The detail level of the image to be sent to the model. One of ``high``, ``low``, or ``auto``.
     Defaults to ``auto``. Is one of the following types: Literal[\"low\"], Literal[\"high\"],
     Literal[\"auto\"]"""

    @overload
    def __init__(
        self,
        *,
        image_url: Optional[str] = None,
        file_id: Optional[str] = None,
        detail: Optional[Literal["low", "high", "auto"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemContentType.INPUT_IMAGE  # type: ignore


class ItemContentInputText(ItemContent, discriminator="input_text"):
    """A text input to the model.

    :ivar type: The type of the input item. Always ``input_text``. Required.
    :vartype type: str or ~azure.ai.projects.models.INPUT_TEXT
    :ivar text: The text input to the model. Required.
    :vartype text: str
    """

    type: Literal[ItemContentType.INPUT_TEXT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the input item. Always ``input_text``. Required."""
    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The text input to the model. Required."""

    @overload
    def __init__(
        self,
        *,
        text: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemContentType.INPUT_TEXT  # type: ignore


class ItemContentOutputAudio(ItemContent, discriminator="output_audio"):
    """An audio output from the model.

    :ivar type: The type of the output audio. Always ``output_audio``. Required.
    :vartype type: str or ~azure.ai.projects.models.OUTPUT_AUDIO
    :ivar data: Base64-encoded audio data from the model. Required.
    :vartype data: str
    :ivar transcript: The transcript of the audio data from the model. Required.
    :vartype transcript: str
    """

    type: Literal[ItemContentType.OUTPUT_AUDIO] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the output audio. Always ``output_audio``. Required."""
    data: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Base64-encoded audio data from the model. Required."""
    transcript: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The transcript of the audio data from the model. Required."""

    @overload
    def __init__(
        self,
        *,
        data: str,
        transcript: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemContentType.OUTPUT_AUDIO  # type: ignore


class ItemContentOutputText(ItemContent, discriminator="output_text"):
    """A text output from the model.

    :ivar type: The type of the output text. Always ``output_text``. Required.
    :vartype type: str or ~azure.ai.projects.models.OUTPUT_TEXT
    :ivar text: The text output from the model. Required.
    :vartype text: str
    :ivar annotations: The annotations of the text output. Required.
    :vartype annotations: list[~azure.ai.projects.models.Annotation]
    :ivar logprobs:
    :vartype logprobs: list[~azure.ai.projects.models.LogProb]
    """

    type: Literal[ItemContentType.OUTPUT_TEXT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the output text. Always ``output_text``. Required."""
    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The text output from the model. Required."""
    annotations: list["_models.Annotation"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The annotations of the text output. Required."""
    logprobs: Optional[list["_models.LogProb"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])

    @overload
    def __init__(
        self,
        *,
        text: str,
        annotations: list["_models.Annotation"],
        logprobs: Optional[list["_models.LogProb"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemContentType.OUTPUT_TEXT  # type: ignore


class ItemContentRefusal(ItemContent, discriminator="refusal"):
    """A refusal from the model.

    :ivar type: The type of the refusal. Always ``refusal``. Required.
    :vartype type: str or ~azure.ai.projects.models.REFUSAL
    :ivar refusal: The refusal explanationfrom the model. Required.
    :vartype refusal: str
    """

    type: Literal[ItemContentType.REFUSAL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the refusal. Always ``refusal``. Required."""
    refusal: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The refusal explanationfrom the model. Required."""

    @overload
    def __init__(
        self,
        *,
        refusal: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemContentType.REFUSAL  # type: ignore


class ItemReferenceItemParam(ItemParam, discriminator="item_reference"):
    """An internal identifier for an item to reference.

    :ivar type: Required.
    :vartype type: str or ~azure.ai.projects.models.ITEM_REFERENCE
    :ivar id: The service-originated ID of the previously generated response item being referenced.
     Required.
    :vartype id: str
    """

    type: Literal[ItemType.ITEM_REFERENCE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The service-originated ID of the previously generated response item being referenced. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.ITEM_REFERENCE  # type: ignore


class LocalShellExecAction(_Model):
    """Execute a shell command on the server.

    :ivar type: The type of the local shell action. Always ``exec``. Required. Default value is
     "exec".
    :vartype type: str
    :ivar command: The command to run. Required.
    :vartype command: list[str]
    :ivar timeout_ms: Optional timeout in milliseconds for the command.
    :vartype timeout_ms: int
    :ivar working_directory: Optional working directory to run the command in.
    :vartype working_directory: str
    :ivar env: Environment variables to set for the command. Required.
    :vartype env: dict[str, str]
    :ivar user: Optional user to run the command as.
    :vartype user: str
    """

    type: Literal["exec"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The type of the local shell action. Always ``exec``. Required. Default value is \"exec\"."""
    command: list[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The command to run. Required."""
    timeout_ms: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional timeout in milliseconds for the command."""
    working_directory: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional working directory to run the command in."""
    env: dict[str, str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Environment variables to set for the command. Required."""
    user: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional user to run the command as."""

    @overload
    def __init__(
        self,
        *,
        command: list[str],
        env: dict[str, str],
        timeout_ms: Optional[int] = None,
        working_directory: Optional[str] = None,
        user: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type: Literal["exec"] = "exec"


class LocalShellTool(Tool, discriminator="local_shell"):
    """A tool that allows the model to execute shell commands in a local environment.

    :ivar type: The type of the local shell tool. Always ``local_shell``. Required.
    :vartype type: str or ~azure.ai.projects.models.LOCAL_SHELL
    """

    type: Literal[ToolType.LOCAL_SHELL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the local shell tool. Always ``local_shell``. Required."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ToolType.LOCAL_SHELL  # type: ignore


class LocalShellToolCallItemParam(ItemParam, discriminator="local_shell_call"):
    """A tool call to run a command on the local shell.

    :ivar type: Required.
    :vartype type: str or ~azure.ai.projects.models.LOCAL_SHELL_CALL
    :ivar call_id: The unique ID of the local shell tool call generated by the model. Required.
    :vartype call_id: str
    :ivar action: Required.
    :vartype action: ~azure.ai.projects.models.LocalShellExecAction
    """

    type: Literal[ItemType.LOCAL_SHELL_CALL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    call_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique ID of the local shell tool call generated by the model. Required."""
    action: "_models.LocalShellExecAction" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        call_id: str,
        action: "_models.LocalShellExecAction",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.LOCAL_SHELL_CALL  # type: ignore


class LocalShellToolCallItemResource(ItemResource, discriminator="local_shell_call"):
    """A tool call to run a command on the local shell.

    :ivar id: Required.
    :vartype id: str
    :ivar created_by: The information about the creator of the item.
    :vartype created_by: ~azure.ai.projects.models.CreatedBy
    :ivar type: Required.
    :vartype type: str or ~azure.ai.projects.models.LOCAL_SHELL_CALL
    :ivar status: Required. Is one of the following types: Literal["in_progress"],
     Literal["completed"], Literal["incomplete"]
    :vartype status: str or str or str
    :ivar call_id: The unique ID of the local shell tool call generated by the model. Required.
    :vartype call_id: str
    :ivar action: Required.
    :vartype action: ~azure.ai.projects.models.LocalShellExecAction
    """

    type: Literal[ItemType.LOCAL_SHELL_CALL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    status: Literal["in_progress", "completed", "incomplete"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Required. Is one of the following types: Literal[\"in_progress\"], Literal[\"completed\"],
     Literal[\"incomplete\"]"""
    call_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique ID of the local shell tool call generated by the model. Required."""
    action: "_models.LocalShellExecAction" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        status: Literal["in_progress", "completed", "incomplete"],
        call_id: str,
        action: "_models.LocalShellExecAction",
        created_by: Optional["_models.CreatedBy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.LOCAL_SHELL_CALL  # type: ignore


class LocalShellToolCallOutputItemParam(ItemParam, discriminator="local_shell_call_output"):
    """The output of a local shell tool call.

    :ivar type: Required.
    :vartype type: str or ~azure.ai.projects.models.LOCAL_SHELL_CALL_OUTPUT
    :ivar output: A JSON string of the output of the local shell tool call. Required.
    :vartype output: str
    """

    type: Literal[ItemType.LOCAL_SHELL_CALL_OUTPUT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    output: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A JSON string of the output of the local shell tool call. Required."""

    @overload
    def __init__(
        self,
        *,
        output: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.LOCAL_SHELL_CALL_OUTPUT  # type: ignore


class LocalShellToolCallOutputItemResource(ItemResource, discriminator="local_shell_call_output"):
    """The output of a local shell tool call.

    :ivar id: Required.
    :vartype id: str
    :ivar created_by: The information about the creator of the item.
    :vartype created_by: ~azure.ai.projects.models.CreatedBy
    :ivar type: Required.
    :vartype type: str or ~azure.ai.projects.models.LOCAL_SHELL_CALL_OUTPUT
    :ivar status: Required. Is one of the following types: Literal["in_progress"],
     Literal["completed"], Literal["incomplete"]
    :vartype status: str or str or str
    :ivar output: A JSON string of the output of the local shell tool call. Required.
    :vartype output: str
    """

    type: Literal[ItemType.LOCAL_SHELL_CALL_OUTPUT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    status: Literal["in_progress", "completed", "incomplete"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Required. Is one of the following types: Literal[\"in_progress\"], Literal[\"completed\"],
     Literal[\"incomplete\"]"""
    output: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A JSON string of the output of the local shell tool call. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        status: Literal["in_progress", "completed", "incomplete"],
        output: str,
        created_by: Optional["_models.CreatedBy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.LOCAL_SHELL_CALL_OUTPUT  # type: ignore


class LogProb(_Model):
    """The log probability of a token.

    :ivar token: Required.
    :vartype token: str
    :ivar logprob: Required.
    :vartype logprob: float
    :ivar bytes: Required.
    :vartype bytes: list[int]
    :ivar top_logprobs: Required.
    :vartype top_logprobs: list[~azure.ai.projects.models.TopLogProb]
    """

    token: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    logprob: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    bytes: list[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    top_logprobs: list["_models.TopLogProb"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        token: str,
        logprob: float,
        bytes: list[int],
        top_logprobs: list["_models.TopLogProb"],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ManagedAzureAISearchIndex(Index, discriminator="ManagedAzureSearch"):
    """Managed Azure AI Search Index Definition.

    :ivar id: Asset ID, a unique identifier for the asset.
    :vartype id: str
    :ivar name: The name of the resource. Required.
    :vartype name: str
    :ivar version: The version of the resource. Required.
    :vartype version: str
    :ivar description: The asset description text.
    :vartype description: str
    :ivar tags: Tag dictionary. Tags can be added, removed, and updated.
    :vartype tags: dict[str, str]
    :ivar type: Type of index. Required. Managed Azure Search
    :vartype type: str or ~azure.ai.projects.models.MANAGED_AZURE_SEARCH
    :ivar vector_store_id: Vector store id of managed index. Required.
    :vartype vector_store_id: str
    """

    type: Literal[IndexType.MANAGED_AZURE_SEARCH] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Type of index. Required. Managed Azure Search"""
    vector_store_id: str = rest_field(name="vectorStoreId", visibility=["create"])
    """Vector store id of managed index. Required."""

    @overload
    def __init__(
        self,
        *,
        vector_store_id: str,
        description: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = IndexType.MANAGED_AZURE_SEARCH  # type: ignore


class MCPApprovalRequestItemParam(ItemParam, discriminator="mcp_approval_request"):
    """A request for human approval of a tool invocation.

    :ivar type: Required.
    :vartype type: str or ~azure.ai.projects.models.MCP_APPROVAL_REQUEST
    :ivar server_label: The label of the MCP server making the request. Required.
    :vartype server_label: str
    :ivar name: The name of the tool to run. Required.
    :vartype name: str
    :ivar arguments: A JSON string of arguments for the tool. Required.
    :vartype arguments: str
    """

    type: Literal[ItemType.MCP_APPROVAL_REQUEST] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    server_label: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The label of the MCP server making the request. Required."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the tool to run. Required."""
    arguments: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A JSON string of arguments for the tool. Required."""

    @overload
    def __init__(
        self,
        *,
        server_label: str,
        name: str,
        arguments: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.MCP_APPROVAL_REQUEST  # type: ignore


class MCPApprovalRequestItemResource(ItemResource, discriminator="mcp_approval_request"):
    """A request for human approval of a tool invocation.

    :ivar id: Required.
    :vartype id: str
    :ivar created_by: The information about the creator of the item.
    :vartype created_by: ~azure.ai.projects.models.CreatedBy
    :ivar type: Required.
    :vartype type: str or ~azure.ai.projects.models.MCP_APPROVAL_REQUEST
    :ivar server_label: The label of the MCP server making the request. Required.
    :vartype server_label: str
    :ivar name: The name of the tool to run. Required.
    :vartype name: str
    :ivar arguments: A JSON string of arguments for the tool. Required.
    :vartype arguments: str
    """

    type: Literal[ItemType.MCP_APPROVAL_REQUEST] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    server_label: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The label of the MCP server making the request. Required."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the tool to run. Required."""
    arguments: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A JSON string of arguments for the tool. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        server_label: str,
        name: str,
        arguments: str,
        created_by: Optional["_models.CreatedBy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.MCP_APPROVAL_REQUEST  # type: ignore


class MCPApprovalResponseItemParam(ItemParam, discriminator="mcp_approval_response"):
    """A response to an MCP approval request.

    :ivar type: Required.
    :vartype type: str or ~azure.ai.projects.models.MCP_APPROVAL_RESPONSE
    :ivar approval_request_id: The ID of the approval request being answered. Required.
    :vartype approval_request_id: str
    :ivar approve: Whether the request was approved. Required.
    :vartype approve: bool
    :ivar reason: Optional reason for the decision.
    :vartype reason: str
    """

    type: Literal[ItemType.MCP_APPROVAL_RESPONSE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    approval_request_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the approval request being answered. Required."""
    approve: bool = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Whether the request was approved. Required."""
    reason: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional reason for the decision."""

    @overload
    def __init__(
        self,
        *,
        approval_request_id: str,
        approve: bool,
        reason: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.MCP_APPROVAL_RESPONSE  # type: ignore


class MCPApprovalResponseItemResource(ItemResource, discriminator="mcp_approval_response"):
    """A response to an MCP approval request.

    :ivar id: Required.
    :vartype id: str
    :ivar created_by: The information about the creator of the item.
    :vartype created_by: ~azure.ai.projects.models.CreatedBy
    :ivar type: Required.
    :vartype type: str or ~azure.ai.projects.models.MCP_APPROVAL_RESPONSE
    :ivar approval_request_id: The ID of the approval request being answered. Required.
    :vartype approval_request_id: str
    :ivar approve: Whether the request was approved. Required.
    :vartype approve: bool
    :ivar reason: Optional reason for the decision.
    :vartype reason: str
    """

    type: Literal[ItemType.MCP_APPROVAL_RESPONSE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    approval_request_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the approval request being answered. Required."""
    approve: bool = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Whether the request was approved. Required."""
    reason: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional reason for the decision."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        approval_request_id: str,
        approve: bool,
        created_by: Optional["_models.CreatedBy"] = None,
        reason: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.MCP_APPROVAL_RESPONSE  # type: ignore


class MCPCallItemParam(ItemParam, discriminator="mcp_call"):
    """An invocation of a tool on an MCP server.

    :ivar type: Required.
    :vartype type: str or ~azure.ai.projects.models.MCP_CALL
    :ivar server_label: The label of the MCP server running the tool. Required.
    :vartype server_label: str
    :ivar name: The name of the tool that was run. Required.
    :vartype name: str
    :ivar arguments: A JSON string of the arguments passed to the tool. Required.
    :vartype arguments: str
    :ivar output: The output from the tool call.
    :vartype output: str
    :ivar error: The error from the tool call, if any.
    :vartype error: str
    """

    type: Literal[ItemType.MCP_CALL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    server_label: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The label of the MCP server running the tool. Required."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the tool that was run. Required."""
    arguments: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A JSON string of the arguments passed to the tool. Required."""
    output: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The output from the tool call."""
    error: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error from the tool call, if any."""

    @overload
    def __init__(
        self,
        *,
        server_label: str,
        name: str,
        arguments: str,
        output: Optional[str] = None,
        error: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.MCP_CALL  # type: ignore


class MCPCallItemResource(ItemResource, discriminator="mcp_call"):
    """An invocation of a tool on an MCP server.

    :ivar id: Required.
    :vartype id: str
    :ivar created_by: The information about the creator of the item.
    :vartype created_by: ~azure.ai.projects.models.CreatedBy
    :ivar type: Required.
    :vartype type: str or ~azure.ai.projects.models.MCP_CALL
    :ivar server_label: The label of the MCP server running the tool. Required.
    :vartype server_label: str
    :ivar name: The name of the tool that was run. Required.
    :vartype name: str
    :ivar arguments: A JSON string of the arguments passed to the tool. Required.
    :vartype arguments: str
    :ivar output: The output from the tool call.
    :vartype output: str
    :ivar error: The error from the tool call, if any.
    :vartype error: str
    """

    type: Literal[ItemType.MCP_CALL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    server_label: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The label of the MCP server running the tool. Required."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the tool that was run. Required."""
    arguments: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A JSON string of the arguments passed to the tool. Required."""
    output: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The output from the tool call."""
    error: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error from the tool call, if any."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        server_label: str,
        name: str,
        arguments: str,
        created_by: Optional["_models.CreatedBy"] = None,
        output: Optional[str] = None,
        error: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.MCP_CALL  # type: ignore


class MCPListToolsItemParam(ItemParam, discriminator="mcp_list_tools"):
    """A list of tools available on an MCP server.

    :ivar type: Required.
    :vartype type: str or ~azure.ai.projects.models.MCP_LIST_TOOLS
    :ivar server_label: The label of the MCP server. Required.
    :vartype server_label: str
    :ivar tools: The tools available on the server. Required.
    :vartype tools: list[~azure.ai.projects.models.MCPListToolsTool]
    :ivar error: Error message if the server could not list tools.
    :vartype error: str
    """

    type: Literal[ItemType.MCP_LIST_TOOLS] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    server_label: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The label of the MCP server. Required."""
    tools: list["_models.MCPListToolsTool"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The tools available on the server. Required."""
    error: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error message if the server could not list tools."""

    @overload
    def __init__(
        self,
        *,
        server_label: str,
        tools: list["_models.MCPListToolsTool"],
        error: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.MCP_LIST_TOOLS  # type: ignore


class MCPListToolsItemResource(ItemResource, discriminator="mcp_list_tools"):
    """A list of tools available on an MCP server.

    :ivar id: Required.
    :vartype id: str
    :ivar created_by: The information about the creator of the item.
    :vartype created_by: ~azure.ai.projects.models.CreatedBy
    :ivar type: Required.
    :vartype type: str or ~azure.ai.projects.models.MCP_LIST_TOOLS
    :ivar server_label: The label of the MCP server. Required.
    :vartype server_label: str
    :ivar tools: The tools available on the server. Required.
    :vartype tools: list[~azure.ai.projects.models.MCPListToolsTool]
    :ivar error: Error message if the server could not list tools.
    :vartype error: str
    """

    type: Literal[ItemType.MCP_LIST_TOOLS] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    server_label: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The label of the MCP server. Required."""
    tools: list["_models.MCPListToolsTool"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The tools available on the server. Required."""
    error: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error message if the server could not list tools."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        server_label: str,
        tools: list["_models.MCPListToolsTool"],
        created_by: Optional["_models.CreatedBy"] = None,
        error: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.MCP_LIST_TOOLS  # type: ignore


class MCPListToolsTool(_Model):
    """A tool available on an MCP server.

    :ivar name: The name of the tool. Required.
    :vartype name: str
    :ivar description: The description of the tool.
    :vartype description: str
    :ivar input_schema: The JSON schema describing the tool's input. Required.
    :vartype input_schema: any
    :ivar annotations: Additional annotations about the tool.
    :vartype annotations: any
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the tool. Required."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The description of the tool."""
    input_schema: Any = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The JSON schema describing the tool's input. Required."""
    annotations: Optional[Any] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Additional annotations about the tool."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        input_schema: Any,
        description: Optional[str] = None,
        annotations: Optional[Any] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MCPTool(Tool, discriminator="mcp"):
    """Give the model access to additional tools via remote Model Context Protocol
    (MCP) servers. `Learn more about MCP </docs/guides/tools-remote-mcp>`_.

        :ivar type: The type of the MCP tool. Always ``mcp``. Required.
        :vartype type: str or ~azure.ai.projects.models.MCP
        :ivar server_label: A label for this MCP server, used to identify it in tool calls. Required.
        :vartype server_label: str
        :ivar server_url: The URL for the MCP server. Required.
        :vartype server_url: str
        :ivar headers: Optional HTTP headers to send to the MCP server. Use for authentication
     or other purposes.
        :vartype headers: dict[str, str]
        :ivar allowed_tools: List of allowed tool names or a filter object. Is either a [str] type or a
         MCPToolAllowedTools1 type.
        :vartype allowed_tools: list[str] or ~azure.ai.projects.models.MCPToolAllowedTools1
        :ivar require_approval: Specify which of the MCP server's tools require approval. Is one of the
         following types: MCPToolRequireApproval1, Literal["always"], Literal["never"]
        :vartype require_approval: ~azure.ai.projects.models.MCPToolRequireApproval1 or str or str
        :ivar project_connection_id: The connection ID in the project for the MCP server. The
         connection stores authentication and other connection details needed to connect to the MCP
         server.
        :vartype project_connection_id: str
    """

    type: Literal[ToolType.MCP] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the MCP tool. Always ``mcp``. Required."""
    server_label: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A label for this MCP server, used to identify it in tool calls. Required."""
    server_url: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The URL for the MCP server. Required."""
    headers: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional HTTP headers to send to the MCP server. Use for authentication
 or other purposes."""
    allowed_tools: Optional[Union[list[str], "_models.MCPToolAllowedTools1"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of allowed tool names or a filter object. Is either a [str] type or a MCPToolAllowedTools1
     type."""
    require_approval: Optional[Union["_models.MCPToolRequireApproval1", Literal["always"], Literal["never"]]] = (
        rest_field(visibility=["read", "create", "update", "delete", "query"])
    )
    """Specify which of the MCP server's tools require approval. Is one of the following types:
     MCPToolRequireApproval1, Literal[\"always\"], Literal[\"never\"]"""
    project_connection_id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The connection ID in the project for the MCP server. The connection stores authentication and
     other connection details needed to connect to the MCP server."""

    @overload
    def __init__(
        self,
        *,
        server_label: str,
        server_url: str,
        headers: Optional[dict[str, str]] = None,
        allowed_tools: Optional[Union[list[str], "_models.MCPToolAllowedTools1"]] = None,
        require_approval: Optional[
            Union["_models.MCPToolRequireApproval1", Literal["always"], Literal["never"]]
        ] = None,
        project_connection_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ToolType.MCP  # type: ignore


class MCPToolAllowedTools1(_Model):
    """MCPToolAllowedTools1.

    :ivar tool_names: List of allowed tool names.
    :vartype tool_names: list[str]
    """

    tool_names: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of allowed tool names."""

    @overload
    def __init__(
        self,
        *,
        tool_names: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MCPToolRequireApproval1(_Model):
    """MCPToolRequireApproval1.

    :ivar always: A list of tools that always require approval.
    :vartype always: ~azure.ai.projects.models.MCPToolRequireApprovalAlways
    :ivar never: A list of tools that never require approval.
    :vartype never: ~azure.ai.projects.models.MCPToolRequireApprovalNever
    """

    always: Optional["_models.MCPToolRequireApprovalAlways"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of tools that always require approval."""
    never: Optional["_models.MCPToolRequireApprovalNever"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of tools that never require approval."""

    @overload
    def __init__(
        self,
        *,
        always: Optional["_models.MCPToolRequireApprovalAlways"] = None,
        never: Optional["_models.MCPToolRequireApprovalNever"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MCPToolRequireApprovalAlways(_Model):
    """MCPToolRequireApprovalAlways.

    :ivar tool_names: List of tools that require approval.
    :vartype tool_names: list[str]
    """

    tool_names: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of tools that require approval."""

    @overload
    def __init__(
        self,
        *,
        tool_names: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MCPToolRequireApprovalNever(_Model):
    """MCPToolRequireApprovalNever.

    :ivar tool_names: List of tools that do not require approval.
    :vartype tool_names: list[str]
    """

    tool_names: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of tools that do not require approval."""

    @overload
    def __init__(
        self,
        *,
        tool_names: Optional[list[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MemoryOperation(_Model):
    """Represents a single memory operation (create, update, or delete) performed on a memory item.

    :ivar kind: The type of memory operation being performed. Required. Known values are: "create",
     "update", and "delete".
    :vartype kind: str or ~azure.ai.projects.models.MemoryOperationKind
    :ivar memory_item: The memory item to create, update, or delete. Required.
    :vartype memory_item: ~azure.ai.projects.models.MemoryItem
    """

    kind: Union[str, "_models.MemoryOperationKind"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of memory operation being performed. Required. Known values are: \"create\",
     \"update\", and \"delete\"."""
    memory_item: "_models.MemoryItem" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The memory item to create, update, or delete. Required."""

    @overload
    def __init__(
        self,
        *,
        kind: Union[str, "_models.MemoryOperationKind"],
        memory_item: "_models.MemoryItem",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MemorySearchItem(_Model):
    """A retrieved memory item from memory search.

    :ivar memory_item: Retrieved memory item. Required.
    :vartype memory_item: ~azure.ai.projects.models.MemoryItem
    """

    memory_item: "_models.MemoryItem" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Retrieved memory item. Required."""

    @overload
    def __init__(
        self,
        *,
        memory_item: "_models.MemoryItem",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MemorySearchOptions(_Model):
    """Memory search options.

    :ivar max_memories: Maximum number of memory items to return.
    :vartype max_memories: int
    """

    max_memories: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Maximum number of memory items to return."""

    @overload
    def __init__(
        self,
        *,
        max_memories: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MemorySearchTool(Tool, discriminator="memory_search"):
    """A tool for integrating memories into the agent.

       :ivar type: The type of the tool. Always ``memory_search``. Required.
       :vartype type: str or ~azure.ai.projects.models.MEMORY_SEARCH
       :ivar memory_store_name: The name of the memory store to use. Required.
       :vartype memory_store_name: str
       :ivar scope: The namespace used to group and isolate memories, such as a user ID.
    Limits which memories can be retrieved or updated.
    Use special variable ``{{$userId}}`` to scope memories to the current signed-in user. Required.
       :vartype scope: str
       :ivar search_options: Options for searching the memory store.
       :vartype search_options: ~azure.ai.projects.models.MemorySearchOptions
       :ivar update_delay: The amount of time to wait after inactivity before updating memories with
        messages from the call (e.g., '0s', '5m'). Defaults to '60s'.
       :vartype update_delay: ~datetime.timedelta
    """

    type: Literal[ToolType.MEMORY_SEARCH] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the tool. Always ``memory_search``. Required."""
    memory_store_name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the memory store to use. Required."""
    scope: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The namespace used to group and isolate memories, such as a user ID.
 Limits which memories can be retrieved or updated.
 Use special variable ``{{$userId}}`` to scope memories to the current signed-in user. Required."""
    search_options: Optional["_models.MemorySearchOptions"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Options for searching the memory store."""
    update_delay: Optional[datetime.timedelta] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The amount of time to wait after inactivity before updating memories with messages from the
     call (e.g., '0s', '5m'). Defaults to '60s'."""

    @overload
    def __init__(
        self,
        *,
        memory_store_name: str,
        scope: str,
        search_options: Optional["_models.MemorySearchOptions"] = None,
        update_delay: Optional[datetime.timedelta] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ToolType.MEMORY_SEARCH  # type: ignore


class MemorySearchToolCallItemParam(ItemParam, discriminator="memory_search_call"):
    """MemorySearchToolCallItemParam.

    :ivar type: Required.
    :vartype type: str or ~azure.ai.projects.models.MEMORY_SEARCH_CALL
    :ivar results: The results returned from the memory search.
    :vartype results: list[~azure.ai.projects.models.MemorySearchItem]
    """

    type: Literal[ItemType.MEMORY_SEARCH_CALL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    results: Optional[list["_models.MemorySearchItem"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The results returned from the memory search."""

    @overload
    def __init__(
        self,
        *,
        results: Optional[list["_models.MemorySearchItem"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.MEMORY_SEARCH_CALL  # type: ignore


class MemorySearchToolCallItemResource(ItemResource, discriminator="memory_search_call"):
    """MemorySearchToolCallItemResource.

       :ivar id: Required.
       :vartype id: str
       :ivar created_by: The information about the creator of the item.
       :vartype created_by: ~azure.ai.projects.models.CreatedBy
       :ivar type: Required.
       :vartype type: str or ~azure.ai.projects.models.MEMORY_SEARCH_CALL
       :ivar status: The status of the memory search tool call. One of ``in_progress``,
    ``searching``, ``completed``, ``incomplete`` or ``failed``,. Required. Is one of the following
        types: Literal["in_progress"], Literal["searching"], Literal["completed"],
        Literal["incomplete"], Literal["failed"]
       :vartype status: str or str or str or str or str
       :ivar results: The results returned from the memory search.
       :vartype results: list[~azure.ai.projects.models.MemorySearchItem]
    """

    type: Literal[ItemType.MEMORY_SEARCH_CALL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    status: Literal["in_progress", "searching", "completed", "incomplete", "failed"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The status of the memory search tool call. One of ``in_progress``,
 ``searching``, ``completed``, ``incomplete`` or ``failed``,. Required. Is one of the following
     types: Literal[\"in_progress\"], Literal[\"searching\"], Literal[\"completed\"],
     Literal[\"incomplete\"], Literal[\"failed\"]"""
    results: Optional[list["_models.MemorySearchItem"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The results returned from the memory search."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        status: Literal["in_progress", "searching", "completed", "incomplete", "failed"],
        created_by: Optional["_models.CreatedBy"] = None,
        results: Optional[list["_models.MemorySearchItem"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.MEMORY_SEARCH_CALL  # type: ignore


class MemoryStoreDefinition(_Model):
    """Base definition for memory store configurations.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    MemoryStoreDefaultDefinition

    :ivar kind: The kind of the memory store. Required. "default"
    :vartype kind: str or ~azure.ai.projects.models.MemoryStoreKind
    """

    __mapping__: dict[str, _Model] = {}
    kind: str = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])
    """The kind of the memory store. Required. \"default\""""

    @overload
    def __init__(
        self,
        *,
        kind: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MemoryStoreDefaultDefinition(MemoryStoreDefinition, discriminator="default"):
    """Default memory store implementation.

    :ivar kind: The kind of the memory store. Required. The default memory store implementation.
    :vartype kind: str or ~azure.ai.projects.models.DEFAULT
    :ivar chat_model: The name or identifier of the chat completion model deployment used for
     memory processing. Required.
    :vartype chat_model: str
    :ivar embedding_model: The name or identifier of the embedding model deployment used for memory
     processing. Required.
    :vartype embedding_model: str
    :ivar options: Default memory store options.
    :vartype options: ~azure.ai.projects.models.MemoryStoreDefaultOptions
    """

    kind: Literal[MemoryStoreKind.DEFAULT] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The kind of the memory store. Required. The default memory store implementation."""
    chat_model: str = rest_field(visibility=["read", "create"])
    """The name or identifier of the chat completion model deployment used for memory processing.
     Required."""
    embedding_model: str = rest_field(visibility=["read", "create"])
    """The name or identifier of the embedding model deployment used for memory processing. Required."""
    options: Optional["_models.MemoryStoreDefaultOptions"] = rest_field(visibility=["read", "create"])
    """Default memory store options."""

    @overload
    def __init__(
        self,
        *,
        chat_model: str,
        embedding_model: str,
        options: Optional["_models.MemoryStoreDefaultOptions"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = MemoryStoreKind.DEFAULT  # type: ignore


class MemoryStoreDefaultOptions(_Model):
    """Default memory store configurations.

    :ivar user_profile_enabled: Whether to enable user profile extraction and storage. Default is
     true. Required.
    :vartype user_profile_enabled: bool
    :ivar user_profile_details: Specific categories or types of user profile information to extract
     and store.
    :vartype user_profile_details: str
    :ivar chat_summary_enabled: Whether to enable chat summary extraction and storage. Default is
     true. Required.
    :vartype chat_summary_enabled: bool
    """

    user_profile_enabled: bool = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Whether to enable user profile extraction and storage. Default is true. Required."""
    user_profile_details: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Specific categories or types of user profile information to extract and store."""
    chat_summary_enabled: bool = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Whether to enable chat summary extraction and storage. Default is true. Required."""

    @overload
    def __init__(
        self,
        *,
        user_profile_enabled: bool,
        chat_summary_enabled: bool,
        user_profile_details: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MemoryStoreDeleteScopeResponse(_Model):
    """Response for deleting memories from a scope.

    :ivar object: The object type. Always 'memory_store.scope.deleted'. Required. Default value is
     "memory_store.scope.deleted".
    :vartype object: str
    :ivar name: The name of the memory store. Required.
    :vartype name: str
    :ivar scope: The scope from which memories were deleted. Required.
    :vartype scope: str
    :ivar deleted: Whether the deletion operation was successful. Required.
    :vartype deleted: bool
    """

    object: Literal["memory_store.scope.deleted"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The object type. Always 'memory_store.scope.deleted'. Required. Default value is
     \"memory_store.scope.deleted\"."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the memory store. Required."""
    scope: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The scope from which memories were deleted. Required."""
    deleted: bool = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Whether the deletion operation was successful. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        scope: str,
        deleted: bool,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object: Literal["memory_store.scope.deleted"] = "memory_store.scope.deleted"


class MemoryStoreObject(_Model):
    """A memory store that can store and retrieve user memories.

    :ivar object: The object type, which is always 'memory_store'. Required. Default value is
     "memory_store".
    :vartype object: str
    :ivar id: The unique identifier of the memory store. Required.
    :vartype id: str
    :ivar created_at: The Unix timestamp (seconds) when the memory store was created. Required.
    :vartype created_at: ~datetime.datetime
    :ivar updated_at: The Unix timestamp (seconds) when the memory store was last updated.
     Required.
    :vartype updated_at: ~datetime.datetime
    :ivar name: The name of the memory store. Required.
    :vartype name: str
    :ivar description: A human-readable description of the memory store.
    :vartype description: str
    :ivar metadata: Arbitrary key-value metadata to associate with the memory store.
    :vartype metadata: dict[str, str]
    :ivar definition: The definition of the memory store. Required.
    :vartype definition: ~azure.ai.projects.models.MemoryStoreDefinition
    """

    object: Literal["memory_store"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The object type, which is always 'memory_store'. Required. Default value is \"memory_store\"."""
    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique identifier of the memory store. Required."""
    created_at: datetime.datetime = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="unix-timestamp"
    )
    """The Unix timestamp (seconds) when the memory store was created. Required."""
    updated_at: datetime.datetime = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="unix-timestamp"
    )
    """The Unix timestamp (seconds) when the memory store was last updated. Required."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the memory store. Required."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A human-readable description of the memory store."""
    metadata: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Arbitrary key-value metadata to associate with the memory store."""
    definition: "_models.MemoryStoreDefinition" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The definition of the memory store. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        created_at: datetime.datetime,
        updated_at: datetime.datetime,
        name: str,
        definition: "_models.MemoryStoreDefinition",
        description: Optional[str] = None,
        metadata: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object: Literal["memory_store"] = "memory_store"


class MemoryStoreOperationUsage(_Model):
    """Usage statistics of a memory store operation.

    :ivar embedding_tokens: The number of embedding tokens. Required.
    :vartype embedding_tokens: int
    :ivar input_tokens: The number of input tokens. Required.
    :vartype input_tokens: int
    :ivar input_tokens_details: A detailed breakdown of the input tokens. Required.
    :vartype input_tokens_details:
     ~azure.ai.projects.models.MemoryStoreOperationUsageInputTokensDetails
    :ivar output_tokens: The number of output tokens. Required.
    :vartype output_tokens: int
    :ivar output_tokens_details: A detailed breakdown of the output tokens. Required.
    :vartype output_tokens_details:
     ~azure.ai.projects.models.MemoryStoreOperationUsageOutputTokensDetails
    :ivar total_tokens: The total number of tokens used. Required.
    :vartype total_tokens: int
    """

    embedding_tokens: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of embedding tokens. Required."""
    input_tokens: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of input tokens. Required."""
    input_tokens_details: "_models.MemoryStoreOperationUsageInputTokensDetails" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A detailed breakdown of the input tokens. Required."""
    output_tokens: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of output tokens. Required."""
    output_tokens_details: "_models.MemoryStoreOperationUsageOutputTokensDetails" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A detailed breakdown of the output tokens. Required."""
    total_tokens: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The total number of tokens used. Required."""

    @overload
    def __init__(
        self,
        *,
        embedding_tokens: int,
        input_tokens: int,
        input_tokens_details: "_models.MemoryStoreOperationUsageInputTokensDetails",
        output_tokens: int,
        output_tokens_details: "_models.MemoryStoreOperationUsageOutputTokensDetails",
        total_tokens: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MemoryStoreOperationUsageInputTokensDetails(_Model):  # pylint: disable=name-too-long
    """MemoryStoreOperationUsageInputTokensDetails.

       :ivar cached_tokens: The number of tokens that were retrieved from the cache.
    `More on prompt caching </docs/guides/prompt-caching>`_. Required.
       :vartype cached_tokens: int
    """

    cached_tokens: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of tokens that were retrieved from the cache.
 `More on prompt caching </docs/guides/prompt-caching>`_. Required."""

    @overload
    def __init__(
        self,
        *,
        cached_tokens: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MemoryStoreOperationUsageOutputTokensDetails(_Model):  # pylint: disable=name-too-long
    """MemoryStoreOperationUsageOutputTokensDetails.

    :ivar reasoning_tokens: The number of reasoning tokens. Required.
    :vartype reasoning_tokens: int
    """

    reasoning_tokens: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of reasoning tokens. Required."""

    @overload
    def __init__(
        self,
        *,
        reasoning_tokens: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MemoryStoreSearchResponse(_Model):
    """Memory search response.

    :ivar search_id: The unique ID of this search request. Use this value as previous_search_id in
     subsequent requests to perform incremental searches. Required.
    :vartype search_id: str
    :ivar memories: Related memory items found during the search operation. Required.
    :vartype memories: list[~azure.ai.projects.models.MemorySearchItem]
    :ivar usage: Usage statistics associated with the memory search operation. Required.
    :vartype usage: ~azure.ai.projects.models.MemoryStoreOperationUsage
    """

    search_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique ID of this search request. Use this value as previous_search_id in subsequent
     requests to perform incremental searches. Required."""
    memories: list["_models.MemorySearchItem"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Related memory items found during the search operation. Required."""
    usage: "_models.MemoryStoreOperationUsage" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Usage statistics associated with the memory search operation. Required."""

    @overload
    def __init__(
        self,
        *,
        search_id: str,
        memories: list["_models.MemorySearchItem"],
        usage: "_models.MemoryStoreOperationUsage",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MemoryStoreUpdateResponse(_Model):
    """Provides the status of a memory store update operation.

    :ivar update_id: The unique ID of this update request. Use this value as previous_update_id in
     subsequent requests to perform incremental updates. Required.
    :vartype update_id: str
    :ivar status: The status of the memory update operation. One of "queued", "in_progress",
     "completed", "failed", or "superseded". Required. Known values are: "queued", "in_progress",
     "completed", "failed", and "superseded".
    :vartype status: str or ~azure.ai.projects.models.MemoryStoreUpdateStatus
    :ivar superseded_by: The update_id the operation was superseded by when status is "superseded".
    :vartype superseded_by: str
    :ivar result: The result of memory store update operation when status is "completed".
    :vartype result: ~azure.ai.projects.models.MemoryStoreUpdateResult
    :ivar error: Error object that describes the error when status is "failed".
    :vartype error: ~azure.ai.projects.models.ApiError
    """

    update_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique ID of this update request. Use this value as previous_update_id in subsequent
     requests to perform incremental updates. Required."""
    status: Union[str, "_models.MemoryStoreUpdateStatus"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The status of the memory update operation. One of \"queued\", \"in_progress\", \"completed\",
     \"failed\", or \"superseded\". Required. Known values are: \"queued\", \"in_progress\",
     \"completed\", \"failed\", and \"superseded\"."""
    superseded_by: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The update_id the operation was superseded by when status is \"superseded\"."""
    result: Optional["_models.MemoryStoreUpdateResult"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The result of memory store update operation when status is \"completed\"."""
    error: Optional["_models.ApiError"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Error object that describes the error when status is \"failed\"."""

    @overload
    def __init__(
        self,
        *,
        update_id: str,
        status: Union[str, "_models.MemoryStoreUpdateStatus"],
        superseded_by: Optional[str] = None,
        result: Optional["_models.MemoryStoreUpdateResult"] = None,
        error: Optional["_models.ApiError"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MemoryStoreUpdateResult(_Model):
    """Memory update result.

    :ivar memory_operations: A list of individual memory operations that were performed during the
     update. Required.
    :vartype memory_operations: list[~azure.ai.projects.models.MemoryOperation]
    :ivar usage: Usage statistics associated with the memory update operation. Required.
    :vartype usage: ~azure.ai.projects.models.MemoryStoreOperationUsage
    """

    memory_operations: list["_models.MemoryOperation"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of individual memory operations that were performed during the update. Required."""
    usage: "_models.MemoryStoreOperationUsage" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Usage statistics associated with the memory update operation. Required."""

    @overload
    def __init__(
        self,
        *,
        memory_operations: list["_models.MemoryOperation"],
        usage: "_models.MemoryStoreOperationUsage",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MicrosoftFabricAgentTool(Tool, discriminator="fabric_dataagent_preview"):
    """The input definition information for a Microsoft Fabric tool as used to configure an agent.

    :ivar type: The object type, which is always 'fabric_dataagent'. Required.
    :vartype type: str or ~azure.ai.projects.models.FABRIC_DATAAGENT_PREVIEW
    :ivar fabric_dataagent_preview: The fabric data agent tool parameters. Required.
    :vartype fabric_dataagent_preview: ~azure.ai.projects.models.FabricDataAgentToolParameters
    """

    type: Literal[ToolType.FABRIC_DATAAGENT_PREVIEW] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The object type, which is always 'fabric_dataagent'. Required."""
    fabric_dataagent_preview: "_models.FabricDataAgentToolParameters" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The fabric data agent tool parameters. Required."""

    @overload
    def __init__(
        self,
        *,
        fabric_dataagent_preview: "_models.FabricDataAgentToolParameters",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ToolType.FABRIC_DATAAGENT_PREVIEW  # type: ignore


class ModelDeployment(Deployment, discriminator="ModelDeployment"):
    """Model Deployment Definition.

    :ivar name: Name of the deployment. Required.
    :vartype name: str
    :ivar type: The type of the deployment. Required. Model deployment
    :vartype type: str or ~azure.ai.projects.models.MODEL_DEPLOYMENT
    :ivar model_name: Publisher-specific name of the deployed model. Required.
    :vartype model_name: str
    :ivar model_version: Publisher-specific version of the deployed model. Required.
    :vartype model_version: str
    :ivar model_publisher: Name of the deployed model's publisher. Required.
    :vartype model_publisher: str
    :ivar capabilities: Capabilities of deployed model. Required.
    :vartype capabilities: dict[str, str]
    :ivar sku: Sku of the model deployment. Required.
    :vartype sku: ~azure.ai.projects.models.ModelDeploymentSku
    :ivar connection_name: Name of the connection the deployment comes from.
    :vartype connection_name: str
    """

    type: Literal[DeploymentType.MODEL_DEPLOYMENT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the deployment. Required. Model deployment"""
    model_name: str = rest_field(name="modelName", visibility=["read"])
    """Publisher-specific name of the deployed model. Required."""
    model_version: str = rest_field(name="modelVersion", visibility=["read"])
    """Publisher-specific version of the deployed model. Required."""
    model_publisher: str = rest_field(name="modelPublisher", visibility=["read"])
    """Name of the deployed model's publisher. Required."""
    capabilities: dict[str, str] = rest_field(visibility=["read"])
    """Capabilities of deployed model. Required."""
    sku: "_models.ModelDeploymentSku" = rest_field(visibility=["read"])
    """Sku of the model deployment. Required."""
    connection_name: Optional[str] = rest_field(name="connectionName", visibility=["read"])
    """Name of the connection the deployment comes from."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = DeploymentType.MODEL_DEPLOYMENT  # type: ignore


class ModelDeploymentSku(_Model):
    """Sku information.

    :ivar capacity: Sku capacity. Required.
    :vartype capacity: int
    :ivar family: Sku family. Required.
    :vartype family: str
    :ivar name: Sku name. Required.
    :vartype name: str
    :ivar size: Sku size. Required.
    :vartype size: str
    :ivar tier: Sku tier. Required.
    :vartype tier: str
    """

    capacity: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Sku capacity. Required."""
    family: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Sku family. Required."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Sku name. Required."""
    size: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Sku size. Required."""
    tier: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Sku tier. Required."""

    @overload
    def __init__(
        self,
        *,
        capacity: int,
        family: str,
        name: str,
        size: str,
        tier: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class MonthlyRecurrenceSchedule(RecurrenceSchedule, discriminator="Monthly"):
    """Monthly recurrence schedule.

    :ivar type: Monthly recurrence type. Required. Monthly recurrence pattern.
    :vartype type: str or ~azure.ai.projects.models.MONTHLY
    :ivar days_of_month: Days of the month for the recurrence schedule. Required.
    :vartype days_of_month: list[int]
    """

    type: Literal[RecurrenceType.MONTHLY] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Monthly recurrence type. Required. Monthly recurrence pattern."""
    days_of_month: list[int] = rest_field(
        name="daysOfMonth", visibility=["read", "create", "update", "delete", "query"]
    )
    """Days of the month for the recurrence schedule. Required."""

    @overload
    def __init__(
        self,
        *,
        days_of_month: list[int],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = RecurrenceType.MONTHLY  # type: ignore


class NoAuthenticationCredentials(BaseCredentials, discriminator="None"):
    """Credentials that do not require authentication.

    :ivar type: The credential type. Required. No credential
    :vartype type: str or ~azure.ai.projects.models.NONE
    """

    type: Literal[CredentialType.NONE] = rest_discriminator(name="type", visibility=["read"])  # type: ignore
    """The credential type. Required. No credential"""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = CredentialType.NONE  # type: ignore


class OAuthConsentRequestItemResource(ItemResource, discriminator="oauth_consent_request"):
    """Request from the service for the user to perform OAuth consent.

    :ivar created_by: The information about the creator of the item.
    :vartype created_by: ~azure.ai.projects.models.CreatedBy
    :ivar id: Required.
    :vartype id: str
    :ivar type: Required.
    :vartype type: str or ~azure.ai.projects.models.OAUTH_CONSENT_REQUEST
    :ivar consent_link: The link the user can use to perform OAuth consent. Required.
    :vartype consent_link: str
    :ivar server_label: The server label for the OAuth consent request. Required.
    :vartype server_label: str
    """

    type: Literal[ItemType.OAUTH_CONSENT_REQUEST] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    consent_link: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The link the user can use to perform OAuth consent. Required."""
    server_label: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The server label for the OAuth consent request. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        consent_link: str,
        server_label: str,
        created_by: Optional["_models.CreatedBy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.OAUTH_CONSENT_REQUEST  # type: ignore


class OneTimeTrigger(Trigger, discriminator="OneTime"):
    """One-time trigger.

    :ivar type: Required. One-time trigger.
    :vartype type: str or ~azure.ai.projects.models.ONE_TIME
    :ivar trigger_at: Date and time for the one-time trigger in ISO 8601 format. Required.
    :vartype trigger_at: str
    :ivar time_zone: Time zone for the one-time trigger.
    :vartype time_zone: str
    """

    type: Literal[TriggerType.ONE_TIME] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. One-time trigger."""
    trigger_at: str = rest_field(name="triggerAt", visibility=["read", "create", "update", "delete", "query"])
    """Date and time for the one-time trigger in ISO 8601 format. Required."""
    time_zone: Optional[str] = rest_field(name="timeZone", visibility=["read", "create", "update", "delete", "query"])
    """Time zone for the one-time trigger."""

    @overload
    def __init__(
        self,
        *,
        trigger_at: str,
        time_zone: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = TriggerType.ONE_TIME  # type: ignore


class OpenApiAgentTool(Tool, discriminator="openapi"):
    """The input definition information for an OpenAPI tool as used to configure an agent.

    :ivar type: The object type, which is always 'openapi'. Required.
    :vartype type: str or ~azure.ai.projects.models.OPENAPI
    :ivar openapi: The openapi function definition. Required.
    :vartype openapi: ~azure.ai.projects.models.OpenApiFunctionDefinition
    """

    type: Literal[ToolType.OPENAPI] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The object type, which is always 'openapi'. Required."""
    openapi: "_models.OpenApiFunctionDefinition" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The openapi function definition. Required."""

    @overload
    def __init__(
        self,
        *,
        openapi: "_models.OpenApiFunctionDefinition",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ToolType.OPENAPI  # type: ignore


class OpenApiAuthDetails(_Model):
    """authentication details for OpenApiFunctionDefinition.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    OpenApiAnonymousAuthDetails, OpenApiManagedAuthDetails, OpenApiProjectConnectionAuthDetails

    :ivar type: The type of authentication, must be anonymous/project_connection/managed_identity.
     Required. Known values are: "anonymous", "project_connection", and "managed_identity".
    :vartype type: str or ~azure.ai.projects.models.OpenApiAuthType
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """The type of authentication, must be anonymous/project_connection/managed_identity. Required.
     Known values are: \"anonymous\", \"project_connection\", and \"managed_identity\"."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OpenApiAnonymousAuthDetails(OpenApiAuthDetails, discriminator="anonymous"):
    """Security details for OpenApi anonymous authentication.

    :ivar type: The object type, which is always 'anonymous'. Required.
    :vartype type: str or ~azure.ai.projects.models.ANONYMOUS
    """

    type: Literal[OpenApiAuthType.ANONYMOUS] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The object type, which is always 'anonymous'. Required."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = OpenApiAuthType.ANONYMOUS  # type: ignore


class OpenApiFunctionDefinition(_Model):
    """The input definition information for an openapi function.

    :ivar name: The name of the function to be called. Required.
    :vartype name: str
    :ivar description: A description of what the function does, used by the model to choose when
     and how to call the function.
    :vartype description: str
    :ivar spec: The openapi function shape, described as a JSON Schema object. Required.
    :vartype spec: any
    :ivar auth: Open API authentication details. Required.
    :vartype auth: ~azure.ai.projects.models.OpenApiAuthDetails
    :ivar default_params: List of OpenAPI spec parameters that will use user-provided defaults.
    :vartype default_params: list[str]
    :ivar functions: List of function definitions used by OpenApi tool.
    :vartype functions: list[~azure.ai.projects.models.OpenApiFunctionDefinitionFunction]
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the function to be called. Required."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A description of what the function does, used by the model to choose when and how to call the
     function."""
    spec: Any = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The openapi function shape, described as a JSON Schema object. Required."""
    auth: "_models.OpenApiAuthDetails" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Open API authentication details. Required."""
    default_params: Optional[list[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of OpenAPI spec parameters that will use user-provided defaults."""
    functions: Optional[list["_models.OpenApiFunctionDefinitionFunction"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """List of function definitions used by OpenApi tool."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        spec: Any,
        auth: "_models.OpenApiAuthDetails",
        description: Optional[str] = None,
        default_params: Optional[list[str]] = None,
        functions: Optional[list["_models.OpenApiFunctionDefinitionFunction"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OpenApiFunctionDefinitionFunction(_Model):
    """OpenApiFunctionDefinitionFunction.

    :ivar name: The name of the function to be called. Required.
    :vartype name: str
    :ivar description: A description of what the function does, used by the model to choose when
     and how to call the function.
    :vartype description: str
    :ivar parameters: The parameters the functions accepts, described as a JSON Schema object.
     Required.
    :vartype parameters: any
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the function to be called. Required."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A description of what the function does, used by the model to choose when and how to call the
     function."""
    parameters: Any = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The parameters the functions accepts, described as a JSON Schema object. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        parameters: Any,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OpenApiManagedAuthDetails(OpenApiAuthDetails, discriminator="managed_identity"):
    """Security details for OpenApi managed_identity authentication.

    :ivar type: The object type, which is always 'managed_identity'. Required.
    :vartype type: str or ~azure.ai.projects.models.MANAGED_IDENTITY
    :ivar security_scheme: Connection auth security details. Required.
    :vartype security_scheme: ~azure.ai.projects.models.OpenApiManagedSecurityScheme
    """

    type: Literal[OpenApiAuthType.MANAGED_IDENTITY] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The object type, which is always 'managed_identity'. Required."""
    security_scheme: "_models.OpenApiManagedSecurityScheme" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Connection auth security details. Required."""

    @overload
    def __init__(
        self,
        *,
        security_scheme: "_models.OpenApiManagedSecurityScheme",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = OpenApiAuthType.MANAGED_IDENTITY  # type: ignore


class OpenApiManagedSecurityScheme(_Model):
    """Security scheme for OpenApi managed_identity authentication.

    :ivar audience: Authentication scope for managed_identity auth type. Required.
    :vartype audience: str
    """

    audience: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Authentication scope for managed_identity auth type. Required."""

    @overload
    def __init__(
        self,
        *,
        audience: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OpenApiProjectConnectionAuthDetails(OpenApiAuthDetails, discriminator="project_connection"):
    """Security details for OpenApi project connection authentication.

    :ivar type: The object type, which is always 'project_connection'. Required.
    :vartype type: str or ~azure.ai.projects.models.PROJECT_CONNECTION
    :ivar security_scheme: Project connection auth security details. Required.
    :vartype security_scheme: ~azure.ai.projects.models.OpenApiProjectConnectionSecurityScheme
    """

    type: Literal[OpenApiAuthType.PROJECT_CONNECTION] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The object type, which is always 'project_connection'. Required."""
    security_scheme: "_models.OpenApiProjectConnectionSecurityScheme" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Project connection auth security details. Required."""

    @overload
    def __init__(
        self,
        *,
        security_scheme: "_models.OpenApiProjectConnectionSecurityScheme",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = OpenApiAuthType.PROJECT_CONNECTION  # type: ignore


class OpenApiProjectConnectionSecurityScheme(_Model):
    """Security scheme for OpenApi managed_identity authentication.

    :ivar project_connection_id: Project connection id for Project Connection auth type. Required.
    :vartype project_connection_id: str
    """

    project_connection_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Project connection id for Project Connection auth type. Required."""

    @overload
    def __init__(
        self,
        *,
        project_connection_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PagedScheduleRun(_Model):
    """Paged collection of ScheduleRun items.

    :ivar value: The ScheduleRun items on this page. Required.
    :vartype value: list[~azure.ai.projects.models.ScheduleRun]
    :ivar next_link: The link to the next page of items.
    :vartype next_link: str
    """

    value: list["_models.ScheduleRun"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ScheduleRun items on this page. Required."""
    next_link: Optional[str] = rest_field(name="nextLink", visibility=["read", "create", "update", "delete", "query"])
    """The link to the next page of items."""

    @overload
    def __init__(
        self,
        *,
        value: list["_models.ScheduleRun"],
        next_link: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PendingUploadRequest(_Model):
    """Represents a request for a pending upload.

    :ivar pending_upload_id: If PendingUploadId is not provided, a random GUID will be used.
    :vartype pending_upload_id: str
    :ivar connection_name: Azure Storage Account connection name to use for generating temporary
     SAS token.
    :vartype connection_name: str
    :ivar pending_upload_type: BlobReference is the only supported type. Required. Blob Reference
     is the only supported type.
    :vartype pending_upload_type: str or ~azure.ai.projects.models.BLOB_REFERENCE
    """

    pending_upload_id: Optional[str] = rest_field(
        name="pendingUploadId", visibility=["read", "create", "update", "delete", "query"]
    )
    """If PendingUploadId is not provided, a random GUID will be used."""
    connection_name: Optional[str] = rest_field(
        name="connectionName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Azure Storage Account connection name to use for generating temporary SAS token."""
    pending_upload_type: Literal[PendingUploadType.BLOB_REFERENCE] = rest_field(
        name="pendingUploadType", visibility=["read", "create", "update", "delete", "query"]
    )
    """BlobReference is the only supported type. Required. Blob Reference is the only supported type."""

    @overload
    def __init__(
        self,
        *,
        pending_upload_type: Literal[PendingUploadType.BLOB_REFERENCE],
        pending_upload_id: Optional[str] = None,
        connection_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PendingUploadResponse(_Model):
    """Represents the response for a pending upload request.

    :ivar blob_reference: Container-level read, write, list SAS. Required.
    :vartype blob_reference: ~azure.ai.projects.models.BlobReference
    :ivar pending_upload_id: ID for this upload request. Required.
    :vartype pending_upload_id: str
    :ivar version: Version of asset to be created if user did not specify version when initially
     creating upload.
    :vartype version: str
    :ivar pending_upload_type: BlobReference is the only supported type. Required. Blob Reference
     is the only supported type.
    :vartype pending_upload_type: str or ~azure.ai.projects.models.BLOB_REFERENCE
    """

    blob_reference: "_models.BlobReference" = rest_field(
        name="blobReference", visibility=["read", "create", "update", "delete", "query"]
    )
    """Container-level read, write, list SAS. Required."""
    pending_upload_id: str = rest_field(
        name="pendingUploadId", visibility=["read", "create", "update", "delete", "query"]
    )
    """ID for this upload request. Required."""
    version: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Version of asset to be created if user did not specify version when initially creating upload."""
    pending_upload_type: Literal[PendingUploadType.BLOB_REFERENCE] = rest_field(
        name="pendingUploadType", visibility=["read", "create", "update", "delete", "query"]
    )
    """BlobReference is the only supported type. Required. Blob Reference is the only supported type."""

    @overload
    def __init__(
        self,
        *,
        blob_reference: "_models.BlobReference",
        pending_upload_id: str,
        pending_upload_type: Literal[PendingUploadType.BLOB_REFERENCE],
        version: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Prompt(_Model):
    """Reference to a prompt template and its variables.
    `Learn more </docs/guides/text?api-mode=responses#reusable-prompts>`_.

        :ivar id: The unique identifier of the prompt template to use. Required.
        :vartype id: str
        :ivar version: Optional version of the prompt template.
        :vartype version: str
        :ivar variables:
        :vartype variables: ~azure.ai.projects.models.ResponsePromptVariables
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique identifier of the prompt template to use. Required."""
    version: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Optional version of the prompt template."""
    variables: Optional["_models.ResponsePromptVariables"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        version: Optional[str] = None,
        variables: Optional["_models.ResponsePromptVariables"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PromptAgentDefinition(AgentDefinition, discriminator="prompt"):
    """The prompt agent definition.

       :ivar rai_config: Configuration for Responsible AI (RAI) content filtering and safety features.
       :vartype rai_config: ~azure.ai.projects.models.RaiConfig
       :ivar kind: Required.
       :vartype kind: str or ~azure.ai.projects.models.PROMPT
       :ivar model: The model deployment to use for this agent. Required.
       :vartype model: str
       :ivar instructions: A system (or developer) message inserted into the model's context.
       :vartype instructions: str
       :ivar temperature: What sampling temperature to use, between 0 and 2. Higher values like 0.8
        will make the output more random, while lower values like 0.2 will make it more focused and
        deterministic.
    We generally recommend altering this or ``top_p`` but not both.
       :vartype temperature: float
       :ivar top_p: An alternative to sampling with temperature, called nucleus sampling,
    where the model considers the results of the tokens with top_p probability
    mass. So 0.1 means only the tokens comprising the top 10% probability mass
    are considered.
    We generally recommend altering this or ``temperature`` but not both.
       :vartype top_p: float
       :ivar reasoning:
       :vartype reasoning: ~azure.ai.projects.models.Reasoning
       :ivar tools: An array of tools the model may call while generating a response. You
    can specify which tool to use by setting the ``tool_choice`` parameter.
       :vartype tools: list[~azure.ai.projects.models.Tool]
       :ivar text: Configuration options for a text response from the model. Can be plain text or
        structured JSON data.
       :vartype text: ~azure.ai.projects.models.PromptAgentDefinitionText
       :ivar structured_inputs: Set of structured inputs that can participate in prompt template
        substitution or tool argument bindings.
       :vartype structured_inputs: dict[str, ~azure.ai.projects.models.StructuredInputDefinition]
    """

    kind: Literal[AgentKind.PROMPT] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    model: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The model deployment to use for this agent. Required."""
    instructions: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A system (or developer) message inserted into the model's context."""
    temperature: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output
     more random, while lower values like 0.2 will make it more focused and deterministic.
 We generally recommend altering this or ``top_p`` but not both."""
    top_p: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An alternative to sampling with temperature, called nucleus sampling,
 where the model considers the results of the tokens with top_p probability
 mass. So 0.1 means only the tokens comprising the top 10% probability mass
 are considered.
 We generally recommend altering this or ``temperature`` but not both."""
    reasoning: Optional["_models.Reasoning"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    tools: Optional[list["_models.Tool"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An array of tools the model may call while generating a response. You
 can specify which tool to use by setting the ``tool_choice`` parameter."""
    text: Optional["_models.PromptAgentDefinitionText"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Configuration options for a text response from the model. Can be plain text or structured JSON
     data."""
    structured_inputs: Optional[dict[str, "_models.StructuredInputDefinition"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Set of structured inputs that can participate in prompt template substitution or tool argument
     bindings."""

    @overload
    def __init__(
        self,
        *,
        model: str,
        rai_config: Optional["_models.RaiConfig"] = None,
        instructions: Optional[str] = None,
        temperature: Optional[float] = None,
        top_p: Optional[float] = None,
        reasoning: Optional["_models.Reasoning"] = None,
        tools: Optional[list["_models.Tool"]] = None,
        text: Optional["_models.PromptAgentDefinitionText"] = None,
        structured_inputs: Optional[dict[str, "_models.StructuredInputDefinition"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = AgentKind.PROMPT  # type: ignore


class PromptAgentDefinitionText(_Model):
    """PromptAgentDefinitionText.

    :ivar format:
    :vartype format: ~azure.ai.projects.models.ResponseTextFormatConfiguration
    """

    format: Optional["_models.ResponseTextFormatConfiguration"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )

    @overload
    def __init__(
        self,
        *,
        format: Optional["_models.ResponseTextFormatConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PromptBasedEvaluatorDefinition(EvaluatorDefinition, discriminator="prompt"):
    """Prompt-based evaluator.

    :ivar init_parameters: The JSON schema (Draft 2020-12) for the evaluator's input parameters.
     This includes parameters like type, properties, required.
    :vartype init_parameters: any
    :ivar data_schema: The JSON schema (Draft 2020-12) for the evaluator's input data. This
     includes parameters like type, properties, required.
    :vartype data_schema: any
    :ivar metrics: List of output metrics produced by this evaluator.
    :vartype metrics: dict[str, ~azure.ai.projects.models.EvaluatorMetric]
    :ivar type: Required. Prompt-based definition
    :vartype type: str or ~azure.ai.projects.models.PROMPT
    :ivar prompt_text: The prompt text used for evaluation. Required.
    :vartype prompt_text: str
    """

    type: Literal[EvaluatorDefinitionType.PROMPT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required. Prompt-based definition"""
    prompt_text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The prompt text used for evaluation. Required."""

    @overload
    def __init__(
        self,
        *,
        prompt_text: str,
        init_parameters: Optional[Any] = None,
        data_schema: Optional[Any] = None,
        metrics: Optional[dict[str, "_models.EvaluatorMetric"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = EvaluatorDefinitionType.PROMPT  # type: ignore


class ProtocolVersionRecord(_Model):
    """A record mapping for a single protocol and its version.

    :ivar protocol: The protocol type. Required. Known values are: "activity_protocol" and
     "responses".
    :vartype protocol: str or ~azure.ai.projects.models.AgentProtocol
    :ivar version: The version string for the protocol, e.g. 'v0.1.1'. Required.
    :vartype version: str
    """

    protocol: Union[str, "_models.AgentProtocol"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The protocol type. Required. Known values are: \"activity_protocol\" and \"responses\"."""
    version: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The version string for the protocol, e.g. 'v0.1.1'. Required."""

    @overload
    def __init__(
        self,
        *,
        protocol: Union[str, "_models.AgentProtocol"],
        version: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RaiConfig(_Model):
    """Configuration for Responsible AI (RAI) content filtering and safety features.

    :ivar rai_policy_name: The name of the RAI policy to apply. Required.
    :vartype rai_policy_name: str
    """

    rai_policy_name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the RAI policy to apply. Required."""

    @overload
    def __init__(
        self,
        *,
        rai_policy_name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class RankingOptions(_Model):
    """RankingOptions.

    :ivar ranker: The ranker to use for the file search. Is either a Literal["auto"] type or a
     Literal["default-2024-11-15"] type.
    :vartype ranker: str or str
    :ivar score_threshold: The score threshold for the file search, a number between 0 and 1.
     Numbers closer to 1 will attempt to return only the most relevant results, but may return fewer
     results.
    :vartype score_threshold: float
    """

    ranker: Optional[Literal["auto", "default-2024-11-15"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The ranker to use for the file search. Is either a Literal[\"auto\"] type or a
     Literal[\"default-2024-11-15\"] type."""
    score_threshold: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The score threshold for the file search, a number between 0 and 1. Numbers closer to 1 will
     attempt to return only the most relevant results, but may return fewer results."""

    @overload
    def __init__(
        self,
        *,
        ranker: Optional[Literal["auto", "default-2024-11-15"]] = None,
        score_threshold: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Reasoning(_Model):
    """**o-series models only**
    Configuration options for
    `reasoning models <https://platform.openai.com/docs/guides/reasoning>`_.

        :ivar effort: Known values are: "low", "medium", and "high".
        :vartype effort: str or ~azure.ai.projects.models.ReasoningEffort
        :ivar summary: A summary of the reasoning performed by the model. This can be
     useful for debugging and understanding the model's reasoning process.
     One of ``auto``, ``concise``, or ``detailed``. Is one of the following types: Literal["auto"],
         Literal["concise"], Literal["detailed"]
        :vartype summary: str or str or str
        :ivar generate_summary: **Deprecated:** use ``summary`` instead.
     A summary of the reasoning performed by the model. This can be
     useful for debugging and understanding the model's reasoning process.
     One of ``auto``, ``concise``, or ``detailed``. Is one of the following types: Literal["auto"],
         Literal["concise"], Literal["detailed"]
        :vartype generate_summary: str or str or str
    """

    effort: Optional[Union[str, "_models.ReasoningEffort"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Known values are: \"low\", \"medium\", and \"high\"."""
    summary: Optional[Literal["auto", "concise", "detailed"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A summary of the reasoning performed by the model. This can be
 useful for debugging and understanding the model's reasoning process.
 One of ``auto``, ``concise``, or ``detailed``. Is one of the following types:
     Literal[\"auto\"], Literal[\"concise\"], Literal[\"detailed\"]"""
    generate_summary: Optional[Literal["auto", "concise", "detailed"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """**Deprecated:** use ``summary`` instead.
 A summary of the reasoning performed by the model. This can be
 useful for debugging and understanding the model's reasoning process.
 One of ``auto``, ``concise``, or ``detailed``. Is one of the following types:
     Literal[\"auto\"], Literal[\"concise\"], Literal[\"detailed\"]"""

    @overload
    def __init__(
        self,
        *,
        effort: Optional[Union[str, "_models.ReasoningEffort"]] = None,
        summary: Optional[Literal["auto", "concise", "detailed"]] = None,
        generate_summary: Optional[Literal["auto", "concise", "detailed"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ReasoningItemParam(ItemParam, discriminator="reasoning"):
    """A description of the chain of thought used by a reasoning model while generating
    a response. Be sure to include these items in your ``input`` to the Responses API
    for subsequent turns of a conversation if you are manually
    `managing context </docs/guides/conversation-state>`_.

        :ivar type: Required.
        :vartype type: str or ~azure.ai.projects.models.REASONING
        :ivar encrypted_content: The encrypted content of the reasoning item - populated when a
         response is
     generated with ``reasoning.encrypted_content`` in the ``include`` parameter.
        :vartype encrypted_content: str
        :ivar summary: Reasoning text contents. Required.
        :vartype summary: list[~azure.ai.projects.models.ReasoningItemSummaryPart]
    """

    type: Literal[ItemType.REASONING] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    encrypted_content: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The encrypted content of the reasoning item - populated when a response is
 generated with ``reasoning.encrypted_content`` in the ``include`` parameter."""
    summary: list["_models.ReasoningItemSummaryPart"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Reasoning text contents. Required."""

    @overload
    def __init__(
        self,
        *,
        summary: list["_models.ReasoningItemSummaryPart"],
        encrypted_content: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.REASONING  # type: ignore


class ReasoningItemResource(ItemResource, discriminator="reasoning"):
    """A description of the chain of thought used by a reasoning model while generating
    a response. Be sure to include these items in your ``input`` to the Responses API
    for subsequent turns of a conversation if you are manually
    `managing context </docs/guides/conversation-state>`_.

        :ivar id: Required.
        :vartype id: str
        :ivar created_by: The information about the creator of the item.
        :vartype created_by: ~azure.ai.projects.models.CreatedBy
        :ivar type: Required.
        :vartype type: str or ~azure.ai.projects.models.REASONING
        :ivar encrypted_content: The encrypted content of the reasoning item - populated when a
         response is
     generated with ``reasoning.encrypted_content`` in the ``include`` parameter.
        :vartype encrypted_content: str
        :ivar summary: Reasoning text contents. Required.
        :vartype summary: list[~azure.ai.projects.models.ReasoningItemSummaryPart]
    """

    type: Literal[ItemType.REASONING] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    encrypted_content: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The encrypted content of the reasoning item - populated when a response is
 generated with ``reasoning.encrypted_content`` in the ``include`` parameter."""
    summary: list["_models.ReasoningItemSummaryPart"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Reasoning text contents. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        summary: list["_models.ReasoningItemSummaryPart"],
        created_by: Optional["_models.CreatedBy"] = None,
        encrypted_content: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.REASONING  # type: ignore


class ReasoningItemSummaryPart(_Model):
    """ReasoningItemSummaryPart.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ReasoningItemSummaryTextPart

    :ivar type: Required. "summary_text"
    :vartype type: str or ~azure.ai.projects.models.ReasoningItemSummaryPartType
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Required. \"summary_text\""""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ReasoningItemSummaryTextPart(ReasoningItemSummaryPart, discriminator="summary_text"):
    """ReasoningItemSummaryTextPart.

    :ivar type: Required.
    :vartype type: str or ~azure.ai.projects.models.SUMMARY_TEXT
    :ivar text: Required.
    :vartype text: str
    """

    type: Literal[ReasoningItemSummaryPartType.SUMMARY_TEXT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        text: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ReasoningItemSummaryPartType.SUMMARY_TEXT  # type: ignore


class RecurrenceTrigger(Trigger, discriminator="Recurrence"):
    """Recurrence based trigger.

    :ivar type: Type of the trigger. Required. Recurrence based trigger.
    :vartype type: str or ~azure.ai.projects.models.RECURRENCE
    :ivar start_time: Start time for the recurrence schedule in ISO 8601 format.
    :vartype start_time: str
    :ivar end_time: End time for the recurrence schedule in ISO 8601 format.
    :vartype end_time: str
    :ivar time_zone: Time zone for the recurrence schedule.
    :vartype time_zone: str
    :ivar interval: Interval for the recurrence schedule. Required.
    :vartype interval: int
    :ivar schedule: Recurrence schedule for the recurrence trigger. Required.
    :vartype schedule: ~azure.ai.projects.models.RecurrenceSchedule
    """

    type: Literal[TriggerType.RECURRENCE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Type of the trigger. Required. Recurrence based trigger."""
    start_time: Optional[str] = rest_field(name="startTime", visibility=["read", "create", "update", "delete", "query"])
    """Start time for the recurrence schedule in ISO 8601 format."""
    end_time: Optional[str] = rest_field(name="endTime", visibility=["read", "create", "update", "delete", "query"])
    """End time for the recurrence schedule in ISO 8601 format."""
    time_zone: Optional[str] = rest_field(name="timeZone", visibility=["read", "create", "update", "delete", "query"])
    """Time zone for the recurrence schedule."""
    interval: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Interval for the recurrence schedule. Required."""
    schedule: "_models.RecurrenceSchedule" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Recurrence schedule for the recurrence trigger. Required."""

    @overload
    def __init__(
        self,
        *,
        interval: int,
        schedule: "_models.RecurrenceSchedule",
        start_time: Optional[str] = None,
        end_time: Optional[str] = None,
        time_zone: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = TriggerType.RECURRENCE  # type: ignore


class RedTeam(_Model):
    """Red team details.

    :ivar name: Identifier of the red team run. Required.
    :vartype name: str
    :ivar display_name: Name of the red-team run.
    :vartype display_name: str
    :ivar num_turns: Number of simulation rounds.
    :vartype num_turns: int
    :ivar attack_strategies: List of attack strategies or nested lists of attack strategies.
    :vartype attack_strategies: list[str or ~azure.ai.projects.models.AttackStrategy]
    :ivar simulation_only: Simulation-only or Simulation + Evaluation. Default false, if true the
     scan outputs conversation not evaluation result.
    :vartype simulation_only: bool
    :ivar risk_categories: List of risk categories to generate attack objectives for.
    :vartype risk_categories: list[str or ~azure.ai.projects.models.RiskCategory]
    :ivar application_scenario: Application scenario for the red team operation, to generate
     scenario specific attacks.
    :vartype application_scenario: str
    :ivar tags: Red team's tags. Unlike properties, tags are fully mutable.
    :vartype tags: dict[str, str]
    :ivar properties: Red team's properties. Unlike tags, properties are add-only. Once added, a
     property cannot be removed.
    :vartype properties: dict[str, str]
    :ivar status: Status of the red-team. It is set by service and is read-only.
    :vartype status: str
    :ivar target: Target configuration for the red-team run. Required.
    :vartype target: ~azure.ai.projects.models.TargetConfig
    """

    name: str = rest_field(name="id", visibility=["read"])
    """Identifier of the red team run. Required."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Name of the red-team run."""
    num_turns: Optional[int] = rest_field(name="numTurns", visibility=["read", "create", "update", "delete", "query"])
    """Number of simulation rounds."""
    attack_strategies: Optional[list[Union[str, "_models.AttackStrategy"]]] = rest_field(
        name="attackStrategies", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of attack strategies or nested lists of attack strategies."""
    simulation_only: Optional[bool] = rest_field(
        name="simulationOnly", visibility=["read", "create", "update", "delete", "query"]
    )
    """Simulation-only or Simulation + Evaluation. Default false, if true the scan outputs
     conversation not evaluation result."""
    risk_categories: Optional[list[Union[str, "_models.RiskCategory"]]] = rest_field(
        name="riskCategories", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of risk categories to generate attack objectives for."""
    application_scenario: Optional[str] = rest_field(
        name="applicationScenario", visibility=["read", "create", "update", "delete", "query"]
    )
    """Application scenario for the red team operation, to generate scenario specific attacks."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Red team's tags. Unlike properties, tags are fully mutable."""
    properties: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Red team's properties. Unlike tags, properties are add-only. Once added, a property cannot be
     removed."""
    status: Optional[str] = rest_field(visibility=["read"])
    """Status of the red-team. It is set by service and is read-only."""
    target: "_models.TargetConfig" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Target configuration for the red-team run. Required."""

    @overload
    def __init__(
        self,
        *,
        target: "_models.TargetConfig",
        display_name: Optional[str] = None,
        num_turns: Optional[int] = None,
        attack_strategies: Optional[list[Union[str, "_models.AttackStrategy"]]] = None,
        simulation_only: Optional[bool] = None,
        risk_categories: Optional[list[Union[str, "_models.RiskCategory"]]] = None,
        application_scenario: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        properties: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Response(_Model):
    """Response.

    :ivar metadata: Set of 16 key-value pairs that can be attached to an object. This can be
useful for storing additional information about the object in a structured
format, and querying for objects via API or the dashboard.
Keys are strings with a maximum length of 64 characters. Values are strings
with a maximum length of 512 characters. Required.
    :vartype metadata: dict[str, str]
    :ivar temperature: What sampling temperature to use, between 0 and 2. Higher values like 0.8
    will make the output more random, while lower values like 0.2 will make it more focused and
    deterministic.
We generally recommend altering this or ``top_p`` but not both. Required.
    :vartype temperature: float
    :ivar top_p: An alternative to sampling with temperature, called nucleus sampling,
where the model considers the results of the tokens with top_p probability
mass. So 0.1 means only the tokens comprising the top 10% probability mass
are considered.
We generally recommend altering this or ``temperature`` but not both. Required.
    :vartype top_p: float
    :ivar user: A unique identifier representing your end-user, which can help OpenAI to monitor
    and detect abuse. `Learn more </docs/guides/safety-best-practices#end-user-ids>`_. Required.
    :vartype user: str
    :ivar service_tier: Note: service_tier is not applicable to Azure OpenAI. Known values are:
    "auto", "default", "flex", "scale", and "priority".
    :vartype service_tier: str or ~azure.ai.projects.models.ServiceTier
    :ivar top_logprobs: An integer between 0 and 20 specifying the number of most likely tokens to
    return at each token position, each with an associated log probability.
    :vartype top_logprobs: int
    :ivar previous_response_id: The unique ID of the previous response to the model. Use this to
create multi-turn conversations. Learn more about
`conversation state </docs/guides/conversation-state>`_.
    :vartype previous_response_id: str
    :ivar model: The model deployment to use for the creation of this response.
    :vartype model: str
    :ivar reasoning:
    :vartype reasoning: ~azure.ai.projects.models.Reasoning
    :ivar background: Whether to run the model response in the background.
`Learn more </docs/guides/background>`_.
    :vartype background: bool
    :ivar max_output_tokens: An upper bound for the number of tokens that can be generated for a
    response, including visible output tokens and `reasoning tokens </docs/guides/reasoning>`_.
    :vartype max_output_tokens: int
    :ivar max_tool_calls: The maximum number of total calls to built-in tools that can be processed
    in a response. This maximum number applies across all built-in tool calls, not per individual
    tool. Any further attempts to call a tool by the model will be ignored.
    :vartype max_tool_calls: int
    :ivar text: Configuration options for a text response from the model. Can be plain
text or structured JSON data. Learn more:
    * [Text inputs and outputs](/docs/guides/text)
    * [Structured Outputs](/docs/guides/structured-outputs).
    :vartype text: ~azure.ai.projects.models.ResponseText
    :ivar tools: An array of tools the model may call while generating a response. You
can specify which tool to use by setting the ``tool_choice`` parameter.
The two categories of tools you can provide the model are:
    * **Built-in tools**: Tools that are provided by OpenAI that extend the
model's capabilities, like [web search](/docs/guides/tools-web-search)
or [file search](/docs/guides/tools-file-search). Learn more about
[built-in tools](/docs/guides/tools).
    * **Function calls (custom tools)**: Functions that are defined by you,
enabling the model to call your own code. Learn more about
[function calling](/docs/guides/function-calling).
    :vartype tools: list[~azure.ai.projects.models.Tool]
    :ivar tool_choice: How the model should select which tool (or tools) to use when generating
a response. See the ``tools`` parameter to see how to specify which tools
the model can call. Is either a Union[str, "_models.ToolChoiceOptions"] type or a
    ToolChoiceObject type.
    :vartype tool_choice: str or ~azure.ai.projects.models.ToolChoiceOptions or
    ~azure.ai.projects.models.ToolChoiceObject
    :ivar prompt:
    :vartype prompt: ~azure.ai.projects.models.Prompt
    :ivar truncation: The truncation strategy to use for the model response.
    * `auto`: If the context of this response and previous ones exceeds
the model's context window size, the model will truncate the
response to fit the context window by dropping input items in the
middle of the conversation.
    * `disabled` (default): If a model response will exceed the context window
size for a model, the request will fail with a 400 error. Is either a Literal["auto"] type or a
    Literal["disabled"] type.
    :vartype truncation: str or str
    :ivar id: Unique identifier for this Response. Required.
    :vartype id: str
    :ivar object: The object type of this resource - always set to ``response``. Required. Default
    value is "response".
    :vartype object: str
    :ivar status: The status of the response generation. One of ``completed``, ``failed``,
``in_progress``, ``cancelled``, ``queued``, or ``incomplete``. Is one of the following types:
    Literal["completed"], Literal["failed"], Literal["in_progress"], Literal["cancelled"],
    Literal["queued"], Literal["incomplete"]
    :vartype status: str or str or str or str or str or str
    :ivar created_at: Unix timestamp (in seconds) of when this Response was created. Required.
    :vartype created_at: ~datetime.datetime
    :ivar error: Required.
    :vartype error: ~azure.ai.projects.models.ResponseError
    :ivar incomplete_details: Details about why the response is incomplete. Required.
    :vartype incomplete_details: ~azure.ai.projects.models.ResponseIncompleteDetails1
    :ivar output: An array of content items generated by the model.
    * The length and order of items in the `output` array is dependent
on the model's response.
    * Rather than accessing the first item in the `output` array and
assuming it's an `assistant` message with the content generated by
the model, you might consider using the `output_text` property where
supported in SDKs. Required.
    :vartype output: list[~azure.ai.projects.models.ItemResource]
    :ivar instructions: A system (or developer) message inserted into the model's context.
When using along with ``previous_response_id``, the instructions from a previous
response will not be carried over to the next response. This makes it simple
to swap out system (or developer) messages in new responses. Required. Is either a str type or
    a [ItemParam] type.
    :vartype instructions: str or list[~azure.ai.projects.models.ItemParam]
    :ivar output_text: SDK-only convenience property that contains the aggregated text output
from all ``output_text`` items in the ``output`` array, if any are present.
Supported in the Python and JavaScript SDKs.
    :vartype output_text: str
    :ivar usage:
    :vartype usage: ~azure.ai.projects.models.ResponseUsage
    :ivar parallel_tool_calls: Whether to allow the model to run tool calls in parallel. Required.
    :vartype parallel_tool_calls: bool
    :ivar conversation: Required.
    :vartype conversation: ~azure.ai.projects.models.ResponseConversation1
    :ivar agent: The agent used for this response.
    :vartype agent: ~azure.ai.projects.models.AgentId
    :ivar structured_inputs: The structured inputs to the response that can participate in prompt
    template substitution or tool argument bindings.
    :vartype structured_inputs: dict[str, any]
    """

    metadata: dict[str, str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Set of 16 key-value pairs that can be attached to an object. This can be
 useful for storing additional information about the object in a structured
 format, and querying for objects via API or the dashboard.
 Keys are strings with a maximum length of 64 characters. Values are strings
 with a maximum length of 512 characters. Required."""
    temperature: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """What sampling temperature to use, between 0 and 2. Higher values like 0.8 will make the output
     more random, while lower values like 0.2 will make it more focused and deterministic.
 We generally recommend altering this or ``top_p`` but not both. Required."""
    top_p: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An alternative to sampling with temperature, called nucleus sampling,
 where the model considers the results of the tokens with top_p probability
 mass. So 0.1 means only the tokens comprising the top 10% probability mass
 are considered.
 We generally recommend altering this or ``temperature`` but not both. Required."""
    user: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A unique identifier representing your end-user, which can help OpenAI to monitor and detect
     abuse. `Learn more </docs/guides/safety-best-practices#end-user-ids>`_. Required."""
    service_tier: Optional[Union[str, "_models.ServiceTier"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Note: service_tier is not applicable to Azure OpenAI. Known values are: \"auto\", \"default\",
     \"flex\", \"scale\", and \"priority\"."""
    top_logprobs: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An integer between 0 and 20 specifying the number of most likely tokens to return at each token
     position, each with an associated log probability."""
    previous_response_id: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique ID of the previous response to the model. Use this to
 create multi-turn conversations. Learn more about
 `conversation state </docs/guides/conversation-state>`_."""
    model: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The model deployment to use for the creation of this response."""
    reasoning: Optional["_models.Reasoning"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    background: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Whether to run the model response in the background.
 `Learn more </docs/guides/background>`_."""
    max_output_tokens: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An upper bound for the number of tokens that can be generated for a response, including visible
     output tokens and `reasoning tokens </docs/guides/reasoning>`_."""
    max_tool_calls: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The maximum number of total calls to built-in tools that can be processed in a response. This
     maximum number applies across all built-in tool calls, not per individual tool. Any further
     attempts to call a tool by the model will be ignored."""
    text: Optional["_models.ResponseText"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Configuration options for a text response from the model. Can be plain
 text or structured JSON data. Learn more:
     * [Text inputs and outputs](/docs/guides/text)
     * [Structured Outputs](/docs/guides/structured-outputs)."""
    tools: Optional[list["_models.Tool"]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An array of tools the model may call while generating a response. You
 can specify which tool to use by setting the ``tool_choice`` parameter.
 The two categories of tools you can provide the model are:
     * **Built-in tools**: Tools that are provided by OpenAI that extend the
 model's capabilities, like [web search](/docs/guides/tools-web-search)
 or [file search](/docs/guides/tools-file-search). Learn more about
 [built-in tools](/docs/guides/tools).
     * **Function calls (custom tools)**: Functions that are defined by you,
 enabling the model to call your own code. Learn more about
 [function calling](/docs/guides/function-calling)."""
    tool_choice: Optional[Union[str, "_models.ToolChoiceOptions", "_models.ToolChoiceObject"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """How the model should select which tool (or tools) to use when generating
 a response. See the ``tools`` parameter to see how to specify which tools
 the model can call. Is either a Union[str, \"_models.ToolChoiceOptions\"] type or a
     ToolChoiceObject type."""
    prompt: Optional["_models.Prompt"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    truncation: Optional[Literal["auto", "disabled"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The truncation strategy to use for the model response.
     * `auto`: If the context of this response and previous ones exceeds
 the model's context window size, the model will truncate the
 response to fit the context window by dropping input items in the
 middle of the conversation.
     * `disabled` (default): If a model response will exceed the context window
 size for a model, the request will fail with a 400 error. Is either a Literal[\"auto\"] type or
     a Literal[\"disabled\"] type."""
    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique identifier for this Response. Required."""
    object: Literal["response"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The object type of this resource - always set to ``response``. Required. Default value is
     \"response\"."""
    status: Optional[Literal["completed", "failed", "in_progress", "cancelled", "queued", "incomplete"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The status of the response generation. One of ``completed``, ``failed``,
 ``in_progress``, ``cancelled``, ``queued``, or ``incomplete``. Is one of the following types:
     Literal[\"completed\"], Literal[\"failed\"], Literal[\"in_progress\"], Literal[\"cancelled\"],
     Literal[\"queued\"], Literal[\"incomplete\"]"""
    created_at: datetime.datetime = rest_field(
        visibility=["read", "create", "update", "delete", "query"], format="unix-timestamp"
    )
    """Unix timestamp (in seconds) of when this Response was created. Required."""
    error: "_models.ResponseError" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    incomplete_details: "_models.ResponseIncompleteDetails1" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Details about why the response is incomplete. Required."""
    output: list["_models.ItemResource"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An array of content items generated by the model.
     * The length and order of items in the `output` array is dependent
 on the model's response.
     * Rather than accessing the first item in the `output` array and
 assuming it's an `assistant` message with the content generated by
 the model, you might consider using the `output_text` property where
 supported in SDKs. Required."""
    instructions: Union[str, list["_models.ItemParam"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A system (or developer) message inserted into the model's context.
 When using along with ``previous_response_id``, the instructions from a previous
 response will not be carried over to the next response. This makes it simple
 to swap out system (or developer) messages in new responses. Required. Is either a str type or
     a [ItemParam] type."""
    output_text: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """SDK-only convenience property that contains the aggregated text output
 from all ``output_text`` items in the ``output`` array, if any are present.
 Supported in the Python and JavaScript SDKs."""
    usage: Optional["_models.ResponseUsage"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    parallel_tool_calls: bool = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Whether to allow the model to run tool calls in parallel. Required."""
    conversation: "_models.ResponseConversation1" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Required."""
    agent: Optional["_models.AgentId"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The agent used for this response."""
    structured_inputs: Optional[dict[str, Any]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The structured inputs to the response that can participate in prompt template substitution or
     tool argument bindings."""

    @overload
    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        metadata: dict[str, str],
        temperature: float,
        top_p: float,
        user: str,
        id: str,  # pylint: disable=redefined-builtin
        created_at: datetime.datetime,
        error: "_models.ResponseError",
        incomplete_details: "_models.ResponseIncompleteDetails1",
        output: list["_models.ItemResource"],
        instructions: Union[str, list["_models.ItemParam"]],
        parallel_tool_calls: bool,
        conversation: "_models.ResponseConversation1",
        service_tier: Optional[Union[str, "_models.ServiceTier"]] = None,
        top_logprobs: Optional[int] = None,
        previous_response_id: Optional[str] = None,
        model: Optional[str] = None,
        reasoning: Optional["_models.Reasoning"] = None,
        background: Optional[bool] = None,
        max_output_tokens: Optional[int] = None,
        max_tool_calls: Optional[int] = None,
        text: Optional["_models.ResponseText"] = None,
        tools: Optional[list["_models.Tool"]] = None,
        tool_choice: Optional[Union[str, "_models.ToolChoiceOptions", "_models.ToolChoiceObject"]] = None,
        prompt: Optional["_models.Prompt"] = None,
        truncation: Optional[Literal["auto", "disabled"]] = None,
        status: Optional[Literal["completed", "failed", "in_progress", "cancelled", "queued", "incomplete"]] = None,
        output_text: Optional[str] = None,
        usage: Optional["_models.ResponseUsage"] = None,
        agent: Optional["_models.AgentId"] = None,
        structured_inputs: Optional[dict[str, Any]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.object: Literal["response"] = "response"


class ResponseStreamEvent(_Model):
    """ResponseStreamEvent.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ResponseErrorEvent, ResponseCodeInterpreterCallCompletedEvent,
    ResponseCodeInterpreterCallInProgressEvent, ResponseCodeInterpreterCallInterpretingEvent,
    ResponseCodeInterpreterCallCodeDeltaEvent, ResponseCodeInterpreterCallCodeDoneEvent,
    ResponseCompletedEvent, ResponseContentPartAddedEvent, ResponseContentPartDoneEvent,
    ResponseCreatedEvent, ResponseFailedEvent, ResponseFileSearchCallCompletedEvent,
    ResponseFileSearchCallInProgressEvent, ResponseFileSearchCallSearchingEvent,
    ResponseFunctionCallArgumentsDeltaEvent, ResponseFunctionCallArgumentsDoneEvent,
    ResponseImageGenCallCompletedEvent, ResponseImageGenCallGeneratingEvent,
    ResponseImageGenCallInProgressEvent, ResponseImageGenCallPartialImageEvent,
    ResponseInProgressEvent, ResponseIncompleteEvent, ResponseMCPCallArgumentsDeltaEvent,
    ResponseMCPCallArgumentsDoneEvent, ResponseMCPCallCompletedEvent, ResponseMCPCallFailedEvent,
    ResponseMCPCallInProgressEvent, ResponseMCPListToolsCompletedEvent,
    ResponseMCPListToolsFailedEvent, ResponseMCPListToolsInProgressEvent,
    ResponseOutputItemAddedEvent, ResponseOutputItemDoneEvent, ResponseTextDeltaEvent,
    ResponseTextDoneEvent, ResponseQueuedEvent, ResponseReasoningDeltaEvent,
    ResponseReasoningDoneEvent, ResponseReasoningSummaryDeltaEvent,
    ResponseReasoningSummaryDoneEvent, ResponseReasoningSummaryPartAddedEvent,
    ResponseReasoningSummaryPartDoneEvent, ResponseReasoningSummaryTextDeltaEvent,
    ResponseReasoningSummaryTextDoneEvent, ResponseRefusalDeltaEvent, ResponseRefusalDoneEvent,
    ResponseWebSearchCallCompletedEvent, ResponseWebSearchCallInProgressEvent,
    ResponseWebSearchCallSearchingEvent

    :ivar type: Required. Known values are: "response.audio.delta", "response.audio.done",
     "response.audio_transcript.delta", "response.audio_transcript.done",
     "response.code_interpreter_call_code.delta", "response.code_interpreter_call_code.done",
     "response.code_interpreter_call.completed", "response.code_interpreter_call.in_progress",
     "response.code_interpreter_call.interpreting", "response.completed",
     "response.content_part.added", "response.content_part.done", "response.created", "error",
     "response.file_search_call.completed", "response.file_search_call.in_progress",
     "response.file_search_call.searching", "response.function_call_arguments.delta",
     "response.function_call_arguments.done", "response.in_progress", "response.failed",
     "response.incomplete", "response.output_item.added", "response.output_item.done",
     "response.refusal.delta", "response.refusal.done", "response.output_text.annotation.added",
     "response.output_text.delta", "response.output_text.done",
     "response.reasoning_summary_part.added", "response.reasoning_summary_part.done",
     "response.reasoning_summary_text.delta", "response.reasoning_summary_text.done",
     "response.web_search_call.completed", "response.web_search_call.in_progress",
     "response.web_search_call.searching", "response.image_generation_call.completed",
     "response.image_generation_call.generating", "response.image_generation_call.in_progress",
     "response.image_generation_call.partial_image", "response.mcp_call.arguments_delta",
     "response.mcp_call.arguments_done", "response.mcp_call.completed", "response.mcp_call.failed",
     "response.mcp_call.in_progress", "response.mcp_list_tools.completed",
     "response.mcp_list_tools.failed", "response.mcp_list_tools.in_progress", "response.queued",
     "response.reasoning.delta", "response.reasoning.done", "response.reasoning_summary.delta", and
     "response.reasoning_summary.done".
    :vartype type: str or ~azure.ai.projects.models.ResponseStreamEventType
    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Required. Known values are: \"response.audio.delta\", \"response.audio.done\",
     \"response.audio_transcript.delta\", \"response.audio_transcript.done\",
     \"response.code_interpreter_call_code.delta\", \"response.code_interpreter_call_code.done\",
     \"response.code_interpreter_call.completed\", \"response.code_interpreter_call.in_progress\",
     \"response.code_interpreter_call.interpreting\", \"response.completed\",
     \"response.content_part.added\", \"response.content_part.done\", \"response.created\",
     \"error\", \"response.file_search_call.completed\", \"response.file_search_call.in_progress\",
     \"response.file_search_call.searching\", \"response.function_call_arguments.delta\",
     \"response.function_call_arguments.done\", \"response.in_progress\", \"response.failed\",
     \"response.incomplete\", \"response.output_item.added\", \"response.output_item.done\",
     \"response.refusal.delta\", \"response.refusal.done\",
     \"response.output_text.annotation.added\", \"response.output_text.delta\",
     \"response.output_text.done\", \"response.reasoning_summary_part.added\",
     \"response.reasoning_summary_part.done\", \"response.reasoning_summary_text.delta\",
     \"response.reasoning_summary_text.done\", \"response.web_search_call.completed\",
     \"response.web_search_call.in_progress\", \"response.web_search_call.searching\",
     \"response.image_generation_call.completed\", \"response.image_generation_call.generating\",
     \"response.image_generation_call.in_progress\",
     \"response.image_generation_call.partial_image\", \"response.mcp_call.arguments_delta\",
     \"response.mcp_call.arguments_done\", \"response.mcp_call.completed\",
     \"response.mcp_call.failed\", \"response.mcp_call.in_progress\",
     \"response.mcp_list_tools.completed\", \"response.mcp_list_tools.failed\",
     \"response.mcp_list_tools.in_progress\", \"response.queued\", \"response.reasoning.delta\",
     \"response.reasoning.done\", \"response.reasoning_summary.delta\", and
     \"response.reasoning_summary.done\"."""
    sequence_number: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The sequence number for this event. Required."""

    @overload
    def __init__(
        self,
        *,
        type: str,
        sequence_number: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResponseCodeInterpreterCallCodeDeltaEvent(
    ResponseStreamEvent, discriminator="response.code_interpreter_call_code.delta"
):  # pylint: disable=name-too-long
    """Emitted when a partial code snippet is streamed by the code interpreter.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always ``response.code_interpreter_call_code.delta``.
     Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_CODE_INTERPRETER_CALL_CODE_DELTA
    :ivar output_index: The index of the output item in the response for which the code is being
     streamed. Required.
    :vartype output_index: int
    :ivar item_id: The unique identifier of the code interpreter tool call item. Required.
    :vartype item_id: str
    :ivar delta: The partial code snippet being streamed by the code interpreter. Required.
    :vartype delta: str
    """

    type: Literal[ResponseStreamEventType.RESPONSE_CODE_INTERPRETER_CALL_CODE_DELTA] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always ``response.code_interpreter_call_code.delta``. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response for which the code is being streamed. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique identifier of the code interpreter tool call item. Required."""
    delta: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The partial code snippet being streamed by the code interpreter. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        output_index: int,
        item_id: str,
        delta: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_CODE_INTERPRETER_CALL_CODE_DELTA  # type: ignore


class ResponseCodeInterpreterCallCodeDoneEvent(
    ResponseStreamEvent, discriminator="response.code_interpreter_call_code.done"
):
    """Emitted when the code snippet is finalized by the code interpreter.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always ``response.code_interpreter_call_code.done``.
     Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_CODE_INTERPRETER_CALL_CODE_DONE
    :ivar output_index: The index of the output item in the response for which the code is
     finalized. Required.
    :vartype output_index: int
    :ivar item_id: The unique identifier of the code interpreter tool call item. Required.
    :vartype item_id: str
    :ivar code: The final code snippet output by the code interpreter. Required.
    :vartype code: str
    """

    type: Literal[ResponseStreamEventType.RESPONSE_CODE_INTERPRETER_CALL_CODE_DONE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always ``response.code_interpreter_call_code.done``. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response for which the code is finalized. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique identifier of the code interpreter tool call item. Required."""
    code: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The final code snippet output by the code interpreter. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        output_index: int,
        item_id: str,
        code: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_CODE_INTERPRETER_CALL_CODE_DONE  # type: ignore


class ResponseCodeInterpreterCallCompletedEvent(
    ResponseStreamEvent, discriminator="response.code_interpreter_call.completed"
):  # pylint: disable=name-too-long
    """Emitted when the code interpreter call is completed.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always ``response.code_interpreter_call.completed``.
     Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_CODE_INTERPRETER_CALL_COMPLETED
    :ivar output_index: The index of the output item in the response for which the code interpreter
     call is completed. Required.
    :vartype output_index: int
    :ivar item_id: The unique identifier of the code interpreter tool call item. Required.
    :vartype item_id: str
    """

    type: Literal[ResponseStreamEventType.RESPONSE_CODE_INTERPRETER_CALL_COMPLETED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always ``response.code_interpreter_call.completed``. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response for which the code interpreter call is completed.
     Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique identifier of the code interpreter tool call item. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        output_index: int,
        item_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_CODE_INTERPRETER_CALL_COMPLETED  # type: ignore


class ResponseCodeInterpreterCallInProgressEvent(
    ResponseStreamEvent, discriminator="response.code_interpreter_call.in_progress"
):  # pylint: disable=name-too-long
    """Emitted when a code interpreter call is in progress.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always ``response.code_interpreter_call.in_progress``.
     Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_CODE_INTERPRETER_CALL_IN_PROGRESS
    :ivar output_index: The index of the output item in the response for which the code interpreter
     call is in progress. Required.
    :vartype output_index: int
    :ivar item_id: The unique identifier of the code interpreter tool call item. Required.
    :vartype item_id: str
    """

    type: Literal[ResponseStreamEventType.RESPONSE_CODE_INTERPRETER_CALL_IN_PROGRESS] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always ``response.code_interpreter_call.in_progress``. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response for which the code interpreter call is in
     progress. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique identifier of the code interpreter tool call item. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        output_index: int,
        item_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_CODE_INTERPRETER_CALL_IN_PROGRESS  # type: ignore


class ResponseCodeInterpreterCallInterpretingEvent(
    ResponseStreamEvent, discriminator="response.code_interpreter_call.interpreting"
):  # pylint: disable=name-too-long
    """Emitted when the code interpreter is actively interpreting the code snippet.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always ``response.code_interpreter_call.interpreting``.
     Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_CODE_INTERPRETER_CALL_INTERPRETING
    :ivar output_index: The index of the output item in the response for which the code interpreter
     is interpreting code. Required.
    :vartype output_index: int
    :ivar item_id: The unique identifier of the code interpreter tool call item. Required.
    :vartype item_id: str
    """

    type: Literal[ResponseStreamEventType.RESPONSE_CODE_INTERPRETER_CALL_INTERPRETING] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always ``response.code_interpreter_call.interpreting``. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response for which the code interpreter is interpreting
     code. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique identifier of the code interpreter tool call item. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        output_index: int,
        item_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_CODE_INTERPRETER_CALL_INTERPRETING  # type: ignore


class ResponseCompletedEvent(ResponseStreamEvent, discriminator="response.completed"):
    """Emitted when the model response is complete.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always ``response.completed``. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_COMPLETED
    :ivar response: Properties of the completed response. Required.
    :vartype response: ~azure.ai.projects.models.Response
    """

    type: Literal[ResponseStreamEventType.RESPONSE_COMPLETED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always ``response.completed``. Required."""
    response: "_models.Response" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Properties of the completed response. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        response: "_models.Response",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_COMPLETED  # type: ignore


class ResponseContentPartAddedEvent(ResponseStreamEvent, discriminator="response.content_part.added"):
    """Emitted when a new content part is added.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always ``response.content_part.added``. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_CONTENT_PART_ADDED
    :ivar item_id: The ID of the output item that the content part was added to. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item that the content part was added to. Required.
    :vartype output_index: int
    :ivar content_index: The index of the content part that was added. Required.
    :vartype content_index: int
    :ivar part: The content part that was added. Required.
    :vartype part: ~azure.ai.projects.models.ItemContent
    """

    type: Literal[ResponseStreamEventType.RESPONSE_CONTENT_PART_ADDED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always ``response.content_part.added``. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the output item that the content part was added to. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item that the content part was added to. Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the content part that was added. Required."""
    part: "_models.ItemContent" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The content part that was added. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        item_id: str,
        output_index: int,
        content_index: int,
        part: "_models.ItemContent",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_CONTENT_PART_ADDED  # type: ignore


class ResponseContentPartDoneEvent(ResponseStreamEvent, discriminator="response.content_part.done"):
    """Emitted when a content part is done.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always ``response.content_part.done``. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_CONTENT_PART_DONE
    :ivar item_id: The ID of the output item that the content part was added to. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item that the content part was added to. Required.
    :vartype output_index: int
    :ivar content_index: The index of the content part that is done. Required.
    :vartype content_index: int
    :ivar part: The content part that is done. Required.
    :vartype part: ~azure.ai.projects.models.ItemContent
    """

    type: Literal[ResponseStreamEventType.RESPONSE_CONTENT_PART_DONE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always ``response.content_part.done``. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the output item that the content part was added to. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item that the content part was added to. Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the content part that is done. Required."""
    part: "_models.ItemContent" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The content part that is done. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        item_id: str,
        output_index: int,
        content_index: int,
        part: "_models.ItemContent",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_CONTENT_PART_DONE  # type: ignore


class ResponseConversation1(_Model):
    """ResponseConversation1.

    :ivar id: Required.
    :vartype id: str
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResponseCreatedEvent(ResponseStreamEvent, discriminator="response.created"):
    """An event that is emitted when a response is created.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always ``response.created``. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_CREATED
    :ivar response: The response that was created. Required.
    :vartype response: ~azure.ai.projects.models.Response
    """

    type: Literal[ResponseStreamEventType.RESPONSE_CREATED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always ``response.created``. Required."""
    response: "_models.Response" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The response that was created. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        response: "_models.Response",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_CREATED  # type: ignore


class ResponseError(_Model):
    """An error object returned when the model fails to generate a Response.

    :ivar code: Required. Known values are: "server_error", "rate_limit_exceeded",
     "invalid_prompt", "vector_store_timeout", "invalid_image", "invalid_image_format",
     "invalid_base64_image", "invalid_image_url", "image_too_large", "image_too_small",
     "image_parse_error", "image_content_policy_violation", "invalid_image_mode",
     "image_file_too_large", "unsupported_image_media_type", "empty_image_file",
     "failed_to_download_image", and "image_file_not_found".
    :vartype code: str or ~azure.ai.projects.models.ResponseErrorCode
    :ivar message: A human-readable description of the error. Required.
    :vartype message: str
    """

    code: Union[str, "_models.ResponseErrorCode"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Required. Known values are: \"server_error\", \"rate_limit_exceeded\", \"invalid_prompt\",
     \"vector_store_timeout\", \"invalid_image\", \"invalid_image_format\",
     \"invalid_base64_image\", \"invalid_image_url\", \"image_too_large\", \"image_too_small\",
     \"image_parse_error\", \"image_content_policy_violation\", \"invalid_image_mode\",
     \"image_file_too_large\", \"unsupported_image_media_type\", \"empty_image_file\",
     \"failed_to_download_image\", and \"image_file_not_found\"."""
    message: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A human-readable description of the error. Required."""

    @overload
    def __init__(
        self,
        *,
        code: Union[str, "_models.ResponseErrorCode"],
        message: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResponseErrorEvent(ResponseStreamEvent, discriminator="error"):
    """Emitted when an error occurs.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always ``error``. Required.
    :vartype type: str or ~azure.ai.projects.models.ERROR
    :ivar code: The error code. Required.
    :vartype code: str
    :ivar message: The error message. Required.
    :vartype message: str
    :ivar param: The error parameter. Required.
    :vartype param: str
    """

    type: Literal[ResponseStreamEventType.ERROR] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always ``error``. Required."""
    code: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error code. Required."""
    message: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error message. Required."""
    param: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error parameter. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        code: str,
        message: str,
        param: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.ERROR  # type: ignore


class ResponseFailedEvent(ResponseStreamEvent, discriminator="response.failed"):
    """An event that is emitted when a response fails.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always ``response.failed``. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_FAILED
    :ivar response: The response that failed. Required.
    :vartype response: ~azure.ai.projects.models.Response
    """

    type: Literal[ResponseStreamEventType.RESPONSE_FAILED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always ``response.failed``. Required."""
    response: "_models.Response" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The response that failed. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        response: "_models.Response",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_FAILED  # type: ignore


class ResponseFileSearchCallCompletedEvent(ResponseStreamEvent, discriminator="response.file_search_call.completed"):
    """Emitted when a file search call is completed (results found).

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always ``response.file_search_call.completed``. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_FILE_SEARCH_CALL_COMPLETED
    :ivar output_index: The index of the output item that the file search call is initiated.
     Required.
    :vartype output_index: int
    :ivar item_id: The ID of the output item that the file search call is initiated. Required.
    :vartype item_id: str
    """

    type: Literal[ResponseStreamEventType.RESPONSE_FILE_SEARCH_CALL_COMPLETED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always ``response.file_search_call.completed``. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item that the file search call is initiated. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the output item that the file search call is initiated. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        output_index: int,
        item_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_FILE_SEARCH_CALL_COMPLETED  # type: ignore


class ResponseFileSearchCallInProgressEvent(ResponseStreamEvent, discriminator="response.file_search_call.in_progress"):
    """Emitted when a file search call is initiated.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always ``response.file_search_call.in_progress``. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_FILE_SEARCH_CALL_IN_PROGRESS
    :ivar output_index: The index of the output item that the file search call is initiated.
     Required.
    :vartype output_index: int
    :ivar item_id: The ID of the output item that the file search call is initiated. Required.
    :vartype item_id: str
    """

    type: Literal[ResponseStreamEventType.RESPONSE_FILE_SEARCH_CALL_IN_PROGRESS] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always ``response.file_search_call.in_progress``. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item that the file search call is initiated. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the output item that the file search call is initiated. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        output_index: int,
        item_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_FILE_SEARCH_CALL_IN_PROGRESS  # type: ignore


class ResponseFileSearchCallSearchingEvent(ResponseStreamEvent, discriminator="response.file_search_call.searching"):
    """Emitted when a file search is currently searching.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always ``response.file_search_call.searching``. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_FILE_SEARCH_CALL_SEARCHING
    :ivar output_index: The index of the output item that the file search call is searching.
     Required.
    :vartype output_index: int
    :ivar item_id: The ID of the output item that the file search call is initiated. Required.
    :vartype item_id: str
    """

    type: Literal[ResponseStreamEventType.RESPONSE_FILE_SEARCH_CALL_SEARCHING] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always ``response.file_search_call.searching``. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item that the file search call is searching. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the output item that the file search call is initiated. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        output_index: int,
        item_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_FILE_SEARCH_CALL_SEARCHING  # type: ignore


class ResponseFormatJsonSchemaSchema(_Model):
    """The schema for the response format, described as a JSON Schema object.
    Learn how to build JSON schemas `here <https://json-schema.org/>`_.

    """


class ResponseFunctionCallArgumentsDeltaEvent(
    ResponseStreamEvent, discriminator="response.function_call_arguments.delta"
):
    """Emitted when there is a partial function-call arguments delta.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always ``response.function_call_arguments.delta``. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_FUNCTION_CALL_ARGUMENTS_DELTA
    :ivar item_id: The ID of the output item that the function-call arguments delta is added to.
     Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item that the function-call arguments delta is
     added to. Required.
    :vartype output_index: int
    :ivar delta: The function-call arguments delta that is added. Required.
    :vartype delta: str
    """

    type: Literal[ResponseStreamEventType.RESPONSE_FUNCTION_CALL_ARGUMENTS_DELTA] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always ``response.function_call_arguments.delta``. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the output item that the function-call arguments delta is added to. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item that the function-call arguments delta is added to. Required."""
    delta: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The function-call arguments delta that is added. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        item_id: str,
        output_index: int,
        delta: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_FUNCTION_CALL_ARGUMENTS_DELTA  # type: ignore


class ResponseFunctionCallArgumentsDoneEvent(
    ResponseStreamEvent, discriminator="response.function_call_arguments.done"
):
    """Emitted when function-call arguments are finalized.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_FUNCTION_CALL_ARGUMENTS_DONE
    :ivar item_id: The ID of the item. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item. Required.
    :vartype output_index: int
    :ivar arguments: The function-call arguments. Required.
    :vartype arguments: str
    """

    type: Literal[ResponseStreamEventType.RESPONSE_FUNCTION_CALL_ARGUMENTS_DONE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item. Required."""
    arguments: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The function-call arguments. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        item_id: str,
        output_index: int,
        arguments: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_FUNCTION_CALL_ARGUMENTS_DONE  # type: ignore


class ResponseImageGenCallCompletedEvent(ResponseStreamEvent, discriminator="response.image_generation_call.completed"):
    """Emitted when an image generation tool call has completed and the final image is available.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always 'response.image_generation_call.completed'. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_IMAGE_GENERATION_CALL_COMPLETED
    :ivar output_index: The index of the output item in the response's output array. Required.
    :vartype output_index: int
    :ivar item_id: The unique identifier of the image generation item being processed. Required.
    :vartype item_id: str
    """

    type: Literal[ResponseStreamEventType.RESPONSE_IMAGE_GENERATION_CALL_COMPLETED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always 'response.image_generation_call.completed'. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response's output array. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique identifier of the image generation item being processed. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        output_index: int,
        item_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_IMAGE_GENERATION_CALL_COMPLETED  # type: ignore


class ResponseImageGenCallGeneratingEvent(
    ResponseStreamEvent, discriminator="response.image_generation_call.generating"
):
    """Emitted when an image generation tool call is actively generating an image (intermediate
    state).

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always 'response.image_generation_call.generating'.
     Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_IMAGE_GENERATION_CALL_GENERATING
    :ivar output_index: The index of the output item in the response's output array. Required.
    :vartype output_index: int
    :ivar item_id: The unique identifier of the image generation item being processed. Required.
    :vartype item_id: str
    """

    type: Literal[ResponseStreamEventType.RESPONSE_IMAGE_GENERATION_CALL_GENERATING] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always 'response.image_generation_call.generating'. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response's output array. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique identifier of the image generation item being processed. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        output_index: int,
        item_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_IMAGE_GENERATION_CALL_GENERATING  # type: ignore


class ResponseImageGenCallInProgressEvent(
    ResponseStreamEvent, discriminator="response.image_generation_call.in_progress"
):
    """Emitted when an image generation tool call is in progress.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always 'response.image_generation_call.in_progress'.
     Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_IMAGE_GENERATION_CALL_IN_PROGRESS
    :ivar output_index: The index of the output item in the response's output array. Required.
    :vartype output_index: int
    :ivar item_id: The unique identifier of the image generation item being processed. Required.
    :vartype item_id: str
    """

    type: Literal[ResponseStreamEventType.RESPONSE_IMAGE_GENERATION_CALL_IN_PROGRESS] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always 'response.image_generation_call.in_progress'. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response's output array. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique identifier of the image generation item being processed. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        output_index: int,
        item_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_IMAGE_GENERATION_CALL_IN_PROGRESS  # type: ignore


class ResponseImageGenCallPartialImageEvent(
    ResponseStreamEvent, discriminator="response.image_generation_call.partial_image"
):
    """Emitted when a partial image is available during image generation streaming.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always 'response.image_generation_call.partial_image'.
     Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_IMAGE_GENERATION_CALL_PARTIAL_IMAGE
    :ivar output_index: The index of the output item in the response's output array. Required.
    :vartype output_index: int
    :ivar item_id: The unique identifier of the image generation item being processed. Required.
    :vartype item_id: str
    :ivar partial_image_index: 0-based index for the partial image (backend is 1-based, but this is
     0-based for the user). Required.
    :vartype partial_image_index: int
    :ivar partial_image_b64: Base64-encoded partial image data, suitable for rendering as an image.
     Required.
    :vartype partial_image_b64: str
    """

    type: Literal[ResponseStreamEventType.RESPONSE_IMAGE_GENERATION_CALL_PARTIAL_IMAGE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always 'response.image_generation_call.partial_image'. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response's output array. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique identifier of the image generation item being processed. Required."""
    partial_image_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """0-based index for the partial image (backend is 1-based, but this is 0-based for the user).
     Required."""
    partial_image_b64: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Base64-encoded partial image data, suitable for rendering as an image. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        output_index: int,
        item_id: str,
        partial_image_index: int,
        partial_image_b64: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_IMAGE_GENERATION_CALL_PARTIAL_IMAGE  # type: ignore


class ResponseIncompleteDetails1(_Model):
    """ResponseIncompleteDetails1.

    :ivar reason: The reason why the response is incomplete. Is either a
     Literal["max_output_tokens"] type or a Literal["content_filter"] type.
    :vartype reason: str or str
    """

    reason: Optional[Literal["max_output_tokens", "content_filter"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The reason why the response is incomplete. Is either a Literal[\"max_output_tokens\"] type or a
     Literal[\"content_filter\"] type."""

    @overload
    def __init__(
        self,
        *,
        reason: Optional[Literal["max_output_tokens", "content_filter"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResponseIncompleteEvent(ResponseStreamEvent, discriminator="response.incomplete"):
    """An event that is emitted when a response finishes as incomplete.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always ``response.incomplete``. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_INCOMPLETE
    :ivar response: The response that was incomplete. Required.
    :vartype response: ~azure.ai.projects.models.Response
    """

    type: Literal[ResponseStreamEventType.RESPONSE_INCOMPLETE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always ``response.incomplete``. Required."""
    response: "_models.Response" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The response that was incomplete. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        response: "_models.Response",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_INCOMPLETE  # type: ignore


class ResponseInProgressEvent(ResponseStreamEvent, discriminator="response.in_progress"):
    """Emitted when the response is in progress.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always ``response.in_progress``. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_IN_PROGRESS
    :ivar response: The response that is in progress. Required.
    :vartype response: ~azure.ai.projects.models.Response
    """

    type: Literal[ResponseStreamEventType.RESPONSE_IN_PROGRESS] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always ``response.in_progress``. Required."""
    response: "_models.Response" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The response that is in progress. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        response: "_models.Response",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_IN_PROGRESS  # type: ignore


class ResponseMCPCallArgumentsDeltaEvent(ResponseStreamEvent, discriminator="response.mcp_call.arguments_delta"):
    """Emitted when there is a delta (partial update) to the arguments of an MCP tool call.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always 'response.mcp_call.arguments_delta'. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_MCP_CALL_ARGUMENTS_DELTA
    :ivar output_index: The index of the output item in the response's output array. Required.
    :vartype output_index: int
    :ivar item_id: The unique identifier of the MCP tool call item being processed. Required.
    :vartype item_id: str
    :ivar delta: The partial update to the arguments for the MCP tool call. Required.
    :vartype delta: any
    """

    type: Literal[ResponseStreamEventType.RESPONSE_MCP_CALL_ARGUMENTS_DELTA] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always 'response.mcp_call.arguments_delta'. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response's output array. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique identifier of the MCP tool call item being processed. Required."""
    delta: Any = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The partial update to the arguments for the MCP tool call. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        output_index: int,
        item_id: str,
        delta: Any,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_MCP_CALL_ARGUMENTS_DELTA  # type: ignore


class ResponseMCPCallArgumentsDoneEvent(ResponseStreamEvent, discriminator="response.mcp_call.arguments_done"):
    """Emitted when the arguments for an MCP tool call are finalized.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always 'response.mcp_call.arguments_done'. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_MCP_CALL_ARGUMENTS_DONE
    :ivar output_index: The index of the output item in the response's output array. Required.
    :vartype output_index: int
    :ivar item_id: The unique identifier of the MCP tool call item being processed. Required.
    :vartype item_id: str
    :ivar arguments: The finalized arguments for the MCP tool call. Required.
    :vartype arguments: any
    """

    type: Literal[ResponseStreamEventType.RESPONSE_MCP_CALL_ARGUMENTS_DONE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always 'response.mcp_call.arguments_done'. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response's output array. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique identifier of the MCP tool call item being processed. Required."""
    arguments: Any = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The finalized arguments for the MCP tool call. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        output_index: int,
        item_id: str,
        arguments: Any,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_MCP_CALL_ARGUMENTS_DONE  # type: ignore


class ResponseMCPCallCompletedEvent(ResponseStreamEvent, discriminator="response.mcp_call.completed"):
    """Emitted when an MCP  tool call has completed successfully.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always 'response.mcp_call.completed'. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_MCP_CALL_COMPLETED
    """

    type: Literal[ResponseStreamEventType.RESPONSE_MCP_CALL_COMPLETED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always 'response.mcp_call.completed'. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_MCP_CALL_COMPLETED  # type: ignore


class ResponseMCPCallFailedEvent(ResponseStreamEvent, discriminator="response.mcp_call.failed"):
    """Emitted when an MCP  tool call has failed.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always 'response.mcp_call.failed'. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_MCP_CALL_FAILED
    """

    type: Literal[ResponseStreamEventType.RESPONSE_MCP_CALL_FAILED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always 'response.mcp_call.failed'. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_MCP_CALL_FAILED  # type: ignore


class ResponseMCPCallInProgressEvent(ResponseStreamEvent, discriminator="response.mcp_call.in_progress"):
    """Emitted when an MCP  tool call is in progress.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always 'response.mcp_call.in_progress'. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_MCP_CALL_IN_PROGRESS
    :ivar output_index: The index of the output item in the response's output array. Required.
    :vartype output_index: int
    :ivar item_id: The unique identifier of the MCP tool call item being processed. Required.
    :vartype item_id: str
    """

    type: Literal[ResponseStreamEventType.RESPONSE_MCP_CALL_IN_PROGRESS] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always 'response.mcp_call.in_progress'. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response's output array. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique identifier of the MCP tool call item being processed. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        output_index: int,
        item_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_MCP_CALL_IN_PROGRESS  # type: ignore


class ResponseMCPListToolsCompletedEvent(ResponseStreamEvent, discriminator="response.mcp_list_tools.completed"):
    """Emitted when the list of available MCP tools has been successfully retrieved.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always 'response.mcp_list_tools.completed'. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_MCP_LIST_TOOLS_COMPLETED
    """

    type: Literal[ResponseStreamEventType.RESPONSE_MCP_LIST_TOOLS_COMPLETED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always 'response.mcp_list_tools.completed'. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_MCP_LIST_TOOLS_COMPLETED  # type: ignore


class ResponseMCPListToolsFailedEvent(ResponseStreamEvent, discriminator="response.mcp_list_tools.failed"):
    """Emitted when the attempt to list available MCP tools has failed.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always 'response.mcp_list_tools.failed'. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_MCP_LIST_TOOLS_FAILED
    """

    type: Literal[ResponseStreamEventType.RESPONSE_MCP_LIST_TOOLS_FAILED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always 'response.mcp_list_tools.failed'. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_MCP_LIST_TOOLS_FAILED  # type: ignore


class ResponseMCPListToolsInProgressEvent(ResponseStreamEvent, discriminator="response.mcp_list_tools.in_progress"):
    """Emitted when the system is in the process of retrieving the list of available MCP tools.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always 'response.mcp_list_tools.in_progress'. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_MCP_LIST_TOOLS_IN_PROGRESS
    """

    type: Literal[ResponseStreamEventType.RESPONSE_MCP_LIST_TOOLS_IN_PROGRESS] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always 'response.mcp_list_tools.in_progress'. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_MCP_LIST_TOOLS_IN_PROGRESS  # type: ignore


class ResponseOutputItemAddedEvent(ResponseStreamEvent, discriminator="response.output_item.added"):
    """Emitted when a new output item is added.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always ``response.output_item.added``. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_OUTPUT_ITEM_ADDED
    :ivar output_index: The index of the output item that was added. Required.
    :vartype output_index: int
    :ivar item: The output item that was added. Required.
    :vartype item: ~azure.ai.projects.models.ItemResource
    """

    type: Literal[ResponseStreamEventType.RESPONSE_OUTPUT_ITEM_ADDED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always ``response.output_item.added``. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item that was added. Required."""
    item: "_models.ItemResource" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The output item that was added. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        output_index: int,
        item: "_models.ItemResource",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_OUTPUT_ITEM_ADDED  # type: ignore


class ResponseOutputItemDoneEvent(ResponseStreamEvent, discriminator="response.output_item.done"):
    """Emitted when an output item is marked done.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always ``response.output_item.done``. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_OUTPUT_ITEM_DONE
    :ivar output_index: The index of the output item that was marked done. Required.
    :vartype output_index: int
    :ivar item: The output item that was marked done. Required.
    :vartype item: ~azure.ai.projects.models.ItemResource
    """

    type: Literal[ResponseStreamEventType.RESPONSE_OUTPUT_ITEM_DONE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always ``response.output_item.done``. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item that was marked done. Required."""
    item: "_models.ItemResource" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The output item that was marked done. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        output_index: int,
        item: "_models.ItemResource",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_OUTPUT_ITEM_DONE  # type: ignore


class ResponsePromptVariables(_Model):
    """Optional map of values to substitute in for variables in your
    prompt. The substitution values can either be strings, or other
    Response input types like images or files.

    """


class ResponseQueuedEvent(ResponseStreamEvent, discriminator="response.queued"):
    """Emitted when a response is queued and waiting to be processed.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always 'response.queued'. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_QUEUED
    :ivar response: The full response object that is queued. Required.
    :vartype response: ~azure.ai.projects.models.Response
    """

    type: Literal[ResponseStreamEventType.RESPONSE_QUEUED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always 'response.queued'. Required."""
    response: "_models.Response" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The full response object that is queued. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        response: "_models.Response",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_QUEUED  # type: ignore


class ResponseReasoningDeltaEvent(ResponseStreamEvent, discriminator="response.reasoning.delta"):
    """Emitted when there is a delta (partial update) to the reasoning content.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always 'response.reasoning.delta'. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_REASONING_DELTA
    :ivar item_id: The unique identifier of the item for which reasoning is being updated.
     Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item in the response's output array. Required.
    :vartype output_index: int
    :ivar content_index: The index of the reasoning content part within the output item. Required.
    :vartype content_index: int
    :ivar delta: The partial update to the reasoning content. Required.
    :vartype delta: any
    """

    type: Literal[ResponseStreamEventType.RESPONSE_REASONING_DELTA] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always 'response.reasoning.delta'. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique identifier of the item for which reasoning is being updated. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response's output array. Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the reasoning content part within the output item. Required."""
    delta: Any = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The partial update to the reasoning content. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        item_id: str,
        output_index: int,
        content_index: int,
        delta: Any,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_REASONING_DELTA  # type: ignore


class ResponseReasoningDoneEvent(ResponseStreamEvent, discriminator="response.reasoning.done"):
    """Emitted when the reasoning content is finalized for an item.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always 'response.reasoning.done'. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_REASONING_DONE
    :ivar item_id: The unique identifier of the item for which reasoning is finalized. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item in the response's output array. Required.
    :vartype output_index: int
    :ivar content_index: The index of the reasoning content part within the output item. Required.
    :vartype content_index: int
    :ivar text: The finalized reasoning text. Required.
    :vartype text: str
    """

    type: Literal[ResponseStreamEventType.RESPONSE_REASONING_DONE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always 'response.reasoning.done'. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique identifier of the item for which reasoning is finalized. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response's output array. Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the reasoning content part within the output item. Required."""
    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The finalized reasoning text. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        item_id: str,
        output_index: int,
        content_index: int,
        text: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_REASONING_DONE  # type: ignore


class ResponseReasoningSummaryDeltaEvent(ResponseStreamEvent, discriminator="response.reasoning_summary.delta"):
    """Emitted when there is a delta (partial update) to the reasoning summary content.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always 'response.reasoning_summary.delta'. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_REASONING_SUMMARY_DELTA
    :ivar item_id: The unique identifier of the item for which the reasoning summary is being
     updated. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item in the response's output array. Required.
    :vartype output_index: int
    :ivar summary_index: The index of the summary part within the output item. Required.
    :vartype summary_index: int
    :ivar delta: The partial update to the reasoning summary content. Required.
    :vartype delta: any
    """

    type: Literal[ResponseStreamEventType.RESPONSE_REASONING_SUMMARY_DELTA] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always 'response.reasoning_summary.delta'. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique identifier of the item for which the reasoning summary is being updated. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response's output array. Required."""
    summary_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the summary part within the output item. Required."""
    delta: Any = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The partial update to the reasoning summary content. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        item_id: str,
        output_index: int,
        summary_index: int,
        delta: Any,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_REASONING_SUMMARY_DELTA  # type: ignore


class ResponseReasoningSummaryDoneEvent(ResponseStreamEvent, discriminator="response.reasoning_summary.done"):
    """Emitted when the reasoning summary content is finalized for an item.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always 'response.reasoning_summary.done'. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_REASONING_SUMMARY_DONE
    :ivar item_id: The unique identifier of the item for which the reasoning summary is finalized.
     Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item in the response's output array. Required.
    :vartype output_index: int
    :ivar summary_index: The index of the summary part within the output item. Required.
    :vartype summary_index: int
    :ivar text: The finalized reasoning summary text. Required.
    :vartype text: str
    """

    type: Literal[ResponseStreamEventType.RESPONSE_REASONING_SUMMARY_DONE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always 'response.reasoning_summary.done'. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The unique identifier of the item for which the reasoning summary is finalized. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item in the response's output array. Required."""
    summary_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the summary part within the output item. Required."""
    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The finalized reasoning summary text. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        item_id: str,
        output_index: int,
        summary_index: int,
        text: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_REASONING_SUMMARY_DONE  # type: ignore


class ResponseReasoningSummaryPartAddedEvent(
    ResponseStreamEvent, discriminator="response.reasoning_summary_part.added"
):
    """Emitted when a new reasoning summary part is added.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always ``response.reasoning_summary_part.added``. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_REASONING_SUMMARY_PART_ADDED
    :ivar item_id: The ID of the item this summary part is associated with. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item this summary part is associated with.
     Required.
    :vartype output_index: int
    :ivar summary_index: The index of the summary part within the reasoning summary. Required.
    :vartype summary_index: int
    :ivar part: The summary part that was added. Required.
    :vartype part: ~azure.ai.projects.models.ReasoningItemSummaryPart
    """

    type: Literal[ResponseStreamEventType.RESPONSE_REASONING_SUMMARY_PART_ADDED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always ``response.reasoning_summary_part.added``. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item this summary part is associated with. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item this summary part is associated with. Required."""
    summary_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the summary part within the reasoning summary. Required."""
    part: "_models.ReasoningItemSummaryPart" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The summary part that was added. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        item_id: str,
        output_index: int,
        summary_index: int,
        part: "_models.ReasoningItemSummaryPart",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_REASONING_SUMMARY_PART_ADDED  # type: ignore


class ResponseReasoningSummaryPartDoneEvent(ResponseStreamEvent, discriminator="response.reasoning_summary_part.done"):
    """Emitted when a reasoning summary part is completed.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always ``response.reasoning_summary_part.done``. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_REASONING_SUMMARY_PART_DONE
    :ivar item_id: The ID of the item this summary part is associated with. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item this summary part is associated with.
     Required.
    :vartype output_index: int
    :ivar summary_index: The index of the summary part within the reasoning summary. Required.
    :vartype summary_index: int
    :ivar part: The completed summary part. Required.
    :vartype part: ~azure.ai.projects.models.ReasoningItemSummaryPart
    """

    type: Literal[ResponseStreamEventType.RESPONSE_REASONING_SUMMARY_PART_DONE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always ``response.reasoning_summary_part.done``. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item this summary part is associated with. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item this summary part is associated with. Required."""
    summary_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the summary part within the reasoning summary. Required."""
    part: "_models.ReasoningItemSummaryPart" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The completed summary part. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        item_id: str,
        output_index: int,
        summary_index: int,
        part: "_models.ReasoningItemSummaryPart",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_REASONING_SUMMARY_PART_DONE  # type: ignore


class ResponseReasoningSummaryTextDeltaEvent(
    ResponseStreamEvent, discriminator="response.reasoning_summary_text.delta"
):
    """Emitted when a delta is added to a reasoning summary text.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always ``response.reasoning_summary_text.delta``. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_REASONING_SUMMARY_TEXT_DELTA
    :ivar item_id: The ID of the item this summary text delta is associated with. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item this summary text delta is associated with.
     Required.
    :vartype output_index: int
    :ivar summary_index: The index of the summary part within the reasoning summary. Required.
    :vartype summary_index: int
    :ivar delta: The text delta that was added to the summary. Required.
    :vartype delta: str
    """

    type: Literal[ResponseStreamEventType.RESPONSE_REASONING_SUMMARY_TEXT_DELTA] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always ``response.reasoning_summary_text.delta``. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item this summary text delta is associated with. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item this summary text delta is associated with. Required."""
    summary_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the summary part within the reasoning summary. Required."""
    delta: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The text delta that was added to the summary. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        item_id: str,
        output_index: int,
        summary_index: int,
        delta: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_REASONING_SUMMARY_TEXT_DELTA  # type: ignore


class ResponseReasoningSummaryTextDoneEvent(ResponseStreamEvent, discriminator="response.reasoning_summary_text.done"):
    """Emitted when a reasoning summary text is completed.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always ``response.reasoning_summary_text.done``. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_REASONING_SUMMARY_TEXT_DONE
    :ivar item_id: The ID of the item this summary text is associated with. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item this summary text is associated with.
     Required.
    :vartype output_index: int
    :ivar summary_index: The index of the summary part within the reasoning summary. Required.
    :vartype summary_index: int
    :ivar text: The full text of the completed reasoning summary. Required.
    :vartype text: str
    """

    type: Literal[ResponseStreamEventType.RESPONSE_REASONING_SUMMARY_TEXT_DONE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always ``response.reasoning_summary_text.done``. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the item this summary text is associated with. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item this summary text is associated with. Required."""
    summary_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the summary part within the reasoning summary. Required."""
    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The full text of the completed reasoning summary. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        item_id: str,
        output_index: int,
        summary_index: int,
        text: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_REASONING_SUMMARY_TEXT_DONE  # type: ignore


class ResponseRefusalDeltaEvent(ResponseStreamEvent, discriminator="response.refusal.delta"):
    """Emitted when there is a partial refusal text.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always ``response.refusal.delta``. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_REFUSAL_DELTA
    :ivar item_id: The ID of the output item that the refusal text is added to. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item that the refusal text is added to. Required.
    :vartype output_index: int
    :ivar content_index: The index of the content part that the refusal text is added to. Required.
    :vartype content_index: int
    :ivar delta: The refusal text that is added. Required.
    :vartype delta: str
    """

    type: Literal[ResponseStreamEventType.RESPONSE_REFUSAL_DELTA] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always ``response.refusal.delta``. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the output item that the refusal text is added to. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item that the refusal text is added to. Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the content part that the refusal text is added to. Required."""
    delta: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The refusal text that is added. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        item_id: str,
        output_index: int,
        content_index: int,
        delta: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_REFUSAL_DELTA  # type: ignore


class ResponseRefusalDoneEvent(ResponseStreamEvent, discriminator="response.refusal.done"):
    """Emitted when refusal text is finalized.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always ``response.refusal.done``. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_REFUSAL_DONE
    :ivar item_id: The ID of the output item that the refusal text is finalized. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item that the refusal text is finalized. Required.
    :vartype output_index: int
    :ivar content_index: The index of the content part that the refusal text is finalized.
     Required.
    :vartype content_index: int
    :ivar refusal: The refusal text that is finalized. Required.
    :vartype refusal: str
    """

    type: Literal[ResponseStreamEventType.RESPONSE_REFUSAL_DONE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always ``response.refusal.done``. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the output item that the refusal text is finalized. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item that the refusal text is finalized. Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the content part that the refusal text is finalized. Required."""
    refusal: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The refusal text that is finalized. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        item_id: str,
        output_index: int,
        content_index: int,
        refusal: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_REFUSAL_DONE  # type: ignore


class ResponsesMessageItemParam(ItemParam, discriminator="message"):
    """A response message item, representing a role and content, as provided as client request
    parameters.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ResponsesAssistantMessageItemParam, ResponsesDeveloperMessageItemParam,
    ResponsesSystemMessageItemParam, ResponsesUserMessageItemParam

    :ivar type: The type of the responses item, which is always 'message'. Required.
    :vartype type: str or ~azure.ai.projects.models.MESSAGE
    :ivar role: The role associated with the message. Required. Known values are: "system",
     "developer", "user", and "assistant".
    :vartype role: str or ~azure.ai.projects.models.ResponsesMessageRole
    """

    __mapping__: dict[str, _Model] = {}
    type: Literal[ItemType.MESSAGE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the responses item, which is always 'message'. Required."""
    role: str = rest_discriminator(name="role", visibility=["read", "create", "update", "delete", "query"])
    """The role associated with the message. Required. Known values are: \"system\", \"developer\",
     \"user\", and \"assistant\"."""

    @overload
    def __init__(
        self,
        *,
        role: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.MESSAGE  # type: ignore


class ResponsesAssistantMessageItemParam(ResponsesMessageItemParam, discriminator="assistant"):
    """A message parameter item with the ``assistant`` role.

    :ivar type: The type of the responses item, which is always 'message'. Required.
    :vartype type: str or ~azure.ai.projects.models.MESSAGE
    :ivar role: The role of the message, which is always ``assistant``. Required.
    :vartype role: str or ~azure.ai.projects.models.ASSISTANT
    :ivar content: The content associated with the message. Required. Is either a str type or a
     [ItemContent] type.
    :vartype content: str or list[~azure.ai.projects.models.ItemContent]
    """

    __mapping__: dict[str, _Model] = {}
    role: Literal[ResponsesMessageRole.ASSISTANT] = rest_discriminator(name="role", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The role of the message, which is always ``assistant``. Required."""
    content: Union["str", list["_models.ItemContent"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The content associated with the message. Required. Is either a str type or a [ItemContent]
     type."""

    @overload
    def __init__(
        self,
        *,
        content: Union[str, list["_models.ItemContent"]],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.role = ResponsesMessageRole.ASSISTANT  # type: ignore


class ResponsesMessageItemResource(ItemResource, discriminator="message"):
    """A response message resource item, representing a role and content, as provided on service
       responses.

       You probably want to use the sub-classes and not this class directly. Known sub-classes are:
       ResponsesAssistantMessageItemResource, ResponsesDeveloperMessageItemResource,
       ResponsesSystemMessageItemResource, ResponsesUserMessageItemResource

       :ivar id: Required.
       :vartype id: str
       :ivar created_by: The information about the creator of the item.
       :vartype created_by: ~azure.ai.projects.models.CreatedBy
       :ivar type: The type of the responses item, which is always 'message'. Required.
       :vartype type: str or ~azure.ai.projects.models.MESSAGE
       :ivar status: The status of the item. One of ``in_progress``, ``completed``, or
    ``incomplete``. Populated when items are returned via API. Required. Is one of the following
        types: Literal["in_progress"], Literal["completed"], Literal["incomplete"]
       :vartype status: str or str or str
       :ivar role: The role associated with the message. Required. Known values are: "system",
        "developer", "user", and "assistant".
       :vartype role: str or ~azure.ai.projects.models.ResponsesMessageRole
    """

    __mapping__: dict[str, _Model] = {}
    type: Literal[ItemType.MESSAGE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the responses item, which is always 'message'. Required."""
    status: Literal["in_progress", "completed", "incomplete"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The status of the item. One of ``in_progress``, ``completed``, or
 ``incomplete``. Populated when items are returned via API. Required. Is one of the following
     types: Literal[\"in_progress\"], Literal[\"completed\"], Literal[\"incomplete\"]"""
    role: str = rest_discriminator(name="role", visibility=["read", "create", "update", "delete", "query"])
    """The role associated with the message. Required. Known values are: \"system\", \"developer\",
     \"user\", and \"assistant\"."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        status: Literal["in_progress", "completed", "incomplete"],
        role: str,
        created_by: Optional["_models.CreatedBy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.MESSAGE  # type: ignore


class ResponsesAssistantMessageItemResource(ResponsesMessageItemResource, discriminator="assistant"):
    """A message resource item with the ``assistant`` role.

       :ivar id: Required.
       :vartype id: str
       :ivar created_by: The information about the creator of the item.
       :vartype created_by: ~azure.ai.projects.models.CreatedBy
       :ivar type: The type of the responses item, which is always 'message'. Required.
       :vartype type: str or ~azure.ai.projects.models.MESSAGE
       :ivar status: The status of the item. One of ``in_progress``, ``completed``, or
    ``incomplete``. Populated when items are returned via API. Required. Is one of the following
        types: Literal["in_progress"], Literal["completed"], Literal["incomplete"]
       :vartype status: str or str or str
       :ivar role: The role of the message, which is always ``assistant``. Required.
       :vartype role: str or ~azure.ai.projects.models.ASSISTANT
       :ivar content: The content associated with the message. Required.
       :vartype content: list[~azure.ai.projects.models.ItemContent]
    """

    __mapping__: dict[str, _Model] = {}
    role: Literal[ResponsesMessageRole.ASSISTANT] = rest_discriminator(name="role", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The role of the message, which is always ``assistant``. Required."""
    content: list["_models.ItemContent"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The content associated with the message. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        status: Literal["in_progress", "completed", "incomplete"],
        content: list["_models.ItemContent"],
        created_by: Optional["_models.CreatedBy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.role = ResponsesMessageRole.ASSISTANT  # type: ignore


class ResponsesDeveloperMessageItemParam(ResponsesMessageItemParam, discriminator="developer"):
    """A message parameter item with the ``developer`` role.

    :ivar type: The type of the responses item, which is always 'message'. Required.
    :vartype type: str or ~azure.ai.projects.models.MESSAGE
    :ivar role: The role of the message, which is always ``developer``. Required.
    :vartype role: str or ~azure.ai.projects.models.DEVELOPER
    :ivar content: The content associated with the message. Required. Is either a str type or a
     [ItemContent] type.
    :vartype content: str or list[~azure.ai.projects.models.ItemContent]
    """

    __mapping__: dict[str, _Model] = {}
    role: Literal[ResponsesMessageRole.DEVELOPER] = rest_discriminator(name="role", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The role of the message, which is always ``developer``. Required."""
    content: Union["str", list["_models.ItemContent"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The content associated with the message. Required. Is either a str type or a [ItemContent]
     type."""

    @overload
    def __init__(
        self,
        *,
        content: Union[str, list["_models.ItemContent"]],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.role = ResponsesMessageRole.DEVELOPER  # type: ignore


class ResponsesDeveloperMessageItemResource(ResponsesMessageItemResource, discriminator="developer"):
    """A message resource item with the ``developer`` role.

       :ivar id: Required.
       :vartype id: str
       :ivar created_by: The information about the creator of the item.
       :vartype created_by: ~azure.ai.projects.models.CreatedBy
       :ivar type: The type of the responses item, which is always 'message'. Required.
       :vartype type: str or ~azure.ai.projects.models.MESSAGE
       :ivar status: The status of the item. One of ``in_progress``, ``completed``, or
    ``incomplete``. Populated when items are returned via API. Required. Is one of the following
        types: Literal["in_progress"], Literal["completed"], Literal["incomplete"]
       :vartype status: str or str or str
       :ivar role: The role of the message, which is always ``developer``. Required.
       :vartype role: str or ~azure.ai.projects.models.DEVELOPER
       :ivar content: The content associated with the message. Required.
       :vartype content: list[~azure.ai.projects.models.ItemContent]
    """

    __mapping__: dict[str, _Model] = {}
    role: Literal[ResponsesMessageRole.DEVELOPER] = rest_discriminator(name="role", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The role of the message, which is always ``developer``. Required."""
    content: list["_models.ItemContent"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The content associated with the message. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        status: Literal["in_progress", "completed", "incomplete"],
        content: list["_models.ItemContent"],
        created_by: Optional["_models.CreatedBy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.role = ResponsesMessageRole.DEVELOPER  # type: ignore


class ResponsesSystemMessageItemParam(ResponsesMessageItemParam, discriminator="system"):
    """A message parameter item with the ``system`` role.

    :ivar type: The type of the responses item, which is always 'message'. Required.
    :vartype type: str or ~azure.ai.projects.models.MESSAGE
    :ivar role: The role of the message, which is always ``system``. Required.
    :vartype role: str or ~azure.ai.projects.models.SYSTEM
    :ivar content: The content associated with the message. Required. Is either a str type or a
     [ItemContent] type.
    :vartype content: str or list[~azure.ai.projects.models.ItemContent]
    """

    __mapping__: dict[str, _Model] = {}
    role: Literal[ResponsesMessageRole.SYSTEM] = rest_discriminator(name="role", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The role of the message, which is always ``system``. Required."""
    content: Union["str", list["_models.ItemContent"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The content associated with the message. Required. Is either a str type or a [ItemContent]
     type."""

    @overload
    def __init__(
        self,
        *,
        content: Union[str, list["_models.ItemContent"]],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.role = ResponsesMessageRole.SYSTEM  # type: ignore


class ResponsesSystemMessageItemResource(ResponsesMessageItemResource, discriminator="system"):
    """A message resource item with the ``system`` role.

       :ivar id: Required.
       :vartype id: str
       :ivar created_by: The information about the creator of the item.
       :vartype created_by: ~azure.ai.projects.models.CreatedBy
       :ivar type: The type of the responses item, which is always 'message'. Required.
       :vartype type: str or ~azure.ai.projects.models.MESSAGE
       :ivar status: The status of the item. One of ``in_progress``, ``completed``, or
    ``incomplete``. Populated when items are returned via API. Required. Is one of the following
        types: Literal["in_progress"], Literal["completed"], Literal["incomplete"]
       :vartype status: str or str or str
       :ivar role: The role of the message, which is always ``system``. Required.
       :vartype role: str or ~azure.ai.projects.models.SYSTEM
       :ivar content: The content associated with the message. Required.
       :vartype content: list[~azure.ai.projects.models.ItemContent]
    """

    __mapping__: dict[str, _Model] = {}
    role: Literal[ResponsesMessageRole.SYSTEM] = rest_discriminator(name="role", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The role of the message, which is always ``system``. Required."""
    content: list["_models.ItemContent"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The content associated with the message. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        status: Literal["in_progress", "completed", "incomplete"],
        content: list["_models.ItemContent"],
        created_by: Optional["_models.CreatedBy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.role = ResponsesMessageRole.SYSTEM  # type: ignore


class ResponsesUserMessageItemParam(ResponsesMessageItemParam, discriminator="user"):
    """A message parameter item with the ``user`` role.

    :ivar type: The type of the responses item, which is always 'message'. Required.
    :vartype type: str or ~azure.ai.projects.models.MESSAGE
    :ivar role: The role of the message, which is always ``user``. Required.
    :vartype role: str or ~azure.ai.projects.models.USER
    :ivar content: The content associated with the message. Required. Is either a str type or a
     [ItemContent] type.
    :vartype content: str or list[~azure.ai.projects.models.ItemContent]
    """

    __mapping__: dict[str, _Model] = {}
    role: Literal[ResponsesMessageRole.USER] = rest_discriminator(name="role", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The role of the message, which is always ``user``. Required."""
    content: Union["str", list["_models.ItemContent"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The content associated with the message. Required. Is either a str type or a [ItemContent]
     type."""

    @overload
    def __init__(
        self,
        *,
        content: Union[str, list["_models.ItemContent"]],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.role = ResponsesMessageRole.USER  # type: ignore


class ResponsesUserMessageItemResource(ResponsesMessageItemResource, discriminator="user"):
    """A message resource item with the ``user`` role.

       :ivar id: Required.
       :vartype id: str
       :ivar created_by: The information about the creator of the item.
       :vartype created_by: ~azure.ai.projects.models.CreatedBy
       :ivar type: The type of the responses item, which is always 'message'. Required.
       :vartype type: str or ~azure.ai.projects.models.MESSAGE
       :ivar status: The status of the item. One of ``in_progress``, ``completed``, or
    ``incomplete``. Populated when items are returned via API. Required. Is one of the following
        types: Literal["in_progress"], Literal["completed"], Literal["incomplete"]
       :vartype status: str or str or str
       :ivar role: The role of the message, which is always ``user``. Required.
       :vartype role: str or ~azure.ai.projects.models.USER
       :ivar content: The content associated with the message. Required.
       :vartype content: list[~azure.ai.projects.models.ItemContent]
    """

    __mapping__: dict[str, _Model] = {}
    role: Literal[ResponsesMessageRole.USER] = rest_discriminator(name="role", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The role of the message, which is always ``user``. Required."""
    content: list["_models.ItemContent"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The content associated with the message. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        status: Literal["in_progress", "completed", "incomplete"],
        content: list["_models.ItemContent"],
        created_by: Optional["_models.CreatedBy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.role = ResponsesMessageRole.USER  # type: ignore


class ResponseText(_Model):
    """ResponseText.

    :ivar format:
    :vartype format: ~azure.ai.projects.models.ResponseTextFormatConfiguration
    """

    format: Optional["_models.ResponseTextFormatConfiguration"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )

    @overload
    def __init__(
        self,
        *,
        format: Optional["_models.ResponseTextFormatConfiguration"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResponseTextDeltaEvent(ResponseStreamEvent, discriminator="response.output_text.delta"):
    """Emitted when there is an additional text delta.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always ``response.output_text.delta``. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_OUTPUT_TEXT_DELTA
    :ivar item_id: The ID of the output item that the text delta was added to. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item that the text delta was added to. Required.
    :vartype output_index: int
    :ivar content_index: The index of the content part that the text delta was added to. Required.
    :vartype content_index: int
    :ivar delta: The text delta that was added. Required.
    :vartype delta: str
    """

    type: Literal[ResponseStreamEventType.RESPONSE_OUTPUT_TEXT_DELTA] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always ``response.output_text.delta``. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the output item that the text delta was added to. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item that the text delta was added to. Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the content part that the text delta was added to. Required."""
    delta: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The text delta that was added. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        item_id: str,
        output_index: int,
        content_index: int,
        delta: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_OUTPUT_TEXT_DELTA  # type: ignore


class ResponseTextDoneEvent(ResponseStreamEvent, discriminator="response.output_text.done"):
    """Emitted when text content is finalized.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always ``response.output_text.done``. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_OUTPUT_TEXT_DONE
    :ivar item_id: The ID of the output item that the text content is finalized. Required.
    :vartype item_id: str
    :ivar output_index: The index of the output item that the text content is finalized. Required.
    :vartype output_index: int
    :ivar content_index: The index of the content part that the text content is finalized.
     Required.
    :vartype content_index: int
    :ivar text: The text content that is finalized. Required.
    :vartype text: str
    """

    type: Literal[ResponseStreamEventType.RESPONSE_OUTPUT_TEXT_DONE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always ``response.output_text.done``. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The ID of the output item that the text content is finalized. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item that the text content is finalized. Required."""
    content_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the content part that the text content is finalized. Required."""
    text: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The text content that is finalized. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        item_id: str,
        output_index: int,
        content_index: int,
        text: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_OUTPUT_TEXT_DONE  # type: ignore


class ResponseTextFormatConfiguration(_Model):
    """ResponseTextFormatConfiguration.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ResponseTextFormatConfigurationJsonObject, ResponseTextFormatConfigurationJsonSchema,
    ResponseTextFormatConfigurationText

    :ivar type: Required. Known values are: "text", "json_schema", and "json_object".
    :vartype type: str or ~azure.ai.projects.models.ResponseTextFormatConfigurationType
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Required. Known values are: \"text\", \"json_schema\", and \"json_object\"."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResponseTextFormatConfigurationJsonObject(
    ResponseTextFormatConfiguration, discriminator="json_object"
):  # pylint: disable=name-too-long
    """ResponseTextFormatConfigurationJsonObject.

    :ivar type: Required.
    :vartype type: str or ~azure.ai.projects.models.JSON_OBJECT
    """

    type: Literal[ResponseTextFormatConfigurationType.JSON_OBJECT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseTextFormatConfigurationType.JSON_OBJECT  # type: ignore


class ResponseTextFormatConfigurationJsonSchema(
    ResponseTextFormatConfiguration, discriminator="json_schema"
):  # pylint: disable=name-too-long
    """JSON Schema response format. Used to generate structured JSON responses.
    Learn more about `Structured Outputs </docs/guides/structured-outputs>`_.

        :ivar type: The type of response format being defined. Always ``json_schema``. Required.
        :vartype type: str or ~azure.ai.projects.models.JSON_SCHEMA
        :ivar description: A description of what the response format is for, used by the model to
     determine how to respond in the format.
        :vartype description: str
        :ivar name: The name of the response format. Must be a-z, A-Z, 0-9, or contain
     underscores and dashes, with a maximum length of 64. Required.
        :vartype name: str
        :ivar schema: Required.
        :vartype schema: ~azure.ai.projects.models.ResponseFormatJsonSchemaSchema
        :ivar strict: Whether to enable strict schema adherence when generating the output.
     If set to true, the model will always follow the exact schema defined
     in the ``schema`` field. Only a subset of JSON Schema is supported when
     ``strict`` is ``true``. To learn more, read the `Structured Outputs
     guide </docs/guides/structured-outputs>`_.
        :vartype strict: bool
    """

    type: Literal[ResponseTextFormatConfigurationType.JSON_SCHEMA] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of response format being defined. Always ``json_schema``. Required."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A description of what the response format is for, used by the model to
 determine how to respond in the format."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the response format. Must be a-z, A-Z, 0-9, or contain
 underscores and dashes, with a maximum length of 64. Required."""
    schema: "_models.ResponseFormatJsonSchemaSchema" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Required."""
    strict: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Whether to enable strict schema adherence when generating the output.
 If set to true, the model will always follow the exact schema defined
 in the ``schema`` field. Only a subset of JSON Schema is supported when
 ``strict`` is ``true``. To learn more, read the `Structured Outputs
 guide </docs/guides/structured-outputs>`_."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        schema: "_models.ResponseFormatJsonSchemaSchema",
        description: Optional[str] = None,
        strict: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseTextFormatConfigurationType.JSON_SCHEMA  # type: ignore


class ResponseTextFormatConfigurationText(ResponseTextFormatConfiguration, discriminator="text"):
    """ResponseTextFormatConfigurationText.

    :ivar type: Required.
    :vartype type: str or ~azure.ai.projects.models.TEXT
    """

    type: Literal[ResponseTextFormatConfigurationType.TEXT] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseTextFormatConfigurationType.TEXT  # type: ignore


class ResponseUsage(_Model):
    """Represents token usage details including input tokens, output tokens,
    a breakdown of output tokens, and the total tokens used.

        :ivar input_tokens: The number of input tokens. Required.
        :vartype input_tokens: int
        :ivar input_tokens_details: A detailed breakdown of the input tokens. Required.
        :vartype input_tokens_details:
         ~azure.ai.projects.models.MemoryStoreOperationUsageInputTokensDetails
        :ivar output_tokens: The number of output tokens. Required.
        :vartype output_tokens: int
        :ivar output_tokens_details: A detailed breakdown of the output tokens. Required.
        :vartype output_tokens_details:
         ~azure.ai.projects.models.MemoryStoreOperationUsageOutputTokensDetails
        :ivar total_tokens: The total number of tokens used. Required.
        :vartype total_tokens: int
    """

    input_tokens: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of input tokens. Required."""
    input_tokens_details: "_models.MemoryStoreOperationUsageInputTokensDetails" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A detailed breakdown of the input tokens. Required."""
    output_tokens: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The number of output tokens. Required."""
    output_tokens_details: "_models.MemoryStoreOperationUsageOutputTokensDetails" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """A detailed breakdown of the output tokens. Required."""
    total_tokens: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The total number of tokens used. Required."""

    @overload
    def __init__(
        self,
        *,
        input_tokens: int,
        input_tokens_details: "_models.MemoryStoreOperationUsageInputTokensDetails",
        output_tokens: int,
        output_tokens_details: "_models.MemoryStoreOperationUsageOutputTokensDetails",
        total_tokens: int,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ResponseWebSearchCallCompletedEvent(ResponseStreamEvent, discriminator="response.web_search_call.completed"):
    """Note: web_search is not yet available via Azure OpenAI.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always ``response.web_search_call.completed``. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_WEB_SEARCH_CALL_COMPLETED
    :ivar output_index: The index of the output item that the web search call is associated with.
     Required.
    :vartype output_index: int
    :ivar item_id: Unique ID for the output item associated with the web search call. Required.
    :vartype item_id: str
    """

    type: Literal[ResponseStreamEventType.RESPONSE_WEB_SEARCH_CALL_COMPLETED] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always ``response.web_search_call.completed``. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item that the web search call is associated with. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique ID for the output item associated with the web search call. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        output_index: int,
        item_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_WEB_SEARCH_CALL_COMPLETED  # type: ignore


class ResponseWebSearchCallInProgressEvent(ResponseStreamEvent, discriminator="response.web_search_call.in_progress"):
    """Note: web_search is not yet available via Azure OpenAI.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always ``response.web_search_call.in_progress``. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_WEB_SEARCH_CALL_IN_PROGRESS
    :ivar output_index: The index of the output item that the web search call is associated with.
     Required.
    :vartype output_index: int
    :ivar item_id: Unique ID for the output item associated with the web search call. Required.
    :vartype item_id: str
    """

    type: Literal[ResponseStreamEventType.RESPONSE_WEB_SEARCH_CALL_IN_PROGRESS] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always ``response.web_search_call.in_progress``. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item that the web search call is associated with. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique ID for the output item associated with the web search call. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        output_index: int,
        item_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_WEB_SEARCH_CALL_IN_PROGRESS  # type: ignore


class ResponseWebSearchCallSearchingEvent(ResponseStreamEvent, discriminator="response.web_search_call.searching"):
    """Note: web_search is not yet available via Azure OpenAI.

    :ivar sequence_number: The sequence number for this event. Required.
    :vartype sequence_number: int
    :ivar type: The type of the event. Always ``response.web_search_call.searching``. Required.
    :vartype type: str or ~azure.ai.projects.models.RESPONSE_WEB_SEARCH_CALL_SEARCHING
    :ivar output_index: The index of the output item that the web search call is associated with.
     Required.
    :vartype output_index: int
    :ivar item_id: Unique ID for the output item associated with the web search call. Required.
    :vartype item_id: str
    """

    type: Literal[ResponseStreamEventType.RESPONSE_WEB_SEARCH_CALL_SEARCHING] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the event. Always ``response.web_search_call.searching``. Required."""
    output_index: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The index of the output item that the web search call is associated with. Required."""
    item_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique ID for the output item associated with the web search call. Required."""

    @overload
    def __init__(
        self,
        *,
        sequence_number: int,
        output_index: int,
        item_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ResponseStreamEventType.RESPONSE_WEB_SEARCH_CALL_SEARCHING  # type: ignore


class SASCredentials(BaseCredentials, discriminator="SAS"):
    """Shared Access Signature (SAS) credential definition.

    :ivar type: The credential type. Required. Shared Access Signature (SAS) credential
    :vartype type: str or ~azure.ai.projects.models.SAS
    :ivar sas_token: SAS token.
    :vartype sas_token: str
    """

    type: Literal[CredentialType.SAS] = rest_discriminator(name="type", visibility=["read"])  # type: ignore
    """The credential type. Required. Shared Access Signature (SAS) credential"""
    sas_token: Optional[str] = rest_field(name="SAS", visibility=["read"])
    """SAS token."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = CredentialType.SAS  # type: ignore


class Schedule(_Model):
    """Schedule model.

    :ivar id: Identifier of the schedule. Required.
    :vartype id: str
    :ivar display_name: Name of the schedule.
    :vartype display_name: str
    :ivar description: Description of the schedule.
    :vartype description: str
    :ivar enabled: Enabled status of the schedule. Required.
    :vartype enabled: bool
    :ivar provisioning_status: Provisioning status of the schedule. Known values are: "Creating",
     "Updating", "Deleting", "Succeeded", and "Failed".
    :vartype provisioning_status: str or ~azure.ai.projects.models.ScheduleProvisioningStatus
    :ivar trigger: Trigger for the schedule. Required.
    :vartype trigger: ~azure.ai.projects.models.Trigger
    :ivar task: Task for the schedule. Required.
    :vartype task: ~azure.ai.projects.models.ScheduleTask
    :ivar tags: Schedule's tags. Unlike properties, tags are fully mutable.
    :vartype tags: dict[str, str]
    :ivar properties: Schedule's properties. Unlike tags, properties are add-only. Once added, a
     property cannot be removed.
    :vartype properties: dict[str, str]
    :ivar system_data: System metadata for the resource. Required.
    :vartype system_data: dict[str, str]
    """

    id: str = rest_field(visibility=["read"])
    """Identifier of the schedule. Required."""
    display_name: Optional[str] = rest_field(
        name="displayName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Name of the schedule."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Description of the schedule."""
    enabled: bool = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Enabled status of the schedule. Required."""
    provisioning_status: Optional[Union[str, "_models.ScheduleProvisioningStatus"]] = rest_field(
        name="provisioningStatus", visibility=["read"]
    )
    """Provisioning status of the schedule. Known values are: \"Creating\", \"Updating\",
     \"Deleting\", \"Succeeded\", and \"Failed\"."""
    trigger: "_models.Trigger" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Trigger for the schedule. Required."""
    task: "_models.ScheduleTask" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Task for the schedule. Required."""
    tags: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Schedule's tags. Unlike properties, tags are fully mutable."""
    properties: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Schedule's properties. Unlike tags, properties are add-only. Once added, a property cannot be
     removed."""
    system_data: dict[str, str] = rest_field(name="systemData", visibility=["read"])
    """System metadata for the resource. Required."""

    @overload
    def __init__(
        self,
        *,
        enabled: bool,
        trigger: "_models.Trigger",
        task: "_models.ScheduleTask",
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        tags: Optional[dict[str, str]] = None,
        properties: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ScheduleRun(_Model):
    """Schedule run model.

    :ivar id: Identifier of the schedule run. Required.
    :vartype id: str
    :ivar schedule_id: Identifier of the schedule. Required.
    :vartype schedule_id: str
    :ivar success: Trigger success status of the schedule run. Required.
    :vartype success: bool
    :ivar trigger_time: Trigger time of the schedule run.
    :vartype trigger_time: str
    :ivar error: Error information for the schedule run.
    :vartype error: str
    :ivar properties: Properties of the schedule run. Required.
    :vartype properties: dict[str, str]
    """

    id: str = rest_field(visibility=["read"])
    """Identifier of the schedule run. Required."""
    schedule_id: str = rest_field(name="scheduleId", visibility=["read", "create", "update", "delete", "query"])
    """Identifier of the schedule. Required."""
    success: bool = rest_field(visibility=["read"])
    """Trigger success status of the schedule run. Required."""
    trigger_time: Optional[str] = rest_field(
        name="triggerTime", visibility=["read", "create", "update", "delete", "query"]
    )
    """Trigger time of the schedule run."""
    error: Optional[str] = rest_field(visibility=["read"])
    """Error information for the schedule run."""
    properties: dict[str, str] = rest_field(visibility=["read"])
    """Properties of the schedule run. Required."""

    @overload
    def __init__(
        self,
        *,
        schedule_id: str,
        trigger_time: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SharepointAgentTool(Tool, discriminator="sharepoint_grounding_preview"):
    """The input definition information for a sharepoint tool as used to configure an agent.

    :ivar type: The object type, which is always 'sharepoint_grounding'. Required.
    :vartype type: str or ~azure.ai.projects.models.SHAREPOINT_GROUNDING_PREVIEW
    :ivar sharepoint_grounding_preview: The sharepoint grounding tool parameters. Required.
    :vartype sharepoint_grounding_preview:
     ~azure.ai.projects.models.SharepointGroundingToolParameters
    """

    type: Literal[ToolType.SHAREPOINT_GROUNDING_PREVIEW] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The object type, which is always 'sharepoint_grounding'. Required."""
    sharepoint_grounding_preview: "_models.SharepointGroundingToolParameters" = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The sharepoint grounding tool parameters. Required."""

    @overload
    def __init__(
        self,
        *,
        sharepoint_grounding_preview: "_models.SharepointGroundingToolParameters",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ToolType.SHAREPOINT_GROUNDING_PREVIEW  # type: ignore


class SharepointGroundingToolParameters(_Model):
    """The sharepoint grounding tool parameters.

       :ivar project_connections: The project connections attached to this tool. There can be a
        maximum of 1 connection
    resource attached to the tool.
       :vartype project_connections: list[~azure.ai.projects.models.ToolProjectConnection]
    """

    project_connections: Optional[list["_models.ToolProjectConnection"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The project connections attached to this tool. There can be a maximum of 1 connection
 resource attached to the tool."""

    @overload
    def __init__(
        self,
        *,
        project_connections: Optional[list["_models.ToolProjectConnection"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StructuredInputDefinition(_Model):
    """An structured input that can participate in prompt template substitutions and tool argument
    binding.

    :ivar description: A human-readable description of the input.
    :vartype description: str
    :ivar default_value: The default value for the input if no run-time value is provided.
    :vartype default_value: any
    :ivar tool_argument_bindings: When provided, the input value is bound to the specified tool
     arguments.
    :vartype tool_argument_bindings: list[~azure.ai.projects.models.ToolArgumentBinding]
    :ivar schema: The JSON schema for the structured input (optional).
    :vartype schema: any
    :ivar required: Whether the input property is required when the agent is invoked.
    :vartype required: bool
    """

    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A human-readable description of the input."""
    default_value: Optional[Any] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The default value for the input if no run-time value is provided."""
    tool_argument_bindings: Optional[list["_models.ToolArgumentBinding"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """When provided, the input value is bound to the specified tool arguments."""
    schema: Optional[Any] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The JSON schema for the structured input (optional)."""
    required: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Whether the input property is required when the agent is invoked."""

    @overload
    def __init__(
        self,
        *,
        description: Optional[str] = None,
        default_value: Optional[Any] = None,
        tool_argument_bindings: Optional[list["_models.ToolArgumentBinding"]] = None,
        schema: Optional[Any] = None,
        required: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StructuredOutputDefinition(_Model):
    """A structured output that can be produced by the agent.

    :ivar name: The name of the structured output. Required.
    :vartype name: str
    :ivar description: A description of the output to emit. Used by the model to determine when to
     emit the output. Required.
    :vartype description: str
    :ivar schema: The JSON schema for the structured output. Required.
    :vartype schema: dict[str, any]
    :ivar strict: Whether to enforce strict validation. Default ``true``. Required.
    :vartype strict: bool
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the structured output. Required."""
    description: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A description of the output to emit. Used by the model to determine when to emit the output.
     Required."""
    schema: dict[str, Any] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The JSON schema for the structured output. Required."""
    strict: bool = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Whether to enforce strict validation. Default ``true``. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        description: str,
        schema: dict[str, Any],
        strict: bool,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StructuredOutputsItemResource(ItemResource, discriminator="structured_outputs"):
    """StructuredOutputsItemResource.

    :ivar id: Required.
    :vartype id: str
    :ivar created_by: The information about the creator of the item.
    :vartype created_by: ~azure.ai.projects.models.CreatedBy
    :ivar type: Required.
    :vartype type: str or ~azure.ai.projects.models.STRUCTURED_OUTPUTS
    :ivar output: The structured output captured during the response. Required.
    :vartype output: any
    """

    type: Literal[ItemType.STRUCTURED_OUTPUTS] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    output: Any = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The structured output captured during the response. Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        output: Any,
        created_by: Optional["_models.CreatedBy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.STRUCTURED_OUTPUTS  # type: ignore


class TaxonomyCategory(_Model):
    """Taxonomy category definition.

    :ivar id: Unique identifier of the taxonomy category. Required.
    :vartype id: str
    :ivar name: Name of the taxonomy category. Required.
    :vartype name: str
    :ivar description: Description of the taxonomy category.
    :vartype description: str
    :ivar risk_category: Risk category associated with this taxonomy category. Required. Known
     values are: "HateUnfairness", "Violence", "Sexual", and "SelfHarm".
    :vartype risk_category: str or ~azure.ai.projects.models.RiskCategory
    :ivar sub_categories: List of taxonomy sub categories. Required.
    :vartype sub_categories: list[~azure.ai.projects.models.TaxonomySubCategory]
    :ivar properties: Additional properties for the taxonomy category.
    :vartype properties: dict[str, str]
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique identifier of the taxonomy category. Required."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the taxonomy category. Required."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Description of the taxonomy category."""
    risk_category: Union[str, "_models.RiskCategory"] = rest_field(
        name="riskCategory", visibility=["read", "create", "update", "delete", "query"]
    )
    """Risk category associated with this taxonomy category. Required. Known values are:
     \"HateUnfairness\", \"Violence\", \"Sexual\", and \"SelfHarm\"."""
    sub_categories: list["_models.TaxonomySubCategory"] = rest_field(
        name="subCategories", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of taxonomy sub categories. Required."""
    properties: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Additional properties for the taxonomy category."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        name: str,
        risk_category: Union[str, "_models.RiskCategory"],
        sub_categories: list["_models.TaxonomySubCategory"],
        description: Optional[str] = None,
        properties: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TaxonomySubCategory(_Model):
    """Taxonomy sub-category definition.

    :ivar id: Unique identifier of the taxonomy sub-category. Required.
    :vartype id: str
    :ivar name: Name of the taxonomy sub-category. Required.
    :vartype name: str
    :ivar description: Description of the taxonomy sub-category.
    :vartype description: str
    :ivar enabled: List of taxonomy items under this sub-category. Required.
    :vartype enabled: bool
    :ivar properties: Additional properties for the taxonomy sub-category.
    :vartype properties: dict[str, str]
    """

    id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Unique identifier of the taxonomy sub-category. Required."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Name of the taxonomy sub-category. Required."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Description of the taxonomy sub-category."""
    enabled: bool = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """List of taxonomy items under this sub-category. Required."""
    properties: Optional[dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Additional properties for the taxonomy sub-category."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        name: str,
        enabled: bool,
        description: Optional[str] = None,
        properties: Optional[dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ToolArgumentBinding(_Model):
    """ToolArgumentBinding.

    :ivar tool_name: The name of the tool to participate in the argument binding. If not provided,
     then all tools with matching arguments will participate in binding.
    :vartype tool_name: str
    :ivar argument_name: The name of the argument within the tool. Required.
    :vartype argument_name: str
    """

    tool_name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the tool to participate in the argument binding. If not provided, then all tools
     with matching arguments will participate in binding."""
    argument_name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the argument within the tool. Required."""

    @overload
    def __init__(
        self,
        *,
        argument_name: str,
        tool_name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ToolChoiceObject(_Model):
    """ToolChoiceObject.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ToolChoiceObjectCodeInterpreter, ToolChoiceObjectComputer, ToolChoiceObjectFileSearch,
    ToolChoiceObjectFunction, ToolChoiceObjectImageGen, ToolChoiceObjectMCP,
    ToolChoiceObjectWebSearch

    :ivar type: Required. Known values are: "file_search", "function", "computer_use_preview",
     "web_search_preview", "image_generation", "code_interpreter", and "mcp".
    :vartype type: str or ~azure.ai.projects.models.ToolChoiceObjectType
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Required. Known values are: \"file_search\", \"function\", \"computer_use_preview\",
     \"web_search_preview\", \"image_generation\", \"code_interpreter\", and \"mcp\"."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ToolChoiceObjectCodeInterpreter(ToolChoiceObject, discriminator="code_interpreter"):
    """ToolChoiceObjectCodeInterpreter.

    :ivar type: Required.
    :vartype type: str or ~azure.ai.projects.models.CODE_INTERPRETER
    """

    type: Literal[ToolChoiceObjectType.CODE_INTERPRETER] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ToolChoiceObjectType.CODE_INTERPRETER  # type: ignore


class ToolChoiceObjectComputer(ToolChoiceObject, discriminator="computer_use_preview"):
    """ToolChoiceObjectComputer.

    :ivar type: Required.
    :vartype type: str or ~azure.ai.projects.models.COMPUTER
    """

    type: Literal[ToolChoiceObjectType.COMPUTER] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ToolChoiceObjectType.COMPUTER  # type: ignore


class ToolChoiceObjectFileSearch(ToolChoiceObject, discriminator="file_search"):
    """ToolChoiceObjectFileSearch.

    :ivar type: Required.
    :vartype type: str or ~azure.ai.projects.models.FILE_SEARCH
    """

    type: Literal[ToolChoiceObjectType.FILE_SEARCH] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ToolChoiceObjectType.FILE_SEARCH  # type: ignore


class ToolChoiceObjectFunction(ToolChoiceObject, discriminator="function"):
    """Use this option to force the model to call a specific function.

    :ivar type: For function calling, the type is always ``function``. Required.
    :vartype type: str or ~azure.ai.projects.models.FUNCTION
    :ivar name: The name of the function to call. Required.
    :vartype name: str
    """

    type: Literal[ToolChoiceObjectType.FUNCTION] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """For function calling, the type is always ``function``. Required."""
    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the function to call. Required."""

    @overload
    def __init__(
        self,
        *,
        name: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ToolChoiceObjectType.FUNCTION  # type: ignore


class ToolChoiceObjectImageGen(ToolChoiceObject, discriminator="image_generation"):
    """ToolChoiceObjectImageGen.

    :ivar type: Required.
    :vartype type: str or ~azure.ai.projects.models.IMAGE_GENERATION
    """

    type: Literal[ToolChoiceObjectType.IMAGE_GENERATION] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ToolChoiceObjectType.IMAGE_GENERATION  # type: ignore


class ToolChoiceObjectMCP(ToolChoiceObject, discriminator="mcp"):
    """Use this option to force the model to call a specific tool on a remote MCP server.

    :ivar type: For MCP tools, the type is always ``mcp``. Required.
    :vartype type: str or ~azure.ai.projects.models.MCP
    :ivar server_label: The label of the MCP server to use. Required.
    :vartype server_label: str
    :ivar name: The name of the tool to call on the server.
    :vartype name: str
    """

    type: Literal[ToolChoiceObjectType.MCP] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """For MCP tools, the type is always ``mcp``. Required."""
    server_label: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The label of the MCP server to use. Required."""
    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the tool to call on the server."""

    @overload
    def __init__(
        self,
        *,
        server_label: str,
        name: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ToolChoiceObjectType.MCP  # type: ignore


class ToolChoiceObjectWebSearch(ToolChoiceObject, discriminator="web_search_preview"):
    """Note: web_search is not yet available via Azure OpenAI.

    :ivar type: Required.
    :vartype type: str or ~azure.ai.projects.models.WEB_SEARCH
    """

    type: Literal[ToolChoiceObjectType.WEB_SEARCH] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""

    @overload
    def __init__(
        self,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ToolChoiceObjectType.WEB_SEARCH  # type: ignore


class ToolDescription(_Model):
    """Description of a tool that can be used by an agent.

    :ivar name: The name of the tool.
    :vartype name: str
    :ivar description: A brief description of the tool's purpose.
    :vartype description: str
    """

    name: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the tool."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A brief description of the tool's purpose."""

    @overload
    def __init__(
        self,
        *,
        name: Optional[str] = None,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ToolProjectConnection(_Model):
    """A project connection resource.

    :ivar project_connection_id: A project connection in a ToolProjectConnectionList attached to
     this tool. Required.
    :vartype project_connection_id: str
    """

    project_connection_id: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """A project connection in a ToolProjectConnectionList attached to this tool. Required."""

    @overload
    def __init__(
        self,
        *,
        project_connection_id: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ToolProjectConnectionList(_Model):
    """A set of project connection resources currently used by either the ``bing_grounding``,
       ``fabric_dataagent``, or ``sharepoint_grounding`` tools.

       :ivar project_connections: The project connections attached to this tool. There can be a
        maximum of 1 connection
    resource attached to the tool.
       :vartype project_connections: list[~azure.ai.projects.models.ToolProjectConnection]
    """

    project_connections: Optional[list["_models.ToolProjectConnection"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The project connections attached to this tool. There can be a maximum of 1 connection
 resource attached to the tool."""

    @overload
    def __init__(
        self,
        *,
        project_connections: Optional[list["_models.ToolProjectConnection"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TopLogProb(_Model):
    """The top log probability of a token.

    :ivar token: Required.
    :vartype token: str
    :ivar logprob: Required.
    :vartype logprob: float
    :ivar bytes: Required.
    :vartype bytes: list[int]
    """

    token: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    logprob: float = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""
    bytes: list[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Required."""

    @overload
    def __init__(
        self,
        *,
        token: str,
        logprob: float,
        bytes: list[int],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UserProfileMemoryItem(MemoryItem, discriminator="user_profile"):
    """A memory item specifically containing user profile information extracted from conversations,
    such as preferences, interests, and personal details.

    :ivar memory_id: The unique ID of the memory item. Required.
    :vartype memory_id: str
    :ivar updated_at: The last update time of the memory item. Required.
    :vartype updated_at: ~datetime.datetime
    :ivar scope: The namespace that logically groups and isolates memories, such as a user ID.
     Required.
    :vartype scope: str
    :ivar content: The content of the memory. Required.
    :vartype content: str
    :ivar kind: The kind of the memory item. Required. User profile information extracted from
     conversations.
    :vartype kind: str or ~azure.ai.projects.models.USER_PROFILE
    """

    kind: Literal[MemoryItemKind.USER_PROFILE] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The kind of the memory item. Required. User profile information extracted from conversations."""

    @overload
    def __init__(
        self,
        *,
        memory_id: str,
        updated_at: datetime.datetime,
        scope: str,
        content: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = MemoryItemKind.USER_PROFILE  # type: ignore


class VectorStoreFileAttributes(_Model):
    """Set of 16 key-value pairs that can be attached to an object. This can be
    useful for storing additional information about the object in a structured
    format, and querying for objects via API or the dashboard. Keys are strings
    with a maximum length of 64 characters. Values are strings with a maximum
    length of 512 characters, booleans, or numbers.

    """


class WebSearchAction(_Model):
    """WebSearchAction.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    WebSearchActionFind, WebSearchActionOpenPage, WebSearchActionSearch

    :ivar type: Required. Known values are: "search", "open_page", and "find".
    :vartype type: str or ~azure.ai.projects.models.WebSearchActionType
    """

    __mapping__: dict[str, _Model] = {}
    type: str = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])
    """Required. Known values are: \"search\", \"open_page\", and \"find\"."""

    @overload
    def __init__(
        self,
        *,
        type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class WebSearchActionFind(WebSearchAction, discriminator="find"):
    """Action type "find": Searches for a pattern within a loaded page.

    :ivar type: The action type. Required.
    :vartype type: str or ~azure.ai.projects.models.FIND
    :ivar url: The URL of the page searched for the pattern. Required.
    :vartype url: str
    :ivar pattern: The pattern or text to search for within the page. Required.
    :vartype pattern: str
    """

    type: Literal[WebSearchActionType.FIND] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The action type. Required."""
    url: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The URL of the page searched for the pattern. Required."""
    pattern: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The pattern or text to search for within the page. Required."""

    @overload
    def __init__(
        self,
        *,
        url: str,
        pattern: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = WebSearchActionType.FIND  # type: ignore


class WebSearchActionOpenPage(WebSearchAction, discriminator="open_page"):
    """Action type "open_page" - Opens a specific URL from search results.

    :ivar type: The action type. Required.
    :vartype type: str or ~azure.ai.projects.models.OPEN_PAGE
    :ivar url: The URL opened by the model. Required.
    :vartype url: str
    """

    type: Literal[WebSearchActionType.OPEN_PAGE] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The action type. Required."""
    url: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The URL opened by the model. Required."""

    @overload
    def __init__(
        self,
        *,
        url: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = WebSearchActionType.OPEN_PAGE  # type: ignore


class WebSearchActionSearch(WebSearchAction, discriminator="search"):
    """Action type "search" - Performs a web search query.

    :ivar type: The action type. Required.
    :vartype type: str or ~azure.ai.projects.models.SEARCH
    :ivar query: The search query. Required.
    :vartype query: str
    """

    type: Literal[WebSearchActionType.SEARCH] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The action type. Required."""
    query: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The search query. Required."""

    @overload
    def __init__(
        self,
        *,
        query: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = WebSearchActionType.SEARCH  # type: ignore


class WebSearchPreviewTool(Tool, discriminator="web_search_preview"):
    """Note: web_search is not yet available via Azure OpenAI.

    :ivar type: The type of the web search tool. One of ``web_search_preview`` or
     ``web_search_preview_2025_03_11``. Required.
    :vartype type: str or ~azure.ai.projects.models.WEB_SEARCH_PREVIEW
    :ivar user_location: The user's location.
    :vartype user_location: ~azure.ai.projects.models.Location
    :ivar search_context_size: High level guidance for the amount of context window space to use
     for the search. One of ``low``, ``medium``, or ``high``. ``medium`` is the default. Is one of
     the following types: Literal["low"], Literal["medium"], Literal["high"]
    :vartype search_context_size: str or str or str
    """

    type: Literal[ToolType.WEB_SEARCH_PREVIEW] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """The type of the web search tool. One of ``web_search_preview`` or
     ``web_search_preview_2025_03_11``. Required."""
    user_location: Optional["_models.Location"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The user's location."""
    search_context_size: Optional[Literal["low", "medium", "high"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """High level guidance for the amount of context window space to use for the search. One of
     ``low``, ``medium``, or ``high``. ``medium`` is the default. Is one of the following types:
     Literal[\"low\"], Literal[\"medium\"], Literal[\"high\"]"""

    @overload
    def __init__(
        self,
        *,
        user_location: Optional["_models.Location"] = None,
        search_context_size: Optional[Literal["low", "medium", "high"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ToolType.WEB_SEARCH_PREVIEW  # type: ignore


class WebSearchToolCallItemParam(ItemParam, discriminator="web_search_call"):
    """The results of a web search tool call. See the
    `web search guide </docs/guides/tools-web-search>`_ for more information.

        :ivar type: Required.
        :vartype type: str or ~azure.ai.projects.models.WEB_SEARCH_CALL
        :ivar action: An object describing the specific action taken in this web search call.
     Includes details on how the model used the web (search, open_page, find). Required.
        :vartype action: ~azure.ai.projects.models.WebSearchAction
    """

    type: Literal[ItemType.WEB_SEARCH_CALL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    action: "_models.WebSearchAction" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An object describing the specific action taken in this web search call.
 Includes details on how the model used the web (search, open_page, find). Required."""

    @overload
    def __init__(
        self,
        *,
        action: "_models.WebSearchAction",
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.WEB_SEARCH_CALL  # type: ignore


class WebSearchToolCallItemResource(ItemResource, discriminator="web_search_call"):
    """The results of a web search tool call. See the
    `web search guide </docs/guides/tools-web-search>`_ for more information.

        :ivar id: Required.
        :vartype id: str
        :ivar created_by: The information about the creator of the item.
        :vartype created_by: ~azure.ai.projects.models.CreatedBy
        :ivar type: Required.
        :vartype type: str or ~azure.ai.projects.models.WEB_SEARCH_CALL
        :ivar status: The status of the web search tool call. Required. Is one of the following types:
         Literal["in_progress"], Literal["searching"], Literal["completed"], Literal["failed"]
        :vartype status: str or str or str or str
        :ivar action: An object describing the specific action taken in this web search call.
     Includes details on how the model used the web (search, open_page, find). Required.
        :vartype action: ~azure.ai.projects.models.WebSearchAction
    """

    type: Literal[ItemType.WEB_SEARCH_CALL] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    status: Literal["in_progress", "searching", "completed", "failed"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The status of the web search tool call. Required. Is one of the following types:
     Literal[\"in_progress\"], Literal[\"searching\"], Literal[\"completed\"], Literal[\"failed\"]"""
    action: "_models.WebSearchAction" = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """An object describing the specific action taken in this web search call.
 Includes details on how the model used the web (search, open_page, find). Required."""

    @overload
    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        status: Literal["in_progress", "searching", "completed", "failed"],
        action: "_models.WebSearchAction",
        created_by: Optional["_models.CreatedBy"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = ItemType.WEB_SEARCH_CALL  # type: ignore


class WeeklyRecurrenceSchedule(RecurrenceSchedule, discriminator="Weekly"):
    """Weekly recurrence schedule.

    :ivar type: Weekly recurrence type. Required. Weekly recurrence pattern.
    :vartype type: str or ~azure.ai.projects.models.WEEKLY
    :ivar days_of_week: Days of the week for the recurrence schedule. Required.
    :vartype days_of_week: list[str or ~azure.ai.projects.models.DayOfWeek]
    """

    type: Literal[RecurrenceType.WEEKLY] = rest_discriminator(name="type", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Weekly recurrence type. Required. Weekly recurrence pattern."""
    days_of_week: list[Union[str, "_models.DayOfWeek"]] = rest_field(
        name="daysOfWeek", visibility=["read", "create", "update", "delete", "query"]
    )
    """Days of the week for the recurrence schedule. Required."""

    @overload
    def __init__(
        self,
        *,
        days_of_week: list[Union[str, "_models.DayOfWeek"]],
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.type = RecurrenceType.WEEKLY  # type: ignore


class WorkflowDefinition(AgentDefinition, discriminator="workflow"):
    """The workflow specification in CSDL format.

    :ivar rai_config: Configuration for Responsible AI (RAI) content filtering and safety features.
    :vartype rai_config: ~azure.ai.projects.models.RaiConfig
    :ivar kind: Required.
    :vartype kind: str or ~azure.ai.projects.models.WORKFLOW
    :ivar trigger: (Deprecated) The CSDL trigger definition. Use ``workflow`` property instead to
     send CSDL yaml definition inline.
    :vartype trigger: dict[str, any]
    :ivar workflow: The CSDL YAML definition of the workflow.
    :vartype workflow: str
    """

    kind: Literal[AgentKind.WORKFLOW] = rest_discriminator(name="kind", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Required."""
    trigger: Optional[dict[str, Any]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """(Deprecated) The CSDL trigger definition. Use ``workflow`` property instead to send CSDL yaml
     definition inline."""
    workflow: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The CSDL YAML definition of the workflow."""

    @overload
    def __init__(
        self,
        *,
        rai_config: Optional["_models.RaiConfig"] = None,
        trigger: Optional[dict[str, Any]] = None,
        workflow: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
        self.kind = AgentKind.WORKFLOW  # type: ignore
