# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential
from azure.mgmt.healthcareapis import HealthcareApisManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-healthcareapis
# USAGE
    python iotconnector_create.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = HealthcareApisManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="subid",
    )

    response = client.iot_connectors.begin_create_or_update(
        resource_group_name="testRG",
        workspace_name="workspace1",
        iot_connector_name="blue",
        iot_connector={
            "identity": {"type": "SystemAssigned"},
            "location": "westus",
            "properties": {
                "deviceMapping": {
                    "content": {
                        "template": [
                            {
                                "template": {
                                    "deviceIdExpression": "$.deviceid",
                                    "timestampExpression": "$.measurementdatetime",
                                    "typeMatchExpression": "$..[?(@heartrate)]",
                                    "typeName": "heartrate",
                                    "values": [
                                        {"required": "true", "valueExpression": "$.heartrate", "valueName": "hr"}
                                    ],
                                },
                                "templateType": "JsonPathContent",
                            }
                        ],
                        "templateType": "CollectionContent",
                    }
                },
                "ingestionEndpointConfiguration": {
                    "consumerGroup": "ConsumerGroupA",
                    "eventHubName": "MyEventHubName",
                    "fullyQualifiedEventHubNamespace": "myeventhub.servicesbus.windows.net",
                },
            },
            "tags": {"additionalProp1": "string", "additionalProp2": "string", "additionalProp3": "string"},
        },
    ).result()
    print(response)


# x-ms-original-file: specification/healthcareapis/resource-manager/Microsoft.HealthcareApis/stable/2022-06-01/examples/iotconnectors/iotconnector_Create.json
if __name__ == "__main__":
    main()
