#------------------------------------------------------
# This is a test proc.  To try this out, source this
# file to wish and type 'tst'.  A help button will
# be displayed.  Click on the button and play with
# the menus.
#-----------------------------------------------------
proc tst {} {
  catch {destroy .hbutton}
  menubutton .hbutton -text Help -menu .hbutton.m -underline 0 
  button .quit -text Quit -command {destroy .}
  menu .hbutton.m
  ##  Create the help menus
  HLP_load .hbutton.m "hlp.txt"
  pack append . .hbutton top .quit bottom
  }

proc HLP_load {w filename} {
#-------------------------------------------------------------
# A general purpose hierarchical help system.  The general idea
# is to pass the name of a button in w and the entry name of a help
# file in filename.  These procedures look for the help file using
# the directories listed in the user's PATH environment variable and,
# if found, proceed to build a heirarchical menu structure using
# cascade menus as required.  The help organization is thus
# removed from the program and can be changed simply by editing the
# text file.
#
# Copyright 1993 
# Permission to use, copy, modify, and distribute this
# software and its documentation for any purpose and without
# fee is hereby granted, provided that this copyright
# notice appears in all copies. There are no representations about 
# the suitability of this software for any purpose.  It is provided 
# "as is" without express or implied warranty.
#
# Paul Amaranth 6/2/93  V 1.0
#
# To keep the name space pollution down, all external identifiers
# are prefixed with HLP.
# 
#
# Global variables used:
#     HLP_menus      -- a list of the menus to create
#     HLP_text-nn    -- The text of the help item.  nn is a number.
#     HLP_last_entry -  Used for building the menus
#
# Procs:
#     HLP_load      - Load in the help file.  Called by application
#                     This is the ONLY proc directly called by the app.
#                     Returns 0 is successful, 1 if an error.
#     HLP_add_menus - Add the menu info in the help file into the
#                     internal format
#     HLP_instantiate_menus  - Realize the menu informat as cascade
#                     menus and command buttons.
#     HLP_rinstantiate_menu - Recursively called form of above.
#     HLP_Command   - Proc called to display info when a help button is
#                     pushed.
#
# The help file format looks like this:
#   MENU name
# followed by text for the menu item.  A heirarchical arrangement is
# specified by using additional names.  EG MENU Name1 Name2 would have
# name2 as a subitem on a cascade menu for Name1.  If you want to 
# include spaces in the menu label, enclose the string in braces {}.
# There are some simple examples in hlp.txt included as a demo.
# NOTE: This string is treated as a list by HLP_add_menus; it should
#       be in list format.
#
# The text is saved in global variables with the name hlp_txt-n.  Single
# menu items are bound to a command button, multiple are assigned a
# cascade menu.
#
# Text is displayed in a top level window called .hlp
#
# You do not have to define intermediate menus, they are automatically
# created as cascade menus.

#-------------------------------------------------------------
# Look through the PATH env variable and see if we can find
# a help file with the name 'filename'.  If so, open it and
# build the help menu with the text.
#-------------------------------------------------------------

global env
global HLP_menus 

set t [catch {set path $env(PATH)}]

# If no path, just bail out
if {$t} {return 1}

set paths [split $path ":"]

foreach p $paths {
  set t [catch {set fn [open $p/$filename r]}]
  if {!$t} break
  }

# If unsuccessful, bail out
if {$t} {return 1}

set HLP_menus {}
set text_no 0

while {[gets $fn line] != -1} {

  if {[string range $line 0 3] == "MENU"} {
    incr text_no;
    global HLP_text-$text_no
    set HLP_text-$text_no {}
    HLP_add_menus $text_no [lrange $line 1 end]
    } else {
    set HLP_text-$text_no [lappend HLP_text-$text_no $line ]
    }
  }

if {$text_no > 0} {HLP_instantiate_menus $w}
return 0
}

#----------------------------------------------------------------------
# Add this, and all intervening names, into the menu list
# The list data structure is
# { level <Button label> {Subitem list} <text no.> }
# Level 0 items are direct descendants of the parent window.
# Either subitem-list or text_no may be null, but not both at once.
#----------------------------------------------------------------------
proc HLP_add_menus {item_no menu_list} {

global HLP_menus HLP_last_entry

set fixup_items {}

# Start at the end of the list to allow for fixups
for {set mn [expr [llength $menu_list]-1]} {$mn > -1} {incr mn -1} {
  set m [lindex $menu_list $mn]
  set mnu_len [llength $HLP_menus]
  set found  0
  for {set i 0} {$i< $mnu_len} {incr i} {
      set m_item [lindex $HLP_menus $i]
      if {[lindex $m_item 0] == $mn && [lindex $m_item 1] == $m} {
          set found $i
          break
         }
      }


   if {!$found} {
      # Add item, only if at end of menu list
      if {$mnu_len == 0 || ($mn == [expr [llength $menu_list]-1])} {
           set tnum $item_no
           set submenu {}
      } else {
           set tnum {}
           set submenu $HLP_last_entry
           }
      lappend HLP_menus [list $mn $m $submenu $tnum]
      set HLP_last_entry [expr [llength $HLP_menus]-1]

    } else {
      # Found it, if not at end, add in the submenu to the list
      if {$i!=[expr $mnu_len-1]} {
         set mnu_item [lindex $HLP_menus $i]
         set submenu [lindex $mnu_item 2]
         if {[lsearch $submenu $HLP_last_entry] == -1} {
           set submenu [lappend submenu $HLP_last_entry]
           }
         set mnu_item [lreplace $mnu_item 2 2 $submenu]
         set HLP_menus [lreplace $HLP_menus $i $i $mnu_item]
         set HLP_last_entry $i
     }
   }
  }
}

proc HLP_instantiate_menus {button} {
#--------------------------------------------------------------
# Take the menu list structure and turn it into a bunch of
# realizable menus.  This is the startup proc for the recursive
# process.  Look for level 0 entries and fire them off.
#--------------------------------------------------------------

global HLP_menus 

set cntr 1

foreach mnu $HLP_menus {
  set mnu_level [lindex $mnu 0]
  set mnu_label [lindex $mnu 1]
  set mnu_submenu [lindex $mnu 2]
  set mnu_textno [lindex $mnu 3]

  if {$mnu_level == 0} {
     if {[llength $mnu_submenu]==0} {
          eval $button add command -label [list $mnu_label] -command \{HLP_Command $mnu_textno\}
        } else {
          incr cntr
          $button add cascade -label [list $mnu_label] -menu $button.$cntr
          menu $button.$cntr
          foreach sm $mnu_submenu { HLP_rinstantiate_menu $button.$cntr $sm }
        }
     }
  }
}

proc HLP_rinstantiate_menu { button entry } {
#--------------------------------------------------------------
# Recursive proc to follow the menu tree, instantiating as
# we go
#--------------------------------------------------------------
global HLP_menus 

set mnu [lindex $HLP_menus $entry] 
set mnu_level [lindex $mnu 0]
set mnu_label [lindex $mnu 1]
set mnu_submenu [lindex $mnu 2]
set mnu_textno [lindex $mnu 3]


if {[llength $mnu_submenu]==0} {
         eval $button add command -label [list $mnu_label] -command \{HLP_Command $mnu_textno\}
   } else {
         $button add cascade -label [list $mnu_label] -menu $button.$entry
         menu $button.$entry
         foreach sm $mnu_submenu { HLP_rinstantiate_menu $button.$entry $sm }
   }
}

proc HLP_Command { help_no } {
#---------------------------------------------------------------------
# We have been called with the number of a help text to display.  Put
# it up in a modal dialog and wait for the user to continue.
# If the amount of text is large enough, use scrollbars.
#---------------------------------------------------------------------

catch {detroy .hlp}
toplevel .hlp
wm title .hlp Help
wm iconname .hlp Help

frame .hlp.f -relief raised -border 1
listbox .hlp.f.list -yscroll ".hlp.f.yscroll set" \
                    -xscroll ".hlp.f.xscroll set" -relief sunken -setgrid 1 
scrollbar .hlp.f.yscroll -relief sunken -command ".hlp.f.list yview"
scrollbar .hlp.f.xscroll -relief sunken -command ".hlp.f.list xview" \
                    -orient horizontal
button .hlp.but -text "Cancel" -command {destroy .hlp}


global HLP_text-$help_no

set width 0
set line_count 0
set use_x 0
set use_y 0

set helptext [eval set HLP_text-$help_no]
foreach str  $helptext {
    incr line_count
    set sl [string length $str]
    if {$sl > $width} {set width $sl}
   .hlp.f.list insert end $str
   }

if {$width > 70} {set width 70; set use_x 1}
if {$line_count > 25} {set line_count 25; set use_y 1}
if {$width == 0} {
     set width 30
     .hlp.f.list insert end "No help available"
     }
if {$line_count == 0} {set line_count 1}
set geom [format "%dx%d" $width $line_count]

if {$use_y} {pack append .hlp.f .hlp.f.yscroll {right filly} }
if {$use_x} {pack append .hlp.f .hlp.f.xscroll {bottom fillx} }

pack append .hlp.f  .hlp.f.list {expand fill}
pack append .hlp .hlp.f {top expand fill} .hlp.but {top}

.hlp.f.list configure -geometry $geom
tkwait visibility .hlp
grab .hlp
tkwait window .hlp

}
