# Implements a text widget for browsing and editing

# For arbitrary symbol generation

global symname symnum
set symname "sym"
set symnum 0

# Returns a new symbol upon each call
proc gensym {} {
  global symname symnum
  incr symnum
  return $symname$symnum
}


# Some entry & label creation procedures.

# Creates an entry & label and sets focus to the entry. ESC-TAB toggles between
# entry and t, which can be any other widget.
# t, label, and entry should be absolute widget names.
proc create_f_entry {t label entry} {
	catch {label $label -relief raised}
	catch {entry $entry}
	pack append [winfo parent $label] $label {left}
	pack append [winfo parent $entry] $entry {left fillx}
	focus $entry

	bind $entry <Escape> "focus $t"
	bind $t <Escape> "focus $entry"
}

# Destroys label and entry created by create_f_entry.
proc destroy_f_entry {t label entry} {
	destroy $label ; destroy $entry
	bind $t <Escape> ";"
}

# Time to display labels
set flash_time 3000

# Displays a label for $flash_time seconds. Label lives in $parent.
# Args gets passed to the label as configuration options.
proc flash_label {parent args} {
	global flash_time
	if {($parent == ".")} {set newlabel ".m[gensym]"
	} else {set newlabel "$parent.m[gensym]"}
	eval label $newlabel $args
	pack append $parent $newlabel {left}
	after $flash_time "destroy $newlabel"
}

# An abbreviation to show in labels in lieu of their normal contents.
set label_abbrev "-"

# Toggles a label between its normal contents and $label_abbrev
proc label_expand_toggle {label variable} {
	global label_abbrev
	if {($variable == [lindex [$label configure -textvariable] 4])} {
		$label configure -textvariable "" -text $label_abbrev
	} else {$label configure -textvariable $variable
}}

# Binds MB1 to toggle between label's normal display and an abbreviated one.
proc label_expand_bind {label variable} {
	$label configure -textvariable $variable -relief flat
	bind $label <ButtonRelease-1> "label_expand_toggle %W $variable"
}


# Create the frame widget (if it doesn't already exist)
if {(![info exists frame])} {
	set frame .frame
	catch {frame $frame -relief raised}
	catch {entry $frame.e -relief sunken -bd 2}
	$frame.e insert end [winfo name .]
	$frame.e configure -state disabled -width 5
	bind $frame.e <B1-Motion> {$frame.e select from 0 ; $frame.e select to end}
	bind $frame.e <Any-ButtonPress-1> {$frame.e select from 0 ; $frame.e select to end}
	pack append $frame $frame.e {left}
	pack append . $frame {bottom fillx}
}

# Create the quit button (if user wants)
if {(![info exists dont_make_quit])} {
	catch {button $frame.q -text "Quit" -command "quit_beth"}
	pack append $frame $frame.q {right expand fillx}
}

# Create the text widget (if it doesn't already exist) and scrollbar.
if {(![info exists text])} {
	set text .text
	catch {text $text -relief sunken -bd 2 -yscrollcommand ".s set" -setgrid true}
	focus default $text
	focus $text
	catch {scrollbar .s -relief raised -command "$text yview"}
	# All Text bindings are disabled; they are re-enabled in other files.
	bind Text <Control-Key> {;}
	bind Text <Control-d> {;}
	bind Text <Control-v> {;}
	bind Text <Meta-Key>  {;}
	bind Text <Control-Meta-Key> {;}
	pack append . .s {left filly} $text {top expand fill}
}
