/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.test;

import gnu.prolog.Version;
import gnu.prolog.database.PrologTextLoaderError;
import gnu.prolog.io.OperatorSet;
import gnu.prolog.io.ReadOptions;
import gnu.prolog.io.TermReader;
import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.Term;
import gnu.prolog.vm.Environment;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologCode;
import java.io.StringReader;
import java.util.Iterator;

public class CodeDumper {
    private CodeDumper() {
    }

    public static void main(String[] args) {
        try {
            System.out.println("GNU Prolog for Java (" + Version.getVersion() + ") Interpreted Code dumper (c) Constantine Plotnikov, 1997-1999.");
            if (args.length < 2) {
                System.out.println("usage: java gnu.prolog.test.CodeDumper <text to load> <predicate indicator>");
                System.out.println("example: java gnu.prolog.test.CodeDumper append.pro append/3");
            }
            String textToLoad = args[0];
            String goalToRun = args[1];
            Environment env = new Environment();
            env.ensureLoaded(AtomTerm.get(textToLoad));
            Interpreter interpreter = env.createInterpreter();
            env.runInitialization(interpreter);
            Iterator<PrologTextLoaderError> i$ = env.getLoadingErrors().iterator();
            while (i$.hasNext()) {
                PrologTextLoaderError element;
                PrologTextLoaderError err = element = i$.next();
                System.err.println(err);
            }
            StringReader rd = new StringReader(goalToRun);
            TermReader trd = new TermReader(rd, env);
            ReadOptions rd_ops = new ReadOptions(new OperatorSet());
            Term goalTerm = trd.readTermEof(rd_ops);
            PrologCode code = env.getPrologCode(CompoundTermTag.get((CompoundTerm)goalTerm));
            System.out.println(code);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

