/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.database;

import gnu.prolog.database.Pair;
import gnu.prolog.database.Predicate;
import gnu.prolog.database.PredicateListener;
import gnu.prolog.database.PredicateUpdatedEvent;
import gnu.prolog.database.PrologTextLoaderError;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.Term;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Module {
    protected Map<CompoundTermTag, Predicate> tag2predicate = new HashMap<CompoundTermTag, Predicate>();
    protected List<Pair<PrologTextLoaderError, Term>> initialization = Collections.synchronizedList(new ArrayList());
    protected List<PredicateListener> predicateListeners = new ArrayList<PredicateListener>();

    public synchronized Predicate createDefinedPredicate(CompoundTermTag tag) {
        if (this.tag2predicate.containsKey(tag)) {
            throw new IllegalStateException("A predicate already exists.");
        }
        Predicate p = new Predicate(this, tag);
        this.tag2predicate.put(tag, p);
        this.predicateUpdated(tag);
        return p;
    }

    public synchronized Predicate getDefinedPredicate(CompoundTermTag tag) {
        Predicate p = this.tag2predicate.get(tag);
        if (p == null) {
            return null;
        }
        return p;
    }

    public synchronized void removeDefinedPredicate(CompoundTermTag tag) {
        this.tag2predicate.remove(tag);
        this.predicateUpdated(tag);
    }

    public synchronized void addInitialization(PrologTextLoaderError prologTextLoaderError, Term term) {
        this.initialization.add(new Pair<PrologTextLoaderError, Term>(prologTextLoaderError, term));
    }

    public synchronized List<Pair<PrologTextLoaderError, Term>> getInitialization() {
        return this.initialization;
    }

    public synchronized void clearInitialization() {
        this.initialization = Collections.synchronizedList(new ArrayList());
    }

    public synchronized Set<CompoundTermTag> getPredicateTags() {
        return this.tag2predicate.keySet();
    }

    public synchronized void predicateUpdated(CompoundTermTag tag) {
        PredicateUpdatedEvent evt = new PredicateUpdatedEvent(this, tag);
        for (PredicateListener listener : new ArrayList<PredicateListener>(this.predicateListeners)) {
            listener.predicateUpdated(evt);
        }
    }

    public synchronized void addPredicateListener(PredicateListener listener) {
        this.predicateListeners.add(listener);
    }

    public synchronized void removePredicateListener(PredicateListener listener) {
        this.predicateListeners.remove(listener);
    }
}

