/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.io;

import gnu.prolog.io.Operator;
import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.IntegerTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.BacktrackInfo;
import gnu.prolog.vm.ExecuteOnlyCode;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;
import java.util.ArrayList;
import java.util.Iterator;

public class Predicate_current_op
extends ExecuteOnlyCode {
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        if (backtrackMode) {
            CurrentOpBacktrackInfo bi = (CurrentOpBacktrackInfo)interpreter.popBacktrackInfo();
            interpreter.undo(bi.startUndoPosition);
            return Predicate_current_op.nextSolution(interpreter, bi);
        }
        Term op = args[2];
        Term specifier = args[1];
        Term priority = args[0];
        if (!(op instanceof AtomTerm) && !(op instanceof VariableTerm)) {
            PrologException.typeError(TermConstants.atomAtom, op);
        }
        if (!(specifier instanceof VariableTerm) && specifier != TermConstants.xfxAtom && specifier != TermConstants.xfyAtom && specifier != TermConstants.yfxAtom && specifier != TermConstants.fxAtom && specifier != TermConstants.fyAtom && specifier != TermConstants.xfAtom && specifier != TermConstants.yfAtom) {
            PrologException.domainError(TermConstants.operatorSpecifierAtom, specifier);
        }
        if (!(priority instanceof VariableTerm)) {
            if (priority instanceof IntegerTerm) {
                IntegerTerm tt = (IntegerTerm)priority;
                if (tt.value <= 0 || 1200 < tt.value) {
                    PrologException.domainError(TermConstants.operatorPriorityAtom, priority);
                }
            } else {
                PrologException.domainError(TermConstants.operatorPriorityAtom, priority);
            }
        }
        ArrayList<AtomTerm> ops = new ArrayList<AtomTerm>();
        ArrayList<AtomTerm> specifiers = new ArrayList<AtomTerm>();
        ArrayList<IntegerTerm> priorities = new ArrayList<IntegerTerm>();
        for (Operator o : interpreter.getEnvironment().getOperatorSet().getOperators()) {
            ops.add(o.tag.functor);
            priorities.add(IntegerTerm.get(o.priority));
            AtomTerm a = null;
            switch (o.specifier) {
                case 0: {
                    a = TermConstants.fxAtom;
                    break;
                }
                case 1: {
                    a = TermConstants.fyAtom;
                    break;
                }
                case 5: {
                    a = TermConstants.xfAtom;
                    break;
                }
                case 6: {
                    a = TermConstants.yfAtom;
                    break;
                }
                case 2: {
                    a = TermConstants.xfxAtom;
                    break;
                }
                case 3: {
                    a = TermConstants.xfyAtom;
                    break;
                }
                case 4: {
                    a = TermConstants.yfxAtom;
                }
            }
            specifiers.add(a);
        }
        CurrentOpBacktrackInfo bi = new CurrentOpBacktrackInfo();
        bi.startUndoPosition = interpreter.getUndoPosition();
        bi.ops = ops.iterator();
        bi.specifiers = specifiers.iterator();
        bi.priorities = priorities.iterator();
        bi.op = op;
        bi.specifier = specifier;
        bi.priority = priority;
        return Predicate_current_op.nextSolution(interpreter, bi);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int nextSolution(Interpreter interpreter, CurrentOpBacktrackInfo bi) throws PrologException {
        try {
            while (true) {
                if (!bi.ops.hasNext()) {
                    return -1;
                }
                Term op = bi.ops.next();
                Term specifier = bi.specifiers.next();
                Term priority = bi.priorities.next();
                if (interpreter.simpleUnify(op, bi.op) == 1 && interpreter.simpleUnify(specifier, bi.specifier) == 1 && interpreter.simpleUnify(priority, bi.priority) == 1) {
                    interpreter.pushBacktrackInfo(bi);
                    return 0;
                }
                interpreter.undo(bi.startUndoPosition);
            }
        }
        catch (PrologException ex) {
            interpreter.undo(bi.startUndoPosition);
            throw ex;
        }
    }

    private static class CurrentOpBacktrackInfo
    extends BacktrackInfo {
        int startUndoPosition;
        Iterator<AtomTerm> ops;
        Iterator<AtomTerm> specifiers;
        Iterator<IntegerTerm> priorities;
        Term op;
        Term specifier;
        Term priority;

        CurrentOpBacktrackInfo() {
            super(-1, -1);
        }
    }
}

