/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.io;

import gnu.prolog.io.Operator;
import gnu.prolog.io.OperatorSet;
import gnu.prolog.io.WriteOptions;
import gnu.prolog.term.AtomTerm;
import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.CompoundTermTag;
import gnu.prolog.term.FloatTerm;
import gnu.prolog.term.IntegerTerm;
import gnu.prolog.term.JavaObjectTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.TermConstants;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;

public class TermWriter
extends PrintWriter {
    protected static final CompoundTermTag numbervarsTag = CompoundTermTag.get("$VAR", 1);
    protected static final CompoundTermTag curly1Tag = CompoundTermTag.get("{}", 1);
    protected static final OperatorSet defaultOperatorSet = new OperatorSet();
    protected static final WriteOptions defaultWriteOptions = new WriteOptions(defaultOperatorSet);

    static {
        TermWriter.defaultWriteOptions.ignoreOps = false;
        TermWriter.defaultWriteOptions.quoted = true;
        TermWriter.defaultWriteOptions.numbervars = false;
    }

    public static String toString(Term term) {
        try {
            StringWriter sout = new StringWriter();
            TermWriter tout = new TermWriter(sout);
            tout.print(term);
            tout.flush();
            return sout.toString();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("BAD TERM: " + ex.toString());
        }
    }

    public static String toString(Term term, WriteOptions options) {
        try {
            StringWriter sout = new StringWriter();
            TermWriter tout = new TermWriter(sout);
            tout.print(options, term);
            tout.flush();
            return sout.toString();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("BAD TERM: " + ex.toString());
        }
    }

    public TermWriter(Writer w) {
        super(w, true);
    }

    public void print(WriteOptions options, Term term) {
        this.displayTerm(options, 1200, term);
    }

    public void print(Term term) {
        this.print((WriteOptions)defaultWriteOptions.clone(), term);
    }

    public void print(OperatorSet opSet, Term term) {
        WriteOptions options = new WriteOptions(opSet);
        options.ignoreOps = false;
        options.quoted = true;
        options.numbervars = false;
        this.print(options, term);
    }

    protected void displayTerm(WriteOptions options, int priority, Term term) {
        if (term == null) {
            this.print("<<NULL>>");
        } else {
            term = term.dereference();
        }
        if (term instanceof AtomTerm) {
            boolean isOp;
            boolean bl = isOp = TermWriter.isOperator(options.operatorSet, (AtomTerm)term) && options.quoted;
            if (isOp) {
                this.print("(");
            }
            this.displayAtom(options, (AtomTerm)term);
            if (isOp) {
                this.print(")");
            }
        } else if (term instanceof IntegerTerm) {
            this.displayInteger(options, (IntegerTerm)term);
        } else if (term instanceof FloatTerm) {
            this.displayFloat(options, (FloatTerm)term);
        } else if (term instanceof CompoundTerm) {
            this.displayCompound(options, priority, (CompoundTerm)term);
        } else if (term instanceof VariableTerm) {
            this.displayVariable(options, (VariableTerm)term);
        } else if (term instanceof JavaObjectTerm) {
            this.displayJavaObject(options, (JavaObjectTerm)term);
        }
    }

    protected void displayCompound(WriteOptions options, int priority, CompoundTerm term) {
        if (options.numbervars && term.tag == numbervarsTag && term.args[0] instanceof IntegerTerm) {
            int n = ((IntegerTerm)term.args[0]).value;
            this.print((char)(n % 26 + 65));
            this.print(n / 26);
            return;
        }
        if (!options.ignoreOps) {
            if (term.tag == TermConstants.listTag) {
                this.print('[');
                this.displayList(options, term);
                this.print(']');
                return;
            }
            if (term.tag == curly1Tag) {
                this.print('{');
                this.displayTerm(options, 1201, term.args[0]);
                this.print('}');
                return;
            }
            Operator op = options.operatorSet.getOperatorForTag(term.tag);
            if (op != Operator.nonOperator) {
                if (op.priority > priority) {
                    this.print('(');
                }
                switch (op.specifier) {
                    case 0: {
                        this.displayAtom(options, term.tag.functor);
                        this.print(" ");
                        this.displayTerm(options, op.priority - 1, term.args[0]);
                        break;
                    }
                    case 1: {
                        this.displayAtom(options, term.tag.functor);
                        this.print(" ");
                        this.displayTerm(options, op.priority, term.args[0]);
                        break;
                    }
                    case 2: {
                        this.displayTerm(options, op.priority - 1, term.args[0]);
                        this.print(" ");
                        this.displayAtom(options, term.tag.functor);
                        this.print(" ");
                        this.displayTerm(options, op.priority - 1, term.args[1]);
                        break;
                    }
                    case 3: {
                        this.displayTerm(options, op.priority - 1, term.args[0]);
                        this.print(" ");
                        this.displayAtom(options, term.tag.functor);
                        this.print(" ");
                        this.displayTerm(options, op.priority, term.args[1]);
                        break;
                    }
                    case 4: {
                        this.displayTerm(options, op.priority, term.args[0]);
                        this.print(" ");
                        this.displayAtom(options, term.tag.functor);
                        this.print(" ");
                        this.displayTerm(options, op.priority - 1, term.args[1]);
                        break;
                    }
                    case 5: {
                        this.displayTerm(options, op.priority - 1, term.args[0]);
                        this.print(" ");
                        this.displayAtom(options, term.tag.functor);
                        break;
                    }
                    case 6: {
                        this.displayTerm(options, op.priority, term.args[0]);
                        this.print(" ");
                        this.displayAtom(options, term.tag.functor);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Wrong operator specifier = " + op.specifier);
                    }
                }
                if (op.priority > priority) {
                    this.print(')');
                }
                return;
            }
        }
        this.displayAtom(options, term.tag.functor);
        this.print('(');
        int i = 0;
        while (i < term.args.length) {
            if (i > 0) {
                this.print(",");
            }
            this.displayTerm(options, 999, term.args[i]);
            ++i;
        }
        this.print(')');
    }

    protected void displayList(WriteOptions options, CompoundTerm term) {
        this.displayTerm(options, 999, term.args[0]);
        Term tail = term.args[1];
        if (tail != null) {
            tail = tail.dereference();
        }
        if (tail != TermConstants.emptyListAtom) {
            if (tail instanceof CompoundTerm && ((CompoundTerm)tail).tag == TermConstants.listTag) {
                this.print(",");
                this.displayList(options, (CompoundTerm)tail);
            } else {
                this.print("|");
                this.displayTerm(options, 999, tail);
            }
        }
    }

    protected void displayFloat(WriteOptions options, FloatTerm term) {
        if (options.quoted) {
            this.print(term.value);
        } else {
            this.print(term.value);
        }
    }

    protected void displayInteger(WriteOptions options, IntegerTerm term) {
        this.print(term.value);
    }

    protected void displayVariable(WriteOptions options, VariableTerm variable) {
        if (options.variable2name == null) {
            options.variable2name = new HashMap<Term, String>();
        }
        String name = options.variable2name.get(variable);
        if (options.declaredVariableNames && name == null) {
            name = variable.name;
        }
        if (name == null) {
            int n = options.numberOfVariables++;
            name = "_" + (char)(n % 26 + 65) + n / 26;
            options.variable2name.put(variable, name);
        }
        this.print(name);
    }

    protected void displayJavaObject(WriteOptions options, JavaObjectTerm term) {
        if (options.javaObjects) {
            if (options.javaObjectsToString) {
                if (term.value == null) {
                    this.print("null");
                } else {
                    this.print(TermWriter.getSingleQuoted(term.value.toString()));
                }
            } else {
                this.print("java_object('");
                if (term.value == null) {
                    this.print("null");
                } else {
                    this.print(term.value.getClass().getName());
                    this.print(" ");
                    this.print(System.identityHashCode(term.value));
                }
                this.print("')");
            }
        }
    }

    protected static boolean isOperator(OperatorSet set, AtomTerm term) {
        Operator fxOp = set.lookupFx(term.value);
        Operator xfOp = set.lookupXf(term.value);
        return fxOp != Operator.nonOperator || xfOp != Operator.nonOperator;
    }

    protected void displayAtom(WriteOptions options, AtomTerm atom) {
        if (options.quoted) {
            String value = atom.value;
            this.print(TermWriter.needBeQuoted(value) ? TermWriter.getSingleQuoted(value) : value);
        } else {
            this.print(atom.value);
        }
    }

    protected static String getSingleQuoted(String s) {
        StringBuffer buf = new StringBuffer(s.length() + 6);
        buf.append('\'');
        int n = s.length();
        int i = 0;
        while (i < n) {
            TermWriter.appendQuotedChar(buf, s.charAt(i), '\'');
            ++i;
        }
        buf.append('\'');
        return buf.toString();
    }

    protected static boolean needBeQuoted(String s) {
        if (s.length() == 0) {
            return true;
        }
        char ch = s.charAt(0);
        if (TermWriter.isSoloChar(ch)) {
            return s.length() != 1 || ch == '%';
        }
        if (TermWriter.isGraphicsChar(ch)) {
            int n = s.length();
            if (n >= 2 && s.charAt(0) == '/' && s.charAt(1) == '*') {
                return true;
            }
            int i = 1;
            while (i < n) {
                if (!TermWriter.isGraphicsChar(s.charAt(i))) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (TermWriter.isAtomStartChar(ch)) {
            int n = s.length();
            int i = 1;
            while (i < n) {
                if (!TermWriter.isAtomChar(s.charAt(i))) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    protected static boolean isSoloChar(char c) {
        switch (c) {
            case '!': 
            case '%': 
            case '(': 
            case ')': 
            case ',': 
            case ';': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    protected static boolean isGraphicsChar(char ch) {
        switch (ch) {
            case '#': 
            case '$': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '^': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    protected static boolean isAtomStartChar(char c) {
        return 'a' <= c && c <= 'z';
    }

    protected static boolean isAtomChar(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_';
    }

    protected static void appendQuotedChar(StringBuffer buf, char ch, char quote) {
        if (ch == quote) {
            buf.append('\\');
            buf.append(quote);
        } else if (ch <= ' ' || ch >= '\u007f') {
            buf.append('\\');
            switch (ch) {
                case '\u0007': {
                    buf.append('a');
                    break;
                }
                case '\b': {
                    buf.append('b');
                    break;
                }
                case '\f': {
                    buf.append('f');
                    break;
                }
                case '\n': {
                    buf.append('n');
                    break;
                }
                case '\t': {
                    buf.append('t');
                    break;
                }
                case '\u000b': {
                    buf.append('v');
                    break;
                }
                case '\r': {
                    buf.append('r');
                    break;
                }
                default: {
                    buf.append('x');
                    buf.append(Integer.toHexString(ch));
                    buf.append('\\');
                    break;
                }
            }
        } else {
            switch (ch) {
                case '\\': {
                    buf.append("\\");
                }
            }
            buf.append(ch);
        }
    }
}

