/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.vm.buildins.allsolutions;

import gnu.prolog.term.CompoundTerm;
import gnu.prolog.term.Term;
import gnu.prolog.term.VariableTerm;
import gnu.prolog.vm.BacktrackInfo;
import gnu.prolog.vm.ExecuteOnlyCode;
import gnu.prolog.vm.Interpreter;
import gnu.prolog.vm.PrologException;
import gnu.prolog.vm.TermConstants;
import gnu.prolog.vm.interpreter.Predicate_call;
import java.util.ArrayList;
import java.util.List;

public class Predicate_findall
extends ExecuteOnlyCode {
    @Override
    public int execute(Interpreter interpreter, boolean backtrackMode, Term[] args) throws PrologException {
        ArrayList<Term> list = new ArrayList<Term>();
        Predicate_findall.checkList(args[2]);
        int rc = Predicate_findall.findall(interpreter, backtrackMode, args[0], args[1], list);
        if (rc == 1) {
            return interpreter.unify(args[2], CompoundTerm.getList(list));
        }
        return -1;
    }

    public static int findall(Interpreter interpreter, boolean backtrackMode, Term template, Term goal, List<Term> list) throws PrologException {
        int startUndoPosition = interpreter.getUndoPosition();
        BacktrackInfo startBi = interpreter.peekBacktrackInfo();
        try {
            try {
                int rc;
                boolean callBacktrackMode = false;
                do {
                    rc = Predicate_call.staticExecute(interpreter, callBacktrackMode, goal);
                    callBacktrackMode = true;
                    if (rc == -1) continue;
                    list.add((Term)template.clone());
                } while (rc == 0);
                if (rc == 1) {
                    interpreter.undo(startUndoPosition);
                }
                return 1;
            }
            catch (RuntimeException rex) {
                PrologException.systemError(rex);
                return -1;
            }
        }
        catch (PrologException ex) {
            interpreter.popBacktrackInfoUntil(startBi);
            interpreter.undo(startUndoPosition);
            throw ex;
        }
    }

    public static void checkList(Term list) throws PrologException {
        Term exArg = list;
        while (list != TermConstants.emptyListAtom) {
            if (list instanceof VariableTerm) {
                return;
            }
            if (!(list instanceof CompoundTerm)) {
                PrologException.typeError(TermConstants.listAtom, exArg);
            }
            CompoundTerm ct = (CompoundTerm)list;
            if (ct.tag != TermConstants.listTag) {
                PrologException.typeError(TermConstants.listAtom, exArg);
            }
            list = ct.args[1].dereference();
        }
    }
}

