/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.io;

import gnu.prolog.term.CompoundTermTag;

public final class Operator {
    public static final int FX = 0;
    public static final int FY = 1;
    public static final int XFX = 2;
    public static final int XFY = 3;
    public static final int YFX = 4;
    public static final int XF = 5;
    public static final int YF = 6;
    public static final int NONE = -1;
    public static final int MAX_PRIORITY = 1200;
    public static final int MIN_PRIORITY = 1;
    public static final Operator nonOperator = new Operator("", -1, -1);
    public final String name;
    public final int specifier;
    public final int priority;
    public final CompoundTermTag tag;

    protected Operator(String name, int specifier, int priority) {
        this.name = name;
        this.specifier = specifier;
        this.priority = priority;
        switch (specifier) {
            case 0: 
            case 1: 
            case 5: 
            case 6: {
                this.tag = CompoundTermTag.get(name, 1);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.tag = CompoundTermTag.get(name, 2);
                break;
            }
            case -1: {
                this.tag = null;
                break;
            }
            default: {
                this.tag = null;
                throw new IllegalArgumentException("invalid specifier = " + specifier);
            }
        }
    }

    public String toString() {
        String[] specifiers = new String[]{"NONE", "FX", "FY", "XFX", "XFY", "YFX", "XF", "YF"};
        return "Opearator[name='" + this.name + "';specifier='" + specifiers[this.specifier + 1] + ";priority=" + this.priority + "]";
    }
}

