.TH user-setup L "2/14/93" "Auburn University"
\" @(#)user-setup.man	2.3	2/14/93	Auburn University Engineering
.SH NAME
user-setup \- interactively configure a user's environment
.SH SYNOPSIS
.B user-setup
[
.I \-nc | -m
]
.SH DESCRIPTION
.B user-setup
is an interactive program designed to help users configure their environment.
.B user-setup
will generate a new
.I .cshrc
and
.I .login
file for the user.  The old 
.I .cshrc
and
.I .login
files will be saved as
.I .cshrc.bak
and
.I .login.bak
respectively.  The user can quit at any time without the changes taking
place.  The
.I .cshrc
and 
.I .login
files are guaranteed to be correct by construction.
.LP
.B user-setup
works as a menu driven front end to the
.B Modules
package.  The
.B Modules
package allows for the dynamic modification of a user's
environment via
.I modulefiles.
Each major application will have a corresponding
.I modulefile
which will contain the configuration commands for adding the 
application to the user's environment.
.B user-setup
is used to select the initial collection of
.I modulefiles
to be used upon logging in or starting a shell.
This same list of
.I modulefiles
can be used by
.B make-olwm-menu
to generate a customized OpenLook Window Manager,
.B olwm,
menu which contains easy to use menu entries for the
.I modulefiles
selected.
.LP
.B user-setup
will present the user with a top level menu.  Under this menu
.I modulefiles
are grouped using a 
.I class/application/version
designation.  The top level menu also contains an
.I apply
entry to apply the changes to the user's environment, a
.I help
entry for online help, and a 
.I show
entry to show all currently selected
.I modulefiles.
Menu entries can be selected by number or a unique string of
characters matching the menu item name.
For example:
.RS
.PD 0
.LP
1 - apply
.LP
2 - help
.LP
3 - show
.LP
4 - math
.LP
5 - office
.LP
6 - unix
.LP
7 - win
.RE
.PD
.LP
Each
.I modulefile
may require the previous selection of another
.I modulefile.
For instance, a windowing application will require the prior selection 
of the appropriate windowing system.
To assure an orderly initialization 
.B user-setup
requires an entry from the
.I unix
class first followed by an entry
.I win
class.  This forces a user to select the flavor of UNIX, BSD or 
System-V, and a windowing system before any other
.I modulefiles.
Other
.I modulefile
prerequisites are handled as each
.I modulefile
is selected.
.LP
.B user-setup
checks for
.I modulefile
conflicts when a
.I modulefile
is selected.  For example, if the
.I modulefile win/X11/R4
is already selected and the user tries to select the conflicting
.I modulefile win/X11/R5
.B user-setup
will recognize the conflict, notify the user, and disallow the 
.I win/X11/R5
selection.
It is the responsibility of the user to correct any conflicts.
.LP
A typical
.B user-setup
session involves selecting a collection of
.I modulefiles
then applying the changes to the user's environment.
When a user selects a
.I modulefile
they will be shown a brief description of the application
and asked whether to add the
.I module
to their environment or not.
This is a simple yes or no question.
If the answer is yes, then the
.I module
will be checked for conflicts and added to the list of
.I modulefiles
to be applied.  If the answer is no, then the
.I modulefile
will not be added to the list.
If a
.I module
was previously selected, then a no response will remove the
.I module
from the list.
The list can be previewed with the
.I show
command in the top level menu.
Once the user has selected the desired
.I modules
then the changes can be applied with the
.I apply
command.
.LP
Applying the changes will cause
.B user-setup
to completely regenerate new
.I .cshrc
and
.I .login
files.
The 
.I .cshrc
file will contain a personal customizable section.
This section will be copied verbatim into the new
.I .cshrc
file's user customizable section.  This allows users to make adjustments
to their
.I .cshrc
file which will not be lost the next time they run
.B user-setup.
The user customizable section is clearly marked and located near the end
of the
.I .cshrc
file so that the user can override any variables set by 
.B user-setup.
.LP
The 
.I \-nc
option will cause the system default personal customization to
be included rather than the user's.  This option is useful when there
is a mistake in the personal customization rendering the environment
useless.
.LP
The
.I \-m
option will make 
.B user-setup
attempt all changes to the
.I .cshrc
file with module commands only.  Only the module load line will be
changed.  This will allow the user to keep customizations outside
of the personal customization area.
.LP
.B user-setup
can be run again at any time to add new applications to the user's 
environment or to change windowing systems.
.LP
Unlike the
.B module
command,
.B user-setup
only modifies the user's "dot" files.
.LP
The user will typically need to logout and then login for the changes
to take place.
.LP
.SH FILES
.TP 2.1i
~/.cshrc
contains most environment configuration.
.TP 2.1i
~/.login
starts the desired window system on login.
.TP 2.1i
/vol/info/user-setup2
directory which contains the
.B user-setup
files.
.SH "SEE ALSO"
.B csh(1), module(1), olwm(1), make-olwm-menu(1)
.SH AUTHORS
.PD 0
Richard Elling <relling@eng.auburn.edu>,
.LP
Matthew Long <long1@eng.auburn.edu>
.PD
.SH BUGS
The
.I .login
file is completely regenerated from scratch.
Any user customizations to the
.I .login
file will be lost.
.SH NOTES
Users tend to ignore the descriptions of the
.I modules;
causing them to miss important information.
.LP
Currently only the C-shell, 
.B csh,
is supported.
.LP
There is a 
.B lot
of software available on the College of Engineering network.  Nobody
knows how it all works.  Each application has its own demands
and quirks.  Every effort will be made to keep the
.I modulefiles
and their actions current.  Feedback is very important in maintaining
an accurate set of questions.  Mail all changes to 
.I admin@eng.auburn.edu
.LP
If a user selects all available software, then it will take a
.B long
time for the user to login.  This is because most of the software is
mounted on demand and it takes several seconds to mount each software
volume.  The net result is that it could take several minutes to login.
Therefore, users should only select those software packages which
they need to use.
