.TH ckitem L "6/5/91" "Auburn University"
\" @(#)ckitem.man	1.2	6/5/91	Auburn University Engineering
.SH NAME
ckitem \- build a menu; prompt for and return a menu item
.SH SYNOPSIS
.B ckitem
[
.B \-Q
]
[
.B \-d
.I default
]
[
.B \-f
.I file
]
[
.B \-l
.I label
]
[
.B \-p
.I prompt
]
[
.I choice
[...]
]
.SH DESCRIPTION
.B ckitem
builds a menu and prompts the user to choose one item from a menu
of items.  It then verifies the response.  Options for this command
define, among other things, a prompt message whose response will be
a menu item and a default value (which will be returned if the user
responds with a carraige return.)

By default, the menu is formatted so that each item is prepended by
a number.  The default item will have the string "[default]"
associated with it.  The items are presented in the order that they
are read from 
.I file
or the command line.

Valid responses may be the number or as much of the string
required for a unique identification of the item.  The string match
is case insensitive.
.SH OPTIONS
The options and arguments for this command are:
.TP 1.0i
-Q
Specifies that quit will not be allowed as a valid response.
.TP 1.0i
-d
Defines the default value as
.I default.
The default is not validated and so does not have to meet any criteria.
.TP 1.0i
-f
Defines a file,
.I file,
hich contains a list of items to be displayed.
[The format of this file is:
.B token<tab>description.
Lines beginning with a pound sign (#) are designated as comments and
ignored.
.TP 1.0i
-l
Defines a label,
.I label,
to print above the menu.
.TP 1.0i
-p
Defines the prompt message as
.I prompt.
.SH "SEE ALSO"
ckyorn(l), ckpath(l)
.SH "EXIT CODES"
.PD 0
0 = Successful execution
.PP
1 = EOF on input
.PP
2 = Usage Error
.PP
3 = User termination (quit)
.PP
4 = No choices
.PD
.SH AUTHOR
Richard Elling <relling@eng.auburn.edu>
.SH BUGS
.B ckitem
doesn't support all of the features of the System V Release 4 version.
Of special note, all of the formatting options are missing.
.SH NOTES
.B ckitem
prints the item list and question to stderr and accepts input from
stdin.  This allows
.B ckitem
to appear interactive and yet return a string on stdout.

The default prompt for
.B ckitem
is:
.PP
.RS
.B
Enter selection [?,??,q]:
.RE
.PP
One question mark will give a help message and then redisplay the 
prompt.  Two question marks will give a help message and then 
redisplay the menu label, the menu and the prompt.

The default error message is:
.PP
.RS
.PD 0
.B
ERROR - Does not match an available menu selection.
.PP
.B
Enter one of the following:
.PP
.B
- the number fo the menu item you wish to select
.PP
.B
- the token associated with the menu item
.PP
.B
- partial string which uniquely identifies the token for the menu item
.PP
.B
- ?? to reprint the menu
.RE
.PD
.PP
The default help message is:
.PP
.RS
.PD 0
.B
Enter one of the following:
.PP
.B
- the number fo the menu item you wish to select
.PP
.B
- the token associated with the menu item
.PP
.B
- partial string which uniquely identifies the token for the menu item
.PP
.B
- ?? to reprint the menu
.RE
.PD
.PP
When the quit option is chosen (and allowed), 
.B q
is returned along with the return code
.B 3.
