/*------------------------------------------------------------------------

      File:  cmdInfo.c
   Project:  Tcl Modules
   Created:  Tue Oct 22 23:45:57 1991
    Author:  John L. Furlani<john.furlani@East.Sun.COM>
  Revision:  1.2
  Last Mod:  20:19:55, 1/19/92

  Description of File:
		
	
	
	
	
	
	
	
------------------------------------------------------------------------*/
/***********************************************************************
* Copyright 1991 by John L. Furlani.  All rights reserved.
* 
* This material was written by John L. Furlani.
*
* Redistribution and use in source and binary forms are permitted
* provided that this entire copyright notice is duplicated in all such
* copies, and that any documentation, announcements, and other
* materials related to such distribution and use acknowledge that the
* software was developed by John Furlani.  No charge, other than an 
* "at-cost" distribution fee, may be charged for copies, derivations, 
* or distributions of this material without the express written 
* consent of the copyright holder.  The name of the author may not
* be used to endorse or promote products derived from this material 
* without specific prior written permission
*
* THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
* WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
* MERCHANTIBILITY AND FITNESS FOR ANY PARTICULAR PURPOSE.
************************************************************************/
static char SccsId[] = "@(#)cmdInfo.c	1.2\t1/19/92";

#include "global.h"

int
cmdModuleInfo(ClientData client_data,
	      Tcl_Interp* interp,
	      int argc,
	      char* argv[])
{
  if(argc < 2) {
    Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
		     " info-descriptor descriptor-args\"", (char *) NULL);
    return TCL_ERROR;
  }
  
  if(!strcmp(argv[1], "flags")) {
    char tmpbuf[6];
    sprintf(tmpbuf, "%d", flags);
    Tcl_SetResult(interp, tmpbuf, NULL);
  } if(!strcmp(argv[1], "mode")) {
    if(argc < 3) {
      Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
		       " info-descriptor mode mode-type\"", (char *) NULL);
      return TCL_ERROR;
    }

    Tcl_SetResult(interp, "0", TCL_STATIC);

    if(!strcmp(argv[2], "load")) {
      if(flags & M_LOAD) Tcl_SetResult(interp, "1", TCL_STATIC);
    }
    else if(!strcmp(argv[2], "remove")) {
      if(flags & M_REMOVE) Tcl_SetResult(interp, "1", TCL_STATIC);
    }
    else if(!strcmp(argv[2], "display")) {
      if(flags & M_DISPLAY) Tcl_SetResult(interp, "1", TCL_STATIC);
    }
    else if(!strcmp(argv[2], "switch1")) {
      if(flags & M_SWSTATE1) Tcl_SetResult(interp, "1", TCL_STATIC);
    }
    else if(!strcmp(argv[2], "switch2")) {
      if(flags & M_SWSTATE2) Tcl_SetResult(interp, "1", TCL_STATIC);
    }
    else if(!strcmp(argv[2], "switch3")) {
      if(flags & M_SWSTATE3) Tcl_SetResult(interp, "1", TCL_STATIC);
    }
    else if(!strcmp(argv[2], "switch")) {
      if(flags & M_SWITCH) Tcl_SetResult(interp, "1", TCL_STATIC);
    }
    else {
      Tcl_AppendResult(interp, 
		       "Unrecognized module-info mode type: ", argv[2],
		       (char *) NULL);
      return TCL_ERROR;
    }
  } else if(!strcmp(argv[1], "name")) {
    Tcl_SetResult(interp, current_module, TCL_VOLATILE);
  } else {

    Tcl_AppendResult(interp, "Unrecognized module-info descriptor: ", argv[1],
		     (char *) NULL);
    return TCL_ERROR;
  }

  return TCL_OK;
}
    
