/*------------------------------------------------------------------------

      File:  cmdAlias.c
   Project:  Modules
   Created:  Tue Oct 22 23:45:57 1991
    Author:  John L. Furlani<john.furlani@East.Sun.COM>
  Revision:  1.2
  Last Mod:  20:19:54, 1/19/92

  Description of File:
		
	
	
	
	
	
	
	
------------------------------------------------------------------------*/
/***********************************************************************
* Copyright 1991 by John L. Furlani.  All rights reserved.
* 
* This material was written by John L. Furlani.
*
* Redistribution and use in source and binary forms are permitted
* provided that this entire copyright notice is duplicated in all such
* copies, and that any documentation, announcements, and other
* materials related to such distribution and use acknowledge that the
* software was developed by John Furlani.  No charge, other than an 
* "at-cost" distribution fee, may be charged for copies, derivations, 
* or distributions of this material without the express written 
* consent of the copyright holder.  The name of the author may not
* be used to endorse or promote products derived from this material 
* without specific prior written permission
*
* THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
* WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
* MERCHANTIBILITY AND FITNESS FOR ANY PARTICULAR PURPOSE.
************************************************************************/
static char SccsId[] = "@(#)cmdAlias.c	1.2\t1/19/92";

#include "global.h"

int
cmdSetAlias(ClientData client_data,
	  Tcl_Interp* interp,
	  int argc,
	  char* argv[])
{
  if(!strncmp(argv[0], "un", 2) && (argc != 2)) {
    Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
		     " variable\"", (char *) NULL);
    return TCL_ERROR;
  } else if(!strncmp(argv[0], "set", 3) && (argc != 3)) {
    Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
		     " variable\"", (char *) NULL);
    return TCL_ERROR;
  }

  if(flags & M_DISPLAY) {
    fprintf(stderr, "Set Alias %s to '%s'\n", argv[1], argv[2]);
    return 0;
  }

  if(!strncmp(argv[0], "un", 2)) {
    if(flags & (M_SWSTATE1 | M_SWSTATE2)) return TCL_OK;
    unset_shell_alias(argv[1]);
  } else {
    if(flags & M_SWSTATE1) {
      set_backup(backup_alias_changes, argv[1], SWMARKER);
    } else if(flags & M_SWSTATE2) {
      set_backup(backup_alias_changes, argv[1], argv[2]);
    } else if(flags & M_SWSTATE3) {
      char* backup_val;
      if(backup_val = get_backup(backup_alias_changes, argv[1])) {
	if(! strcmp(backup_val, SWMARKER))
	  unset_shell_alias(argv[1]);
      }
    } else if(flags & M_REMOVE) {
      unset_shell_alias(argv[1]);
    } else {
      set_shell_alias(argv[1], argv[2]);
    }
  }
  
  return TCL_OK;
}
