/*------------------------------------------------------------------------

      File:  LocateModule.c
   Project:  Tcl Modules
   Created:  Tue Oct 22 23:45:57 1991
    Author:  John L. Furlani<john.furlani@East.Sun.COM>
  Revision:  1.3
  Last Mod:  20:19:53, 1/19/92

  Description of File:
		
	
	
	
	
	
	
	
------------------------------------------------------------------------*/
/***********************************************************************
* Copyright 1991 by John L. Furlani.  All rights reserved.
* 
* This material was written by John L. Furlani.
*
* Redistribution and use in source and binary forms are permitted
* provided that this entire copyright notice is duplicated in all such
* copies, and that any documentation, announcements, and other
* materials related to such distribution and use acknowledge that the
* software was developed by John Furlani.  No charge, other than an 
* "at-cost" distribution fee, may be charged for copies, derivations, 
* or distributions of this material without the express written 
* consent of the copyright holder.  The name of the author may not
* be used to endorse or promote products derived from this material 
* without specific prior written permission
*
* THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
* WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
* MERCHANTIBILITY AND FITNESS FOR ANY PARTICULAR PURPOSE.
************************************************************************/
static char SccsId[] = "@(#)LocateModule.c	1.3\t1/19/92";

#include <string.h>
#include <sys/types.h>
#include <dirent.h>
#include <sys/stat.h>
#include "global.h"

int
filename_compare(char** fi1, char** fi2) {
  return strcmp(*fi2, *fi1);
}

char*
Locate_ModuleFile(Tcl_Interp* interp,
		  char*       modulename,
		  char**      newname)
{
  static char full_path[1024];
  char*  tmppath = getenv("MODULEPATH");
  char*  p;
  char** pathlist;
  int    numpaths, i;

  if(modulename[0] == '/' || modulename[0] == '.') { /* Full Path Name! */
    p = (char*) rindex(modulename, '/');
    *p = '\0';

    if((*newname = GetModuleName(interp, modulename, (p + 1))) == NULL) 
      return NULL;

    if(*newname == NULL) goto exit;

    if(!strcmp((p + 1), *newname)) {
      *p = '/';
      strcpy(full_path, modulename);
      return full_path;
    }

    sprintf(full_path, "%s/%s", modulename, *newname);

    *p = '/';

    return full_path;
  }

  if(! tmppath) {
    current_module = NULL;
    return NULL;
  }

  pathlist = SplitIntoList(interp, tmppath, &numpaths);

  for(i = 0; i < numpaths; i++) {
    *newname = GetModuleName(interp, pathlist[i], modulename);

    if(*newname == NULL) continue;

    sprintf(full_path, "%s/%s", pathlist[i], *newname);

    return full_path;
  }

 exit:
  return NULL;
}

char*
GetModuleName(Tcl_Interp* interp,
	      char*       path,
	      char*       modulename)
{
  char*          newname, *p;
  char**         filelist;
  int            i, j, numlist;

  if((filelist = SortedDirList(interp, path, modulename, &numlist)) == NULL)
    return NULL;

  newname = strdup(filelist[0]);

  FreeList(filelist, numlist);

  return newname;
}


char**
SortedDirList(Tcl_Interp* interp,
	      char* path,
	      char* modulename,
	      int* listcnt) {
  struct dirent* file;
  struct stat    stats;
  DIR*           subdirp;
  char*          full_path;
  char**         filelist;
  int            i, j, n;

  if((full_path = (char*) malloc(strlen(path) + strlen(modulename) + 2)) 
     == NULL) {
    Tcl_AppendResult(interp, "malloc() failed in SortedDirList()", NULL);
    return NULL;
  }

  if((filelist = (char**) calloc(n = 100, sizeof(char*))) == NULL) {
    Tcl_AppendResult(interp, "The calloc() failed in SortDirList().",
		     NULL);
    return NULL;
  }
    
  sprintf(full_path, "%s/%s", path, modulename);

  if(stat(full_path, &stats) == 0) {
    if(S_ISREG(stats.st_mode)) {
      *listcnt = 1;
      filelist[0] = strdup(modulename);
      return filelist;
    }
  } else {
    return NULL;
  }

  if(S_ISDIR(stats.st_mode)) {
    if((subdirp = opendir(full_path)) == NULL)
      return NULL;
    
    for(file = readdir(subdirp), i = 0, j = 0; file != NULL;
	file = readdir(subdirp), i++) {
      if(j == n) {
	if((filelist = (char**) realloc((char*) filelist, 
					(size_t) n *= 2)) == NULL) {
	  Tcl_AppendResult(interp, 
			   "The realloc() failed in SortDirList().",
			   NULL);
	  return NULL;
	}
      }
      
      if(strcmp(file->d_name, ".") && strcmp(file->d_name, "..")) {
	filelist[j] = (char*) malloc(strlen(modulename) + 
				     strlen(file->d_name) + 2);
	sprintf(filelist[j++], "%s/%s", modulename, file->d_name);
      }
    }
    
    qsort((void*) filelist, (size_t) j, 
	  (size_t) sizeof(char*), filename_compare);
    
    *listcnt = j;
    
    free(full_path);
    closedir(subdirp);
    
    return filelist;
  }

  return NULL;
}

char**
SplitIntoList(Tcl_Interp* interp,
	      char* pathenv, 
	      int* numpaths) 
{
  char**  pathlist;
  char*   modpath, *dirname;
  int     i, n;

  if((modpath = (char*) malloc(strlen(pathenv) + 1)) == NULL) {
    Tcl_AppendResult(interp, "The malloc() failed in SplitIntoList().",
		     NULL);
    return NULL;
  }

  if((pathlist = (char**) calloc(n = 100, sizeof(char*))) == NULL) {
    Tcl_AppendResult(interp, "The calloc() failed in SplitIntoList().",
		     NULL);
    return NULL;
  }

  strcpy(modpath, pathenv);
  
  dirname = strtok(modpath, ": ");
  for(i = 0; dirname; dirname = strtok(NULL, ": ")) {
    if(i == n) {
      if((pathlist = (char**) realloc((char*) pathlist, 
				      (size_t) n *= 2)) == NULL) {
	Tcl_AppendResult(interp, 
			 "The realloc() failed in SplitIntoList().",
			 NULL);
	return NULL;
      }
    }
    
    pathlist[i] = (char*) malloc(strlen(dirname) + 1);
    strcpy(pathlist[i++], dirname);
  }

  *numpaths = i;

  return pathlist;
}

void
FreeList(char** list, int numelem) {
  register int j;

  if(!list) return;

  for(j = 0; j < numelem; j++)
    if(list[j])
      free((void*) list[j]);

  free((void*) list);
}



