/*This line lets emacs recognize this as -*- C -*- Code
 *-----------------------------------------------------------------------------
 *
 * Project:	Tcl Modules
 * Created:	92/10/16
 * Author:	John L. Furlani<john.furlani@East.Sun.COM>
 *
 * Description:
 *      Provides fast aquisition of the information available via uname.  This
 *  shows a 1000% improvement over having to exec the actual uname program
 *  from within a modulefile.
 *	
 * $Log: cmdUname.c,v $
 *
 *
 * Revision 1.1  1992/11/05  23:38:33  jlf
 * Initial revision
 *
 *---------------------------------------------------------------------------*/
static char Id[] =
    "$Id: cmdUname.c,v 2.0 1993/02/21 00:01:01 jlf Exp jlf $";

#include "global.h"

#ifdef HAS_UNAME
#include <sys/utsname.h>

int
cmdUname(ClientData client_data,
	  Tcl_Interp* interp,
	  int argc,
	  char* argv[])
{
    struct utsname namestruct;
    int  length;
    char c;
    
    
    if(argc != 2) {
        Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
                         " member\"", (char *) NULL);
        return TCL_ERROR;
    }
    length = strlen(argv[1]);
    c = argv[1][0];

    if(uname(&namestruct) < 0) {
        Tcl_AppendResult(interp, "uname(2) failed", NULL);
        return TCL_ERROR;
    }

    if(c == 's' && !strncmp(argv[1], "sysname", length)) {
        Tcl_SetResult(interp, namestruct.sysname, TCL_VOLATILE);
        return TCL_OK;
    } else if(c == 'n' && !strncmp(argv[1], "nodename", length)) {
        Tcl_SetResult(interp, namestruct.nodename, TCL_VOLATILE);
        return TCL_OK;
    } else if(c == 'r' && !strncmp(argv[1], "release", length)) {
        Tcl_SetResult(interp, namestruct.release, TCL_VOLATILE);
        return TCL_OK;
    } else if(c == 'v' && !strncmp(argv[1], "version", length)) {
        Tcl_SetResult(interp, namestruct.version, TCL_VOLATILE);
        return TCL_OK;
    } else if(c == 'm' && !strncmp(argv[1], "machine", length)) {
        Tcl_SetResult(interp, namestruct.machine, TCL_VOLATILE);
        return TCL_OK;
    } else {
        Tcl_AppendResult(interp, "bad option \"", argv[1],
                         "\": should be sysname, nodename, release, version, ",
                         "or machine",
                         NULL);
        return TCL_ERROR;
    }
}

#else

int
cmdUname(ClientData client_data,
	  Tcl_Interp* interp,
	  int argc,
	  char* argv[])
{
    static char hostname[BUFSIZ];
    int  length;
    char c;
    
    
    if(argc != 2) {
        Tcl_AppendResult(interp, "wrong # args: should be \"", argv[0],
                         " member\"", (char *) NULL);
        return TCL_ERROR;
    }
    length = strlen(argv[1]);
    c = argv[1][0];

    if(c == 's' && !strncmp(argv[1], "sysname", length)) {
        Tcl_SetResult(interp, UNAME_SYSNAME, TCL_STATIC);
        return TCL_OK;
    } else if(c == 'n' && !strncmp(argv[1], "nodename", length)) {
#ifdef HAS_GETHOSTNAME
        gethostname(hostname, BUFSIZ);
        Tcl_SetResult(interp, hostname, TCL_STATIC);
#else
#ifdef PHOSTNAME
        FILE* hname;
        if((hname = popen(PHOSTNAME, "r")) == NULL) {
            Tcl_AppendResult(interp, "Couldn't popen to get hostname", 
                             (char *) NULL);
            return TCL_ERROR;
        }
        fgets(hostname, BUFSIZ, hname);
        hostname[strlen(hostname)-1] = '\0';  /* remove \n */
        Tcl_SetResult(interp, hostname, TCL_STATIC);
        pclose(hname);
#else
        Tcl_SetResult(interp, UNAME_NODENAME, TCL_STATIC);
#endif
#endif
        return TCL_OK;
    } else if(c == 'r' && !strncmp(argv[1], "release", length)) {
        Tcl_SetResult(interp, UNAME_RELEASE, TCL_STATIC);
        return TCL_OK;
    } else if(c == 'v' && !strncmp(argv[1], "version", length)) {
        Tcl_SetResult(interp, UNAME_VERSION, TCL_STATIC);
        return TCL_OK;
    } else if(c == 'm' && !strncmp(argv[1], "machine", length)) {
        Tcl_SetResult(interp, UNAME_MACHINE, TCL_STATIC);
        return TCL_OK;
    } else {
        Tcl_AppendResult(interp, "bad option \"", argv[1],
                         "\": should be sysname, nodename, release, version, ",
                         "or machine",
                         NULL);
        return TCL_ERROR;
    }
}
#endif
