/*This line lets emacs recognize this as -*- C -*- Code
 *-----------------------------------------------------------------------------
 *
 * Project:	Tcl Modules
 * Created:	92/06/20
 * Author:	John L. Furlani<john.furlani@East.Sun.COM>
 *
 * Description:
 *      Prepends (and appends) directories to the MODULEPATH environment
 *  variable to enable access to more modulefiles.
 *	
 * $Log: ModuleCmd_Use.c,v $
 *
 *
 * Revision 1.2  1993/01/22  17:34:39  jlf
 * Fixed such that when removing a modulefile that adds a directory to
 * MODULESPATH, it will be removed.
 *
 * Revision 1.1  1992/11/05  23:56:17  jlf
 * Initial revision
 *
 *---------------------------------------------------------------------------*/
static char Id[] =
    "$Id: ModuleCmd_Use.c,v 2.0 1993/02/21 00:00:25 jlf Exp jlf $";

#include <sys/types.h>
#include <sys/stat.h>
#include "global.h"

void
append_to_modulesbeginenv(Tcl_Interp* interp, char* var)
{
    char* filename;
    FILE* file;

    filename = Tcl_GetVar2(interp, "env", "_MODULESBEGINENV_", TCL_GLOBAL_ONLY);
    if(filename) {
        char* val;
        val = Tcl_GetVar2(interp, "env", var, TCL_GLOBAL_ONLY);
        if(var) {
            if((file=fopen(filename, "a+")) != NULL) {
                fprintf(file, "%s=%s\n", var, val);
                fclose(file);
            }
        }
    }
}

int  ModuleCmd_Use(Tcl_Interp* interp,
		   int         argc,
		   char*       argv[])
{
  struct stat  stats;
  char*        pathargv[4];
  int          i,start=0;
  
  if(argc < 1) {
    Tcl_AppendResult(interp,
		     "Wrong number of arguments:  usage is ", 
		     "'use [-append] dir [dir ...]'", NULL);
    return TCL_ERROR;
  }

  if(flags & M_REMOVE) { 
      return ModuleCmd_UnUse(interp, argc, argv);
  }
      
  if(*argv[0] == '-' && !strncmp(argv[0], "-append", 7)) {
      pathargv[0] = "append-path";
      start=1;
  } else {
      pathargv[0] = "prepend-path";
  }

  pathargv[1] = "MODULEPATH";
  pathargv[3] = NULL;
  for(i=start; i < argc; i++) {
    if(stat(argv[i], &stats) < 0) {
      Tcl_AppendResult(interp, argv[i], " is not found or unreadable", NULL);
      return TCL_ERROR;
    } else if(! S_ISDIR(stats.st_mode))  {
      Tcl_AppendResult(interp, argv[i], " is not a directory", NULL);
      return TCL_ERROR;
    }

    pathargv[2] = argv[i];
    if(cmdSetPath((ClientData) 0, interp, 3, pathargv) == TCL_ERROR)
      return TCL_ERROR;
  }
  
  /*
   *  What I'm going to do here is add the new value of MODULESPATH to the end
   *  of the beginenvcache so that update will be able to find its
   *  modulefiles.
   */
  append_to_modulesbeginenv(interp, "MODULEPATH");
      
  return TCL_OK;
}

int  ModuleCmd_UnUse(Tcl_Interp* interp,
		     int         argc,
		     char*       argv[])
{
  struct stat  stats;
  char*        pathargv[4];
  int          i = 0;
  
  if(argc < 1) {
    Tcl_AppendResult(interp,
		     "Wrong number of arguments:  usage is ", 
		     "'unuse dir [dir ...]'", NULL);
    return TCL_ERROR;
  }
  
  pathargv[0] = "remove-path";
  pathargv[1] = "MODULEPATH";
  pathargv[3] = NULL;
  for(i = 0; i < argc; i++) {
    pathargv[2] = argv[i];
    if(cmdRemovePath((ClientData) 0, interp, 3, pathargv) == TCL_ERROR)
      return TCL_ERROR;
  }
  
  /*
   *  What I'm going to do here is add the new value of MODULESPATH to the end
   *  of the beginenvcache so that update will be able to find its
   *  modulefiles.
   */
  append_to_modulesbeginenv(interp, "MODULEPATH");
      
  return TCL_OK;
}


