/*This line lets emacs recognize this as -*- C -*- Code
 *-----------------------------------------------------------------------------
 *
 * Project:	Tcl Modules
 * Created:	92/06/20
 * Author:	John L. Furlani<john.furlani@East.Sun.COM>
 *
 * Description:
 *      Lists the currently loaded modulefiles.
 *	
 * $Log: ModuleCmd_List.c,v $
 *
 *
 * Revision 1.3  1993/01/20  17:46:38  jlf
 * Fixed computation of the terminal_width.
 *
 * Revision 1.2  1993/01/20  03:27:52  jlf
 * Modified the list command to format the output into columns.  Added
 * numbers by each modulefile so the load order is clear.
 *
 * Revision 1.1  1992/11/05  23:50:09  jlf
 * Initial revision
 *
 *---------------------------------------------------------------------------*/
static char Id[] =
    "$Id: ModuleCmd_List.c,v 2.0 1993/02/21 00:00:07 jlf Exp jlf $";

#include "global.h"
#include <termios.h>
#include <fcntl.h>

static int
compute_maxwidth(char** list)
{
    int maxwidth = 0;
    while(*list) {
        int entry_len = strlen(*list++);

        if(entry_len > maxwidth) 
            maxwidth = entry_len;
    }

    return maxwidth;
}

static void 
print_spaced_file(char* name, int number, int maxwidth, int space)
{
  int filelen;

  chk4spch(name);  /* turn any weird characters into ? marks */

  filelen = strlen(name);

  fprintf(stderr, "%3d) %s",  number, name);

  if(space) {
      while(filelen < maxwidth) {
          filelen++;
          putc(' ', stderr);
      }
  }
}

static int
print_aligned_files(char** list, int tcount)
{
    int      i, j, cnt, columns, num_rows, ent;
    int      maxwidth = 0;
    int      terminal_width = 80;
    struct   winsize window_size;

    if(isatty(2))
        if(ioctl(2, TIOCGWINSZ, &window_size) != -1)
            terminal_width = (window_size.ws_col == 0 ? 80 : 
                              window_size.ws_col);

    maxwidth = compute_maxwidth(list) + 2;

    /*
     *  The 5 is added to take account of the five extra spaces
     *  used to print out the modulefile number.  Subtract 8 from
     *  terminal_width to account for the tab at the beginning of
     *  each line.
     */
    if((columns = (terminal_width-8)/(maxwidth+5)) == 0)
        columns = 1;

    num_rows = (tcount-1)/columns+1;

    for(j=0; j<num_rows; j++) {
        fprintf(stderr, "\t");
        for(i=0; i<columns; i++) {
            ent = (num_rows * i) + j;
            if(ent < tcount)
                print_spaced_file(list[ent], ent+1, maxwidth, i!=columns-1);
        }
        fprintf(stderr, "\n");
    }

    return 1;
}


int ModuleCmd_List(Tcl_Interp* interp,
                   char*       argv[])
{
    char* loaded = getenv("LOADEDMODULES");
    
    if(! loaded || ! *loaded) {
	fprintf(stderr, "No Modulefiles Currently Loaded.\n");
    } else {
	char*  list[1024];
        int    i = 1;
	fprintf(stderr, "Currently Loaded Modulefiles:\n");
        list[0] = strtok(loaded, ":");
	
	while(list[i] = strtok(NULL, ":")) i++;
        list[i] = NULL;

        print_aligned_files(list, i);
    }

    return TCL_OK;
}

