/*This line lets emacs recognize this as -*- C -*- Code
 *-----------------------------------------------------------------------------
 *
 * Project:	Tcl Modules
 * Created:	92/06/20
 * Author:	John L. Furlani<john.furlani@East.Sun.COM>
 *
 * Description:
 *      Displays what changes a modulefile will make to the environment
 *  including any conflics or prerequisits. 
 *	
 * $Log: ModuleCmd_Display.c,v $
 *
 *
 * Revision 1.2  1993/01/20  03:30:39  jlf
 * Updated to use new LocateModule function.
 *
 * Revision 1.1  1992/11/05  23:45:22  jlf
 * Initial revision
 *
 *---------------------------------------------------------------------------*/
static char Id[] =
    "$Id: ModuleCmd_Display.c,v 2.0 1993/02/20 23:59:53 jlf Exp jlf $";

#include "global.h"

int 
ModuleCmd_Display(Tcl_Interp* interp,
                  char*       argv[])
{
    Tcl_Interp*  disp_interp;
    Tcl_CmdBuf   cmdbuf;
    int          i, result;
    char         modulefile[1024];
    char         modulename[1024];
    
    cmdbuf = Tcl_CreateCmdBuf();

    flags |= M_DISPLAY;
    for(i=0; argv[i]; i++) {
	disp_interp = Tcl_CreateInterp();
	InitializeModuleCommands(disp_interp);

	Locate_ModuleFile(disp_interp, argv[i], modulename, modulefile);

	if(Locate_ModuleFile(disp_interp, argv[i], modulename, modulefile) == 
           TCL_ERROR) 
        {
            fprintf(stderr,
                    "-------------------------------------------------------------------\n");
	    fprintf(stderr, "\n\tError:  Cannot locate the '%s' modulefile\n\n", argv[i]);
            fprintf(stderr,
                    "-------------------------------------------------------------------\n");
	    continue;
	}

        current_module = modulename;

        fprintf(stderr,
                "-------------------------------------------------------------------\n");
	fprintf(stderr, "%s:\n\n", modulefile);

	result = CallModuleProcedure(disp_interp, cmdbuf, modulefile, 
				     "ModulesDisplay", 0);

        fprintf(stderr,
                "-------------------------------------------------------------------\n");

	Tcl_DeleteInterp(disp_interp);
    }
    flags &= ~M_DISPLAY;
    fprintf(stderr, "\n");

    Tcl_DeleteCmdBuf(cmdbuf);

    return TCL_OK;
}

