/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.3.2, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * uFile.h -- Declarations of uFile package.
 * 
 * Author           : Richard A. Stroobosscher
 * Created On       : Mon Feb 26 20:56:31 1990
 * Last Modified By : Hamish Macdonald
 * Last Modified On : Tue Mar  5 17:15:05 1991
 * Update Count     : 38
 */

#ifndef __U_FILEH__
#define __U_FILEH__

/*
 * When compiling with a C++ compiler, make all these
 * declarations appear as C declarations to the C++ compiler.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include <sys/types.h>
#include <sys/file.h>

/*
 * Handle to opaque uFile descriptor
 */
typedef struct uFileD *uFile;

/*
 * These are the external variables that the uKernel
 * provides.
 */
    
extern void uFileEnter( uFile );
extern void uFileLeave( uFile );
extern int uFileFd( uFile );
extern uFile uOpen( char *, int, int );
extern int uRead( uFile, void *, int );
extern int uWrite( uFile, void *, int );
extern off_t uLseek( uFile, off_t, int );
extern int uFsync( uFile );
extern int uClose( uFile );
extern uFile uSocket( int, int, int );
extern int uBind( uFile, void *, int );
extern int uConnect( uFile, void *, int );
extern int uListen( uFile, int );
extern uFile uAccept( uFile, void *, int * );
extern int uGetsockname( uFile, void *, int * );

/*
 * Close the C++ wrapper.
 */
    
#ifdef __cplusplus
}
#endif

#endif /* __U_FILEH__ */
