/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.3.2, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * uKernel.i -- 
 * 
 * Author           : Rick Stroobosscher
 * Created On       : Tue Aug 28 15:15:34 1990
 * Last Modified By : Peter A. Buhr
 * Last Modified On : Thu Feb 14 10:56:32 1991
 * Update Count     : 19
 */

#include <signal.h>
#include <sys/time.h>
#include <sys/resource.h>

#define U_MAGIC 0x12345678

#ifdef __sgi__

/* declare private variables to be a part of the */
/* private data section of each process */

#define uSchedulerTask (* (uTask *) ((int)PRDA))
#define uWorkProcessor (* (uProcessor *) ((int)PRDA + sizeof( uTask )))
#define uWorkTask (* (uTask *) ((int)PRDA + sizeof( uTask ) + sizeof( uProcessor )))
#define uWorkCoroutine (* (uCoroutine *) ((int)PRDA + sizeof( uTask ) + sizeof( uProcessor ) + sizeof( uTask )))

#else

extern uTask uSchedulerTask;				/* reference to the uSystem task */
extern uProcessor uWorkProcessor;			/* reference to the currently active processor */
extern uTask uWorkTask;					/* reference to the currently active task */
extern uCoroutine uWorkCoroutine;			/* reference to the currently active coroutine */

#endif

/* Local Variables: */
/* compile-command: "dmake" */
/* End: */
