/*                               -*- Mode: C -*- 
 * 
 * uSystem Version 4.3.2, Copyright (C) Peter A. Buhr and Richard A. Stroobosscher 1990
 * 
 * uSystem.h -- Declaration of objects that the uSystem makes available to the user.
 * 
 * Author           : Rick Stroobosscher
 * Created On       : Fri Feb  9 15:25:06 1990
 * Last Modified By : Richard A. Stroobosscher
 * Last Modified On : Fri Feb 15 11:54:29 1991
 * Update Count     : 79
 */

#ifndef __U_SYSTEMH__
#define __U_SYSTEMH__

/*
 * When compiling with a C++ compiler, make all these
 * declarations appear as C declarations to the C++ compiler.
 */

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Include all the machine dependent files, and the declaration
 * files.
 */

#if defined( sgi ) || defined( __sgi__ )
#include <stdlib.h>					/* Standard ANSI definitions on an ANSI header equipped machine */
#include "/usr/include/stddef.h"			/* standard definitions */
#define _STDDEF_H
#endif

#include <stdio.h>					/* always include the stdio library */

#include "uMachine.h"					/* machine dependent definitions */

#include "uKernel.h"					/* uKernel data structures and functions */
#include "uExcept.h"					/* uSystem exception handling definitions */
#include "uMalloc.h"					/* uMalloc functions */
#include "uStart.h"					/* uStart function */

#include "uStream.h"					/* uStream data structures and functions */
#include "uDelay.h"					/* uDelay functions */

#include "uSystemEx.h"					/* uSystem defined exceptions and message definitions */

/*
 * Some compilers must "see" the definition of main in order
 * to insert some system startup code.  The following definition
 * allows the user to include a proper definition of main and make
 * it visible to the host compiler.
 */
 
#define U_MAIN int main( int argc, char *argv[], char *envp[] ) { return uKernel( argc, argv, envp ); }

/*
 * Close the C++ wrapper.
 */
    
#ifdef __cplusplus
}
#endif

#endif
