#include <uSystem.h>
#include <uSGIGraphics.h>

void Coarse( Icoord xoffset, Icoord xsize, Icoord ysize ) {
    Icoord x, y;

    uGrAcquire();
    color( RED );
    for ( y = 0; y < ysize; y += 1 ) {
        for ( x = xoffset; x < xsize + xoffset; x += 1 ) {
            pnt2i( x, y );
        } /* for */
    } /* for */
    uGrRelease();
} /* Coarse */

void Medium( Icoord xoffset, Icoord xsize, Icoord ysize ) {
    Icoord x, y;

    for ( y = 0; y < ysize; y += 1 ) {
        uGrAcquire();
        color( GREEN );
        for ( x = xoffset; x < xsize + xoffset; x += 1 ) {
            pnt2i( x, y );
        } /* for */
        uGrRelease();
    } /* for */
} /* Medium */

void Fine( Icoord xoffset, Icoord xsize, Icoord ysize ) {
    Icoord x, y;

    for ( y = 0; y < ysize; y += 1 ) {
        for ( x = xoffset; x < xsize + xoffset; x += 1 ) {
            uGrAcquire();
            color( BLUE );
            pnt2i( x, y );
            uGrRelease();
        } /* for */
    } /* for */
} /* Fine */

void uMain( int argc, char *argv[] ) {
    Icoord xsize, ysize;
    long wid;
    uTask c, m, f;

    uGrOpen( "w" );

    uGrAcquire();
    foreground();
    wid = winopen( "Granularity" );
    getsize( &xsize, &ysize );
    uGrRelease();

    c = uEmit( Coarse, 0, xsize/3, ysize );
    m = uEmit( Medium, xsize/3, xsize/3, ysize );
    f = uEmit( Fine, 2*xsize/3, xsize/3, ysize );

    uAbsorb( c, NULL, 0 );
    uAbsorb( m, NULL, 0 );
    uAbsorb( f, NULL, 0 );

    uGrClose( "w" );
} /* uMain */

/* Local Variables: */
/* compile-command: "concc -compiler cc -multi SGIEx1.c -lgl_s" */
/* End: */
