/* Copyright (c) 1989  P. A. Buhr */

/*
  Method: use a lock to protect critical section
  Work?: NO
  Problem: if simultaneous execution of lock check & set both
    processes can enter the critical section
  
    To work would require an atomic test & set operation.
*/

#include <uSystem.h>

#define CLOSED 1
#define OPEN 0

int Lock = OPEN;					/* shared between processes */

void PermissionLock() {
    int i;						/* loop counter */

    for (i = 1; i <= 1000; i += 1) {			/* exercise critical section */

        /* entry protocol */

        while (Lock == CLOSED) {}			/* busy wait */
    
        /* critical section */
    
        Lock = CLOSED;					/* guard critical section */

        CriticalSection();
    
        /* exit protocol */

        Lock = OPEN;					/* unguard critical section */
    } /* for */

    uDie(NULL, 0);
} /* PermissionLock */
 
void uMain() {
    uTask t0, t1;

    uSetTimeSlice(10);
 
    t0 = uEmit(PermissionLock);				/* start process */
    t1 = uEmit(PermissionLock);				/* start process */

    uAbsorb(t0, NULL, 0);				/* wait for completion of process */
    uAbsorb(t1, NULL, 0);				/* wait for completion of process */
    uPrintf("successful execution\n");
} /* uMain */
