/* Copyright (c) 1989  P. A. Buhr */

/*
  Method: alternate between processes
  Work?: NO
  Problems: Works only if both processes execute the same number
    of times and does not allow the same process to enter the
    critical section again until the other process has entered.
*/

#include <uSystem.h>

int Last = 0;						/* shared between processes */

void Alternation(int who) {
    int i;						/* loop counter */

    for (i = 1; i <= 1000; i += 1) {			/* execute critical section */

        /* entry protocol */

        while (Last == who) {}				/* busy wait */

        /* critical section */
        
        CriticalSection();

        /* exit protocol */

        Last = who;					/* alternate */
    } /* for */

    uDie(NULL, 0);
} /* Alternation */

void uMain() {
    uTask t0, t1;
    int me, other;

    uSetTimeSlice(10);
    
    me = 0;
    other = 1;
    t0 = uEmit(Alternation, me);			/* start process */
    t1 = uEmit(Alternation, other);			/* start process */
 
    uAbsorb(t0, NULL, 0);				/* wait for completion of process */
    uAbsorb(t1, NULL, 0);				/* wait for completion of process */
    uPrintf("successful execution\n");
} /* uMain */
