/* Copyright (c) 1988 Peter A. Buhr */
/* This monitor implements Send-Receive-Reply message passing */

#include <uMonitor.h>

#define MsgLength 10
typedef int message[MsgLength];

uMonitor( PriorityNonBlocking ) {
    typedef struct listnode {
	struct listnode *flink, *blink;
	uTask SenderPid;
	uTask ReceiverPid;
	uCondition cond;
	int *SendMsg, *ReplyMsg;
    } ListNode, *List;
    
    ListNode freelist = {&freelist, &freelist}, SendList = {&SendList, &SendList},
    ReceiveList = {&ReceiveList, &ReceiveList}, ReplyList = {&ReplyList, &ReplyList};
    
    uLocal int Empty( List list ) {
	return( list->flink == list );
    } /* Empty */
    
    uLocal List Search( List list, uTask SenderKey, uTask ReceiverKey ) { /* search forward for key in a list */
	List i;
	for ( i = list->flink;; i = i->flink ) {
	    if ( list == i ) break;
	    if ( ( i->SenderPid == SenderKey || i->SenderPid == NULL ) && i->ReceiverPid == ReceiverKey ) break;
	} /* for */
	if ( list == i ) i = 0;
	return( i );
    } /* Search */
    
    uLocal void Add( List list, List Item ) {		/* add an item to the front of the list */
	Item->flink = list->flink;
	Item->blink = list;
	list->flink->blink = Item;
	list->flink = Item;
    } /* Add */
    
    uLocal void Remove( List Item ) {			/* remove an item from a list */
	Item->blink->flink = Item->flink;
	Item->flink->blink = Item->blink;
    } /* Remove */
    
    uEntry void SendReply( uTask ReceiverId, message SendMsg, message ReplyMsg ) { /* send a message to a specific receiver */
	ListNode self;
	List found;
	int i;
	self.SenderPid = uThisTask(  );			/* initialize a node for this process */
	self.ReceiverPid = ReceiverId;
	self.cond = U_CONDITION;
	self.SendMsg = SendMsg;
	self.ReplyMsg = ReplyMsg;
	found = Search( &ReceiveList, uThisTask( ), ReceiverId ); /* search receiver list for specified receiver */
	if ( found ) {
	    for ( i = 0; i < MsgLength; i += 1 ) {	/* copy message from sender to waiting receiver */
		found->SendMsg[i] = SendMsg[i];
	    } /* for */
	    Add( &ReplyList, &self );			/* put self on reply list */
	    uSignal found->cond;			/* notify waiting receiver */
	} else {
	    Add( &SendList, &self );			/* put self on the end of the sender list */
	} /* if */
	uWait self.cond;				/* wait for reply */
	Remove( &self );				/* remove self from reply list */
    } /*  SendReply */
    
    uEntry void Receive( uTask SenderId, message RecMsg ) { /* receive a message from a specific sender */
	List found;
	int i;
	found = Search( &SendList, SenderId, uThisTask( ) ); /* seach sender list for specified sender */
	if ( found ) {
	    for ( i = 0; i < MsgLength; i += 1 ) {	/* copy message from waiting sender to receiver */
		RecMsg[i] = found->SendMsg[i];
	    } /* for */
	    Remove( found );				/* remove waiting sender from sender list */
	    Add( &ReplyList, found );			/* and add it to the reply list */
	} else {
	    ListNode self;
	    
	    self.SenderPid = SenderId;			/* initialize a node for this process */
	    self.ReceiverPid = uThisTask( );
	    self.cond = U_CONDITION;
	    self.SendMsg = RecMsg;
	    Add( &ReceiveList, &self );			/* put self on on the end of the receiver list */
	    uWait self.cond;				/* wait for a sender */
	    Remove( &self );				/* remove self from receiver list */
	} /* if */
    } /* Receive */
    
    uEntry uTask ReceiveAny( message RecMsg ) {		/* receive a message from any sender */
	List found;
	int i;
	if ( !Empty( &SendList ) ) {			/* send list not empty */
	    found = SendList.flink;			/* select sender on the front */
	    for ( i = 0; i < MsgLength; i += 1 ) {	/* copy message from waiting sender to receiver */
		RecMsg[i] = found->SendMsg[i];
	    } /* for */
	    Remove( found );				/* remove waiting sender from sender list */
	    Add( &ReplyList, found );			/* and add it to the reply list */
	} else {
	    ListNode self;
	    
	    self.SenderPid = NULL;			/* initialize a node for this process */
	    self.ReceiverPid = uThisTask( );
	    self.cond = U_CONDITION;
	    self.SendMsg = RecMsg;
	    Add( &ReceiveList, &self );			/* put self on on the end of the receiver list */
	    uWait self.cond;				/* wait for a sender */
	    Remove( &self );				/* remove self from receiver list */
	} /* if */
	return( ReplyList.flink->SenderPid );		/* send is at the beginning of reply list */
    } /* ReceiveAny */
    
    uEntry void Reply( uTask SenderId, message ReplyMsg ) {
	List found;
	int i;
	found = Search( &ReplyList, SenderId, uThisTask( ) ); /* search reply list for specified sender */
	if ( found ) {
	    for ( i = 0; i < MsgLength; i += 1 ) {	/* copy message from replying receiver to waiting sender */
		found->ReplyMsg[i] = ReplyMsg[i];
	    } /* for */
	    uSignal found->cond;			/* notify waiting sender */
	} else {
	    uError( "ERROR: Attempt to reply to a sender that has not been received\n" );
	} /* if */
    } /* Reply */
}
