/* Copyright (c) 1989  P. A. Buhr */

/*
  Produce the fibonacci numbers in sequence on each call.
  
  Communicate with shared variables and maintain state explicitly.
  */

void printf( char *, ... );

int fn, fn1, fn2, state = 1;				/* shared variable */

int fibonacci() {
    switch (state) {
      case 1:						/* 1st case */
	fn = 1;
	fn1 = fn;
	state = 2;
	break;
      case 2:						/* 2nd case */
	fn = 1;
	fn2 = fn1;
	fn1 = fn;
	state = 3;
	break;
      case 3:						/* general case */
	fn = fn1 + fn2;
	fn2 = fn1;
	fn1 = fn;
	break;
    } /* switch */
    return(fn);
} /* fibonacci */

#define NoOfFibs 10

void main() {
    int i;
    
    printf("Fibonacci Numbers\n");
    for (i = 1; i <= NoOfFibs; i += 1) {
	printf("%d\n", fibonacci());
    } /* for */
    printf("successful completion\n");
} /* main */
