/*
 * xrpctest.c
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.3 $
 * $Date: 1992/02/11 23:30:18 $
 */

/*
 * Ping-pong test of XRPC
 */

#include "xkernel.h"

/*
 * These definitions describe the lower protocol
 */
#define HOST_TYPE IPhost
#define INIT_FUNC xrpctest_init
#define PROT_STRING "xrpc"

static	HOST_TYPE SERVER = SITE_SERVER_IP;
static	HOST_TYPE CLIENT = SITE_CLIENT_IP;
static	long	serverId = 1002;

#define TRIPS 100
#define TIMES 1
#define DELAY 3
/*
 * Define to do timing calculations
 */
#define TIME
#define SAVE_SERVER_SESSN
#define RPCTEST
#define CUSTOM_ASSIGN

static void
setServer( p )
    Part	*p;
{
    partPush(*p, &SERVER);	/* IP host 		*/
    partPush(*p, &serverId);
}

static void
serverSetPart( p )
    Part	*p;
{
    partInit(p, 1);
    setServer(p);
}


static void
clientSetPart( p )
    Part	*p;
{
    partInit(p, 2);
    setServer(p);
#if 1
    partPush(p[1], ANY_HOST);
#endif    
}


static int lens[] = { 
  1000, 2000, 4000, 8000, 16000
};


#include "common_test.c"

static void
testInit()
{
}
