/*
 * blast_hdr.c
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.5 $
 * $Date: 1992/02/05 18:22:38 $
 */

#include "blast_internal.h"
 

long
blastHdrLoad(hdr, src, len, arg)
    VOID *hdr;
    char *src;
    long int len;
    VOID *arg;
{
    xAssert( len == sizeof(BLAST_HDR) );
    bcopy( src, hdr, len );
    ((BLAST_HDR *)hdr)->op = ntohl(((BLAST_HDR *)hdr)->op);
    ((BLAST_HDR *)hdr)->prot_id = ntohl(((BLAST_HDR *)hdr)->prot_id);
    ((BLAST_HDR *)hdr)->seq = ntohl(((BLAST_HDR *)hdr)->seq);
    ((BLAST_HDR *)hdr)->num_frag = ntohs(((BLAST_HDR *)hdr)->num_frag);
    ((BLAST_HDR *)hdr)->mask = ntohs(((BLAST_HDR *)hdr)->mask);
    ((BLAST_HDR *)hdr)->len = ntohl(((BLAST_HDR *)hdr)->len);
    return len;
}


void
blastHdrStore(hdr, dst, len, arg)
    VOID *hdr;
    char *dst;
    long int len;
    VOID *arg;
{
    BLAST_HDR	h;

    xAssert( len == sizeof(BLAST_HDR) );
    h = *(BLAST_HDR *)hdr;
    h.op = htonl(h.op);
    h.prot_id = htonl(h.prot_id);
    h.seq = htonl(h.seq);
    h.num_frag = htons(h.num_frag);
    h.mask = htons(h.mask);
    h.len = htonl(h.len);
    bcopy( (char *)&h, dst, len );
}
