/* 
 * arp_internal.h
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.9 $
 * $Date: 1992/02/07 04:40:41 $
 */

#ifndef arp_i_h
#define arp_i_h

#include "ip.h"
#include "eth.h"
#include "arp.h"

#define	ARP_HRD	  1
#define	ARP_PROT  0x0800	/* doing IP addresses only */
#define	ARP_HLEN  28		/* the body is null */
#define	ARP_TAB   100		/* arp table size */
#define ARP_TIME  2000		/* 2 seconds */
#define ARP_RTRY  2		/* retries for arp request */
#define ARP_RRTRY 200000	/* retries for rarp request */
#define INIT_RARP_DELAY	 5000	/* msec to delay between failed self rarps */

#define	ARP_REQ   1
#define	ARP_RPLY  2
#define	ARP_RREQ  3
#define	ARP_RRPLY 4


typedef enum { ARP_ARP, ARP_RARP } ArpType;
typedef enum { ARP_FREE, ARP_ALLOC, ARP_RSLVD } ArpStatus;

typedef struct arppak {
    short  arp_hrd;
    short  arp_prot;
    char   arp_hlen;
    char   arp_plen;
    short  arp_op;
    ETHhost  arp_sha;
    IPhost arp_spa;
    ETHhost  arp_tha;
    IPhost arp_tpa;
} arppak;


/* TMP kludge */
typedef struct {
    arppak	hdr;
    XObj	arp_s;
    XObj	rarp_s;
} InterfacePrivate;


typedef struct {
    Interfaceid		pub;
    InterfacePrivate	priv;
} Interface;

/*
 * An arpWait represents an outstanding request
 */
typedef struct {
    ArpStatus	*status;
    Interface	*ifs;
    int 	tries;
    ArpType 	type;
    Event	event;
    Semaphore 	s;
    int 	numBlocked;
    union {
	arppak	reqMsg;		/* ARP requests only */
	ETHhost	remPhysHost;	/* RARP requests only */
    } u;
} ArpWait;


typedef struct ARPprotlstate {
    Interface	ifs[ARP_MAXINTERFACES];
    u_short  	numif;
    XObj	rarp;
} ARPprotlstate, PSTATE;


#ifdef __STDC__

void		arpPlatformInit( XObj );
void		arpSendRequest( ArpWait * );
void		newArpWait( ArpWait *, IPhost *, Interface *, ArpStatus * );
void		newRarpWait( ArpWait *, ETHhost *, ArpStatus * );
Interface * 	arpIpToInterface( IPhost * );

#else

void		arpPlatformInit();
void		arpSendRequest();
void		newArpWait();
void		newRarpWait();
Interface * 	arpIpToInterface();

#endif


extern int	tracearpp;

#endif arp_i_h
