/*
 * msg_internal.h
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.11 $
 * $Date: 1992/02/12 01:54:26 $
 */

#define PageSize 16384

/* 
 * Size of virtual space for tree nodes
 */
#ifdef MSGCACHEING
static int MNodePairVSpace = 1 * PageSize;
static int MNodeBufVSpace =  1 * PageSize;
static int MNodePageVSpace = 126 * PageSize;

static char *mWindow;
#endif MSGCACHEING


/* enum NodeType */

enum NodeType {
  t_MNodeJunk,
  t_MNodePair,
  t_MNodePage,
  t_MNodeBuf,
#ifdef MSG_NEW_ALG
  t_MNodeDummy
#endif MSG_NEW_ALG
};

struct nlink {
  long offset;
  long length;
  MNode  *node;
};

/* These sizes are computed from the MNode structure definition */
#define MNodeSize (sizeof(enum NodeType) + sizeof(long))
#define MNodePairSize (MNodeSize + 2 * sizeof(struct nlink))
#define MNodeLeafSize (MNodeSize + sizeof(long) + sizeof(char *))
#define MNodePageSize (PageSize)
#define MNodePageDataSize (MNodePageSize - MNodeLeafSize)
#define MNodeBufSize  (MNodeLeafSize + sizeof(void (*)()))

#define mprsize MNodePairSize
#define mpgsize MNodePageSize
#define mbfsize MNodeBufSize

#define mprtype t_MNodePair
#define mpgtype t_MNodePage
#define mbftype t_MNodeBuf

/*
 * struct MNode
 * all tree nodes
 */
struct MNode {
  enum NodeType type;
  unsigned long refCnt;
  union {
    struct {
      struct nlink l, r;
    } pair;
    struct {
      long  size;     /* size of buffer */
      char *data;     /* the buffer */
    } leaf;
    struct {
      long  size;     /* size of buffer */
      char *data;     /* the buffer */
      char buffer[MNodePageDataSize];
    } page;
    struct {
      long  size;     /* size of buffer */
      char *data;     /* the buffer */
      void (*bFree)(/* void* */);  /* the buffer's deallocator function */
    } buf;
  } b;
};



/*
 * struct MNodePair
 */
#ifdef MSGCACHEING
static MNodePair* mpr_freeStore;
static int        mpr_numNodes;
static int        mpr_lastFreeNode;
#endif

extern MNodePair *newMNodePair();

/*
 * struct MNodePage
 * a leaf node on one vm page
 */
#ifdef MSGCACHEING
static MNodePage* mpg_freeStore;
static int        mpg_numNodes;
static int        mpg_lastFreeNode;
#endif

extern MNodePage *newMNodePage();

/*
 * struct MNodeBuf
 * a leaf node that refers to a user-provided buffer
 */

#ifdef MSGCACHEING
static MNodeBuf*  mbf_freeStore;
static int        mbf_numNodes;
static int        mbf_lastFreeNode;
#endif

extern MNodeBuf  *newMNodeBuf();

extern void msgShow();

#ifdef MSG_NEW_ALG
static MNodeLeaf   dummyStack;
#if 0 
static char       *vmWindow;
#endif
/* limit for number of nodes allocated to a Msg */
#ifdef CONTROL_RESOURCES
static int numNodesHardLimit = 1000;
#endif CONTROL_RESOURCES
static int numNodesSoftLimit = 100;

#endif MSG_NEW_ALG
