/* 
 * assert.h
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1991  Arizona Board of Regents
 *
 *
 * $Revision: 1.5 $
 * $Date: 1992/02/07 17:08:43 $
 */

#ifndef assert_h
#define assert_h

#if ! defined(FILE) && ! defined(XKMACHKERNEL)
#include "x_stdio.h"
#endif

#ifndef XKMACHKERNEL
#  ifdef __STDC__
extern int abort(void);
#  else
extern int abort();
#  endif __STDC__
#define ABORT abort
#define PRINT(A,B,C) fprintf(stderr, (A), (B), (C))
#else
#define PRINT(A,B,C) printf((A), (B), (C))
extern int panic();
#define ABORT panic
#endif XKMACHKERNEL

#define assertMessage "Assertion failed: file %s, line %d\n"

#ifndef NDEBUG
#   define _xAssert(ex) ((ex) ? 1 : (PRINT(assertMessage, __FILE__, __LINE__), ABORT()))
#   define xAssert(ex)  ((ex) ? 1 : (PRINT(assertMessage, __FILE__, __LINE__), ABORT()))
#else
#   define _xAssert(ex) 1
#   define xAssert(ex) 1
#endif

#endif
