#include <stdio.h>

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/Sme.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/Paned.h>

String fallback_resources[] = {
       "*input:                TRUE",
       "*View.forceBars:       TRUE",
       "*View.useBottom:       TRUE",
       "*View.allowHoriz:      TRUE",
       "*View.allowVert:       TRUE",
       "*fileButton.label:     FILE",
       "*editButton.label:     EDIT",
       "*selectButton.label:   SELECT",
       "*optionButton.label:   OPTION",
       "*Com_box.orientation:      horizontal",
       "*Com_box.hSpace:            20",
       NULL,
 };

void main(argc,argv)
int argc;
char *argv[];

  {
    XtAppContext app_con;
    Widget top,view, outer,com_box;
    void make_com_bar();
    static Arg args[] = {
     {XtNheight,(XtArgVal)300},
     {XtNwidth,(XtArgVal)400},
};

    static Arg args1[] = {
     {XtNheight,(XtArgVal)30},
     {XtNwidth,(XtArgVal)400},
};
    static Arg args2[] = {
     {XtNheight,(XtArgVal)270},
     {XtNwidth,(XtArgVal)400},
};
    top = XtAppInitialize(&app_con,"Xg",NULL,ZERO,&argc,argv,fallback_resources,NULL,ZERO);

    outer = XtCreateManagedWidget("Form",formWidgetClass,top,args,XtNumber(args));

    com_box = XtCreateManagedWidget("Com_box",boxWidgetClass,outer,args1,XtNumber(args1));
    view = XtCreateManagedWidget("View",viewportWidgetClass,outer,args2,XtNumber(args2));
    make_com_bar(com_box);

    XtRealizeWidget(top);
    XtAppMainLoop(app_con);

 }


void make_com_bar(toplevel)
Widget toplevel;

 {

    Widget  file, edit, select, option;

    static char *file_item_names[] = {
    "new", "open", "save","save as","quit",
    };

    static char *edit_item_names[] = {
    "undo","cut","paste",
    };
    
    static char *select_item_names[] = {
    "node","edge",
    };
  
    static char *option_item_names[] = {
    "reduce","enlarge",
    };
    void make_menu();



    file = XtCreateManagedWidget("fileButton",menuButtonWidgetClass,toplevel,NULL,ZERO);
    make_menu(file,file_item_names,5);
   
    edit = XtCreateManagedWidget("editButton",menuButtonWidgetClass,toplevel,NULL,ZERO);
    make_menu(edit,edit_item_names,3);

    select = XtCreateManagedWidget("selectButton",menuButtonWidgetClass,toplevel,NULL,ZERO);
    make_menu(select,select_item_names,2);

    option = XtCreateManagedWidget("optionButton",menuButtonWidgetClass,toplevel,NULL,ZERO);
    make_menu(option,option_item_names,2);

}


void make_menu(command,menu_item_names,x)
Widget command;
char **menu_item_names;
int x;

 {

   Widget menu,entry;
   int i, size;
   char *item;

   menu = XtCreatePopupShell("menu",simpleMenuWidgetClass,command,NULL,ZERO);

   size = (int) XtNumber(menu_item_names);
   for(i = 0; i < x /* size */ ; i++) {
       item = menu_item_names[i];
       entry = XtCreateManagedWidget(item,smeBSBObjectClass,menu,NULL,ZERO);

   }
 }


