/*
 * testarp.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include "eth.h"
#include "ip.h"

IPhost my_inet_addr();
extern ETHhost iptoeth();

user()
{
  char ipaddr[256];
  IPhost ia;
  ETHhost ea;
  
  while (1) {
    printf("Enter IP address: ");
    scanf("%s", ipaddr);
    ia = my_inet_addr(ipaddr);
    ea = iptoeth(ia);
    printf("Ethernet address is %d.%d.%d", ea.high, ea.mid, ea.low);
    printf(" (%x.%x.%x)\n", ea.high, ea.mid, ea.low);

  }
}

IPhost my_inet_addr(ipaddr_str)
char *ipaddr_str;
{
IPhost iphost;
char *p;
int i, num_fields;

  p = ipaddr_str;

  for (num_fields = 1; num_fields <= 4; num_fields++) {
    i = 0;
    while ((*p) && *p != '.') {
      i = 10*i+(*p-'0');
      p++;
    }
    p++;
    if (i < 0 || i > 255) {
      printf("invalid IP address: %s\n", ipaddr_str);
      xexit(-1);
    }
    switch(num_fields) {
    case 1: iphost.a = i;
            break;
    case 2: iphost.b = i;
            break;
    case 3: iphost.c = i;
            break;
    case 4: iphost.d = i;
            break;
    default: printf("Error in my_inet_addr\n");
             xexit(-1);
    }
  }

  return iphost;
}
