h32950
s 00008/00007/00245
d D 1.2 91/01/10 11:27:41 llp 2 1
c Prepared for 3.1 Distribution
e
s 00252/00000/00000
d D 1.1 90/12/09 00:54:31 menze 1 0
c date and time created 90/12/09 00:54:31 by menze
e
u
U
f e 0
t
T
I 1
/*
 * timesunrpc.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
I 2
 */

/********************************************************************
E 2
 *
D 2
 ********************************************************************
 *
E 2
 * Time SunRPC:  This user program will run a ping-pong timing test
 * for the Sun RPC protocol.
 *
 * Boot parameters: (choose one of -s or -c, all others optional)
 *	
 *	-cHostname:  boot as client of Hostname 
 *
 *	-s:	     boot as server
 *
 *	-tTrips:     Number of round trips per test
 *
 *	-xTimes:     Number of tests run for each size
 *
 * The array "lens" lists the size for the arguments (and return value) of
 * each test.
I 2
 *
 ********************************************************************/
E 2

D 2
/********************************************************************/

E 2
#include "xkernel.h"
#include "ip.h"
#include "udp.h"
D 2
#include "site.h"
E 2
#include "sun_rpc.h"

D 2
static PROTL IP, SUNRPC;
E 2
I 2
static Protl IP, SUNRPC;
E 2

#define IP_NULL { 0, 0, 0, 0 };

static  char	Request_buf[16*1024];
static  char	Reply_buf[16*1024];

IPhost client_host  = IP_NULL;
IPhost server_host  = IP_NULL;

SUNRPCaddr SERVER;
SUNRPCaddr CLIENT;
char *SERVERNAME;

typedef struct {
  int sec, usec;
} time;

static time starttime, now, total;
#define TIMES 1
#define TRIPS 100
#define DELAY 3000

static times = TIMES;
static trips = TRIPS;


#define TIMING_PROG 100012
#define TIMING_PROC 1
#define TIMING_VERS 1

static int lens[] = {
/*    15*1024, 15*1024, 15*1024, 8*1024, 15*1024, 4*1024, 3*1024, 2*1024, 1024, 1 */
/*    15*1024, 15*1024, 15*1024, 8*1024, 15*1024, 4*1024, 3*1024, 2*1024, 1024, 1, 1024, 2*1024, 3*1024, 4*1024, 8*1024, 15*1024 */
 1, 1024, 2*1024, 3*1024, 4*1024, 8*1024, 15*1024 
/*    1, 1024, 2*1024, 3*1024, 1024, 1*/
  }
;


int strtoi(s)
    char *s;
{
    int i = 0;

    while(1) {
	if (*s < '0' || *s > '9') return i;
	i *= 10;
	i += (*s - '0');
	s++;
    }
}


client()
{
  int p, s, i;
  int null();
  Part whom[2];
  int test = 0;
  int lenindex;
  int len;
  
  
  s = NULL;
  p = xcreateprotl(null, null, null);
  printf("I am the client, talking to %s\n", SERVERNAME);

  init_partlist(whom, 2, SUNRPCaddr);
  set_part(whom, 0, CLIENT);
  set_part(whom, 1, SERVER);
  
  if ((s = xopen(p, SUNRPC, whom)) == 0) {
      printf("can t open SUNRPC session\n");
      return;
  }
      
  if (s > 0) {
    for (lenindex = 0; ; lenindex++) {
      if (lenindex >= sizeof(lens)/sizeof(long)) {
	  while(1);
      }
      len = lens[lenindex];
      for (test = 0; test < times; test++) {
	printf("Starting test (%d) ...\n", test);
	xgettime(&starttime);
	try_call(s, trips, len);
	xgettime(&now);
	subtime(&starttime, &now, &total);
	printf("len = %d/%d, %d trips: %6d.%-6d\n", 
	       len, len, trips, total.sec, total.usec);
	xpause(DELAY);
      }
    }
  } else {
    printf("Not sending, other host not up\n");
  }
}
  
server()
{
  int serverdemux(), null(), p;
  Part whom[2];
  printf("I am the  server (%s)\n", SERVERNAME);

  
  init_partlist(whom, 1, SUNRPCaddr);
  set_part(whom, 0, SERVER);
  
  p = xcreateprotl(serverdemux, null, null);
  (void) xopenenable(p, SUNRPC, whom);
}


/*****************************************************************************
 * set all stuff for work on top of SUNRPC, fires process for client and server
 */
user(argc, argv)
int argc;
char **argv;
{
  IPhost ipaddr, nametoip();
  printf("sun_rpc test\n");
  IP = xgetprotlbyname("ip");
  SUNRPC = xgetprotlbyname("sun_rpc");
  SERVER.host.host = server_host;
  SERVER.prot =17;                  /* UDP hard coded */
  SERVER.prog = TIMING_PROG;
  SERVER.proc = TIMING_PROC;
  SERVER.vers = TIMING_VERS;

  SERVERNAME = SITE_SERVER_NAME;
D 2
  if (xcontrolprotl(IP, MYADDR, &ipaddr, sizeof(IPhost)) != sizeof(IPhost)) {
E 2
I 2
  if (xcontrolprotl(IP, GETMYADDR, &ipaddr, sizeof(IPhost)) != 
      sizeof(IPhost)) {
E 2
    printf("Cannot get my own IP addr\n");
    return;
  } else {
    printf("My IP addr = %d.%d.%d.%d\n", ipaddr.a,ipaddr.b,ipaddr.c,ipaddr.d);
  }

  while (argc > 1) {
    if (!strncmp(argv[1], "-s", 2)) {
	SERVER.host.host = ipaddr;
	SERVERNAME = malloc(24);
	iptoname(SERVER.host.host, SERVERNAME);
    } else if (!strncmp(argv[1], "-c", 2)) {
	client_host = ipaddr;
	CLIENT.host.host = client_host;
	CLIENT.host.port = 0;
	CLIENT.prog = TIMING_PROG;
	CLIENT.proc = TIMING_PROC;
	CLIENT.vers = TIMING_VERS;
	SERVERNAME = &argv[1][2];
	SERVER.host.host = nametoip(SERVERNAME);
    } else if (!strncmp(argv[1], "-x", 2)) {
	times = strtoi(&argv[1][2]);
    } else if (!strncmp(argv[1], "-t", 2)) {
	trips = strtoi(&argv[1][2]);
    } else {
	printf("Unrecognized flag %s\n", argv[1]);
    }
    argc --;
    argv++;
  }
  if (IP_EQUAL(ipaddr, SERVER.host.host)) {
    xcreateprocess(server, 5, 0);
  }
  if (IP_EQUAL(ipaddr, client_host)) {
    xcreateprocess(client, 6, 0);
  }
}

null(s,m,length)
int s, length;
char *m;
{
}

serverdemux(s, m, length)
int s, length;
char *m;
{
  xpush(s, Reply_buf, length, 0, 0);
}

subtime(t1, t2, t3)
time *t1, *t2, *t3;
{
  t3->sec = t2->sec - t1->sec;
  t3->usec = t2->usec - t1->usec;
  if (t3->usec < 0) {
    t3->usec += 1000000;
    t3->sec -= 1;
  }
}

try_call(sessn, times, length)
Sessn		sessn;
int		times;
int		length;
{
  int reply_len;
  int ret_val;
  int i;
  int l = sizeof(Reply_buf);

  for (i=0; i<times; i++) {
      reply_len = l;
      ret_val = xpush(sessn,Request_buf,length,Reply_buf,&reply_len);

      if (reply_len != length) {
	  printf("Bizarre reply length.  Expected %d, received %d\n",
		 length, reply_len);
      }

      if( ret_val < 0 ) {
	  printf( "SELECT CLIENT: SELECT CALL GOT ERR %d\n",ret_val );
      }
  }
}
E 1
