h22996
s 00006/00006/00321
d D 1.2 91/01/10 11:27:38 llp 2 1
c Prepared for 3.1 Distribution
e
s 00327/00000/00000
d D 1.1 90/12/09 00:54:26 menze 1 0
c date and time created 90/12/09 00:54:26 by menze
e
u
U
f e 0
t
T
I 1
/*
 * testsunrpc.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
D 2
 *
 *****************************************************************************
E 2
I 2
 */

/*****************************************************************************
E 2
 * Test SUNRPC: Test the parameters for procedure number and arguments
 *               calling a procedure (rusers) in server that mprints the
 * 		 the number of users on the server by the client
 *****************************************************************************/

#include "xkernel.h"
D 2
#include "xType.h"
#include "site.h"
E 2
#include "ip.h"
#include "udp.h"
#include "sun_rpc.h"


#define RUSERSPROC_NUM 1
#define RUSERSPROG 100002
#define RUSERSVERS 2
#define MULTIPLY 99

#define MAXUSERS 100
#define	MAX_NUM		5
#define TRIPS		1000
#define DELAY		1000
#define	SIZE		(sizeof(REQ_BUF_SZ)/sizeof(int))
#define	REP_BUF_SZ	1

typedef struct {
  int	sec, usec;
} time;

static time starttime;
time now, total;
/* 
 * default server and client 
 */
IPhost client_host = SITE_CLIENT_IP;   
IPhost server_host = SITE_SERVER_IP;
   
typedef struct {
  int	a, b;
} mult;


D 2
static  PROTL    IP, SUNRPC;
E 2
I 2
static  Protl    IP, SUNRPC;
E 2
static  char	 Request_buf[16*1024];
static  char	 Reply_buf[16*1024];
static	int	 REQ_BUF_SZ[] = {
  				  1, 1024, 2*1024, 4*1024, 6*1024, 8*1024,
  				  10*1024, 12*1024, 14*1024, 16*1024,
       				};

int		 null();
int		 mult_client();
int		 rus_client();
int 		proc_num;
char		*SERVERNAME,*CLIENTNAME;
SUNRPCaddr	SERVER, CLIENT;
Semaphore	*sem;
Semaphore	*mult_sem;

/*****************************************************************************/

client()
{
  int	i, p,c;
  int	null();
  int	s, len;

  p = xcreateprotl(null, null, null);
  sem = (Semaphore *)xcreatesemaphore(0);
  mult_sem = (Semaphore *)xcreatesemaphore(0);
  printf("I am the client, talking to %s\n", SERVERNAME);
  printf("    1. multiply test\n");
  printf("    2. rusers test\n");
  printf("    3. RPC timing test\n");
  printf("\n");

  xcreateprocess(mult_client, 6, 1, p);
  xpsem(mult_sem);
  printf("\ntest1 completed\n\n\n");

  xcreateprocess(rus_client, 6, 1, p);
  xpsem(sem);
  printf("\nEnd of test \n");
  
}

/****************************************************************************
 * Process that requests to the server to execute procedure 99 (multiply)
 * and then prints the values returned
 */
rus_client()
{
  int	p , s, i, len;
  int	reply;
  int	request;
  Part	whom[3];
  int   ret_val;

    proc_num = RUSERSPROG;
    CLIENT.prog = RUSERSPROG;
    CLIENT.vers = RUSERSVERS;
    CLIENT.proc = RUSERSPROC_NUM;
    SERVER.prog = RUSERSPROG;
    SERVER.vers = RUSERSVERS;
    SERVER.proc = RUSERSPROC_NUM;
    init_partlist(whom, 2, SUNRPCaddr);
    set_part(whom, 0, CLIENT);/*this is the procedure number want ot exec*/
    set_part(whom, 1, SERVER);  
      if ((s = xopen(p, SUNRPC, whom)) == 0) {
        printf("can't open SUNRPC session\n");
        xvsem(sem);
        return;
      }
      len = sizeof(reply);
      ret_val = xpush(s, &request, sizeof(int), &reply, &len);
      if (ret_val < 0) {
        printf("Error On Getting ret_val\n");
      }
      printf("the number of users in %s is %d\n\n",SERVERNAME, reply);
      printf("\ntest2 completed\n\n\n");
      printf("Computing time for RPC..\n ");
      xgettime(&starttime);
      for (i=0; i<TRIPS ; i++) {
        ret_val = xpush(s, &request, sizeof(int), &reply, &len);
        if (ret_val < 0) {
          printf("Error On Getting ret_val in trip %d\n", i);
        }
      }
      xgettime(&now);
      subtime(&starttime, &now, &total);
      printf("Time (msec) by 1 RPC %6d.%-6d\n",total.sec, total.usec);
      printf("\ntest3 completed\n\n\n");
      xvsem(sem);
}

/****************************************************************************
 * Process that requests to the server to execute procedure 99 (multiply)
 * and then prints the values returned
 */
mult_client(p)
int p;
{
  int	s, i, len;
  int	reply;
  mult	request;
  Part	whom[3];
  int   ret_val;

  printf("\nI am the multiplication client\n");

  proc_num = MULTIPLY;
  CLIENT.prog = MULTIPLY;
  CLIENT.vers = 1;
  CLIENT.proc = 1;
  SERVER.prog = MULTIPLY;
  SERVER.vers = 1;
  SERVER.proc = 1;
  init_partlist(whom, 2, SUNRPCaddr);
  set_part(whom, 0, CLIENT); /* this is the procedure number want ot exec*/
  set_part(whom, 1, SERVER);  

  if ((s = xopen(p, SUNRPC, whom)) == 0) {
    printf("can t open SUNRPC session\n");
    xvsem(mult_sem);
    return;
  }

  for (i = 0; i < MAX_NUM; i++) {
    request.a = request.b = i;
    len = sizeof(reply);
    ret_val = xpush(s, &request, sizeof(mult), &reply, &len);
    if (ret_val < 0) {
      printf("Error On Getting ret_val\n");
      }
    printf("the square of %d is %d\n", i, reply);
    xpause(DELAY);
  }
  printf("\nmultiplication run completed\n");
  xvsem(mult_sem);
}


/*****************************************************************************
 * Just multiply the values received and push them back
 */
mult_serverdemux(s, m, length)
int s, length;
char *m;
{
  int	 product;
  mult	*p;

  p = (mult *)m;
  product = (p->a) * (p->b);	
  xpush(s, &product, sizeof(int), 0, 0);
}


/*****************************************************************************
 * Starts the server side for multiplication
 */
mult_server()
{
  int   mult_serverdemux();
  int	p;
  Part	whom[2];

  printf("I am the server on %s\n", SERVERNAME);
  init_partlist(whom, 1, SUNRPCaddr);
  SERVER.prog = MULTIPLY; 
  SERVER.vers = 1; 
  SERVER.proc = 1;
  set_part(whom, 0, SERVER);
  p = xcreateprotl(mult_serverdemux, null, null);
  (void) xopenenable(p, SUNRPC, whom);
}


  
/*****************************************************************************
 * Starts the server side
 */
rusers_server()
{
  int	rus_serverdemux();
  int	r;
  Part	whom[2];


  printf("I am the server on %s\n", SERVERNAME);
  init_partlist(whom, 1, SUNRPCaddr);
  SERVER.prog = RUSERSPROG;
  SERVER.vers = RUSERSVERS;
  SERVER.proc = RUSERSPROC_NUM;
  set_part(whom, 0, SERVER);
  r = xcreateprotl(rus_serverdemux, null, null);
  (void) xopenenable(r, SUNRPC, whom);
}


/*****************************************************************************
 * Just get the number of users and push it back
 */
rus_serverdemux(s, m, length)
int s, length;
char *m;
{
  int	 nusers;

  nusers = 1;  /* just return 1 cause I am the only user */
  xpush(s, &nusers, sizeof(int), 0, 0);
}

/*****************************************************************************
 * auxiliar to take time
 */
subtime(t1, t2, t3)
time *t1, *t2, *t3;
{
  t3->sec = t2->sec - t1->sec;
  t3->usec = t2->usec - t1->usec;
  if (t3->usec < 0) {
    t3->usec += 1000000;
    t3->sec -= 1;
  }
}

/*****************************************************************************
 * set all stuff for work on top of SUNRPC, fires process for client and server
 */
user(argc, argv)
int argc;
char **argv;
{
  IPhost ipaddr, nametoip();
  printf("sun_rpc test\n");
  IP = xgetprotlbyname("ip");
  SUNRPC = xgetprotlbyname("sun_rpc");
  SERVER.host.host = server_host;
  SERVER.prot =17;                  /* UDP hard coded */
  SERVERNAME = SITE_SERVER_NAME;
D 2
  if (xcontrolprotl(IP, MYADDR, &ipaddr, sizeof(IPhost)) != sizeof(IPhost)) {
E 2
I 2
  if (xcontrolprotl(IP, GETMYADDR, &ipaddr, sizeof(IPhost)) != 
      sizeof(IPhost)) {
E 2
    printf("Cannot get my own IP addr\n");
    return;
  } else {
    printf("My IP addr = %d.%d.%d.%d\n", ipaddr.a,ipaddr.b,ipaddr.c,ipaddr.d);
  }

  while (argc > 1) {
    if (!strncmp(argv[1], "-s", 2)) {
      SERVER.host.host = ipaddr;
    } else if (!strncmp(argv[1], "-c", 2)) {
      client_host = ipaddr;
      CLIENT.host.host = client_host;
      CLIENT.host.port = 0;
      SERVERNAME = &argv[1][2];
      SERVER.host.host = nametoip(SERVERNAME);
    }
    SERVERNAME = malloc(24);
    iptoname(SERVER.host.host, SERVERNAME);
    argc --;
    argv++;
  }
  if (IP_EQUAL(ipaddr, SERVER.host.host)) {
    xcreateprocess(rusers_server, 5, 0);
    xcreateprocess(mult_server, 5, 0);
  }
  if (IP_EQUAL(ipaddr, client_host)) {
    client();
  }
}

/*****************************************************************************/
null(s,m,length)
int s, length;
char *m;
{
}

E 1
