/* 
 * cachetemplate.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

/* 
 * implements simple direct mapped cache for various size keys
 */

#include "system.h"

/*
 * We need the definitions of:
 *	PREFIX
 *	KEYSIZE
 *	HASH
 *	COMPBYTES
 *	COPYBYTES
 */
struct STRUCT {
  int     int_id;
  int     full;
  int 	  time;
  char    ext_id[KEYSIZE];
};

typedef struct STRUCT CACHE_ELEM,*CACHE;



CACHE CACHE_CREATE (size)
int     size;
{
  CACHE	table;

  table = (CACHE)calloc((unsigned)(size + 2), sizeof(CACHE_ELEM));
  /* use first element to store size */
  table[0].int_id = size;

  /* use second element to keep stats */
#ifdef CACHE_STAT 
  table[1].int_id = 0; /* Hits */
  table[1].full = 0; /* Misses */
  table[1].time = 0; /* Spills  */ 
#endif

  return(table);
}

CACHE_INSERT (table, ext, intern,time,old_intern)
CACHE	table;
register char	*ext;
int	intern;
int time;
int  *old_intern;
{
  int      posn;
  int state;

  posn = HASH(ext, table[0].int_id) + 2;
  
  if (!table[posn].full) {
    state = MISS;
  } else if (COMPBYTES(table[posn].ext_id, ext)) {
    state = HIT;
    *old_intern = table[posn].int_id;
#ifdef CACHE_STAT
    table[1].time++;
#endif
  } else {
    state = SPILL;
    *old_intern = table[posn].int_id;
#ifdef CACHE_STAT
    table[1].time++;
#endif
  }
  table[posn].full = TRUE;
  table[posn].int_id = intern;
  table[posn].time = time;
  COPYBYTES(table[posn].ext_id, ext);
	
  return(state);
}

CACHE_DELETE (table, ext, intern,time)
CACHE	table;
register char	*ext;
int	*intern;
int *time;
{
  int      posn;
  int state;

  posn = HASH(ext, table[0].int_id) + 2;
  
  if (!table[posn].full) {
    state = MISS;
  } else if (COMPBYTES(table[posn].ext_id, ext)) {
    state = HIT;
    *intern = table[posn].int_id;
    *time = table[posn].time;
    table[posn].full = FALSE;
    
#ifdef CACHE_STAT
    table[1].time++;
#endif
  } else {
    state = SPILL;
    *old_intern = table[posn].int_id;
#ifdef CACHE_STAT
    table[1].time++;
#endif
  }
  return(state);
}
CACHE_LOOKUP (table, ext,intern,time)
CACHE	table;
register char	*ext;
int 	*intern;
int	*time;
{
  register int posn;
  int state;

  posn = HASH(ext, table[0].int_id) + 2;

  if (!table[posn].full) {
    state = MISS;
#ifdef CACHE_STAT
    table[1].full++;
#endif
  } else if (COMPBYTES(table[posn].ext_id, ext)) {
    state = HIT;
    *intern = table[posn].int_id;
    *time = table[posn].time;
#ifdef CACHE_STAT
    table[1].int_id++;
#endif
  } else {
    state = MISS;
#ifdef CACHE_STAT
    table[1].full++;
#endif
  }
  return(state);
}

unsigned CACHE_SIZE (table) 
CACHE table;
{
	return((unsigned) table[0].int_id);
}

CACHE_FLUSH (table,posn,ext,intern,time) 
CACHE table;
int posn;
register char	*ext;
int 	*intern;
int	*time;
{
  int true_posn;
  int state;

  true_posn = posn + 2;
 
  if (table[true_posn].full) {
    state = SPILL;
    table[true_posn].full = FALSE;
    *intern = table[true_posn].int_id;
    *time = table[true_posn].time;
    COPYBYTES(ext, table[true_posn].ext_id);
#ifdef CACHE_STAT
    table[1].time++;
#endif
  } else {
    state = MISS;
  }
  return(state);
}


CACHE_CLOSE (table)
CACHE	table;
{
  free((char *)table);
}

p_cache_stat(table) 
CACHE table;
{
	printf(":::CACHE STATS:::\n");
	printf("size %d\n",table[0].int_id);
	printf("hits %d\n",table[1].int_id);
	printf("misses %d\n",table[1].full);
	printf("spills %d\n",table[1].time);
	printf(":::END CACHE STATS:::\n");
}
