h45966
s 00134/00087/00449
d D 1.3 91/01/10 11:22:29 llp 3 2
c Prepared for 3.1 Distribution
e
s 00029/00011/00507
d D 1.2 89/10/24 16:50:18 norm 2 1
c Implemented controls on user protocols
e
s 00518/00000/00000
d D 1.1 89/10/24 13:46:39 norm 1 0
c date and time created 89/10/24 13:46:39 by norm
e
u
U
f e 0
t
T
I 1
/* 
D 3
 * %W%  %G%
E 3
I 3
 * upi.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 3
 */
I 3

#include <varargs.h>
E 3
#include "upi.h"
#include "system.h"
#include "process.h"
I 3
#ifndef XSIMUL
#include "memory.h"
#endif
E 3

I 3
int *checkaddress;

#if 0
#define CHECKADDRESS if (checkaddress) printf(" --> %x\n", *checkaddress);
#else
#define CHECKADDRESS 
#endif

E 3
int x_errno;
#ifndef NDEBUG
static char *controlops[] = {
D 3
  "myaddr",
  "peeraddr",
  "maxpacket",
  "getipinterfaces",
  "getipaddrs"
E 3
I 3
  "getmyaddr",
  "getpeeraddr",
  "getalladdrs",
  "getmaxpacket",
  "getoptpacket",
  "getproto",
  "setproto",
  "setdebug",
  "resolve",
  "rresolve",
  "freeresources"
E 3
};
#  define CONTROLMSG(n) ((n) < sizeof controlops / sizeof(char *) ? \
	controlops[n] : "unknown")
#else
#  define CONTROLMSG(n) ""
#endif

/*************************************************
* Uniform Protocol Interface Operations
/*************************************************/

x_init(p)
D 3
XOBJ p;
E 3
I 3
XObj p;
E 3
{
  assert(p->type == Protocol);
  (*p->init)(p);
}


D 3
XOBJ x_open(hlp, llp, participants)
XOBJ	hlp;
XOBJ	llp;
PART	*participants;
E 3
I 3
XObj x_open(hlp, llp, participants)
XObj	hlp;
XObj	llp;
Part	*participants;
E 3
{
D 3
  XOBJ s;
E 3
I 3
  XObj s;
E 3
  assert(llp->type == Protocol);
  assert(hlp->type == Protocol);
  if (!validopen(hlp, llp))  {
    x_errno = INVALID_OPEN;
    TRACE2(protocol, 1, "Invalid open of %s by %s", llp->name, hlp->name);
    return(ERR_XOBJ);
  }
  TRACE2(protocol, 1, "Calling open[%s] by %s", llp->name, hlp->name);
D 3
  s = (XOBJ)(*(llp->open))(llp,hlp, participants);
E 3
I 3
  CHECKADDRESS;
  s = (XObj)(*(llp->open))(llp,hlp, participants);
E 3
  TRACE3(protocol, 1, "Open[%s] by %s returns %x", llp->name, hlp->name, s);
I 3
  CHECKADDRESS;
E 3
  return(s);
}

x_openenable(hlp, llp, participants)
D 3
XOBJ	hlp;
XOBJ	llp;
PART	*participants;
E 3
I 3
XObj	hlp;
XObj	llp;
Part	*participants;
E 3
{
I 3
  int ans;
E 3
  assert(llp->type == Protocol);
  assert(hlp->type == Protocol);
  TRACE2(protocol, 3, "Calling openenable[%s] by %s", llp->name, hlp->name);
D 3
  return((*(llp->openenable))(llp,hlp, participants));
E 3
I 3
  CHECKADDRESS;
  ans = (*(llp->openenable))(llp,hlp, participants);
  CHECKADDRESS;
  return ans;
E 3
}

void x_callopendone(hlp, s, participants)
D 3
XOBJ hlp;
XOBJ s;
PART *participants;
E 3
I 3
XObj hlp;
XObj s;
Part *participants;
E 3
{
D 3
  register PFS od;
E 3
I 3
  register Pfs od;
E 3
#ifndef XSIMUL
  extern callUserOpenDone();
#endif

  assert(s->type == Session);
  assert(hlp->type == Protocol);
  
D 3
  if (!(od = (PFS) hlp->opendone)) return;
E 3
I 3
  if (!(od = (Pfs) hlp->opendone)) return;
E 3
  if (hlp->kernel) {
    TRACE2(protocol, 1, "Calling kernel opendone[%s] by %s", hlp->name, s->myprotl->name);
    (*od)(hlp, s, participants);
  } else {
    TRACE2(protocol, 1, "Calling user opendone[%s] by %s", hlp->name, s->myprotl->name);
I 3
  CHECKADDRESS;
E 3
#ifndef XSIMUL
    callUserOpenDone(hlp->as, od, s, participants);
#else
    (*od)(s, participants);
#endif
I 3
    TRACE2(protocol, 1, "Opendone[%s] by %s returns", hlp->name, s->myprotl->name);
    CHECKADDRESS;
E 3
  }
}

D 3
XOBJ x_opendone(hlp, llp, participants)
XOBJ	hlp;			  
XOBJ	llp;
PART	*participants;
E 3
I 3
XObj x_opendone(hlp, llp, participants)
XObj	hlp;			  
XObj	llp;
Part	*participants;
E 3
{
D 3
  XOBJ	s;
E 3
I 3
  XObj	s;
E 3

  assert(llp->type == Protocol);
  assert(hlp->type == Protocol);
  if (!validopen(hlp, llp))  {
    x_errno = INVALID_OPEN;		
    return(ERR_XOBJ);
  }
D 3
  if ((s=(XOBJ)(*(llp->open))(llp,hlp, participants)) == ERR_XOBJ)
E 3
I 3
  if ((s=(XObj)(*(llp->open))(llp,hlp, participants)) == ERR_XOBJ)
E 3
    return(s);
  x_callopendone(hlp, s, participants);
  return(s);
}

D 3
x_closedone(s)
XOBJ s;
E 3
I 3
x_callclosedone(s)
XObj s;
E 3
{
D 3
  register PFI cd;
E 3
I 3
  register Pfi cd;
E 3
#ifndef XSIMUL
  extern callUserCloseDone();
#endif
  assert(s->type == Session);
D 3


E 3
  if (cd = s->up->closedone) {
    if (s->up->kernel) {
      TRACE2(protocol, 1, "Calling kernel closedone[%s] by %s", s->up->name,
	s->myprotl->name);
      (*cd)(s);
    } else {
      TRACE2(protocol, 1, "Calling user closedone[%s] by %s", s->up->name, s->myprotl->name);
#ifndef XSIMUL
      callUserCloseDone(s->up->as, cd, s);
#else
      (*cd)(s);
#endif
    }
  }
I 3
}

x_closedone(s)
XObj s;
{
  x_callclosedone(s);
E 3
  (*s->close)(s);
}

x_opendisable(hlp, llp, participants)
D 3
XOBJ	hlp;
XOBJ	llp;
PART	*participants;
E 3
I 3
XObj	hlp;
XObj	llp;
Part	*participants;
E 3
{
  assert(llp->type == Protocol);
  assert(hlp->type == Protocol);
  TRACE2(protocol, 1, "Calling opendisable[%s] by %s", llp->name, hlp->name);
  return((*(llp->opendisable))(llp,hlp, participants));
}

x_close(s)
D 3
XOBJ s;
E 3
I 3
XObj s;
E 3
{
  TRACE0(protocol, 3, "x_close: entered");
  assert(x_is_session(s));
  TRACE2(protocol, 3, "Calling close[%s] by %s", s->myprotl->name, s->up->name);
  return((*s->close)(s));
}

#if defined(XSIMUL) || !defined(NDEBUG)

x_demux(s, msg)
D 3
XOBJ 	s;
MSG	msg;
E 3
I 3
XObj 	s;
Msg	msg;
E 3
{
#ifndef XSIMUL
  extern callUserDemux();
#endif
D 3
  register PFI demux;
E 3
I 3
  register Pfi demux;
E 3

  assert(x_is_session(s));
  TRACE3(protocol, 3, "Calling demux[%s] by %s, %d bytes", s->up->name, s->myprotl->name,
    msg_len(msg));
  IFTRACE(protocol, 7) {
    printf("       Message:\n");
    msg_display(msg, 8);
  }
  if (!(demux = s->up->demux)) return(NULL);
  if (s->up->kernel) {
    return((*demux)(s->up,s, msg));
  } else {
#ifndef XSIMUL
    callUserDemux(s->up->as, demux, s, msg);
    return(NULL);
#else
    int res, len;
    char *buffer;
    len = msg_len(msg);
    buffer = malloc((unsigned)len);

    msg_externalize(msg, buffer);
    res = (*demux)(s, buffer, len);
    free(buffer);
    return(res);
#endif
  }
}

x_push(s, msg, nmsg)
D 3
XOBJ s;
MSG	msg, *nmsg;
E 3
I 3
XObj s;
Msg	msg, *nmsg;
E 3
{
  assert(x_is_session(s));
  TRACE3(protocol, 3, "Calling push[%s] by %s, %d bytes", s->myprotl->name, s->up->name,
    msg_len(msg));
  IFTRACE(protocol, 7) {
    printf("       Message:\n");
    msg_display(msg, 8);
  }
  return((*s->push)(s, msg, nmsg));
}

x_pop(s, ds, msg)
D 3
XOBJ s, ds;
MSG	msg;
E 3
I 3
XObj s, ds;
Msg	msg;
E 3
{
  assert(!(int)ds || x_is_session(ds));
  TRACE2(protocol, 3, "Calling pop[%s], %d bytes", s->myprotl->name,
    msg_len(msg));
  return((*s->pop)(s, ds, msg));
}
#endif XSIMUL || !NDEBUG

x_control(s, opcode, buf, len)
D 2
XOBJ s;
E 2
I 2
D 3
XOBJ	s;
E 3
I 3
XObj	s;
E 3
E 2
int	opcode;
char	*buf;
int	len;
{
D 2
  TRACE3(protocol, 3, "Calling control[%s] op %s (%d)", s->myprotl->name,
    CONTROLMSG(opcode), opcode);
  if (s->control) {
    return((*s->control)(s, opcode, buf, len));
E 2
I 2
D 3
  register PFI c;
E 3
I 3
  register Pfi c;
E 3
#ifndef XSIMUL
  extern callUserControl();
#endif
  int res;
  if (c = s->control) {
    if (s->kernel) {
      TRACE3(protocol, 1, "Calling kernel control[%s] op %s (%d)",
	s->myprotl->name, CONTROLMSG(opcode), opcode);
I 3
      CHECKADDRESS;
E 3
      res = c(s, opcode, buf, len);
    } else {
      TRACE3(protocol, 1, "Calling user control[%s] op %s (%d)",
	s->myprotl->name, CONTROLMSG(opcode), opcode);
I 3
      CHECKADDRESS;
E 3
#ifndef XSIMUL
      res = callUserControl(s->as, c, s, opcode, buf, len);
#else
      res = c(s, opcode, buf, len);
#endif
    }
E 2
  } else {
D 2
    return(0);
E 2
I 2
    res = 0;
E 2
  }
I 2
  TRACE4(protocol, 1, "Control[%s] op %s (%d) returns %d",
	s->myprotl->name, CONTROLMSG(opcode), opcode, res);
I 3
  CHECKADDRESS;
E 3
  return res;
E 2
}

x_getproc(s, p, type)
D 3
XOBJ	s;
XOBJ	p;
xobj_type type;
E 3
I 3
XObj	s;
XObj	p;
XObjType type;
E 3
{
  TRACE2(protocol, 3, "Calling getproc old %s new %s",s->name,p->name);
  if (s->getproc) {
    (*s->getproc)(p,type);
    TRACE0(protocol, 3, "Done getproc");
    return(0);
  } else {
    return(-1);
  }
}

x_instantiateprotl(p)
D 3
XOBJ p;
E 3
I 3
XObj p;
E 3
{
  assert(x_is_protocol(p));
  TRACE1(protocol, 3, "Calling instantiateprotl protl %s",p->name);
  if (p->instantiateprotl) {
    return ((*p->instantiateprotl)(p));
  }
  return(0);
}


x_closeprotl(p)
D 3
XOBJ p;
E 3
I 3
XObj p;
E 3
{
  assert(x_is_protocol(p));
  TRACE1(protocol, 3, "Calling closeprotl protl %s",p->name);
  if (p->close) {
    return ((*p->close)(p));
  }
  return(0);
}


/*************************************************
D 3
/* Create and Destroy XOBJ's Sessions and Protocols 
E 3
I 3
/* Create and Destroy XObj's Sessions and Protocols 
E 3
/*************************************************/

D 3


/*************************************************
/* Create and Destroy Sessions
/*************************************************/
E 3
I 3
/*
 * x_createsession(hlp, llp, numdown, downs)
 */
E 3

D 3
XOBJ x_createsession(hlp, llp, numdown)
XOBJ	hlp;
XOBJ	llp;
int numdown;
E 3
I 3
XObj x_createsession(va_alist)
va_dcl
E 3
{
D 3
  XOBJ s;
E 3
I 3
  va_list ap;
  XObj	hlp;
  XObj	llp;
  int numdown;
  XObj s;
  int i;
E 3

D 3
  s = x_createxobj(numdown);
E 3
I 3
  va_start(ap);
  hlp = va_arg(ap, XObj);
  llp = va_arg(ap, XObj);
  numdown = va_arg(ap, int);
  s = x_createxobj(numdown);
E 3
  s->name = llp->name;
  s->type = Session;
  s->up = hlp;
  s->index = llp->index;
  s->as = llp->as;
  s->myprotl = llp;
  s->protocolid = llp->protocolid;
  s->instance = llp->instance;
  s->kernel = llp->kernel;
  s->device = llp->device;
  llp->rcnt++;
  x_getproc(llp,s,Session);
D 3
  return(s);
E 3
I 3
  for (i = 0; i < numdown; i++) {
    s->down[i] = va_arg(ap, XObj);
  }
  return s;
E 3
}

D 3
XOBJ x_createprotocol(numdown,name,id,instance,kernel,device,getproc)
E 3
I 3
XObj x_createprotocol(numdown,name,id,instance,kernel,device,getproc)
E 3
int numdown;
char *name;
int id;
int instance;
int kernel;
int device;
D 3
PFI getproc;
E 3
I 3
Pfi getproc;
E 3
{
D 3
  XOBJ s;
E 3
I 3
  XObj s;
E 3

  s = x_createxobj(numdown);
  s->type = Protocol;
  s->name = name;
  s->myprotl = s;
  s->index = (unsigned int)s;
  s->protocolid = id;
  s->instance = instance;
  s->kernel = kernel;
  s->device = device;
  if (getproc) (*getproc)(s,Protocol);
  return(s);
}


D 3
XOBJ x_createxobj(i)
E 3
I 3
XObj x_createxobj(i)
E 3
int i;
{
D 3
  XOBJ s;
E 3
I 3
  XObj s;
E 3

  if (i > STD_DOWN) {
D 3
    s = (struct xobj *) malloc((unsigned)(sizeof(struct xobj)+((i-STD_DOWN)*sizeof(XOBJ))));
E 3
I 3
    s = (struct xobj *) malloc((unsigned)(sizeof(struct xobj)+((i-STD_DOWN)*sizeof(XObj))));
E 3
  } else {
    s = (struct xobj *) malloc(sizeof(struct xobj));
  }
  bzero((char *)s,sizeof(struct xobj));
  s->state= ST_INITIALIZING;
  s->mutex = (int *)malloc(sizeof(Semaphore));
  InitSemaphore((Semaphore *)s->mutex, 1);
  s->rcnt = 1;
D 3
  return((XOBJ)s);
E 3
I 3
  return((XObj)s);
E 3
}

user_getproc(p,type)
D 3
XOBJ p;
xobj_type type;
E 3
I 3
XObj p;
XObjType type;
E 3
{
  if (type == Protocol) {
    p->instantiateprotl = noop;
    p->init = noop;
    p->close = noop;
    p->push = noop;
    p->pop = noop;
  } else {
    p->push = noop;
    p->pop = noop;
    p->instantiateprotl = noop;
    p->init = noop;
    p->close = noop;
  }
  p->open = noop;
  p->openenable = noop;
  p->opendone = noop;
  p->closedone = noop;
  p->opendisable = noop;
  p->demux = noop;
  p->getproc = noop; 
}

D 2
XOBJ x_createuserprotl(demux, opendone, closedone, kernel)
PFI demux, closedone;
E 2
I 2
D 3
XOBJ x_createuserprotl(demux, opendone, closedone, control)
PFI demux, closedone, control;
E 2
PFS opendone;
E 3
I 3
XObj x_createuserprotl(demux, opendone, closedone, control)
Pfi demux, closedone, control;
Pfs opendone;
E 3
D 2
int kernel;
E 2
{
D 3
  XOBJ p;
E 3
I 3
  XObj p;
E 3
  TRACE0(protocol, 3, "Calling createprotl");  

D 2
  p = x_createprotocol(0,"user",0,0,kernel,0,user_getproc);
E 2
I 2
  p = x_createprotocol(0,"user",0,0,0,0,user_getproc);
E 2
  p->demux = demux;
D 3
  p->opendone = (PFI) opendone;
E 3
I 3
  p->opendone = (Pfi) opendone;
E 3
D 2
  p->closedone = (PFI) closedone;
E 2
I 2
  p->closedone = closedone;
  p->control = control;
E 2
#ifndef XSIMUL
  p->as =  (struct _Aspace *)GetAddressableAspace();
#endif
  TRACE1(protocol, 3, "createprotl returns %x", p);
  return(p);
}


x_destroyxobj(s)
D 3
XOBJ	s;
E 3
I 3
XObj	s;
E 3
{
  if (s->state > ST_BROKEN)
    free(s->state);
  VAll((Semaphore *)s->mutex);
  free((char *)s->mutex);
  free((char *)s);
}

x_destroysession(s)
D 3
XOBJ s;
E 3
I 3
XObj s;
E 3
{
  assert(s->type == Session);
  if ((--(s->myprotl->rcnt)) < 1) { 
    x_closeprotl(s->myprotl);
  } 
  x_destroyxobj(s);
  
}

x_destroyprotl(s)
D 3
XOBJ s;
E 3
I 3
XObj s;
E 3
{
  assert(s->type == Protocol);
  x_destroyxobj(s);
}

/*************************************************
/* Miscellaneous Routines
/*************************************************/

noop()
{
}

/*ARGSUSED*/
validopen(hlp, llp)    /* perhaps validate based on dependency graph */
D 3
XOBJ	hlp, llp;
E 3
I 3
XObj	hlp, llp;
E 3
{
  return(1);
}


D 3
void initProtocols(deviceP)
E 3
I 3
void InitProtocols(deviceP)
E 3
int deviceP;
{
  static int nextp;
  if (deviceP) {
    TRACE0(protocol, 3, "initProtocols (device)");
    build_pgraph();
    for (nextp=0; protl_tab[nextp] && protl_tab[nextp]->device; nextp++)  {
      TRACE2(protocol, 1, "initializing protocol %d (%s)", nextp,
	protl_tab[nextp]->name);
      (*protl_tab[nextp]->init)(protl_tab[nextp]);
    }
  } else {
    TRACE0(protocol, 3, "initProtocols (process)");
    for (; protl_tab[nextp]; nextp++)  {
D 3
      TRACE2(protocol, 1, "initializing protocol %d (%s)", nextp,
E 3
I 3
      TRACE2(protocol, 1, "initializing protocol %d %s", nextp,
E 3
	protl_tab[nextp]->name);
      (*protl_tab[nextp]->init)(protl_tab[nextp]);
    }
  }
}

/* this may even work. */
int x_probeprotl(name)
char *name;
{
  register char *whom;
  register int i;
  for (i = 0; (whom = protocol_names[i]); i++) {
    if (*whom == *name && !strcmp(whom, name)) return(i);
  }
  return(-1);
}

D 3
XOBJ x_getprotlbyname(name)
E 3
I 3
XObj x_getprotlbyname(name)
E 3
char *name;
{
D 3
  register XOBJ p;
E 3
I 3
  register XObj p;
E 3
  register int i;
  for (i = 0; (p = protl_tab[i]); i++) {
    if (*p->name == *name && !strcmp(p->name, name)) return(p);
  }
  return(NULL);
}

int x_printxobj(p)
D 3
XOBJ p;
E 3
I 3
XObj p;
E 3
{
 	int i;

  	if (!p) printf("\nXOBJ NULL \n");
  	printf("\nXOBJ %x %s \n",p, p->name);
	if (p->type == Protocol) {
  	 	printf("type = Protocol\n");
      	} else {
  	 	printf("type = Session\n");
	}
     	printf("myprotocol = %x %s\n",p->myprotl,p->myprotl->name);
	printf("id = %d instance = %d\n",p->protocolid,p->instance);
	printf("rcnt = %d \n",p->rcnt);
	printf("up = %x ",p->up);
	if (p->up) {
		printf("up->type = %s ", p->type == Protocol ? "Protocol" : "Session");
		printf("up->name = %s\n",p->up->name);
	} else {
		printf("\n");
	}
 		
			
	printf("numdown = %d ",p->numdown);
	for (i=0;i<p->numdown;i++) {
		if (p->down[i]) {
			printf(" %d = %s ",i,p->down[i]->name);
		}
	}
	printf("\n");
}
E 1
