h35878
s 00180/00136/00255
d D 1.2 91/01/10 11:45:10 llp 2 1
c Prepared for 3.1 Distribution
e
s 00391/00000/00000
d D 1.1 90/11/16 10:53:22 menze 1 0
c date and time created 90/11/16 10:53:22 by menze
e
u
U
f e 0
t
T
I 1
/* 
 * udp.c
 *
 * x-kernel v3.1	12/10/90
 *
D 2
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
I 2
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
 */

#include "xkernel.h"
#include "ip.h"
#include "udp.h"
#include "udp_internal.h"

D 2
int             traceudpp;
E 2
I 2
int	traceudpp;
E 2

/*
 * Return a string with a nicely formatted udp address.
 */
static char    *formatudp(a)
D 2
  UDPaddr        *a;
E 2
I 2
     UDPaddr        *a;
E 2
{
  static char     place[2][32];
  static int      which = 0;
D 2

E 2
I 2
  
E 2
  sprintf(place[which], "%d.%d.%d.%d,%d", a->host.a, a->host.b, a->host.c, a->host.d, a->port);
  return place[!(which = !which)];
}

I 2

/*
 * udp_instantiateprotol
 */
E 2
udp_instantiateprotl(self)
D 2
  XObj            self;
E 2
I 2
     XObj	self;
E 2
{
D 2
  PSTATE         *pstate;

E 2
I 2
  PSTATE	*pstate;
  
E 2
  TRACE0(udpp, 1, "UDP instantiateprotl");
  assert(x_is_protocol(self));
D 2

E 2
I 2
  
E 2
  pstate = (PSTATE *) malloc(sizeof(PSTATE));
  self->state = (char *) pstate;
  pstate->activemap = map_create(101, 8);
  pstate->passivemap = map_create(23, 2);
}

I 2

/*
 * udp_init
 */
E 2
udp_init(self)
D 2
  XObj            self;
E 2
I 2
     XObj	self;
E 2
{
D 2
  Part            part[2];
  PSTATE         *pstate;

E 2
I 2
  Part		part[2];
  PSTATE	*pstate;
  
E 2
  TRACE0(udpp, 1, "UDP init");
  assert(x_is_protocol(self));
D 2

E 2
I 2
  
E 2
  pstate = (PSTATE *) self->state;
  pstate->myaddr.protocolnum = 17;
D 2
  x_controlprotl(self->down[0], MYADDR,
E 2
I 2
  x_controlprotl(self->down[0], GETMYADDR,
E 2
		 (char *) &pstate->myaddr.host, sizeof(IPhost));
D 2

E 2
I 2
  
E 2
  init_partlist(part, 1, IPaddr);
  set_part(part, 0, pstate->myaddr);
D 2

E 2
I 2
  
E 2
  if (x_openenable(self, self->down[0], part) < 0) {
    TRACE0(udpp, 0, "udp_init: can't openenable transport protocol");
    free((char *) pstate);
    return -1;
  }
  TRACE0(udpp, 1, "UDP init done");
  return 0;
}

D 2
XObj            udp_open(self, hlp, p)
  XObj            self;
  XObj            hlp;
  Part           *p;
{
  XObj            udp_s;
  HDR            *udph;
  Part            part[3];
  UDPaddr         local_addr, remote_addr;
  IPaddr          remote_ipaddr;
  ActiveId        activeid;
  XObj            transport_s;
  PSTATE         *pstate;
  SSTATE         *sstate;
E 2

I 2
/*
 * udp_open
 */
XObj udp_open(self, hlp, p)
     XObj	self;
     XObj	hlp;
     Part	*p;
{
  XObj		udp_s;
  HDR           *udph;
  Part          part[3];
  UDPaddr       local_addr, remote_addr;
  IPaddr        remote_ipaddr;
  ActiveId      activeid;
  XObj          transport_s;
  PSTATE        *pstate;
  SSTATE        *sstate;
  
E 2
  TRACE0(udpp, 3, "UDP open");
  assert(x_is_protocol(self));
  assert(x_is_protocol(hlp));
D 2

E 2
I 2
  
E 2
  pstate = (PSTATE *) self->state;
D 2

E 2
I 2
  
E 2
  local_addr = get_part(p, 0, UDPaddr);
  remote_addr = get_part(p, 1, UDPaddr);
  TRACE2(udpp, 5, "From %s to %s", 
	 formatudp(&local_addr), formatudp(&remote_addr));
D 2

E 2
I 2
  
E 2
  /*
   * We need to check that this open is legal.  I would expect that it is
   * illegal if anyone has already opened the same local port.  I need some
   * map to check for that.  This is not done.
   */
D 2

E 2
I 2
  
E 2
  init_partlist(part, 2, IPaddr);
  set_part(part, 0, pstate->myaddr);
  remote_ipaddr.protocolnum = pstate->myaddr.protocolnum;
  remote_ipaddr.host = remote_addr.host;
  set_part(part, 1, remote_ipaddr);
D 2

E 2
I 2
  
E 2
  if ((transport_s = x_open(self, self->down[0], part)) == ERR_XOBJ) {
    printf("udp_open: cannot open transport session (x_errno=%d)\n", x_errno);
    return ERR_XOBJ;
  }
  activeid.localport = local_addr.port;
  activeid.remoteport = remote_addr.port;
  activeid.sessn = transport_s;
  udp_s = (XObj) map_resolve(pstate->activemap, (char *) &activeid);
  if (udp_s != ERR_XOBJ) {
    udp_s->rcnt++;
  } else {
    udp_s = x_createsession(hlp, self, 1, transport_s);
    udp_s->binding = map_bind(pstate->activemap, (char *) &activeid, (int) udp_s);
D 2

E 2
I 2
    
E 2
    sstate = (SSTATE *) malloc(sizeof(SSTATE));
    sstate->dhost = remote_addr.host;
    udp_s->state = (char *)sstate;
D 2

E 2
I 2
    
E 2
    udph = &(sstate->hdr);
    udph->sport = htons(local_addr.port);
    udph->dport = htons(remote_addr.port);
    udph->ulen = htons(0);
    udph->sum = 0;
  }
  TRACE1(udpp, 3, "UDP open returns %x", udp_s);
  return udp_s;
}

I 2

/*
 * udp_controlsessn
 */
E 2
udp_controlsessn(s, opcode, buf, len)
D 2
  XObj            s;
  int             opcode, len;
  char           *buf;
E 2
I 2
     XObj	s;
     int        opcode, len;
     char       *buf;
E 2
{
D 2
  SSTATE         *sstate;
  PSTATE         *pstate;
  HDR            *hdr;

E 2
I 2
  SSTATE        *sstate;
  PSTATE        *pstate;
  HDR           *hdr;
  
E 2
  assert(x_is_session(s));
D 2

E 2
I 2
  
E 2
  sstate = (SSTATE *) s->state;
  pstate = (PSTATE *) s->myprotl->state;
D 2

E 2
I 2
  
E 2
  hdr = &(sstate->hdr);
  switch (opcode) {
D 2

   case MYADDR:
     checkLen(len, UDPADLEN);
     ((UDPaddr *) buf)->host = pstate->myaddr.host;
     ((UDPaddr *) buf)->port = hdr->sport;
     return UDPADLEN;

   case PEERADDR:
     checkLen(len, UDPADLEN);
     ((UDPaddr *) buf)->host = sstate->dhost;
     ((UDPaddr *) buf)->port = hdr->dport;
     return UDPADLEN;

   case MAXPACKET:
     checkLen(len, sizeof(int));
     *(int *) buf = MAX;
     return sizeof(int);

   default:
     x_errno = INVALID_OPCODE;
     return -1;
E 2
I 2
    
  case GETMYADDR:
    checkLen(len, UDPADLEN);
    ((UDPaddr *) buf)->host = pstate->myaddr.host;
    ((UDPaddr *) buf)->port = hdr->sport;
    return UDPADLEN;
    
  case GETPEERADDR:
    checkLen(len, UDPADLEN);
    ((UDPaddr *) buf)->host = sstate->dhost;
    ((UDPaddr *) buf)->port = hdr->dport;
    return UDPADLEN;
    
  case GETMAXPACKET:
    checkLen(len, sizeof(int));
    *(int *) buf = MAX;
    return sizeof(int);
    
  default:
    x_errno = INVALID_OPCODE;
    return -1;
E 2
  }
}

I 2

/*
 * udp_controlprotl
 */
E 2
udp_controlprotl(self, opcode, buf, len)
D 2
  XObj            self;
  int             opcode, len;
  char           *buf;
E 2
I 2
     XObj	self;
     int        opcode, len;
     char       *buf;
E 2
{
  assert(x_is_protocol(self));
D 2

E 2
I 2
  
E 2
  switch (opcode) {
D 2
   case MAXPACKET:
     checkLen(len, sizeof(int));
     *(int *) buf = MAX;
     return sizeof(int);

   case MYADDR:
     return x_controlprotl(self->down[0], MYADDR, buf, len);

   default:
     x_errno = INVALID_OPCODE;
     return -1;
E 2
I 2
  case GETMAXPACKET:
    checkLen(len, sizeof(int));
    *(int *) buf = MAX;
    return sizeof(int);
    
  case GETMYADDR:
    return x_controlprotl(self->down[0], GETMYADDR, buf, len);
    
  default:
    x_errno = INVALID_OPCODE;
    return -1;
E 2
  }
}

I 2

/*
 * udp_openenable
 */
E 2
udp_openenable(self, hlp, p)
D 2
  XObj            self;
  XObj            hlp;
  Part           *p;
E 2
I 2
     XObj	self;
     XObj       hlp;
     Part       *p;
E 2
{
D 2
  UDPaddr	  localaddr;
  PassiveId       localport;
  PSTATE         *pstate;

E 2
I 2
  UDPaddr	localaddr;
  PassiveId     localport;
  PSTATE        *pstate;
  
E 2
  TRACE0(udpp, 3, "UDP open enable");
  assert(x_is_protocol(self));
  assert(x_is_protocol(hlp));
  pstate = (PSTATE *) self->state;
D 2

E 2
I 2
  
E 2
  localaddr = get_part(p, 0, UDPaddr);
  localport = localaddr.port;
  TRACE1(udpp, 5, "Port number %d", localport);
  if (map_bind(pstate->passivemap, (char *) &localport, (int) hlp) == ERR_BIND) {
    x_errno = ALREADY_OPEN;
    return -1;
  }
  return 0;
}

I 2

/*
 * udp_closesessn
 */
E 2
udp_closesessn(s)
D 2
  XObj            s;
E 2
I 2
     XObj	s;
E 2
{
D 2
  PSTATE         *pstate;

E 2
I 2
  PSTATE        *pstate;
  
E 2
  assert(x_is_session(s));
D 2

E 2
I 2
  
E 2
  TRACE1(udpp, 3, "UDP close of session %x", s);
  if (--s->rcnt > 0)
    return 0;
D 2

E 2
I 2
  
E 2
  pstate = (PSTATE *) s->myprotl->state;
D 2

E 2
I 2
  
E 2
  map_unbindbinding(pstate->activemap, s->binding);
  x_close(s->down[0]);
  x_destroysession(s);
  return 0;
}

I 2
/*
 * udp_closeprotl
 */
E 2
udp_closeprotl(self)
D 2
  XObj            self;
E 2
I 2
     XObj	self;
E 2
{
D 2
  PSTATE         *pstate;

E 2
I 2
  PSTATE        *pstate;
  
E 2
  assert(x_is_protocol(self));
D 2

E 2
I 2
  
E 2
  if (((self->rcnt)) > 0)
    return;
D 2

E 2
I 2
  
E 2
  pstate = (PSTATE *) self->state;
  map_close(pstate->activemap);
  map_close(pstate->passivemap);
  free((char *) pstate);
}

I 2
/*
 * udp_push
 */
E 2
/*ARGSUSED*/
udp_push(s, msg, rmsg_ptr)
D 2
  XObj            s;
  MSG             msg;
  MSG            *rmsg_ptr;
E 2
I 2
     XObj	s;
     Msg        msg;
     Msg        *rmsg_ptr;
E 2
{
D 2
  SSTATE         *sstate;
  HDR            *hdr;

E 2
I 2
  SSTATE        *sstate;
  HDR           *hdr;
  
E 2
  TRACE0(udpp, 3, "in udp push");
  assert(x_is_session(s));
  sstate = (SSTATE *) s->state;
  hdr = (HDR *) msg_push(msg, HLEN);
  *hdr = sstate->hdr;
  hdr->ulen = htons(msg_len(msg));
  TRACE2(udpp, 5, "sending msg len %d from port %d",
	 msg_len(msg), hdr->sport);
  TRACE5(udpp, 5, "  to port %d @ %d.%d.%d.%d", hdr->dport,
	 sstate->dhost.a, sstate->dhost.b, sstate->dhost.c,
	 sstate->dhost.d);
D 2
  return x_push(s->down[0], msg, (MSG *) 0);
E 2
I 2
  return x_push(s->down[0], msg, (Msg *) 0);
E 2
}

I 2

/*
 * udp_demux
 */
E 2
udp_demux(self, transport_s, dg)
D 2
  XObj            self;
  XObj            transport_s;
  MSG             dg;
E 2
I 2
     XObj	self;
     XObj       transport_s;
     Msg        dg;
E 2
{
  register HDR   *h;
D 2
  Part            part[3];
  XObj            hlp;
  XObj            s;
  IPhost          peeriphost;
  UDPaddr         localaddr, remoteaddr;
  ActiveId        activeid;
  PassiveId       passiveid;
  PSTATE         *pstate;

E 2
I 2
  Part          part[3];
  XObj          hlp;
  XObj          s;
  IPhost        peeriphost;
  UDPaddr       localaddr, remoteaddr;
  ActiveId      activeid;
  PassiveId     passiveid;
  PSTATE        *pstate;
  
E 2
  assert(x_is_session(transport_s));
  assert(x_is_protocol(self));
D 2

E 2
I 2
  
E 2
  pstate = (PSTATE *) self->state;
  h = (HDR *) msg_top(dg, HLEN);
  swap_hdr(h);
D 2

E 2
I 2
  
E 2
  if (h->ulen < msg_len(dg))
    msg_chopright(dg, dg, (int) h->ulen);
D 2

E 2
I 2
  
E 2
  TRACE2(udpp, 3, "in udp demux sport = %d, dport = %d", h->sport,
	 h->dport);
  TRACE2(udpp, 7, " h->ulen = %d, msg_len = %d", h->ulen,
	 msg_len(dg));
D 2

E 2
I 2
  
E 2
  TRACE2(udpp, 5, "received msg len %d to port %d",
	 msg_len(dg), h->dport);
D 2

E 2
I 2
  
E 2
  activeid.localport = h->dport;;
  activeid.remoteport = h->sport;
  activeid.sessn = transport_s;
  s = (XObj) map_resolve(pstate->activemap, (char *) &activeid);
  if (s != ERR_XOBJ) {
    TRACE1(udpp, 3, "Popping to existing session %x", s);
    return x_pop(s, transport_s, dg);
  }
  passiveid = h->dport;
  hlp = (XObj) map_resolve(pstate->passivemap, (char *) &passiveid);
  if (hlp != ERR_XOBJ) {
    TRACE1(udpp, 3, "Found an open enable for prot %d", hlp);
D 2

E 2
I 2
    
E 2
    /* Retrieve the other IP host address for opening myself */
D 2
    (void) x_controlsessn(transport_s, PEERADDR, (char *) &peeriphost, IPADLEN);

E 2
I 2
    (void) x_controlsessn(transport_s, GETPEERADDR, (char *) &peeriphost, IPADLEN);
    
E 2
    init_partlist(part, 2, UDPaddr);
    localaddr.port = h->dport;
    localaddr.host = pstate->myaddr.host;
    set_part(part, 0, localaddr);
    remoteaddr.port = h->sport;
    remoteaddr.host = peeriphost;
    set_part(part, 1, remoteaddr);
D 2

E 2
I 2
    
E 2
    TRACE1(udpp, 3, "Calling self.open for prot %d", hlp);
    s = x_open(hlp, self, part);
D 2

E 2
I 2
    
E 2
    if (s != ERR_XOBJ) {
      TRACE1(udpp, 3, "Calling open done for prot %d", hlp);
      x_callopendone(hlp, s, part);
D 2

E 2
I 2
      
E 2
      TRACE1(udpp, 3, "Popping to session %x", s);
      return x_pop(s, transport_s, dg);
    }
  }
  TRACE0(udpp, 3, "...dropping the message");
  msg_free(dg);
  return 0;
}

I 2
/*
 * udp_pop
 */
E 2
/*ARGSUSED*/
udp_pop(s, ds, dg)
D 2
  XObj            s, ds;
  MSG             dg;
E 2
I 2
     XObj	s, ds;
     Msg        dg;
E 2
{
D 2

E 2
I 2
  
E 2
  TRACE1(udpp, 2, "UDP pop, length = %d", msg_len(dg));
  assert(x_is_session(s));
  msg_pop(dg, HLEN);
  return x_demux(s, dg);
}


I 2
/*
 * udp_getproc
 */
E 2
udp_getproc(p, type)
D 2
  XObj            p;
  XobjType       type;
E 2
I 2
     XObj	p;
     XObjType   type;
E 2
{
  if (type == Protocol) {
    p->instantiateprotl = udp_instantiateprotl;
    p->init = udp_init;
    p->close = udp_closeprotl;
    p->push = noop;
    p->pop = noop;
    p->control = udp_controlprotl;
  } else {
    p->push = udp_push;
    p->pop = udp_pop;
    p->instantiateprotl = noop;
    p->init = noop;
    p->control = udp_controlsessn;
    p->close = udp_closesessn;
  }
  p->open = (Pfi) udp_open;
  p->openenable = udp_openenable;
  p->opendone = noop;
  p->closedone = noop;
  p->opendisable = noop;
  p->demux = udp_demux;
  p->getproc = udp_getproc;
}
E 1
