h63781
s 00000/00016/00035
d D 1.3 91/02/11 18:09:03 menze 3 2
c blast now asks the llp for the appropriate fragmentation size
e
s 00007/00005/00044
d D 1.2 91/01/10 11:44:33 llp 2 1
c Prepared for 3.1 Distribution
e
s 00049/00000/00000
d D 1.1 90/11/16 10:52:53 menze 1 0
c date and time created 90/11/16 10:52:53 by menze
e
u
U
f e 0
t
T
I 1
/* 
 * blast.h
 *
 * x-kernel v3.1	12/10/90
 *
D 2
 * Copyright 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
I 2
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
E 2
 */

D 2
#pragma once
E 2
I 2
#ifndef blast_h
#define blast_h
E 2

/* Protocol number which IP uses to identify BLAST */
#define BLAST_IP_PROT 100 

/* Protocol number ("type") which ETH uses to identify BLAST */
#define BLAST_ETH_TYPE 0x1234

#define BLASTADLEN  sizeof(BLASTaddr)

D 3
#define MAX_FRAG_LEN 1440
#define MAX_DGM 16*1024  	/* Largest supported datagram */


/* timeout calculations: timeout = CONST (msec) * number_of_fragments */

#define REC_CONST 50	
#define SEND_CONST 100

#define BLAST_MAX_TRIES(m) (((m)/MAX_FRAG_LEN) + 1) 
#define BLAST_REC_DELAY(m) (((m)/MAX_FRAG_LEN)*REC_CONST)
#define BLAST_SEND_DELAY(m) (((m)/MAX_FRAG_LEN)*SEND_CONST)

E 3
/* Default number of concurrent outstanding messages allowed
 * (per protocol instantiation)
 */
#define OUTSTANDING_MESSAGES 64

D 2
#define BLAST_SET_OUTSTANDING_MSGS (LASTSTANDARDOP + 1)
#define BLAST_GET_OUTSTANDING_MSGS (LASTSTANDARDOP + 2)
E 2
I 2
#define BLAST_SETOUTSTANDINGMSGS (BLAST_CTL*MAXOPS + 0)
#define BLAST_GETOUTSTANDINGMSGS (BLAST_CTL*MAXOPS + 1)
E 2

D 2
typedef struct {
E 2
I 2
typedef struct blastaddr {
E 2
	IPhost  host;
	int	prot;
} BLASTaddr;
 
D 3

#define FULLMASK 0xffff

E 3
extern int traceblastp;

I 2
#endif blast_h
E 2
E 1
