h45033
s 00140/00000/00000
d D 1.1 91/01/10 11:10:16 llp 1 0
c date and time created 91/01/10 11:10:16 by llp
e
u
U
f e 0
t
T
I 1
/* 
 * process.h
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

/*
 * Process Descriptors
 */

#ifndef process_h
#define process_h

#ifndef system_h
#include "system.h"
#endif

#ifndef memory_h
#include "memory.h"
#endif

#ifndef ms_process_h
#include "ms_process.h"
#endif

#ifndef upi_h
#include "upi.h"
#endif

/* Values for state field of process descriptor */
#define READY		1	/* Eligible for execution */
#define DEAD		2
#define WAITING		3

#define MAX_PROCESS_PRIORITY	0
#define NULL_PROC_PRIORITY 31



/* Bits in status register */
#define TRACE_MODE		(1<<15)
#define SUPERVISOR_STATE	(1<<13)
#define INTERRUPT_MASK		(7<<8)
#define EXTEND_BIT		(1<<4)
#define NEGATIVE_BIT		(1<<3)
#define ZERO_BIT		(1<<2)
#define OVERFLOW_BIT		(1<<1)
#define CARRY_BIT		(1<<0)

typedef struct _SQueue {
  struct _Process		*head;
  struct _Process		*tail;
  unsigned short	lock;
  unsigned short	type;
} SyncQueue;

/* Values for the type field. - only used for postmortem, etc. */
#define READY_QUEUE	1

typedef struct _Process {
  struct _Process	*link;	/* General-purpose queue link. MUST BE FIRST */
  struct _Process	*next;
  ProcessId	pid;		/* pid */
  unsigned char state;		/* Blocked state else ready */
  unsigned short priority;	/* Processor allocation */
  Aspace	*aspace;	/* Aspace of process */
  SyncQueue	*queuePtr;	/* Queue that the process is in, if any. */
  /* Machine-specific processor state */
  Ms_ProcessorState  ps;
  int		extrastuff;
} Process;

typedef struct sSemaphore {
  struct _Process		*head;
  struct _Process	       **tail;
  short				 unused;
  short				 count;
} Semaphore;

#define Q_INIT(Q) { \
  (Q)->head = NULL; \
  (Q)->tail = &(Q)->head; \
}

#define Q_EMPTY(Q) ((Q)->tail == &(Q)->head)

#define Q_INSERTLAST(Q, E) { \
  *((Q)->tail) = (E); \
  (E)->link = NULL; \
  (Q)->tail = &(E)->link; \
}

#define Q_INSERTFIRST(Q, E) { \
  (E)->link = (Q)->head; \
  (Q)->head = (E); \
  if (Q_EMPTY(Q)) (Q)->tail = &(E)->link; \
}

#define Q_REMOVEFIRST(Q, E) { \
  if ((E) = (Q)->head) { \
    if (! ((Q)->head = (E)->link)) (Q)->tail = &(Q)->head; \
  } \
}

/* Format for system-maintained time. */
typedef struct {
  long    seconds;
  int    clicks; /* mod CLICKS_PER_SECOND */
} TimeRecord;

/*********************************************************
* Exported macros, functions, and variables
**********************************************************/

#define P(S) { if (--(S)->count < 0) Ms_P(S); }
#define V(S) { if (++(S)->count <= 0) realV(S); }
#define kSwitch() Ms_Switch()
#define Delay(x) Ms_Delay(x)
#define Idle() Ms_Idle()
#define splx(x) Ms_Splx(x)
#define spl7() Ms_Spl7()

extern int	InitProcesses();
extern Process	*CreateProcess();
extern Process	*CreateKernelProcess();
extern int	DestroyProcess();
extern int	Wait();
extern int	Signal();
extern int	InitSemaphore();
extern int	VAll();
extern int	Kabort();

extern Process	*Active;
extern Process  *ProcessDescriptors;
extern Process  *EndPds;
extern unsigned long MaxProcesses;

#endif
E 1
