/*
 * nfslib.h
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

 
#ifndef _nfslib_h_
#define _nfslib_h_

#ifndef EOF
#define EOF (-1)
#endif

#include "userupi.h"

#define BUFFER_SIZE 8192

typedef struct _NFS_FD_struct {
   Protl proto;
   Sessn file;
} NFS_FD_struct, *NFS_FD;

typedef struct _NFS_FILE {
   int cnt;
   char *ptr;
   char buf[BUFFER_SIZE];
   NFS_FD file;
} NFS_FILE;

extern int nfs_mount();
extern NFS_FD nfs_open();
extern NFS_FILE *nfs_fopen();
extern NFS_FILE *nfs_create();
extern int nfs_read_data();
extern int nfs_filbug();
extern int nfs_ungetch();
extern int nfs_fscanf();
extern int nfs_close();
extern void nfs_fclose();
extern int nfs_fread();
extern off_t nfs_lseek();
extern int nfs_tell();
extern int nfs_fseek();
extern int nfs_fstat();

#endif
