/* 
 * maptable.c
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */

#include "upi.h"
#include "ethernet.h"
#include "ip.h"

#define eaddreq(A, B) ((A).high == (B).high && (A).mid == (B).mid && (A).low == (B).low)
#define ipaddreq(A, B) ((A).a == (B).a && (A).b == (B).b && (A).c == (B).c && (A).d == (B).d)

static struct {
  char *name;
  IPhost ipaddr;
  ETHhost eaddr;
} map[] = {
/*STARTHERE*/
  { "acacia", {192, 12, 69, 82 }, { 0x0800, 0x2008, 0xaeaa } },
  { "agave", {192, 12, 69, 29 }, { 0x0800, 0x2007, 0x43B5 } },
  { "albertus", { 192, 12, 69, 9 }, { 0x0000, 0x0F00, 0x2A96 } },
  { "aloe", {192, 12, 69, 71 }, { 0x0800, 0x2008, 0x8380 } },
  { "ash", {192, 12, 69, 88 }, { 0x0800, 0x2008, 0x5215 } },
  { "auriga", { 192, 12, 69, 11 }, { 0x0800, 0x2001, 0x5040 } },
  { "balder", { 192, 12, 69, 195 }, { 0x0800, 0x89d0, 0x3267 } },
  { "barrel", { 192, 12, 69, 30 }, { 0x0800, 0x2001, 0x2D94 } },
  { "baskerville", { 192, 12, 69, 35 }, { 0x0800, 0x2001, 0xC984 } },
  { "bembo", { 192, 12, 69, 37 }, { 0x0800, 0x2001, 0xD982 } },
  { "benguiat", { 192, 12, 69, 8 }, { 0x0800, 0x2001, 0x51e6 } },
  { "bobcat", {192, 12, 69, 70 }, { 0x0800, 0x2007, 0xfb2b } },
  { "bocklin", { 192, 12, 69, 2 }, { 0x0800, 0x2B02, 0x365F } },
  { "bodoni", { 192, 12, 69, 22 }, { 0x0800, 0x2000, 0x22A6 } },
  { "boojum", {192, 12, 69, 17 }, { 0x0800, 0x2009, 0xC6E9 } },
  { "bougainvillea", {192, 12, 69, 76 }, { 0x0800, 0x2009, 0x2c70 } },
  { "caslon", { 192, 12, 69, 55 }, { 0x0800, 0x4700, 0x1130 } },
  { "cheltenham", {192, 12, 69, 60 }, { 0x0800, 0x2008, 0xc3e4 } },
  { "cholla", {192, 12, 69, 59 }, { 0x0800, 0x2008, 0x338b } },
  { "cicada", {192, 12, 69, 74 }, { 0x0800, 0x2009, 0xAC83 } },
  { "clarendon", { 192, 12, 69, 23 }, { 0x0800, 0x2006, 0x0098 } },
  { "coatimundi", {192, 12, 69, 18 }, { 0x0800, 0x2008, 0x5cc2 } },
  { "compaq", { 192, 12, 69, 51 }, { 0x0001, 0x0002, 0x0003 } }, /*NOETHER*/
  { "corona", { 192, 12, 69, 47 }, { 0x0800, 0x2001, 0xCE64 } },
  { "cottonwood", {192, 12, 69, 84 }, { 0x0800, 0x2007, 0xfbb9 } },
  { "courier", { 192, 12, 69, 5 }, { 0x0800, 0x2001, 0x11D5 } },
  { "creosote", { 192, 12, 69, 20 }, { 0x0800, 0x2001, 0x2F0D } },
  { "deuna", { 0, 0, 0, 0 }, { 0xab00, 0x0002, 0x0000 } }, /*VAX deuna babble*/
  { "droste", { 192, 12, 69, 43 }, { 0x0800, 0x0902, 0xC586 } },
  { "eagle", {192, 12, 69, 66 }, { 0x0800, 0x2008, 0x2FBF } },
  { "franklin", { 192, 12, 69, 36 }, { 0x0800, 0x2001, 0xD340 } },
  { "friz", { 192, 12, 69, 38 }, { 0x0800, 0x2007, 0x5DC9 } },
  { "futura", { 192, 12, 69, 25 }, { 0x0800, 0x2001, 0x5324 } },
  { "gacham", { 192, 12, 69, 24 }, { 0x0800, 0x2001, 0x5153 } },
  { "galliard", { 192, 12, 69, 10 }, { 0x0800, 0x2007, 0x2c68 } },
  { "garamond", { 192, 12, 69, 19 }, { 0x0800, 0x2001, 0x90DA } },
  { "gilamonster", {192, 12, 69, 20 }, { 0x0800, 0x2008, 0x302c } },
  { "gothic", { 192, 12, 69, 7 }, { 0x0800, 0x89d0, 0x3267 } },
  { "granjon", { 192, 12, 69, 27 }, { 0x0800, 0x2001, 0x504A } },
  { "hackberry", { 192, 12, 69, 6 }, { 0x0001, 0x0002, 0x0003 } }, /*NOETHER*/
  { "hedgehog", {192, 12, 69, 67 }, { 0x0800, 0x2008, 0x3365 } },
  { "hershey", { 192, 12, 69, 28 }, { 0x0800, 0x2000, 0x559E } },
  { "hoder", { 192, 12, 69, 194 }, { 0x0800, 0x89d0, 0x3267 } },
  { "hummingbird", {192, 12, 69, 30 }, { 0x0800, 0x2008, 0x8387 } },
  { "italic", {192, 12, 69, 26 }, { 0x0800, 0x2007, 0x2341 } },
  { "jaguarundi", {192, 12, 69, 73 }, { 0x0800, 0x2008, 0x5cad } },
  { "javelina", {192, 12, 69, 68 }, { 0x0800, 0x2008, 0x073b } },
  { "jenson", { 192, 12, 69, 32 }, { 0x0800, 0x2007, 0x7815 } },
  { "jojoba", {192, 12, 69, 12 }, { 0x0800, 0x2008, 0x5cd0 } },
  { "kadmos", { 192, 12, 69, 49 }, { 0x0800, 0x2001, 0x5154 } },
  { "lan bridge", { 0, 0, 0, 0 }, {0x0800, 0x2b04, 0xcd77 } },
  { "lan multicast", { 0, 0, 0, 0 }, {0x0900, 0x2b01, 0x0001 } },
  { "lantana", {192, 12, 69, 62 }, { 0x0800, 0x2008, 0xa735 } },
  { "lectura", { 192, 12, 69, 3 }, { 0x0800, 0x2B00, 0x0F9A } },
  { "london", { 192, 12, 69, 4 }, { 0x0800, 0x89d0, 0x2323 } },
  { "lubalin", { 192, 12, 69, 45 }, { 0x0800, 0x2001, 0x51d6 } },

  { "lucida", { 192, 12, 69, 48 }, { 0x0800, 0x2000, 0x4012 } },
  { "megaron", { 192, 12, 69, 1 }, { 0x0800, 0x2B02, 0x5DEE } },
  { "melior", { 192, 12, 69, 46 }, { 0x0001, 0x0002, 0x0003 } }, /*NOETHER*/
  { "mesquite", {192, 12, 69, 72 }, { 0x0800, 0x2009, 0x88BC } },
  { "morris", { 192, 12, 69, 33 }, { 0x0800, 0x2001, 0x7E56 } },
  { "mule", { 192, 12, 69, 58 }, { 0x0800, 0x2b13, 0xcbe8 } },
  { "nestle", { 192, 12, 69, 41 }, { 0x0800, 0x2000, 0x2A7E } },
  { "nomi", { 192, 12, 69, 31 }, { 0x0800, 0x2001, 0x9684 } },
  { "ocotillo", { 192, 12, 69, 18 }, { 0x0800, 0x2001, 0x2EA4 } },
  { "opuntia", {192, 12, 69, 69 }, { 0x0800, 0x2008, 0x2fed } },
  { "orator", { 192, 12, 69, 42 }, { 0x0800, 0x2001, 0x4776 } },
  { "organpipe", { 192, 12, 69, 14 }, { 0x0800, 0x2001, 0x0F86 } },
  { "owl", {192, 12, 69, 61 }, { 0x0800, 0x2009, 0xAC73 } },
  { "paloverde", {192, 12, 69, 16 }, { 0x0800, 0x2009, 0xBE4A } },
  { "pcrt", { 192, 12, 69, 54 }, { 0x0001, 0x0002, 0x0003 } }, /*NOETHER*/
  { "pcxt", { 192, 12, 69, 52 }, { 0x0001, 0x0002, 0x0003 } }, /*NOETHER*/
  { "plantin", { 192, 12, 69, 34 }, { 0x0800, 0x2001, 0x85A5 } },
  { "ps2", { 192, 12, 69, 44 }, { 0x0001, 0x0002, 0x0003 } }, /*NOETHER*/
  { "quail", {192, 12, 69, 79 }, { 0x0800, 0x2009, 0x2cc6 } },
  { "raffia", { 192, 12, 69, 12 }, { 0x0800, 0x2001, 0x1271 } },
  { "rbbs", { 192, 12, 69, 50 }, { 0x0001, 0x0002, 0x0003 } }, /*NOETHER*/
  { "roadrunner", {192, 12, 69, 65 }, { 0x0800, 0x2008, 0x30ce } },
  { "saguaro", {192, 12, 69, 13 }, { 0x0800, 0x2008, 0x56ca } },
  { "saltbush", {192, 12, 69, 81 }, { 0x0800, 0x2009, 0x2c7c } },
  { "scorpion", {192, 12, 69, 75 }, { 0x0800, 0x2008, 0x56b3 } },
  { "spadefoot", {192, 12, 69, 83 }, { 0x0800, 0x2008, 0xb6a2 } },
  { "sycamore", {192, 12, 69, 87 }, { 0x0800, 0x2008, 0x3385 } },
  { "tivoli", { 192, 12, 69, 57 }, { 0x0800, 0x6902, 0x0d40 } },
  { "toad", { 192, 12, 69, 53 }, { 0x0207, 0x0104, 0x3641 } },
  { "tobler", { 192, 12, 69, 56 }, { 0x0800, 0x6902, 0x0c9d } },
  { "trump", { 192, 12, 69, 40 }, { 0x0800, 0x2000, 0x1CB8 } },
  { "tumbleweed", {192, 12, 69, 64 }, { 0x0800, 0x2008, 0x569b } },
  { "univers", {192, 12, 69, 46 }, { 0x0800, 0x2006, 0xc433 } },
  { "ursus", {192, 12, 69, 63 }, { 0x0800, 0x2007, 0x3160 } },
  { "walnut", {192, 12, 69, 85 }, { 0x0800, 0x2008, 0x3358 } },
  { "whitetail", {192, 12, 69, 80 }, { 0x0800, 0x2009, 0x2d00 } },
  { "willow", {192, 12, 69, 86 }, { 0x0800, 0x2008, 0x5cc4 } },
  { "yucca", { 192, 12, 69, 15 }, { 0x0800, 0x2001, 0x5173 } },
  { "zapf", { 192, 12, 69, 39 }, { 0x0800, 0x2001, 0xB84C } },
  { "zephyr", { 192, 12, 69, 21 }, { 0x0800, 0x2000, 0x46B5 } },
/*ENDHERE*/

  { "broadcast", { 192, 12, 69, 0}, { 0xffff,0xffff,0xffff } },
  { "broadcast", { 192, 12, 69, 255}, { 0xffff,0xffff,0xffff } },
  { 0, {0, 0, 0, 0}, { 0, 0, 0 } }
};

ETHhost nametoeth(name)
char *name;
{
  register int i, len = strlen(name);
  for (i = 0; map[i].name && strncmp(map[i].name, name, len); i++) ;
  return map[i].eaddr;
}

IPhost nametoip(name)
char *name;
{
  register int i, len = strlen(name);
  for (i = 0; map[i].name && strncmp(map[i].name, name, len); i++) ;
  return map[i].ipaddr;
}

void ethtoname(eaddr, s)
ETHhost eaddr;
char *s;
{
  register int i;
  for (i = 0; map[i].name && !eaddreq(map[i].eaddr, eaddr); i++) ;
  if (map[i].name) {
    strcpy(s, map[i].name);
  } else {
    strcpy(s, "unknown");
  }
}

void iptoname(ipaddr, s)
IPhost ipaddr;
char *s;
{
  register int i;
  for (i = 0; map[i].name && !ipaddreq(map[i].ipaddr, ipaddr); i++) ;
  if (map[i].name) {
    strcpy(s, map[i].name);
  } else {
    strcpy(s, "unknown");
  }
}

IPhost ethtoip(eaddr)
ETHhost eaddr;
{
  register int i;
  for (i = 0; map[i].name && !eaddreq(map[i].eaddr, eaddr); i++) ;
  return map[i].ipaddr;
}

ETHhost iptoeth(ipaddr)
IPhost ipaddr;
{
  register int i;
  for (i = 0; map[i].name && !ipaddreq(map[i].ipaddr, ipaddr); i++) ;
  return map[i].eaddr;
}
