/* 
 * intelEthCmd.h
 *
 * x-kernel v3.1	12/10/90
 *
 * Copyright (C) 1990  Larry L. Peterson and Norman C. Hutchinson
 */


/*
 * Xmit Buffer Descriptor
 */
typedef struct xbdStruct {

  u_char bufSzLoByte:8;
  u_char lastXbdOfCmd:1;
         u_char:1;		/* unused */
  u_char bufSzHiByte:6;		/* higher 6 bits of length */
  ieOffset_t nextXbdOffset;
  ieAd_t bufPtr;

  /* EXTRA FIELD NOT RECOGNIZED BY IE DEVICE */
  struct xbdStruct *nextXbdPtr;

}         xmitBufDesc_t;


#define INIT_XBD( xbdPtr, newBufPtr, newBufSz )\
		{\
			if( (xbdPtr) == NULL ){\
				Kabort("EXHAUSTED XMIT BUFFER DESCRIPTORS!\n");\
			}\
			(xbdPtr)->bufPtr = IE_AD_FROM_AD( newBufPtr );\
			(xbdPtr)->bufSzLoByte = LO_BYTE_OF_2( newBufSz );\
			(xbdPtr)->bufSzHiByte = HI_BYTE_OF_2( newBufSz );\
			(xbdPtr)->lastXbdOfCmd = FALSE;\
		}


/*
 * Command Block Prefix
 *
 * first "half" of a command block
 */
typedef struct {
  unsigned xmitDeferred:1;	/* Xmit deferred to trafic; XMIT ONLY */
  unsigned heartbeat:1;		/* heartbeat; XMIT ONLY */
  unsigned tooManyCollisions:1;	/* too many collisions; XMIT ONLY */
  unsigned:1;			/* not used */
  unsigned numCollisions:4;	/* number of collisions; XMIT ONLY */
  /* 0 and tooManyCollisions => 16 */
  unsigned cmdDone:1;		/* command completed */
  unsigned cmdInProgress:1;	/* busy executing command */
  unsigned cmdSuccessful:1;	/* error free completion */
  unsigned cmdAborted:1;	/* command aborted */
  unsigned:1;			/* not used */
  unsigned noCarrier:1;		/* no carrier sense; XMIT ONLY */
  unsigned lostClearToSend:1;	/* lost clear to send; XMIT ONLY */
  unsigned dmaUnderrun:1;	/* DMA underrun; XMIT ONLY */
  unsigned:5;			/* not used */
  unsigned cmdKind:3;		/* command */
  unsigned lastPostedCmd:1;
  unsigned suspendWhenDone:1;	/* suspend cu on completion */
  unsigned intrWhenDone:1;	/* interrupt on completion */
  unsigned:5;			/* not used */
  ieOffset_t nextCmdOffset;	/* link to next command */
}      cmdBlkPrefix_t;


/*
 * action command kinds
 */
#define	NOOP_CMD		 	0
#define	INDIV_AD_SETUP_CMD	1	/* Individual address set_up */
#define	CONFIG_CMD			2
#define	MCAST_SETUP_CMD	 	3	/* Multicast address set_up */
#define	XMIT_CMD			4
#define	TDR_CMD		 		5	/* Time division
						 * reflectometry	 */
#define	DUMP_REGS_CMD		6
#define	DIAGNOSE_CMD		7


/*
 * Command Block Suffix
 *
 * different for the different command kinds
 */


/* NOOP_CMD */
/* no suffix, it's all in the prefix */


/* INDIV_AD_SETUP_CMD */
typedef struct {
  ethAd_t localEthAd;
}      indivAdCmdBlkSuffix_t;


 /* CONFIG_CMD *//* INCOMPLETE DEFINITION */
typedef struct {
  u_char:4;			/* unused */
  u_char bcnt:4;		/* byte_count */
         u_char:4;		/* unused */
  u_char fifo:4;		/* FIFO threshold */
  u_char svbf:1;		/* save BF */
  u_char srdy:1;		/* SRDY/ARDY pin */
         u_char:6;		/* unused */
  u_char ext_lpb:1;		/* External loopback */
  u_char int_lpb:1;		/* Internal loopback */
  u_char pream_len:2;		/* preamble length */
  u_char al_loc:1;		/* address & len field */
  u_char addr_len:3;		/* address length */
  u_char bof_met:1;		/* exp backoff method */
  u_char acr:3;			/* Acce */
         u_char:1;
  u_char lin_prio:3;
  u_char frame_sp;
  u_char slot_timel;
  u_char retry_num:4;
         u_char:1;
  u_char slot_timeh:3;
  u_char pad:1;
  u_char bt_stf:1;
  u_char crc_16:1;
  u_char ncrc:1;
  u_char tono_crc:1;
  u_char man:1;
  u_char bc_dis:1;
  u_char promiscMode:1;
  u_char cdt_src:1;
  u_char cdtf:3;
  u_char crs_src:1;
  u_char crsf:3;
  u_char min_frm;
  u_char junk;
}      configCmdBlkSuffix_t;


 /* MCAST_AD_SETUP_CMD *//* INCOMPLETE DEFINITION	 */
typedef struct {
  u_char junk;
}      mcastSetupCmdBlkSuffix_t;


/*  XMIT_CMD */
typedef struct {
  ieOffset_t xbdHeadOffset;	/* pointer to chain of xmit buf descs */
  ethAd_t destEthAd;
  ethType_t ethType;
  Msg msg;			/* Msg to xmit */
  /* NOT OFFICIALLY PART OF XMIT CMD */
}      xmitCmdBlkSuffix_t;


/*
 * Command Block (simply "cmd")
 *
 * Prefix + Suffix
 */
typedef struct cmdStruct {

  cmdBlkPrefix_t prefix;

  union {
    indivAdCmdBlkSuffix_t indivAd;
    configCmdBlkSuffix_t config;
    mcastSetupCmdBlkSuffix_t mcast;
    xmitCmdBlkSuffix_t xmit;
  }     suffix;

  /* PLUS EXTRA FIELDS NOT RECOGNIZED BY IE DEVICE */
  struct {
    xmitBufDesc_t *xbdHeadPtr;	/* just XMIT cmds */
    char *firstChunk;
    struct cmdStruct *nextCmdPtr;
    struct cmdStruct *prevCmdPtr;
  }      extra;

}         cmd_t;


/* command blocks are linked in a ring,
 * and are allocated, posted, used, and freed in ring order.
 */

extern Semaphore FreeCmdCntSem;
extern cmd_t *NextFreeCmdPtr;

#define ALLOC_CMD( cmdPtr )		{\
					P( &FreeCmdCntSem );\
					cmdPtr = NextFreeCmdPtr;\
					NextFreeCmdPtr = NextFreeCmdPtr->extra.nextCmdPtr->extra.nextCmdPtr;\
								}

#define FREE_CMD	V( &FreeCmdCntSem );


/*
 * Command Unit control commands
 */
#define	CU_NOP		0
#define	CU_START	1
#define	CU_RESUME	2
#define	CU_SUSPEND	3
#define	CU_ABORT	4


/*
 * Command Unit status
 */
#define	CU_STATUS_IDLE			0
#define	CU_STATUS_SUSPEND		1
#define	CU_STATUS_ACTIVE	 	2

#define MIN_FIRST_CHUNK			64

