
/* Copyright (C) 1988, 1989 Herve' Touati, Aquarius Project, UC Berkeley */

/* Copyright Herve' Touati, Aquarius Project, UC Berkeley */

% Calculate environment sizes in all call instructions:
% Returns maximum environment size.

envsize([], 0) :- !.
envsize([call(_,EnvSize)|Code], EnvSize) :-
	envsize(Code, EnvSize), !.
envsize([I|Code], EnvSize) :-
	type_arg(I, T, R),
	nonvar(R), R=y(N1),
	envsize(Code, N2),
	max(N1, N2, EnvSize), !.
envsize([_|Code], EnvSize) :- 
	envsize(Code, EnvSize).
