/*
**	net.c	- 
**
**
** Copyright (c) 1993  David J. Hughes
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
**
** This software is provided "as is" without any expressed or implied warranty.
**
** ID = "$Id:"
**
*/


#include <stdio.h>
#include <sys/types.h>
#include <winsock.h>
#include<memory.h>
#include <string.h>
#include "portabil.h"
#include "msql_pri.h"


static 	u_char	packetBuf[PKT_LEN + 4];
static	int	readTimeout;
u_char	*packet = NULL;

void initNet()
{
	packet = (u_char *)packetBuf + 4;
}



void writePkt(int fd)
{
	u_char	*cp;
	int	len,
		offset,
		remain,
		numBytes;

	cp = packetBuf;
	len = strlen(packet);
	*cp++ = (unsigned int)(len & 0x000000ff);
	*cp++ = (unsigned int)(len & 0x0000ff00) >> 8;
	*cp++ = (unsigned int)(len & 0x00ff0000L) >> 16;
	*cp++ = (unsigned int)(len & 0xff000000L) >> 24;

	offset = 0;
	remain = len+4;
	while(remain > 0)
	{
		numBytes = send(fd,packetBuf,len + 4,0);
		if (numBytes == -1)
		{
			return;
		}
		offset += numBytes;
		remain -= numBytes;
	}
}

int readPkt(int fd)
{
u_char	*c,
buf[4];
int	len,remain,offset,numBytes;
static	int init = 1;

readTimeout = 0;
(void)bzero(packetBuf,(PKT_LEN + 4));
if(recv(fd,buf,4,0) <= 0)
	return(-1);
c = buf;
len = *c++;
len += ((int) *c++) << 8 ;
len += ((int) *c++) << 16;
len += ((int) *c++) << 24;
if (len > PKT_LEN)
	return(-1);
remain = len;
offset = 0;
while(remain > 0)	{
	numBytes = recv(fd,packet+offset,remain,0);
	if (readTimeout)
		return(-1);
	if (numBytes < 0)
		return(-1);
	remain -= numBytes;
	offset += numBytes;
	}
return(len);
}



