/*
**	msql.h	-
**
**
** Copyright (c) 1993  David J. Hughes
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
**
** This software is provided "as is" without any expressed or implied warranty.
**
** ID = "$Id:"
**
*/
#if ! defined (WIN32)
#if defined EXPORT
#undef EXPORT
#define EXPORT __export pascal far
#else
#define EXPORT __export pascal far
#endif
#elif ! defined EXPORT
#define EXPORT
#endif

#define MSQL_ERROR_TEXT_LEN 160

typedef	char	** m_row;

typedef struct field_s {
	char	*name,
		*table;
	int	type,
		length,
		flags;
} m_field;



typedef	struct	m_data_s {
	int	width;
	m_row	data;
	struct	m_data_s *next;
} m_data;

typedef struct m_fdata_s {
	m_field	field;
	struct m_fdata_s *next;
} m_fdata;



typedef struct result_s {
        m_data 	*queryData,
                *cursor;
	m_fdata	*fieldData,
		*fieldCursor;
	int	numRows,
		numFields;
} m_result;


#define	msqlNumRows(res) res->numRows
#define	msqlNumFields(res) res->numFields


extern	char msqlErrMsg[];
m_result * EXPORT msqlListDBs(int sock);
m_result * EXPORT msqlListTables(int sock);
m_result * EXPORT msqlListFields(int sock,char*);
int EXPORT msqlQuery(int sock,char* q);
void EXPORT msqlDataSeek(m_result* handle,int offset);
void EXPORT msqlFieldSeek(m_result* handle,int offset);
m_row EXPORT 	msqlFetchRow(m_result* handle);
m_field	* EXPORT msqlFetchField(m_result* handle);
m_result * EXPORT msqlStoreResult();
int EXPORT msqlSelectDB(int sock,char* db);
int EXPORT msqlConnect(char	*host);
void EXPORT msqlClose(int sock);
void EXPORT msqlFreeResult(m_result *result);

#define __ANSI_PROTO(A) A

	int 	EXPORT	msqlCreateDB __ANSI_PROTO((int, char*));
	int 	EXPORT	msqlDropDB __ANSI_PROTO((int, char*));
	int 	EXPORT	msqlShutdown __ANSI_PROTO((int));
	int 	EXPORT	msqlReloadAcls __ANSI_PROTO((int));
	int 	EXPORT	msqlGetProtoInfo();
	char* 	EXPORT	msqlGetServerInfo();
	char* 	EXPORT	msqlGetHostInfo();


#define INT_TYPE	1
#define CHAR_TYPE	2
#define REAL_TYPE	3
#define IDENT_TYPE	4
#define NULL_TYPE	5

#define NOT_NULL_FLAG   1
#define PRI_KEY_FLAG    2

#define IS_PRI_KEY(n)	(n & PRI_KEY_FLAG)
#define IS_NOT_NULL(n)	(n & NOT_NULL_FLAG)


/* Extensions to support ODBC */

/* This function is added to allow the msql API
 * to operate as a DLL */
int EXPORT msqlErrorText(char *);

/*
 * Some internal data dictionary entries require a
 * 2 byte integer. This is not used for communications
 * with the API. It is here to define it beside the
 * other types.
 */
#define SHORT_TYPE  10


